/**
 * $Id: SampleNotifyPassword.java,v 1.5 2004/02/05 17:52:56 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.console.user;
 
import com.iplanet.am.util.Debug;
import com.iplanet.am.sdk.AMUser;

import com.sun.identity.password.plugins.NotifyPassword;
import com.sun.identity.password.ui.model.PWResetException;


/**
 * <code>SampleNotifyPassword</code> is sample plugin implementation to show
 * that how customer can write their own notification mechanism after the 
 * password is reset. It is based on the public interface
 * <code>NotifyPassword</code>.
 * This plugin is called(after configuring it in IS console by the 
 * "Password Reset" module. Identity Server comes with a default plugin 
 * implementation as well.
 */
public class SampleNotifyPassword implements NotifyPassword
{

    /**
     * Get a handle of the debug file.
     */ 
    private static Debug debug = Debug.getInstance("amConsole");

    /**
     * Constructs a <code>SampleNotifyPassword</code> object.
     */
    public SampleNotifyPassword() {
    }

    /**
     * Notifies user when password is changed.
     *
     * @param user <code>AMUser</code> object
     * @param password new password
     * @param localeContext <code>ISLocaleContext</code> object
     * @throws PWResetException if password cannot be notified
     */
    public void notifyPassword(
        AMUser user, 
        String password, 
        java.util.Locale localeContext)
        throws PWResetException
    {
	if (debug.messageEnabled()) {
	    debug.message(
		"User password  has changed." +
		" User or Admin will be notified of this change");
	} 

        /*
         * Put your own logic here using the
	 * info(user, password, localcontext) to notify the user.
         * You can use the Identity Server SDK classes to send the
	 *  notification or your own java classes.
         */

	debug.message(
	    "User or Admin has been notified about the password change.");
    }
 }
