/**
 * $Id: UMNewTabDataViewBean.java,v 1.3 2004/02/05 17:52:54 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.console.user;

import com.iplanet.am.console.base.AMViewBeanBase;
import com.iplanet.am.console.user.model.UMNewTabModel;
import com.iplanet.am.console.user.model.UMNewTabModelImpl;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.StaticTextField;

public class UMNewTabDataViewBean extends AMViewBeanBase {

    public static final String PAGE_NAME = "UMNewTabData";   
    public static final String DEFAULT_DISPLAY_URL =
	"/console/user/UMNewTabData.jsp";
    public static final String TXT_INVOKED = "txtInvoked";

    private UMNewTabModel model = null;

    /** creates a new tab navigation view bean */
    public UMNewTabDataViewBean() {
	super(PAGE_NAME);
	setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
	registerChildren();
    }

    /** registers child components/views */
    protected void registerChildren() {
        super.registerChildren();
        registerChild(TXT_INVOKED, StaticTextField.class);
    }

    /**
     * creates child component
     *
     * @param name of child component
     * @return child component
     */
    protected View createChild(String name) {
        View child = null;
        if (name.equals(TXT_INVOKED)) {
            child = new StaticTextField(this, TXT_INVOKED, "");
        } else {
            child = super.createChild(name);
        }
        return child;
    }

    /**
     * begins displaying page. we set the required information
     *
     * @param event   display event
     * @throws ModelControlException  if problem access value of component
     */
    public void beginDisplay(DisplayEvent event)
        throws ModelControlException
    {
        super.beginDisplay(event);
	RequestContext rc = getRequestContext();

	UMNewTabModel model = getModel(rc);
	String txt = model.getDataViewInvokedMessage() + " " +
	    model.getLocationDN();
        setDisplayFieldValue(TXT_INVOKED, txt);
    }

    private UMNewTabModel getModel(RequestContext rc) {
	if (model == null) {
	    model = new UMNewTabModelImpl(rc.getRequest(),
		getPageSessionAttributes());
	}
	return model;
    }
}
