/**
 * $Id: UMRelocateUserModelImpl.java,v 1.3 2004/02/05 17:52:53 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.console.user.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import com.iplanet.am.console.base.model.AMModelBase;
import javax.servlet.http.HttpServletRequest;
import com.iplanet.am.sdk.*;
import com.iplanet.services.util.*;
import java.util.StringTokenizer;

public class UMRelocateUserModelImpl extends AMModelBase
    implements UMRelocateUserModel {

    public UMRelocateUserModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    } 

    /**
     * Moves the user to a new organization
     */
    public void moveUser(String userDN, String newPcDN) {
        try {
            AMUser user =  dpStoreConn.getUser(userDN);
            Map map = user.getAttributes();
            //old 
            String oldPCDn = user.getParentDN();
            AMPeopleContainer amOldPC = dpStoreConn.getPeopleContainer(oldPCDn);

            //Strip off the user part
            StringTokenizer st = new StringTokenizer(userDN, ",");
            String userId = (String)st.nextToken();
            int userIndex = userId.indexOf("="); 
            String newUser = null;
            if (userIndex != -1 ) {
                newUser = userId.substring(userIndex+1);
            }
            HashMap userMap = new HashMap();
            userMap.put(newUser, map);
            AMPeopleContainer amNewPC = dpStoreConn.getPeopleContainer(newPcDN);
            amNewPC.createUsers(userMap);

            HashSet userSet = new HashSet();
            userSet.add(userDN);
            amOldPC.deleteUsers(userSet);
        } catch (Exception ex) {
            Debug debug = Debug.getInstance("amConsole");
            debug.error("Could not move the user:" + ex.toString());
        }
        
    }

    /**
     * @return the title for the moving user page
     */
    public String getTitle() {
        return getLocalizedString("moveuser.title");
    }

    /**
     * @return the label for <code>UID</code> for the moving user page
     */
    public String getUIDLabel() {
        return getLocalizedString("uid.label");
    }

    /**
     * @return the label for people container for the moving user page
     */
    public String getUserdnExample() {
        return getLocalizedString("userdn_example.label");
    }

    /**
     * @return the label for New People Container for the moving user page
     */
    public String getNewPCLabel() {
        return getLocalizedString("newPC.label");
    }

    /**
     * @return the label for Organization DN for the moving user page
     */
    public String getOrgDNExample() {
        return getLocalizedString("newOrgDn_example.label");
    }

    /**
     * @return the  label for New Organization DN for the moving user page
     */	
    public String getNewOrgDNLabel() {
        return getLocalizedString("newOrgDN.label");
    }

}
