/**
 * $Id: UMChangeUserPasswordModelImpl.java,v 1.3 2004/02/05 17:52:50 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.console.user.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import com.iplanet.am.sdk.*;

public class UMChangeUserPasswordModelImpl extends UMUserModelImpl 
    implements UMChangeUserPasswordModel {

    public UMChangeUserPasswordModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    } 

    /**
    * @return the title for the moving user page
    */
    public String getTitle() {
        return getLocalizedString("changepassword.title");
    }

    /**
    * @return the label for Password
    */
    public String getPasswordLabel() {
        return getLocalizedString("password.label");
    }

    /**
    * @return the  label for Password (Confirm)
    */	
    public String getPasswordConfirmLabel() {
        return getLocalizedString("passwordconfirm.label");
    }

    /**
    * @return the  label for Submit Button
    */
    public String getSubmitBtnLabel() {
        return getLocalizedString("submit.button");
    }

    /**
    * @return the  label for Close Button
    */
    public String getCloseBtnLabel() {
        return getLocalizedString("close.button");
    }

    /**
    * @return the Error Message
    */
    public String getErrorMessage() {
        return getLocalizedString("error.message");
    }

    /**
    * @return the Null Error Message
    */
    public String getNullErrorMessage() {
        return getLocalizedString("nullerror.message");
    }

    /**
    * @return the Blank Error Message
    */
    public String getBlankErrorMessage() {
        return getLocalizedString("blankerror.message");
    }

    /**
    * @return the  label for Error Title
    */
    public String getErrorTitle() {
        return getLocalizedString("error.title");
    }

    /**
    * @return the Error Message if the passwords cannot be changed
    */
    public String getErrMessage() {
        return getLocalizedString("err.message");
    }

    /**
    * @return the label for Error Title if the passwords cannot be changed
    */
    public String getErrTitle() {
        return getLocalizedString("err.title");
    }                   

    /**
    * Changes the password of the current user
    */
    public boolean changePassword(String password) {
        try {
            AMUser user = getCurrentUser();
            Map passwdMap = new HashMap(1);
            Set attribVals = new HashSet(1);
            attribVals.add(password);
            passwdMap.put("userpassword", attribVals);
            user.setAttributes(passwdMap);
            user.store();
        } catch (Exception ex) {
            debug.message("Error:" + ex.toString());
            return false;
        }
        return true;
    }
}
