/**
 * $Id: UMChangeUserPasswordViewBean.java,v 1.3 2004/02/05 17:52:48 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.console.user;

import com.iplanet.am.console.base.AMViewBeanBase;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.jato.view.html.TextField;
import com.iplanet.am.console.components.view.html.MessageBox;
import com.iplanet.am.console.user.model.UMChangeUserPasswordModelImpl;
import com.iplanet.am.console.user.model.UMChangeUserPasswordModel;
import javax.servlet.http.HttpServletRequest;

public class UMChangeUserPasswordViewBean extends AMViewBeanBase {

    public final String MESSAGE_BOX = "MessageBox";
    public static final String CREATE_TITLE = "createTitle";
    public static final String PASSWORD = "password";
    public static final String PASSWORD_TEXT = "password_text";
    public static final String PASSWORD_CONFIRM = "passwordconfirm";
    public static final String PASSWORD_CONFIRM_TEXT = "passwordconfirm_text";
    public static final String SUBMIT_BUTTON = "btnSubmit";
    public static final String CLOSE_BUTTON = "btnClose";
    public static final String PAGE_NAME = "UMChangeUserPassword";   
    public static final String DEFAULT_DISPLAY_URL =
        "/console/user/UMChangeUserPassword.jsp";

    protected UMChangeUserPasswordModel model = null;
    public  boolean reloadFrames = false;
    protected String RELOAD_NAV_FRAME = "reloadFlag";

    /**
     * constructor
     *
     */
    public UMChangeUserPasswordViewBean() {
        super(PAGE_NAME);
        setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        registerChildren();
    }

    /**
     * registers child components/views
     */
    protected void registerChildren() {
        super.registerChildren();
        registerChild(CREATE_TITLE, StaticTextField.class);
        registerChild(MESSAGE_BOX, MessageBox.class);
        registerChild(PASSWORD, StaticTextField.class);
        registerChild(PASSWORD_TEXT, TextField.class);
        registerChild(PASSWORD_CONFIRM, StaticTextField.class);
        registerChild(PASSWORD_CONFIRM_TEXT, TextField.class);
        registerChild(SUBMIT_BUTTON, IPlanetButton.class);
        registerChild(CLOSE_BUTTON, IPlanetButton.class);
        registerChild(CREATE_TITLE, StaticTextField.class);
    }

    /**
     * creates child component
     *
     * @param name of child component
     * @return child component
     */
    protected View createChild(String name) {
        View child = null;
        if (name.equals(PASSWORD)) {
            child = new StaticTextField(this, PASSWORD, "");
        } else if (name.equals(PASSWORD_TEXT)) {
            child = new TextField(this, PASSWORD_TEXT, "");
        } else if (name.equals(PASSWORD_CONFIRM)) {
            child = new StaticTextField(this, PASSWORD_CONFIRM, "");
        } else if (name.equals(PASSWORD_CONFIRM_TEXT)) {
            child = new TextField(this, PASSWORD_CONFIRM_TEXT, "");
        } else if (name.equals(MESSAGE_BOX)) {
            return new MessageBox(this,MESSAGE_BOX,"");
        } else if (name.equals(SUBMIT_BUTTON)) {
            child = new IPlanetButton(this, SUBMIT_BUTTON, "");
        } else if (name.equals(CLOSE_BUTTON)) {
            child = new IPlanetButton(this, CLOSE_BUTTON, "");
        } else if (name.equals(CREATE_TITLE)) {
            child = new StaticTextField(this, CREATE_TITLE, "");
        } else {
            child = super.createChild(name);
        }
        return child;
    }




    /**
     * begins displaying page. we set the required information
     *
     * @param event   display event
     * @throws ModelControlException  if problem access value of component
     */
    public void beginDisplay(DisplayEvent event)
        throws ModelControlException {
        super.beginDisplay(event);
        model = (UMChangeUserPasswordModel)
            getModel(getRequestContext().getRequest());

        setChildValues(model);
        setDisplayFieldValue(CREATE_TITLE, model.getTitle());
        setDisplayFieldValue(PASSWORD, model.getPasswordLabel());
        setDisplayFieldValue(PASSWORD_TEXT,"");
        setDisplayFieldValue(PASSWORD_CONFIRM, model.getPasswordConfirmLabel());
        setDisplayFieldValue(PASSWORD_CONFIRM_TEXT,"");
        setDisplayFieldValue(SUBMIT_BUTTON, model.getSubmitBtnLabel());
        setDisplayFieldValue(CLOSE_BUTTON, model.getCloseBtnLabel());
    }

    /**
     * handles form submission request
     *
     * @param event request invocation event
     */
    public void handleBtnSubmitRequest(RequestInvocationEvent event) {
        RequestContext rc = getRequestContext();
        HttpServletRequest req = rc.getRequest();
        if (model == null ) {
            model = getModel(req);
        }
        String password = (String)getDisplayFieldValue(PASSWORD_TEXT);
        String passwordConfirm = (String)
            getDisplayFieldValue(PASSWORD_CONFIRM_TEXT);

        if ((password == null) || (passwordConfirm == null)) {
            showMessage(
                MessageBox.TYPE_ERROR,
                model.getErrTitle(),
                model.getNullErrorMessage());
            forwardTo();
        }
        password = password.trim();
        passwordConfirm = passwordConfirm.trim();
        if ((password.length() == 0) || 
            (passwordConfirm.length() == 0)) {
            showMessage(
                MessageBox.TYPE_ERROR,
                model.getErrTitle(),
                model.getBlankErrorMessage());
            forwardTo();
        }
        if (!password.equals(passwordConfirm)) {
            showMessage(
                MessageBox.TYPE_ERROR,
                model.getErrorTitle(),
                model.getErrorMessage());
            forwardTo();
        }
        if (model.changePassword(password)) {
	    UMSuccessfullyChangedPasswordViewBean uscpVB =
		(UMSuccessfullyChangedPasswordViewBean)
		getViewBean(UMSuccessfullyChangedPasswordViewBean.class);
	    uscpVB.forwardTo(rc);
        } else {
            showMessage(
                MessageBox.TYPE_ERROR,
                model.getErrTitle(),
                model.getErrMessage());
            forwardTo();
        }
    }

    /**
     * get model for this view bean
     *
     * @param req HTTP servlet request
     * @return model for this view bean
     */
    protected UMChangeUserPasswordModel getModel(HttpServletRequest req) {
        if (model == null) {
            model = new UMChangeUserPasswordModelImpl (
                req, getPageSessionAttributes());
        }
        return model;
    }

     /**
     * This sets up the message box with the title and message to
     * display.
     *
     * @param type Type of message box to display(error, warning,information)
     * @param title Title of the message box
     * @param message Message that will be displayed in the box.
     */
    protected void showMessage(int type, String title, String message) {
        if (title == null) {
            title = "";
        }

        if (message == null) {
            message = "";
        }

        MessageBox mb = (MessageBox) getDisplayField(MESSAGE_BOX);
        mb.setType(type);
        mb.setTitle(title);
        mb.setMessage(message);
        mb.setEnabled(true);
    }   
}
