/**
 * $Id: PureJAASSampleLoginModule.java,v 1.2 2004/02/05 17:54:27 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */


import java.util.*;
import java.io.IOException;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;


/**
 * <p> This sample LoginModule authenticates users by replaying
 * the callbacks required by IS Auth module
 * 
 * <p> If User successfully authenticates itself against IS Auth module,
 * a <code>PureJAASSamplePrincipal</code> with the User's user name
 * is added to the Subject.
 *
 * <p> This LoginModule recognizes the debug option.
 * If set to true in the login Configuration,
 * debug messages will be output to the output stream, System.out.
 *
 */
public class PureJAASSampleLoginModule implements LoginModule {

    // initial state
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;

    // configurable option
    private boolean debug = false;

    // the authentication status
    private boolean succeeded = false;
    private boolean commitSucceeded = false;

    // username and password
    private String username;
    private char[] password;

    // testUser's SamplePrincipal
    private PureJAASSamplePrincipal userPrincipal;
    
    static String indexName = "";
    static AuthContext.IndexType indexType;
    static String orgName = "";

    /**
     * Initialize this <code>LoginModule</code>.
     *
     * <p>
     *
     * @param subject the <code>Subject</code> to be authenticated. <p>
     *
     * @param callbackHandler a <code>CallbackHandler</code> for communicating
     *			with the end user (prompting for user names and
     *			passwords). <p>
     *
     * @param sharedState shared <code>LoginModule</code> state. <p>
     *
     * @param options options specified in the login
     *			<code>Configuration</code> for this particular
     *			<code>LoginModule</code>.
     */
    public void initialize(Subject subject, CallbackHandler callbackHandler,
			Map sharedState, Map options) {
 
	this.subject = subject;
	this.callbackHandler = callbackHandler;
	this.sharedState = sharedState;
	this.options = options;

	// initialize any configured options
	debug = "true".equalsIgnoreCase((String)options.get("debug"));
	orgName = (String)options.get("ORG_NAME");
	indexName = (String)options.get("INDEX_NAME");
    }

    /**
     * Authenticate the user by prompting for a user name and password.
     *
     * @return true in all cases since this <code>LoginModule</code>
     *		should not be ignored.
     *
     * @exception FailedLoginException if the authentication fails. <p>
     *
     * @exception LoginException if this <code>LoginModule</code>
     *		is unable to perform the authentication.
     */
    public boolean login() throws LoginException {
    	AuthContext lc = null;
        System.out.println("orgname is : " + orgName);
        try {
            lc = new AuthContext(orgName);
            indexType = AuthContext.IndexType.MODULE_INSTANCE;
            System.out.println("Obtained login context ...");
            lc.login(indexType, indexName);
        } catch (AuthLoginException le) {
            le.printStackTrace();
            System.out.println("Login failed!!");
            return false;
        }

	// prompt for a user name and password
	if (callbackHandler == null) {
	    throw new LoginException("Error: no CallbackHandler available " +
			"to garner authentication information from the user");
	}
	 Callback[] callbacks = null;
        // get information requested from IS Auth module
        while (lc.hasMoreRequirements()) {
            callbacks = lc.getRequirements();
 
	    try {
		callbackHandler.handle(callbacks);
		lc.submitRequirements(callbacks);
	    } catch (java.io.IOException ioe) {
		throw new LoginException(ioe.toString());
	    } catch (UnsupportedCallbackException uce) {
		throw new LoginException("Error: " + 
						uce.getCallback().toString() +
		" not available to garner authentication information " +
		"from the user");
	    }
	}
	if (lc.getStatus() == AuthContext.Status.SUCCESS) {
	    succeeded = true;
	    for (int i = 0; i < callbacks.length; i++) {
		if (callbacks[i] instanceof NameCallback) {
		     NameCallback nc = (NameCallback)callbacks[i];
		     username = nc.getName();
		}
	    }
	    System.out.println("UserName: " +username+"  Login success!!");
	    return true;
	} else if (lc.getStatus() == AuthContext.Status.FAILED) {
	    System.out.println("Login has failed!!");
	    throw new FailedLoginException("Password Incorrect");
	} else {
	    System.out.println("Unknown status: " + lc.getStatus());
	    throw new FailedLoginException("Password Incorrect");
	}

    }

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication succeeded
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * succeeded).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> method), then this method associates a
     * <code>SamplePrincipal</code>
     * with the <code>Subject</code> located in the
     * <code>LoginModule</code>.  If this LoginModule's own
     * authentication attempted failed, then this method removes
     * any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the commit fails.
     *
     * @return true if this LoginModule's own login and commit
     *		attempts succeeded, or false otherwise.
     */
    public boolean commit() throws LoginException {
	if (succeeded == false) {
	    return false;
	} else {
	    // add a Principal (authenticated identity)
	    // to the Subject
	    // assume the user we authenticated is the PureJAASSamplePrincipal
	    userPrincipal = new PureJAASSamplePrincipal(username);
	    if (!subject.getPrincipals().contains(userPrincipal)) {
		subject.getPrincipals().add(userPrincipal);
	    }

	    if (debug) {
		System.out.println("\t\t[SampleLoginModule] " +
				"added PureJAASSamplePrincipal to Subject");
	    }

	    // in any case, clean out state
	    username = null;
	    commitSucceeded = true;
	    return true;
	}
    }

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication failed.
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * did not succeed).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> and <code>commit</code> methods),
     * then this method cleans up any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the abort fails.
     *
     * @return false if this LoginModule's own login and/or commit attempts
     *		failed, and true otherwise.
     */
    public boolean abort() throws LoginException {
	if (succeeded == false) {
	    return false;
	} else if (succeeded == true && commitSucceeded == false) {
	    // login succeeded but overall authentication failed
	    succeeded = false;
	    username = null;
	    userPrincipal = null;
	} else {
	    // overall authentication succeeded and commit succeeded,
	    // but someone else's commit failed
	    logout();
	}
	return true;
    }

    /**
     * Logout the user.
     *
     * <p> This method removes the <code>SamplePrincipal</code>
     * that was added by the <code>commit</code> method.
     *
     * <p>
     *
     * @exception LoginException if the logout fails.
     *
     * @return true in all cases since this <code>LoginModule</code>
     *          should not be ignored.
     */
    public boolean logout() throws LoginException {

	subject.getPrincipals().remove(userPrincipal);
	succeeded = false;
	succeeded = commitSucceeded;
	username = null;
	userPrincipal = null;
	return true;
    }


}
