/**
 * $Id: ISAuthPostProcessSample.java,v 1.2 2004/02/05 17:54:25 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.authentication.spi.postprocess;

import com.iplanet.sso.SSOToken;
import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * The <code>ISPostAuthPostProcessSample</code> sample implements
 * AMPostAuthProcessInterface interface for authentication
 * post processing after
 * The post processing can be per ORGANIZATION or SERVICE or ROLE 
 */

public class ISAuthPostProcessSample implements AMPostAuthProcessInterface
{

   private static Debug debug = Debug.getInstance("amAuthPostProcessSample");

  /** Post processing on successful authentication.
    * @param requestParamsMap - map contains HttpServletRequest parameters
    * @param request HttpServletRequest object
    * @param response HttpServletResponse object
    * @param ssoToken  authenticated user's ssoToken
    * @exception Authentication Exception when there is an error 
    */

  public void onLoginSuccess(Map requestParamsMap,
                             HttpServletRequest request,
                             HttpServletResponse response,
                             SSOToken ssoToken)
        throws AuthenticationException
  {
      debug.message("ISAuthPostProcessSample:onLoginSuccess called");
      try {
          ssoToken.setProperty("AUTHPOSTPROCESSTEST1", "TESTVALUE1");
      } catch (Exception ex) {
          debug.message("onLoginSuccess exception while setting property :",ex);
      }
  }

  /** Post processing on failed authentication.
    * @param requestParamsMap - map contains HttpServletRequest parameters
    * @param request HttpServletRequest object
    * @param response HttpServletResponse object
    * @exception AuthenticationException when there is an error 
    */
  public void onLoginFailure(Map requestParamsMap,
                             HttpServletRequest req,
                             HttpServletResponse res)
        throws AuthenticationException
  {
      debug.message("ISAuthPostProcessSample:onLoginFailure called");
  }

 
 /** Post processing on Logout.
   * @param requestParamsMap - map contains HttpServletRequest parameters
   * @param request HttpServletRequest object
   * @param response HttpServletResponse object
   * @param ssoToken - user's session 
   */

 public void onLogout(HttpServletRequest request,
                      HttpServletResponse response,
                      SSOToken ssoToken)
       throws AuthenticationException
  {
      debug.message("ISAuthPostProcessSample:onLogout called");
  }
}
