/**
 * $Id: MSISDN.java,v 1.4 2004/02/05 17:54:24 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.authentication.spi.msisdn;

import java.util.ResourceBundle;
import java.util.Set;
import java.util.Map;
import java.util.Iterator;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Cookie;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

import com.sun.identity.authentication.spi.AMLoginModule;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SSLSocketFactoryManager;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class MSISDN extends AMLoginModule {

    private  ResourceBundle bundle = null;
    private static com.iplanet.am.util.Debug debug = null;
    private static final int DEFAULT_MSISDN_AUTH_LEVEL = 0;

    private String userTokenId;
    
    private String errorMsg = null;
    private final int FINISHED = -1;

    private MSISDNAuthPrincipal userPrincipal;
    private CallbackHandler callbackHandler;
    
    private Map options;
    
    private Set gatewayList;
    private Set parameterNameList;
    private int authLevel;
    private String userSearchAttr;
    private String serverHost;  
    private int serverPort = 389;
    private String startSearchLoc;  
    private String principleUser;  
    private String principlePasswd;  
    private String useSSL;        
    
    public MSISDN() throws LoginException {
    }


    public void init(Subject subject, Map sharedState, Map options) {
        if (debug == null) {
            debug = com.iplanet.am.util.Debug.getInstance("amAuthMSISDN");
        }
	java.util.Locale locale = getLoginLocale();
	bundle = amCache.getResBundle("amAuthMSISDN", locale);
	if (debug.messageEnabled()) {
	    debug.message("MSISDN resbundle locale="+locale);
	}
        
        this.options = options;
        initAuthConfig();
    }

    /**
     * Gets MSISDN auth config parameters.
     */
    private void initAuthConfig() {
        if (options != null) {
            debug.message("MSISDN: getting attributes.");
            
            gatewayList = (Set)options.get(
                "iplanet-am-auth-msisdn-trusted-gateway-list");
            parameterNameList = (Set)options.get(
                "iplanet-am-auth-msisdn-parameter-name-list");

            String tmp = Misc.getMapAttr(options, 
                "iplanet-am-auth-msisdn-auth-level");

            if (tmp == null || tmp.equals("")) {
                authLevel = DEFAULT_MSISDN_AUTH_LEVEL;
            } else {
                try {
                    authLevel = Integer.parseInt(tmp);
                } catch (Exception e) {
                    debug.error("Invalid auth level " + tmp);
                    authLevel = DEFAULT_MSISDN_AUTH_LEVEL;
                }
            }
            userSearchAttr = Misc.getMapAttr(options,
                "iplanet-am-auth-msisdn-user-search-attribute");
            principleUser = Misc.getMapAttr(options,
                "iplanet-am-auth-msisdn-principal-user");
   	    principlePasswd = Misc.getMapAttr(options,
                "iplanet-am-auth-msisdn-principal-passwd"); 
            useSSL = Misc.getMapAttr(options,
                "iplanet-am-auth-msisdn-use-ssl");
            serverHost = Misc.getServerMapAttr(options, 
                "iplanet-am-auth-msisdn-ldap-provider-url");

            if (serverHost == null) {
                debug.error("Fatal error: LDAP Server and Port misconfigured");
                errorMsg = bundle.getString("wrongLDAPServer");
                return;
            }

            String port = null;
            if (serverHost != null) {
                // set LDAP Parameters
                int index = serverHost.indexOf(':');
                if (index != -1) { 
                    port = serverHost.substring(index+1);
    		    serverPort = Integer.parseInt(port);
                    serverHost = serverHost.substring(0, index); 
                }
            }
            startSearchLoc = Misc.getServerMapAttr(options, 
                "iplanet-am-auth-msisdn-base-dn");
            if (startSearchLoc == null) {
                debug.error("Fatal error: LDAP Start Search DN misconfigured");
                errorMsg = bundle.getString("wrongStartDN");
                return;
            }

            if (debug.messageEnabled()) {
                debug.message("\n ldapProviderUrl="+ serverHost +
                    "\n\t serverPort (" + port + ") = " + serverPort +
                    "\n\t startSearchLoc=" + startSearchLoc +
                    "\n\t userSearchAttr=" + userSearchAttr +
                    "\n\t principleUser=" + principleUser +
                    "\n\t authLevel="+authLevel+
                    "\n\t useSSL=" + useSSL);
            }
        } else {
            debug.error("options is null");
            errorMsg = bundle.getString("MSISDNValidateEx");
        }
    }

    public int process (Callback[] callbacks, int state) throws LoginException {
        debug.message("MSISDN : in process ..");
        if (errorMsg != null) {
            throw new LoginException(errorMsg);
        } 
        
        HttpServletRequest req = getHttpServletRequest();
        String gateway = null;
        String msisdnNumber = null;
        
        if (req != null) {
            gateway = req.getRemoteAddr();
            
            Iterator it = parameterNameList.iterator();
            String parameterName = null;
            String cookieName = null;
            int index;
            while(it.hasNext()) {
                parameterName = it.next().toString();
                if (debug.messageEnabled()) {
                    debug.message("parameterName : " + parameterName); 
                }
                
                // see if it's cookie
                // Syntax :: "Cookie:cookie_name"
                index = parameterName.indexOf(':');
                if (index != -1) {
                    String cookieStr = parameterName.substring(0, index);
                    if(cookieStr.equalsIgnoreCase("Cookie")) {
                        // parameter name is a cookie name.
                        cookieName = parameterName.substring(index+1);
                    }
                    if(cookieName != null && cookieName.length() > 0) {
                        if (debug.messageEnabled()) {
                            debug.message("cookieName : " + cookieName); 
                        }
                        Cookie cookieArray[] = req.getCookies();
                        for(int i = 0; i < cookieArray.length; i++) {
                            if(cookieArray[i].getName().equalsIgnoreCase(cookieName)) {
                                msisdnNumber = cookieArray[i].getValue();
                                break; // break from for loop
                            }
                        }// end for
                        // if MSISDN number is found in cookies come out
                        if (msisdnNumber != null) {
                            break; // break from while loop
                        }
                    }// end inner if
                }// end outer if
                
                // check in headers.
                msisdnNumber = req.getHeader(parameterName);
                if (msisdnNumber != null) {
                    break;
                }
                // check in query/body
                msisdnNumber = req.getParameter(parameterName);
                if (msisdnNumber != null) {
                    break;
                }
            }//end while
        } else {
            debug.message("MSISDN : null request calling sendCallback"); 
            Map map = sendCallback();
            if (map == null) {
                debug.error(" null map from sendCallback : ");
	        throw new LoginException(bundle.getString("MSISDNValidateEx"));
            }
            gateway = (String)map.get("gateway");
            msisdnNumber = (String)map.get("msisdnNumber");
        }

        if (debug.messageEnabled()) {
            debug.message("MSISDN : " + msisdnNumber + " gateway: " + gateway); 
        }
        
        if (msisdnNumber == null || gateway == null) {
            debug.error(" null value MSISDN : " + msisdnNumber + " gateway: " + gateway);
	    throw new LoginException(bundle.getString("MSISDNValidateEx"));
        }
        
        userTokenId = getUserId(msisdnNumber);

	if (userTokenId != null) {
            if (debug.messageEnabled()) {
                debug.message("User Found : " + userTokenId); 
            }
            boolean gatewayFound = false;

            Iterator it = gatewayList.iterator();
            while(it.hasNext()) {
                if (gateway.equalsIgnoreCase(it.next().toString())) {
                    gatewayFound = true;
                    break;
                }
            }
            if (!gatewayFound) {
                if (debug.messageEnabled()) {
                    debug.message("gateway not found  : " + gateway);
                }
                setFailureID(userTokenId);
                throw new LoginException(bundle.getString("MSISDNValidateEx"));
            }

	} else {
            debug.error(" msisdnNumber not matched : " + msisdnNumber);
	    throw new LoginException(bundle.getString("MSISDNValidateEx"));
	}
        return FINISHED; 
    }

    private String getUserId(String msisdnNumber) throws LoginException{
        LDAPConnection ldc = null;
        if (useSSL.equals("true")) {
            debug.message("MSISDN:  initial ldc  using ssl.");
            try {
                ldc = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
                debug.message("validate(): SSLSocketFactory called");
            } catch (Exception e) {
                debug.error("validate.JSSSocketFactory", e);
                throw new LoginException(bundle.getString("jssSokFactoryFail"));
            }
        } else { // non-ssl
            ldc = new LDAPConnection();
        }

        try {
            ldc.connect(serverHost, serverPort);
            ldc.authenticate(3, principleUser, principlePasswd);
        } catch (LDAPException e) {
            debug.error("MSISDN : dircontext", e);
            throw new LoginException(bundle.getString("MSISDNNoContext"));

        }

        try {
	    if (debug.messageEnabled()) {
		debug.message("MSISDN - ldc.search: searching  "+
			      startSearchLoc + " " + ldc);
	    }
            String searchFilter = new StringBuffer(250).append("(")
                .append(userSearchAttr).append("=")
                .append(msisdnNumber).append(")").toString();
 
            if (debug.messageEnabled()) {
                debug.message("MSISDN - ldc.search: using this filter: " + 
                    searchFilter);
            }

            //
            // we are interested only in dn & also saves memory (especially
            // when the entry contains the display profile !)
            //
            String[] attrs = { "dn" };
            LDAPSearchResults results =
                ldc.search(startSearchLoc, LDAPConnection.SCOPE_SUB,
                            searchFilter, attrs, false);

            if(results != null && results.hasMoreElements()) {
                if(results.getCount() > 1) {
                    debug.error("Multiple entries matched: " + results.getCount());
                    throw new LoginException(bundle.getString("MultipleUIDMatch"));
                }
                LDAPEntry entry = results.next();
                String userDN = entry.getDN();
                
                if (debug.messageEnabled()) {
                    debug.message("MSISDN - userDN : " + userDN);
                }
                return userDN;
            }
        } catch (Exception e) {
            debug.error("MSISDN - Error finding user:  " , e );
            throw new LoginException(bundle.getString("UserNotFound"));
        }
        if (debug.messageEnabled()) {
            debug.message("MSISDN - user not found with given MSISDN Number:" 
                + msisdnNumber);
        }
        return null;
    }

    public java.security.Principal getPrincipal() {
        if (userPrincipal != null) {
            return userPrincipal;
        } else if (userTokenId != null) {
            userPrincipal = new MSISDNAuthPrincipal(userTokenId);
            return userPrincipal;
        } else {
            return null;
        }
    }
    
    /**
     * Send callbacks to get gateway and/or msisdnNumber
     * @return Map contains gateway and/or msisdnNumber
     */
    private Map sendCallback() {
        try {
            CallbackHandler callbackHandler = getCallbackHandler();
            if (callbackHandler == null) {
                throw new LoginException(bundle.getString("NoCallbackHandler"));
            }
            Callback[] callbacks = new Callback[2];
            callbacks[0] = new NameCallback(bundle.getString("gateway"));
            callbacks[1] = new PasswordCallback(bundle.getString("msisdn"), true);
            if (debug.messageEnabled()) {
                debug.message("Callback is.. :" + callbacks);
            }
            callbackHandler.handle(callbacks);

            // map to hold return
            Map map = new HashMap();

            // process return 
            int len = callbacks.length;
            for (int i = 0; i < len; i ++) {
                Callback cb = callbacks[i];
                if (cb instanceof PasswordCallback) {
                    char[] pass = ((PasswordCallback) cb).getPassword();
                    if (pass != null) {
                        map.put("msisdnNumber", new String(pass));
                    }
                } else if (cb instanceof NameCallback) { 
                    String gateway = ((NameCallback) cb).getName();
                    if (gateway != null) {
                        map.put("gateway", gateway);
                    }
                } 
            }
            return map;
        } catch (Exception e) {
            debug.error("sendCallback", e);
        }
        return null;
    }
}
