/**
 * $Id: JDBC.java,v 1.2 2004/02/05 17:54:23 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.authentication.spi.jdbc;

import java.util.Map;
import java.util.ResourceBundle;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import javax.sql.DataSource;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;

public class JDBC extends AMLoginModule {
    
    private String userTokenId;
    private String userName;
    private String password;
    private String resultPassword;
    private char[] passwordCharArray;
    private java.security.Principal userPrincipal = null;
    private String errorMsg = null;
    
    private static final String amAuthJDBC = "amAuthJDBC";
    private static Debug debug = Debug.getInstance(amAuthJDBC);
    private ResourceBundle bundle = null;
    
    private Map options;
    
    private String CONNECTIONTYPE = "iplanet-am-auth-jdbc-connection-type";
    private String JNDINAME = "iplanet-am-auth-jdbc-jndi-name";
    private String DRIVER = "iplanet-am-auth-jdbc-driver";
    private String URL = "iplanet-am-auth-jdbc-url";
    private String DBUSER = "iplanet-am-auth-jdbc-dbuser";
    private String DBPASSWORD = "iplanet-am-auth-jdbc-dbpassword";
    private String PASSWORDCOLUMN = "iplanet-am-auth-jdbc-password-column";
    private String STATEMENT = "iplanet-am-auth-jdbc-statement";
    private String TRANSFORM = "iplanet-am-auth-jdbc-password-syntax-transform-plugin";
    private String AUTHLEVEL = "iplanet-am-auth-jdbc-auth-level";  
    private String DEFAULT_TRANSFORM =
        "com.sun.identity.authentication.modules.jdbc.ClearTextTransform";
    
    private String driver;
    private String connectionType;
    private String jndiName;
    private String url;
    private String dbuser;
    private String dbpassword;
    private String passwordColumn;
    private String statement;
    private String transform;
    private String authLevel;
    
    private boolean useJNDI = false;
    
    public JDBC() throws LoginException{
        debug.message("JDBC()");
    }

    public void init(Subject subject, Map sharedState, Map options) {
        debug.message("in initialize...");
        java.util.Locale locale  = getLoginLocale();
        bundle = amCache.getResBundle(amAuthJDBC, locale);
        
        if (debug.messageEnabled()) {
            debug.message("amAuthJDBC Authentication resource bundle locale="+
                          locale);
        }
        
        this.options = options;
        
        if(options != null) {
            
            try {
                    
                // First, figure out the type of connection
                connectionType = Misc.getMapAttr(options, CONNECTIONTYPE);
                if (connectionType == null) {
                    debug.message("No CONNECTIONTYPE for configuring");
		    errorMsg ="noCONNECTIONTYPE";
		    return;
                } else { 
                    if (debug.messageEnabled()) {
                        debug.message("Found config for CONNECTIONTYPE: " + 
                                      connectionType);
                    }
               
                    if (connectionType.equals("JNDI")) { 
                        useJNDI = true;
                    }
                    
                    // If its pooled, get the JNDI name
                    if ( useJNDI ) {
                        debug.message("Using JNDI Retrieved Connection pool");
                        jndiName = Misc.getMapAttr(options, JNDINAME);
                        if (jndiName == null) {
                            debug.message("No JNDINAME for configuring");
                            errorMsg ="noJNDINAME";
			    return;
                        } else  { 
                            if (debug.messageEnabled()) {
                                debug.message("Found config for JNDINAME: " + 
                                              jndiName);
                            }
                        }


                        // If its a non-pooled, then get the JDBC config    
                    } else {
                        debug.message("Using non pooled JDBC");
                        driver = Misc.getMapAttr(options, DRIVER);
                        if (driver == null) {
                            debug.message("No DRIVER for configuring");
                            errorMsg ="noDRIVER";
                        } else  {
                            if (debug.messageEnabled()) 
                                debug.message("Found config for DRIVER: " + 
                                              driver);
                        }
                    }

                    url = Misc.getMapAttr(options, URL);
                    if (url == null) {
                        debug.message("No URL for configuring");
                        errorMsg ="noURL";
			return;
                    } else {
                        if (debug.messageEnabled()) { 
                            debug.message("Found config for URL: " + url);
                        }
                    }
                    dbuser = Misc.getMapAttr(options, DBUSER);
                    if (dbuser == null) {
                        debug.message("No DBUSER for configuring");
                        errorMsg = "noDBUSER";
			return;
                    } else  {
                        if (debug.messageEnabled()) {
                            debug.message("Found config for DBUSER: " + 
                                          dbuser);
                        }
                    }

                    dbpassword = Misc.getMapAttr(options, DBPASSWORD, "");
                    if (dbpassword == null) {
                        debug.message("No DBPASSWORD for configuring");
                        errorMsg = "noDBPASSWORD";
			return;
                    } else  {
                        if (debug.messageEnabled())
                            debug.message("Found config for DBPASSWORD: " +
                                          dbpassword);
                    }
                }
                
                // and get the props that apply to both connection types 
                passwordColumn = Misc.getMapAttr(options, PASSWORDCOLUMN);
                if (passwordColumn == null) {
                    debug.message("No PASSWORDCOLUMN for configuring");
                    errorMsg = "noPASSWORDCOLUMN";
		    return;
                } else {
                    if (debug.messageEnabled()) { 
                        debug.message("Found config for PASSWORDCOLUMN: " +
                                      passwordColumn);
                    }
                }          
                statement = Misc.getMapAttr(options, STATEMENT);
                if (statement == null) {
                    debug.message("No STATEMENT for configuring");
                    errorMsg = "noSTATEMENT";
                }                   
                transform = Misc.getMapAttr(options, TRANSFORM);
                if (transform == null) {
                    if (debug.messageEnabled()) {
                        debug.message("No TRANSFORM for configuring."+
                                      "Using clear text");
                    }
                    transform = DEFAULT_TRANSFORM;
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("Plugin for TRANSFORM: " + transform);
                    }
                }
                                        
                String authLevel = Misc.getMapAttr(options, AUTHLEVEL);
                if (authLevel != null) {
                    try {
                        setAuthLevel(Integer.parseInt(authLevel));
                    } catch (Exception e) {
                        debug.error("Unable to set auth level " +
                                    authLevel,e);
                    }
                }
                      
            } catch(Exception ex) {
                debug.error("JDBC Init Exception", ex);
            }
        }
    }
    
    public int process(Callback[] callbacks, int state) 
      throws javax.security.auth.login.LoginException {
	  if (errorMsg != null) {
	      throw new AuthLoginException(amAuthJDBC, errorMsg, null);
	  }
	  int currentState = state;
	  if (debug.messageEnabled()) {
	      debug.message("State: " + currentState);
	  }
        
	  if (currentState != 1) {
	      throw new AuthLoginException(amAuthJDBC, "invalidState", null);
	  }
        
	  userName = ((NameCallback) callbacks[0]).getName();
	  if (debug.messageEnabled()) {
	      debug.message("Authenticating this user: " + userName);
	  }
                
	  passwordCharArray =  ((PasswordCallback) callbacks[1]).getPassword();
	  password = new String(passwordCharArray);
                
	  if (userName !=null && (userName.equals("") ||
				  password.equals(""))) {
	      throw new LoginException(bundle.getString("loginFailed"));
	  }
        
	  // Check if they'return being a bit malicious with their UID.
	  // SQL attacks will be handled by prepared stmt escaping.
	  if (userName.length() > 80 ) {
	      throw new LoginException(bundle.getString("loginFailed"));
	  } 
	  try {
	      Connection database = null;
	      if ( useJNDI ) {        
		  if (debug.messageEnabled()) {
		      debug.message("Using JNDI Retrieved Connection pool");
		  }
		  Context initctx = new InitialContext();
		  DataSource ds = (DataSource)initctx.lookup(jndiName);
		  if (debug.messageEnabled()) { 
		      debug.message("Datasource Acquired: " + ds.toString());
		  }
		  database = ds.getConnection();
		  debug.message("Using JNDI Retrieved Connection pool");
                
	      } else {
		  Class.forName (driver);
		  database = DriverManager.getConnection(url,dbuser,dbpassword);
	      }          
	      if (debug.messageEnabled()) {
		  debug.message("Connection Acquired: " +
				database.toString());    
	      }           
	      //Prepare the statement for execution
	      if (debug.messageEnabled()) {
		  debug.message("PreparedStatement to build: " + statement);
	      }
	      PreparedStatement thisStatement = 
		  database.prepareStatement(statement);
	      // thisStatement.setString(1,passwordColumn);
	      thisStatement.setString(1,userName);
	      if (debug.messageEnabled()) {
		  debug.message("Statement to execute: " + thisStatement);
	      }
            
	      // execute the query
	      ResultSet results = thisStatement.executeQuery();
            
	      // be a good citizen and close or return the connection right away
	      database.close();
            
	      if (results == null) {
		  throw new LoginException(bundle.getString("loginFailed"));
	      }
            
	      //parse the results.  should only be one item in one row.
	      if (results.next()) {
		  if (results.isLast()) {
		      // do normal processing..its the first and last row
		      resultPassword = results.getString(passwordColumn).trim();

		  } else {
		      //error : too many results!
		      if (debug.messageEnabled()) {
			  debug.message("Too many results."+
					"UID should be a primary key");
		      }
		      throw new LoginException(bundle.getString("loginFailed"));
		  } 
	      } else {
		  // no results
		  if (debug.messageEnabled()) {
		      debug.message("No results from your SQL query."+
				    "UID should be valid");
		  }
		  throw new LoginException(bundle.getString("loginFailed"));
	      }

	  } catch (Throwable e) {

	      if (debug.messageEnabled()) {
		  debug.message("JDBC Exception:"+ e.toString());
	      }
	      throw new AuthLoginException(e);
	  }
            
	  if (!transform.equals(DEFAULT_TRANSFORM)) {
                
	      try {
                    
		  JDBCPasswordSyntaxTransform syntaxTransform = 
		      (JDBCPasswordSyntaxTransform)Class.forName(transform).newInstance();
		  if (debug.messageEnabled()) {
		      debug.message("Got my Transform Object" + 
				    syntaxTransform.toString() );
		  }
		  resultPassword = 
		      syntaxTransform.transform(resultPassword);               
		  if (debug.messageEnabled()) {
		      debug.message("Password transformed by: " + transform );
		  }
                    
	      } catch (Throwable e) {
		  if (debug.messageEnabled()) {
		      debug.message("Syntax Transform Exception:"+ 
				    e.toString());
		  }
		  throw new AuthLoginException(e);               
	      }
                
	  }
	  // see if the passwords match
	  if (password != null && password.equals(resultPassword)) {
	      userTokenId = userName;
	      return -1;      
	  } else {           
	      throw new LoginException(bundle.getString("loginFailed"));
	  }
            
    }

    public java.security.Principal getPrincipal() {
        if (userPrincipal != null) {
            return userPrincipal;
        } else if (userTokenId != null) {
            userPrincipal = new JDBCPrincipal(userTokenId);
            return userPrincipal;   
        } else {
            return null;
        }
    }
}
