/**
 * $Id: JCDI.java,v 1.2 2004/02/05 17:54:22 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.authentication.spi.jcdi;

import java.util.*;
import java.io.*;
import java.net.*;
import java.util.logging.*;
import java.io.File;

import java.security.cert.*;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import com.sun.identity.authentication.spi.*;
import com.iplanet.sso.SSOToken;
import com.iplanet.am.sdk.*;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;

public class JCDI extends AMLoginModule {
    
    private String moduleName = "JCDI";
    private String userTokenId;
    private java.security.Principal userPrincipal = null;
    private String userName;
    private String errorMsg = null;
    private static final String amAuthJCDI = "amAuthJCDI";
    private static Debug debug = Debug.getInstance(amAuthJCDI);
    private ResourceBundle bundle = null;
    
    private Map options;
    
    private String LDAPServerName = "iplanet-am-auth-jcdi-LDAPServerName";
    private String LDAPServerDomain = "iplanet-am-auth-jcdi-LDAPServerDomain";
    private String LDAPServer = "iplanet-am-auth-jcdi-LDAPServer";
    private String LDAPPort = "iplanet-am-auth-jcdi-LDAPPort";
    private String LDAPSearchRoot = "iplanet-am-auth-jcdi-LDAPSearchRoot";
    private String LDAPResultAttr = "iplanet-am-auth-jcdi-LDAPResultAttr";
    private String LDAPFilterAttr = "iplanet-am-auth-jcdi-LDAPFilterAttr";
    private String LDAPBindDN = "iplanet-am-auth-jcdi-LDAPBindDN";
    private String LDAPBindPassword = "iplanet-am-auth-jcdi-LDAPBindPassword";
    private String AUTHLEVEL = "iplanet-am-auth-jcdi-auth-level";
    
    private String ldapServerName;
    private String ldapServerDomain;
    private String ldapServer;
    private String ldapPort;
    private String ldapSearchRoot;
    private String ldapResultAttr;
    private String ldapFilterAttr;
    private String ldapBindDN;
    private String ldapBindPassword;
    
    Map serviceAttrs = new HashMap();
      
    public JCDI() throws LoginException{
        debug.message("JCDI ()");
    }
    
    public void init(Subject subject, Map sharedState, Map options) {
        debug.message("in init...");
        java.util.Locale locale  = getLoginLocale();
        bundle = amCache.getResBundle(amAuthJCDI, locale);
        
        if (debug.messageEnabled()) {
            debug.message("amAuthJCDI Authentication resource bundle locale="+
            locale);
        }      
              
        this.options = options;
        
        if(options != null) {
            
            try {                
                ldapServerName = Misc.getMapAttr(options, LDAPServerName);
                if (ldapServerName == null) {
                    debug.message("No LDAP server name for configuring");
                    errorMsg ="noLDAPServerName";
                    return;
                } 
                serviceAttrs.put("SERVER_NAME", ldapServerName);
                
                ldapServerDomain = Misc.getMapAttr(options, LDAPServerDomain);
                if (ldapServerDomain == null) {
                    debug.message("No LDAPServerDomain for configuring");
                    errorMsg = "noLDAPServerDomain";
                    return;
                } 
                serviceAttrs.put("SERVER_DOMAIN", ldapServerDomain);
                
                ldapServer = Misc.getMapAttr(options, LDAPServer);
                if (ldapServer == null) {
                    debug.message("No LDAP Server for configuring");
                    errorMsg ="noLDAPServer";
                    return;
                }
                serviceAttrs.put("SERVER", ldapServer);
                
                ldapPort = Misc.getMapAttr(options, LDAPPort);
                if (ldapPort == null) {
                    debug.message("No LDAP Port for configuring");
                    errorMsg = "noLDAPPort";
                    return;
                }
                serviceAttrs.put("PORT", ldapPort);
                
                ldapSearchRoot = Misc.getMapAttr(options, LDAPSearchRoot);
                if (ldapSearchRoot == null) {
                    debug.message("No LDAP Search root for configuring");
                    errorMsg = "noLDAPSearchRoot";
                }
                serviceAttrs.put("SEARCH_ROOT", ldapSearchRoot);
                
                ldapResultAttr = Misc.getMapAttr(options, LDAPResultAttr); 
                serviceAttrs.put("RESULT_ATTR", ldapResultAttr);
                
                ldapFilterAttr = Misc.getMapAttr(options, LDAPFilterAttr);
                serviceAttrs.put("FILTER_ATTR", ldapFilterAttr);
                
                ldapBindDN = Misc.getMapAttr(options, LDAPBindDN);
                serviceAttrs.put("BIND_DN", ldapBindDN);
                
                ldapBindPassword = Misc.getMapAttr(options, LDAPBindPassword);
                serviceAttrs.put("BIND_PASSWORD", ldapBindPassword);
                
                String authLevel = Misc.getMapAttr(options, AUTHLEVEL);
                if (authLevel != null) {
                    serviceAttrs.put("AUTH_LEVEL", authLevel);
                    try {
                        setAuthLevel(Integer.parseInt(authLevel));
                    } catch (Exception e) {
                        debug.error("Unable to set auth level " +
                        authLevel,e);
                    }
                }
                
            } catch(Exception ex) {
                debug.error("JDBC Init Exception", ex);
            }
        }
    }
    
    public int process(Callback[] callbacks, int state) throws LoginException {
        
        if (errorMsg != null) {
	    throw new AuthLoginException(amAuthJCDI, errorMsg, null);
	}
	
        int currentState = state;
	if (debug.messageEnabled()) {
	    debug.message("State: " + currentState);
	}
        
        // Serial Number
        String serialNumber;
        
        // Certificate
        String userCertificate;
        
        try {
            
            debug.message("Start Processing");
            
            // Process each state of the authentication
            if (currentState == 1) {
                
                // Get the serial number
                serialNumber = ((NameCallback) callbacks[0]).getName();
                
                // Get the user certificate
                userCertificate =  ((NameCallback) callbacks[1]).getName();
                
                if (serialNumber == null || serialNumber.equals("") || 
                    userCertificate == null || userCertificate.equals("")) {
                    debug.message("Serial number and/or user certificate are empty");
                    throw new AuthLoginException(
                    "Serial number and/or user certificate must not be empty");
                }
                
                // Create the Authentication LDAP search
                AuthLdapCert auth = new AuthLdapCert(debug, serviceAttrs);
                
                try {
                    
                    // Init the search
                    auth.init(userCertificate, serialNumber);
                    
                    // Search for the cuid into LDAP and retreive the certificate
                    auth.search("authentication-cuid", serialNumber);
                    
                    // Compare the two certificates (user and LDAP)
                    if (!auth.compareCertificate()) {
                        debug.message("User Certificate not valid");
                        throw new AuthLoginException("Certificate not valid");
                    }
                    
                    // Retreive the user name/Id
                    userName = auth.getUsername();
                    
                    if (debug.messageEnabled()) {
                        debug.message("User name : " + userName);
                    }
                    
                    // Replace the callback of step 2 with the userName
                    replaceCallback(2, 0, new NameCallback(userName));
                }
                catch (Exception e) {
                    
                    // Login Exception
                    if (e instanceof CertificateException) {
                        if (debug.messageEnabled()) {
                            debug.message("Error in Cert format : "+e.getMessage());
                        }
                    }
                    debug.message("serial Number/Certificate not valid");
                    throw new AuthLoginException("serial Number/Certificate not valid" );
                }
                return 2;
                
            } else if (currentState == 2) {
                userTokenId = userName;
                return -1;
            }
            
            // Invalid state
            debug.message("Invalid State");
            throw new AuthLoginException(amAuthJCDI, "invalidState", null);
        }
        
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("Login failed : " + e.getMessage());
            }
            throw new AuthLoginException("Login failed");
        }
    }
    
    public java.security.Principal getPrincipal() {
        if (userPrincipal != null) {
            return userPrincipal;
        } else if (userTokenId != null) {
            userPrincipal = new JCDIPrincipal(userTokenId);
            return userPrincipal;
        } else {
            return null;
        }
    }
}
