/**
 * $Id: AuthLdapCert.java,v 1.2 2004/02/05 17:54:22 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.authentication.spi.jcdi;

import java.util.*;
import java.io.*;
import java.net.*;
import java.util.logging.*;
import java.io.File;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.cert.*;
import javax.naming.Context;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.DirContext;
import javax.naming.directory.Attributes;
import javax.naming.NamingException;
import com.iplanet.am.sdk.*;
import com.iplanet.sso.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.naming.directory.*;
import javax.naming.*;
import com.iplanet.am.util.Debug;

public class AuthLdapCert {
    
    private String moduleName = "AuthLdapCert";
    private Certificate userCertificate;
    private String strUserCertificate;
    private Certificate ldapCertificate;
    private CertificateFactory cf;
    private String serialNumber;
    private Set results;
    private UserCert userCert;
    private static Debug debug;
    private Map serviceAttrs = new HashMap();
    
  /** Creates a new instance of AuthLdapCert */
  public AuthLdapCert(Debug debug, Map serviceAttrs) {
      this.debug = debug;
      this.serviceAttrs = serviceAttrs;
  }
    
  public void init(String strCertificate, String serialNumber) 
  throws CertificateException {
          
    debug.message("AuthLdapCert init");
          
    // Create the X509 certificate factory
    cf = CertificateFactory.getInstance("X.509");
    strUserCertificate = strCertificate;
    ByteArrayInputStream buffer = 
        new ByteArrayInputStream(strCertificate.getBytes());
        
    // Generate the certificate based on the string
    this.userCertificate = cf.generateCertificate(buffer);
    this.serialNumber = serialNumber;
  }
    
  public String getUsername() {
    return userCert.userId;
  }
    

  public UserCert search(String searchAttributeName, String serialNumber) 
  throws AMException, SSOException, Exception {
        
    AMUser amuser;
    String uid = null;
    boolean found = false;
    
    debug.message("Entering Search");

    String tmpStr = null;
    Hashtable env = new Hashtable();
    env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");

    tmpStr = "ldap://" + serviceAttrs.get("SERVER_NAME") + "." + 
        serviceAttrs.get("SERVER_DOMAIN") + ":" + serviceAttrs.get("PORT");
    if (debug.messageEnabled()) {
        debug.message("The LDAP Server access we use is : " + tmpStr);
    }
    env.put(Context.PROVIDER_URL, tmpStr);

    tmpStr = (String) serviceAttrs.get("BIND_DN");
    if (debug.messageEnabled()) {
        debug.message("The LDAP Server BIND DN is : " + tmpStr);
    }
    env.put(Context.SECURITY_PRINCIPAL, tmpStr);

    tmpStr = (String) serviceAttrs.get("BIND_PASSWORD");
    if (debug.messageEnabled()) {
        debug.message("The LDAP Server BIND PASSWORD is : " + tmpStr);
    }
    env.put(Context.SECURITY_CREDENTIALS, tmpStr);

    tmpStr = (String) serviceAttrs.get("FILTER_ATTR");
    String filter = "("+ tmpStr + "=" + serialNumber +")";
    if (debug.messageEnabled()) {
        debug.message("The LDAP filter we use is : " + filter);
    }
	
    Attributes matchAttrs = new BasicAttributes(true);
    String attrIDs[] = new String[3];
    attrIDs[0] = "uid";
    attrIDs[1] = "authentication-cuid";
    attrIDs[2] = "usercertificate";
    SearchControls ctls = new SearchControls();
    ctls.setReturningAttributes(attrIDs);

    // --------------------------------------------------

    try {
        if (debug.messageEnabled()) {      
            debug.message("Looking for cert linked to serialnumber: " + 
                          serialNumber);
        }
        
        DirContext ctx = new InitialDirContext(env);
        
        String ldapServerSearchRoot = (String) serviceAttrs.get("SEARCH_ROOT");
        if (debug.messageEnabled()) {  
            debug.message("The LDAP Search Root is : " + ldapServerSearchRoot);
        }
    
        // the search fileter is on the cuid
        NamingEnumeration ne = ctx.search(ldapServerSearchRoot, filter, ctls);
    
        if (ne.hasMore()) {
            debug.message("found the right one!");
        
            userCert = new UserCert();
    	    Attribute resAttr = null;
            SearchResult sr = (SearchResult)ne.next();
            Attributes attrs = sr.getAttributes();
            if (debug.messageEnabled()) {  
                debug.message("Number of attributes found : "  + 
                              (new Integer(attrs.size())).toString());
            }
    
            // YES, it's found !
            found = true;
    
            // filling the userCert structure with found attributes
            // The serial number
            resAttr = attrs.get("authentication-cuid");
    
            if (debug.messageEnabled()) {  
                debug.message("attribute authentication-cuid has " + 
                              (new Integer(resAttr.size())).toString() + " values");
            }
            userCert.serialNumber = (String)resAttr.get();

            if (debug.messageEnabled()) {  
                debug.message("user serial number is : " + userCert.serialNumber);
            }
    
            // The user name 
            resAttr = attrs.get("uid");
            if (debug.messageEnabled()) {  
                debug.message("attribute uid has " + 
                              (new Integer(resAttr.size())).toString() + " values");
            }
            userCert.userId = (String)resAttr.get();

            if (debug.messageEnabled()) {
                debug.message("user id is : " + userCert.userId);
            }
                
            // The certificate
            // Generate the certificate based on the string
            resAttr = attrs.get("usercertificate");
            byte[] tmpbytes = (byte [])resAttr.get();

            if (debug.messageEnabled()) {
                debug.message("attribute  usercertificate has " + 
                              (new Integer(resAttr.size())).toString() + " values");
            }
            userCert.ldapCertificate = new String(tmpbytes);

            if (debug.messageEnabled()) {
                debug.message("user certificate is : " + userCert.ldapCertificate);
            }
    
            ByteArrayInputStream buffer = new ByteArrayInputStream(tmpbytes);
            ldapCertificate = cf.generateCertificate(buffer);
    
            return userCert;
        }
        else {
    	    found = false;
            if (debug.messageEnabled()) {
    	        debug.message("LDAP error: no user found for given serial number: " + 
                          serialNumber);
            }
    	    throw new Exception("not found");
        }
    } catch (Exception dirE) {
        if (debug.messageEnabled()) {
            debug.message("LDAP error: " + dirE.toString() + 
                          dirE.getClass().getName() + dirE.getMessage());
        }
    }
	
    return userCert;
  }
    
  public boolean compareCertificate() {
    return (ldapCertificate.equals(userCertificate));
  }
}

