/**
 * $Id: LDAPLogin.java,v 1.2 2004/02/05 17:54:20 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.io.*;
import java.util.*;

import java.security.Principal;
import javax.security.auth.*;
import javax.security.auth.login.*;
import javax.security.auth.callback.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.iplanet.am.util.Debug;


public class LDAPLogin {
    
    static String indexName = "";
    static AuthContext.IndexType indexType;
    static String orgName = "";
    static boolean debug = true;
    
    public static  void main(String[] args) {
        // Initialize DSAMELoginContext
        AuthContext lc = null;
	orgName = args[0];
        debugMessage("orgname is : " + orgName);
        try {
            lc = new AuthContext(orgName);
	    indexType = AuthContext.IndexType.MODULE_INSTANCE;
	    indexName = "LDAP";
            debugMessage("LDAPLogin: Obtained login context");
            lc.login(indexType, indexName);
        } catch (AuthLoginException le) {
            le.printStackTrace();
	    debugMessage("Login failed!!");
            return;
        }

	Callback[] callbacks = null;
	// get information requested from module
	while (lc.hasMoreRequirements()) {
	    callbacks = lc.getRequirements();

	    if (callbacks != null) {
		try {
		    addLoginCallbackMessage(callbacks);
		    lc.submitRequirements(callbacks);
		} catch (Exception e) {
		    debugMessage("Login failed!!");
		    return;
		}
	    }
	}

	if (lc.getStatus() == AuthContext.Status.SUCCESS) {
	    debugMessage("Login success!!");
	} else if (lc.getStatus() == AuthContext.Status.FAILED) {
	    debugMessage("Login has failed!!");
	} else {
	    debugMessage("Unknown status: " + lc.getStatus());
	}
	System.exit(0);
    }

    // get user's inputs and set them to callback array.
    static void addLoginCallbackMessage(Callback[] callbacks) throws UnsupportedCallbackException {
        debugMessage("begin addLoginCallbackMessage()");
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; i++) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    debugMessage("Got TextOutputCallback");
                    // display the message according to the specified type
                    TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                    switch (toc.getMessageType()) {
                        case TextOutputCallback.INFORMATION:
                            debugMessage(toc.getMessage());
                            break;
                        case TextOutputCallback.ERROR:
                            debugMessage("ERROR: " + toc.getMessage());
                            break;
                        case TextOutputCallback.WARNING:
                            debugMessage("WARNING: " + toc.getMessage());
                            break;
                        default:
                            debugMessage("Unsupported message type: " +
                            toc.getMessageType());
                    }
                } else if (callbacks[i] instanceof NameCallback) {
                    debugMessage("Got NameCallback");
                    // prompt the user for a username
                    NameCallback nc = (NameCallback) callbacks[i];
                    debugMessage(nc.getPrompt());
                    System.err.flush();
                    nc.setName((new BufferedReader
                    (new InputStreamReader(System.in))).readLine());

                } else if (callbacks[i] instanceof PasswordCallback) {
                    debugMessage("Got PasswordCallback");
                    // prompt the user for sensitive information
                    PasswordCallback pc = (PasswordCallback) callbacks[i];
                    System.err.print(pc.getPrompt());
                    System.err.flush();
                    pc.setPassword(readPassword(System.in));

                } else if (callbacks[i] instanceof TextInputCallback) {
                    debugMessage("Got TextInputCallback");
                    // prompt for text input
                    TextInputCallback tic = (TextInputCallback) callbacks[i];
                    // ignore the provided defaultValue
                    System.err.print(tic.getPrompt());
                    System.err.flush();
                    tic.setText((new BufferedReader
                    (new InputStreamReader(System.in))).readLine());

                } else if (callbacks[i] instanceof ChoiceCallback) {
                    debugMessage("Got ChoiceCallback");
                    // prompt for choice input
                    ChoiceCallback cc = (ChoiceCallback) callbacks[i];
                    // ignore the provided defaultValue
                    System.err.print(cc.getPrompt());

                    String[] strChoices = cc.getChoices();
                    for (int j = 0; j < strChoices.length; j++) {
                        System.err.print("choice[" + j + "] : " + strChoices[j]);
                    }
                    System.err.flush();
                    cc.setSelectedIndex(Integer.parseInt((new BufferedReader
                    (new InputStreamReader(System.in))).readLine()));
                }
            }
        } catch (Exception e) {
            throw new UnsupportedCallbackException(callbacks[i], "Callback exception: " + e);
        }
    }

    // Reads user password from given input stream.
    private static char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf;
        int i;

        buf = lineBuffer = new char[128];

        int room = buf.length;
        int offset = 0;
        int c;

        loop:
            while (true) {
                switch (c = in.read()) {
                    case -1:
                    case '\n':
                        break loop;

                    case '\r':
                        int c2 = in.read();
                        if ((c2 != '\n') && (c2 != -1)) {
                            if (!(in instanceof PushbackInputStream)) {
                                in = new PushbackInputStream(in);
                            }
                            ((PushbackInputStream)in).unread(c2);
                        } else
                            break loop;

                    default:
                        if (--room < 0) {
                            buf = new char[offset + 128];
                            room = buf.length - offset - 1;
                            System.arraycopy(lineBuffer, 0, buf, 0, offset);
                            Arrays.fill(lineBuffer, ' ');
                            lineBuffer = buf;
                        }
                        buf[offset++] = (char) c;
                        break;
                }
            }

            if (offset == 0) {
                return null;
            }

            char[] ret = new char[offset];
            System.arraycopy(buf, 0, ret, 0, offset);
            Arrays.fill(buf, ' ');

            return ret;
    }

    static void debugMessage(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

}
        
