/**
 * $Id: IasSampleUserInfo.java,v 1.6 2004/02/05 17:54:16 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.appserver;

import java.io.*;
import java.net.*;
import java.util.*;
import com.iplanet.am.sdk.*;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This example file describes the deployment of servlets/jsps
 * (web application) when integrating with DSAME on iAS.
 * This is a user bean for the JSP page where it gets the user DN and
 * SSO Token from the HttpServletRequest and inturn gets the user 
 * information by using them.
 */



public class IasSampleUserInfo {

    SSOToken ssoToken = null;
    String userDN = null;
    AMStoreConnection dpsc = null;
    AMUser dpUser = null;
    Map attrValues = null;
    private String uid = null;
    private String lastname = null;
    private String firstname = null;
    private String fullname = null;
    private String status = null;
    private static Debug debug = Debug.getInstance("amSDK");
    private String userId = null;


    /*
     * JSP user bean needs empty constructor
     */

    public IasSampleUserInfo () {
    }

    /* 
     * Get the SSO Token and userDN information from HttpServletRequest
     */

    public void initSSOToken(HttpServletRequest request) {
      try {
           SSOTokenManager manager = SSOTokenManager.getInstance();
           ssoToken = manager.createSSOToken(request);  
           manager.validateToken(ssoToken);
	   userDN = (String)request.getAttribute("userDN");
	   getIasSampleUserInfo();
      } catch (SSOException ex) {
	 debug.message("SSO Exception occured");
      }
    }

   /*
    * Get the user information using AMSDK
    */


    public void getIasSampleUserInfo() {
     try {
         dpsc = new AMStoreConnection(ssoToken);
         dpUser = dpsc.getUser(userDN);
	 uid = dpUser.getStringAttribute("uid");
	 lastname = dpUser.getStringAttribute("sn");
	 firstname = dpUser.getStringAttribute("cn");
	 fullname = dpUser.getStringAttribute("givenname");
	 status = dpUser.getStringAttribute("inetuserstatus");
     } catch (Exception ex) {
	debug.message("IasSampleUserInfo: Exception occured");
	debug.message(ex.toString());
     }
    }

   /*
    * These functions help JSP to display the user attributes 
    */ 

    public String getUid() {
        return uid;
    }
    public String getLastName() {
        return lastname;
    }
    public String getFirstName() {
        return firstname;
    }
    public String getFullName() {
        return fullname;
    }
    public String getInetUserStatus() {
        return status;
    }

}
