/**
 * $Id: IasSampleServlet.java,v 1.5 2004/02/05 17:54:16 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.appserver;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.iplanet.sso.*;
import com.iplanet.am.sdk.*;

/**
 * This example file just describes the deployment of servlets/jsps
 * (web application) when integrating with DSAME on iAS.
 * This servlet gets the user information from a static HTML page and creates
 * as a DSAME user. Once it is successfully created, it transfers the request
 * to a JSP page where it gets the user information from a DSAME Directory
 * Server and display it to the user
 */ 


public class IasSampleServlet extends HttpServlet {

    String userDN = null;



    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request,
		      HttpServletResponse response)
	throws ServletException, IOException {
	doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request,
		      HttpServletResponse response)
	throws ServletException, IOException {
	doGetPost(request, response);
    }

    public void doGetPost(HttpServletRequest request, 
		       HttpServletResponse response)
	throws ServletException, IOException {

      boolean showOnly = false;
      boolean createOnly = false;

      /* 
       * Get all the user parameters from an HTML form
       */

      String userId = request.getParameter("userUid");
      String firstName = request.getParameter("firstName");
      String lastName = request.getParameter("lastName");
      String fullName = request.getParameter("fullName");
      String password = request.getParameter("userPassword");
      String email = request.getParameter("emailAddress");
      String org = request.getParameter("organization");
      String rootSuffix = request.getParameter("rootsuffix");
      userDN = request.getParameter("userDN");

      String showUser = request.getParameter("showUser");
      if ( showUser != null ) {
	  showOnly = true;
      }
      String createUser = request.getParameter("createUser");
      if ( createUser != null ) {
	  createOnly = true;
      }

      /*
       * This case should never happen, incase if it happens
       */

      if ( (createUser != null) && (showUser != null)) {
         response.sendRedirect("create.html");
	 return;
      }

     
      try {

        /* create the sso token from http requeest 
	 * This example does not work unless SSO Token is available 
	 */
         SSOTokenManager manager = SSOTokenManager.getInstance();
         SSOToken token = manager.createSSOToken(request);

         /* use isValid to method to check if the token is valid or not
          * this method retuns true for valid token, false otherise
          */
          if (manager.isValidToken(token)) {
		if (showOnly) {
		   /* If the request is display only, then we forward the
		    * request to a JSP page by forwarding the user DN along 
		    * with it so that jsp bean can get the user info
		    * This basic purpose of this example is to show the
		    * usage of jsps/servlets  but not the complexities   
		    */
		   gotoPage("/IasSample.jsp", request, response);
		} else if (createOnly) {

		  /*
		   * Create a user by calling AMSDK from here.
		   * Create User needs all the attribute value pairs in a Map
		   */
		   Map userAttributes = new HashMap();
		   Map userAttributeValues = new HashMap();

		   userAttributeAdd("userPassword", password, userAttributeValues);
		   userAttributeAdd("cn", fullName, userAttributeValues);
		   userAttributeAdd("givenname", firstName, userAttributeValues);
		   userAttributeAdd("sn",lastName, userAttributeValues);
		   userAttributeAdd("mail", email, userAttributeValues);

		   userAttributes.put(userId, userAttributeValues);
		   String pcdn = "ou=People," + org + "," + rootSuffix;

		   try {
	             AMStoreConnection dpsc = new AMStoreConnection(token);
		     AMPeopleContainer dppc = dpsc.getPeopleContainer(pcdn);
		     dppc.createUsers(userAttributes);
		     gotoPage("/Success.jsp", request, response);
		   } catch (AMException dex) {
		    gotoPage("/Fail.jsp", request, response);
		   }
		  
		}
          }  
      } catch (SSOException e) {
	 gotoPage("/SSOFailure.jsp", request, response);
      }
    }

   /*
    * This function is just to fill the user attribute values 
    */

    public void userAttributeAdd(String attribute, String attrValue, Map userMap) {
      HashSet userSet = new HashSet();
      userSet.add(attrValue);
      userMap.put(attribute, userSet);
    }

    /*
     * This function redirects the requests to JSPs 
     */

    public void gotoPage(String address,
			HttpServletRequest request,
			HttpServletResponse response)
	throws ServletException, IOException {

	/* Set the user id in the case of display user */
        if (userDN != null) {
            request.setAttribute("userDN", userDN);
        }
       
         RequestDispatcher  dispatcher =
		getServletContext().getRequestDispatcher(address);
         dispatcher.forward(request, response); 
    }
}
