/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.SecurityMessage;
import com.sun.wbem.security.SecurityToken;
import com.sun.wbem.security.SecurityUtil;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.WorkMod51;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;

public class RmiClientSecurity
implements ClientSecurityContext {
    private static String mechanism = "RmiDigest";
    private static boolean initialized = false;
    private static MessageDigest md = null;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey cprivkey;
    private static PublicKey cpubkey;
    private CIMNameSpace nameSpace;
    private Principal principal;
    private String userName;
    private byte[] userPswd;
    private String nsHost;
    private String nsPath;
    private boolean bEstablished = false;
    private PublicKey spubkey;
    private String initialKey = "InitialKey";
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] encryptKey = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    private static synchronized void initialize() throws NoSuchAlgorithmException {
        if (!initialized) {
            md = MessageDigest.getInstance("MD5");
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            cprivkey = keypair.getPrivate();
            cpubkey = keypair.getPublic();
            initialized = true;
        }
    }

    public RmiClientSecurity() throws NoSuchAlgorithmException {
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
        RmiClientSecurity.initialize();
    }

    public RmiClientSecurity(CIMNameSpace ns, Principal prin, Object cred) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(ns);
        this.setPrincipal(prin);
        this.setCredential(cred);
        RmiClientSecurity.initialize();
    }

    public String getMechanism() {
        return mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace namespace) throws CIMException {
        if (namespace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = namespace;
        this.nsHost = namespace.getHost();
        this.nsPath = namespace.getNameSpace();
    }

    public void setPrincipal(Principal prin) throws CIMException {
        if (prin == null || !(prin instanceof UserPrincipal)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = prin;
        this.userName = prin.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    public void setCredential(Object cred) throws CIMException {
        String tPswd = null;
        if (cred != null) {
            if (cred instanceof PasswordCredential) {
                tPswd = new String(((PasswordCredential)cred).getUserPassword());
            } else if (cred instanceof String) {
                tPswd = new String((String)cred);
            }
        }
        if (tPswd == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int len = tPswd.length();
        this.userPswd = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = tPswd.charAt(i);
            this.userPswd[i] = (byte)c;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getRoleName() {
        return null;
    }

    public String getRolePassword() {
        return null;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getUserName() {
        return this.userName;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return cpubkey;
    }

    public PublicKey getServerPublicKey() {
        return this.spubkey;
    }

    public PrivateKey getPrivateKey() {
        return cprivkey;
    }

    public MessageDigest getMD() {
        return md;
    }

    public Signature getSigner() {
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateHello() {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            byte[] cchallenge1 = new byte[16];
            SecurityUtil.secrand.nextBytes(cchallenge1);
            md.reset();
            md.update(cchallenge1);
            md.update(this.initialKey.getBytes());
            byte[] digest = md.digest();
            byte[] unb = this.userName.getBytes();
            byte[] nsb = this.nsPath.getBytes();
            byte[] hashedUser = SecurityUtil.hashData(unb, digest);
            byte[] hashednsb = SecurityUtil.hashData(nsb, digest);
            md.reset();
            md.update(cchallenge1);
            md.update(this.initialKey.getBytes());
            md.update(hashedUser);
            return SecurityMessage.hello(cchallenge1, hashedUser, hashednsb, md.digest(hashednsb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateResponse(SecurityMessage sm) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!sm.isChallenge()) {
                throw new IllegalArgumentException("not a challenge message");
            }
            this.schallenge1 = sm.getChallenge();
            md.reset();
            md.update(sm.getChallenge());
            byte[] digest = md.digest(this.initialKey.getBytes());
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(sm.getSalt());
            if (!MessageDigest.isEqual(md.digest(sm.getSessionId()), sm.getChecksum())) {
                throw new IllegalArgumentException("Checksum error");
            }
            byte[] salt = SecurityUtil.extractHashedData(sm.getSalt(), digest);
            this.sessionId = sm.getSessionId();
            if (salt == null || this.sessionId == null) {
                throw new IllegalArgumentException("Null salt/session");
            }
            byte[] cf = new WorkMod51().mod51Format(this.userPswd, salt);
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(cf);
            digest = md.digest();
            byte[] pwHash = SecurityUtil.hashData(this.userPswd, digest);
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(cf);
            md.update(pwHash);
            md.update(cpubkey.getEncoded());
            return SecurityMessage.response(pwHash, cpubkey, this.sessionId, md.digest(this.sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checkResult(SecurityMessage sm) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!sm.isResult()) {
                throw new IllegalArgumentException("not a result message");
            }
            md.reset();
            md.update(this.getChallenge());
            md.update(this.userPswd);
            byte[] digest = md.digest();
            md.reset();
            md.update(this.getChallenge());
            md.update(this.userPswd);
            md.update(sm.getSessionId());
            this.spubkey = sm.getPublicKey();
            md.update(this.spubkey.getEncoded());
            md.update(sm.getResponse());
            if (!MessageDigest.isEqual(md.digest(), sm.getChecksum())) {
                throw new IllegalArgumentException("mutual authentication failed");
            }
            this.sessionKey = SecurityUtil.extractHashedData(sm.getResponse(), digest);
            if (this.sessionKey == null) {
                throw new IllegalArgumentException("Null response");
            }
            this.encryptKey = new byte[this.sessionKey.length];
            System.arraycopy(this.sessionKey, 0, this.encryptKey, 0, this.sessionKey.length);
            return this.sessionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityToken getSecurityToken(String[] sarray) throws CIMException {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            SecurityToken st = new SecurityToken();
            String s = "";
            for (int i = 0; i < sarray.length; ++i) {
                s = s + sarray[i];
            }
            byte[] ser = s.getBytes();
            MessageDigest digester = this.getMD();
            digester.reset();
            digester.update(this.getSessionKey());
            digester.update(ser);
            byte[] digest = digester.digest();
            st.setChecksum(digest);
            st.setSessionId(this.getSessionId());
            return st;
        }
    }

    public synchronized void incSessionKey() {
        SecurityUtil.incByteArray(this.sessionKey);
    }

    public String trans51Format(String inData) throws CIMException {
        int i;
        if (inData.length() > 15 || this.encryptKey == null) {
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] pwb = inData.getBytes();
        int len = this.encryptKey.length;
        byte[] rb = new byte[len];
        System.arraycopy(this.encryptKey, 0, rb, 0, len);
        byte[] pad = new byte[len];
        SecurityUtil.secrand.nextBytes(pad);
        for (i = 0; i < pwb.length; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
        }
        int n = i++;
        rb[n] = (byte)(rb[n] ^ 0);
        while (i < rb.length) {
            int n2 = i;
            rb[n2] = (byte)(rb[n2] ^ pad[i]);
            ++i;
        }
        String val = this.toHex(rb);
        return val;
    }

    private String toHex(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    private byte[] fromHex(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        byte[] ba = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int k;
            ba[j] = 0;
            boolean ok = false;
            char c = str.charAt(i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(k << 4 & 0xF0);
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ok = false;
            c = str.charAt(++i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(ba[j] | (byte)(k & 0xF));
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ++j;
        }
        return ba;
    }

    static {
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

