/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.query;

import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.query.DateTimeExp;
import com.sun.wbem.query.NumericValue;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.StringValueExp;
import com.sun.wbem.query.ValueExp;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;

public class BinaryRelQueryExp
extends QueryExp {
    private int relOp;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryRelQueryExp(int op, ValueExp v1, ValueExp v2) {
        this.relOp = op;
        this.exp1 = v1;
        this.exp2 = v2;
    }

    public BinaryRelQueryExp() {
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    public boolean apply(CIMElement obj) throws CIMException {
        return this.doApply(this.exp1.apply(obj), this.exp2.apply(obj));
    }

    private boolean doApply(Object val1, Object val2) throws CIMException {
        boolean numeric = val1 instanceof NumericValue;
        if (val1 == null || val2 == null) {
            return false;
        }
        if (numeric) {
            BigDecimal bdval1 = new BigDecimal(val1.toString());
            BigDecimal bdval2 = new BigDecimal(val2.toString());
            switch (this.relOp) {
                case 0: {
                    return bdval1.compareTo(bdval2) > 0;
                }
                case 1: {
                    return bdval1.compareTo(bdval2) < 0;
                }
                case 2: {
                    return bdval1.compareTo(bdval2) >= 0;
                }
                case 3: {
                    return bdval1.compareTo(bdval2) <= 0;
                }
                case 4: {
                    return bdval1.compareTo(bdval2) == 0;
                }
                case 5: {
                    return bdval1.compareTo(bdval2) != 0;
                }
            }
        }
        if (val1 instanceof DateTimeExp || val2 instanceof DateTimeExp) {
            if (!(val1 instanceof DateTimeExp)) {
                try {
                    val1 = new DateTimeExp(((StringValueExp)val1).getValue());
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", val1.toString());
                }
            }
            CIMDateTime dtval1 = ((DateTimeExp)val1).getValue();
            if (!(val2 instanceof DateTimeExp)) {
                try {
                    val2 = new DateTimeExp(((StringValueExp)val2).getValue());
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", val2.toString());
                }
            }
            CIMDateTime dtval2 = ((DateTimeExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return dtval1.after(dtval2);
                }
                case 1: {
                    return dtval1.before(dtval2);
                }
                case 2: {
                    return dtval1.after(dtval2) || dtval1.equals(dtval2);
                }
                case 3: {
                    return dtval1.before(dtval2) || dtval1.equals(dtval2);
                }
                case 4: {
                    return dtval1.equals(dtval2);
                }
                case 5: {
                    return !dtval1.equals(dtval2);
                }
            }
        } else {
            String sval1 = ((StringValueExp)val1).getValue();
            String sval2 = ((StringValueExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return sval1.compareTo(sval2) > 0;
                }
                case 1: {
                    return sval1.compareTo(sval2) < 0;
                }
                case 2: {
                    return sval1.compareTo(sval2) >= 0;
                }
                case 3: {
                    return sval1.compareTo(sval2) <= 0;
                }
                case 4: {
                    return sval1.compareTo(sval2) == 0;
                }
                case 5: {
                    return sval1.compareTo(sval2) != 0;
                }
                case 6: {
                    return this.like(sval1, sval2);
                }
                case 7: {
                    return !this.like(sval1, sval2);
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.exp1 + " " + this.relOpString() + " " + this.exp2;
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "LIKE";
            }
            case 7: {
                return "NOT LIKE";
            }
            case 8: {
                return "ISA";
            }
            case 9: {
                return "NOT ISA";
            }
        }
        return "=";
    }

    private String trimPercent(String pattern) {
        StringCharacterIterator ci = new StringCharacterIterator(pattern);
        StringBuffer sb = new StringBuffer();
        int prevc = 65535;
        char c = ci.first();
        while (c != '\uffff') {
            if (c != '%' || prevc != 37) {
                sb.append(c);
            }
            prevc = c;
            c = ci.next();
        }
        return sb.toString();
    }

    private boolean like(String match, String pattern) {
        int prevState = -1;
        int currState = 0;
        int backtrack = -1;
        char backtrackChar = '\uffff';
        int length = match.length();
        pattern = this.trimPercent(pattern);
        int endIndex = pattern.length() - 1;
        for (int i = 0; i < length; ++i) {
            char a;
            if (currState > endIndex) {
                return false;
            }
            char pcs = pattern.charAt(currState);
            if (pcs == '%') {
                prevState = currState;
                if (currState == endIndex) {
                    return true;
                }
                a = match.charAt(i);
                if (a != pattern.charAt(currState + 1)) continue;
                currState += 2;
                backtrackChar = a;
                backtrack = -1;
                continue;
            }
            a = match.charAt(i);
            if (backtrack == -1 && a == backtrackChar) {
                backtrack = i;
            }
            if (a != pcs) {
                if (prevState == -1) {
                    return false;
                }
                currState = prevState;
                if (backtrack == -1) continue;
                i = backtrack - 1;
                backtrack = -1;
                continue;
            }
            ++currState;
        }
        return currState > endIndex || currState == endIndex && pattern.charAt(endIndex) == '%';
    }
}

