/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.HttpClient;
import com.sun.wbem.client.http.Hurryable;
import com.sun.wbem.client.http.MeteredStream;
import com.sun.wbem.client.http.ProgressData;
import com.sun.wbem.client.http.ProgressEntry;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KeepAliveStream
extends MeteredStream
implements Hurryable {
    HttpClient hc;
    boolean hurried;

    public KeepAliveStream(InputStream is, ProgressEntry te, HttpClient hc) {
        super(is, te);
        this.hc = hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.expected > this.count) {
                long nskip = this.expected - this.count;
                if (nskip <= (long)this.available()) {
                    long n = 0L;
                    while (n < nskip) {
                        n = this.skip(nskip -= n);
                    }
                } else {
                    this.hc.closeServer();
                }
            }
            if (!this.closed && !this.hurried) {
                this.hc.finished();
            }
        }
        finally {
            ProgressData.pdata.unregister(this.te);
            this.in = null;
            this.hc = null;
            this.closed = true;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int limit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public synchronized boolean hurry() {
        try {
            if (this.closed || this.count >= this.expected) {
                return false;
            }
            if (this.in.available() < this.expected - this.count) {
                return false;
            }
            byte[] buf = new byte[this.expected - this.count];
            DataInputStream dis = new DataInputStream(this.in);
            dis.readFully(buf);
            this.in = new ByteArrayInputStream(buf);
            this.hurried = true;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

