/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlInstance;
import java.util.Calendar;
import java.util.Vector;

class XmlMessage
extends XmlInstance {
    static final String PROTOCOLVERSION = "1.0";
    private static int uniqueInt = 0;

    XmlMessage() {
    }

    void setError(int code) {
        this.setAttr("CODE", String.valueOf(code));
    }

    void setError(int code, String description) {
        this.setAttr("CODE", String.valueOf(code));
        this.setAttr("DESCRIPTION", description);
    }

    void setId(String cdata) {
        this.setAttr("ID", cdata);
    }

    void setProtocolVersion() {
        this.setAttr("PROTOCOLVERSION", PROTOCOLVERSION);
    }

    synchronized String getUniqueString() {
        Calendar c = Calendar.getInstance();
        return new String(c.get(1) + ":" + c.get(2) + ":" + c.get(5) + ":" + c.get(10) + ":" + c.get(9) + ":" + c.get(12) + ":" + c.get(13) + ":" + ++uniqueInt);
    }

    String message(String body) {
        this.setId(this.getUniqueString());
        this.setProtocolVersion();
        return this.stag(MESSAGE) + body + this.etag();
    }

    String request(String call) {
        return this.stag(SIMPLEREQ) + call + this.etag();
    }

    String request(Vector calls) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < calls.size(); ++i) {
            Xml.append(this.request((String)calls.elementAt(i)));
        }
        if (calls.size() > 1) {
            Xml = new StringBuffer(this.stag(MULTIREQ) + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String call(String name, String body) {
        this.setCIMName(name);
        return this.stag(IMETHODCALL) + body + this.etag();
    }

    String xcall(String name, String body) {
        this.setCIMName(name);
        return this.stag(METHODCALL) + body + this.etag();
    }

    String paramValue(CIMProperty p) {
        this.setCIMName(p.getName());
        if (p.getValue().isArrayValue()) {
            if (p.isReference()) {
                return this.stag(PARAMVALUE) + this.stag(VALUE_REFARRAY) + this.value(p) + this.etag(PARAMVALUE);
            }
            return this.stag(PARAMVALUE) + this.value(p) + this.etag(PARAMVALUE);
        }
        return this.stag(PARAMVALUE) + this.value(p) + this.etag();
    }

    String paramValue(Vector params) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < params.size(); ++i) {
            Xml.append(this.paramValue((CIMProperty)params.elementAt(i)));
        }
        return Xml.toString();
    }

    String iParamValue(String name, String value) {
        this.setCIMName(name);
        return this.stag(IPARAMVALUE) + this.value(value) + this.etag();
    }

    String iParamValue(String name, String[] value) {
        this.setCIMName(name);
        return this.stag(IPARAMVALUE) + this.value(value) + this.etag();
    }

    String iParamValue(String name, boolean b) {
        this.setCIMName(name);
        return this.stag(IPARAMVALUE) + this.value(b) + this.etag();
    }

    String iParamValue(String name, CIMObjectPath cop) {
        this.setCIMName(name);
        return this.stag(IPARAMVALUE) + this.objectName(cop) + this.etag();
    }

    String iParamValue(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            this.setCIMName("InstanceName");
        } else {
            this.setCIMName("ClassName");
        }
        return this.stag(IPARAMVALUE) + this.objectName(cop) + this.etag();
    }

    String iParamValue(CIMValue cv) {
        this.setCIMName("NewValue");
        return this.stag(IPARAMVALUE) + this.value(cv) + this.etag();
    }

    String iParamValue(CIMClass cc, String call) {
        if (call.equals("CreateClass")) {
            this.setCIMName("NewClass");
        } else if (call.equals("ModifyClass")) {
            this.setCIMName("ModifiedClass");
        }
        return this.stag(IPARAMVALUE) + cc.toXml() + this.etag();
    }

    String iParamValue(CIMInstance ci) {
        this.setCIMName("NewInstance");
        return this.stag(IPARAMVALUE) + ci.toXml() + this.etag();
    }

    String iParamValue(CIMObjectPath name, CIMInstance ci) {
        this.setCIMName("ModifiedInstance");
        return this.stag(IPARAMVALUE) + this.valueNamedInstance(name, ci) + this.etag();
    }

    String iParamValue(CIMQualifierType qt) {
        this.setCIMName("QualifierDeclaration");
        return this.stag(IPARAMVALUE) + this.qualifierDeclaration(qt) + this.etag();
    }

    private String response(String[] responses) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < responses.length; ++i) {
            Xml.append(responses[i]);
        }
        if (responses.length > 1) {
            Xml = new StringBuffer(this.stag(MULTIRSP) + Xml.toString() + this.etag());
        }
        this.setId(this.getUniqueString());
        this.setProtocolVersion();
        return this.stag(MESSAGE) + Xml.toString() + this.etag();
    }
}

