/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.XmlGenericId;
import com.sun.wbem.client.XMLParser;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CIMResponse {
    CIMResponse() {
    }

    Vector getResponse(XmlDocument response) throws IOException, CIMException {
        Vector<Hashtable> responses = new Vector<Hashtable>();
        XMLParser parser = new XMLParser();
        TreeWalker walker = new TreeWalker((Node)response);
        Node node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.endsWith(XmlGenericId.SIMPLERSP)) {
                responses.addElement(this.getSimpleResponse(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            node = walker.getNext();
        }
        return responses;
    }

    private Hashtable getSimpleResponse(Node response) throws IOException, CIMException {
        XMLParser parser = new XMLParser();
        Vector<Serializable> v = new Vector<Serializable>();
        Hashtable simple = new Hashtable(1);
        String method = null;
        String cimtype = null;
        boolean isinvokemethod = false;
        TreeWalker walker = new TreeWalker(response);
        Node node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.endsWith(XmlGenericId.METHODRESPONSE)) {
                if (nodename.equals(XmlGenericId.METHODRESPONSE)) {
                    isinvokemethod = true;
                }
                method = ((ElementNode)node).getAttribute("NAME");
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals(XmlGenericId.ERROR)) {
                int code = Integer.parseInt(((ElementNode)node).getAttribute("CODE"));
                CIMException e = new CIMException();
                v.addElement(new CIMException(code + ":" + e.getXmlCode(code)));
                node = walker.getNext();
                continue;
            }
            if (nodename.equals(XmlGenericId.CLASS)) {
                v.addElement(XMLParser.getCIMClass(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals(XmlGenericId.INSTANCE) || nodename.equals(XmlGenericId.VALUE_NAMEDINSTANCE)) {
                v.addElement(XMLParser.getCIMInstance(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals(XmlGenericId.CLASSNAME) || nodename.equals(XmlGenericId.INSTANCENAME)) {
                v.addElement(XMLParser.getCIMObjectPath(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals(XmlGenericId.VALUE)) {
                v.addElement(XMLParser.getCIMValue(node, cimtype));
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals(XmlGenericId.VALUE_OBJECTWITHPATH)) {
                NodeList nl = node.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node item = nl.item(i);
                    if ("CLASS".equalsIgnoreCase(item.getNodeName())) {
                        v.addElement(XMLParser.getCIMClass(item));
                        continue;
                    }
                    if (!"INSTANCE".equalsIgnoreCase(item.getNodeName())) continue;
                    v.addElement(XMLParser.getCIMInstance(item));
                }
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals(XmlGenericId.QUALIFIER_DECLARATION)) {
                v.addElement(XMLParser.getCIMQualifierType(node));
                node = walker.getNextElement(nodename);
                continue;
            }
            if (nodename.equals(XmlGenericId.VALUE_ARRAY) || nodename.equals(XmlGenericId.VALUE_REFERENCE)) {
                v.addElement(XMLParser.getCIMValue(node, cimtype));
                break;
            }
            node = walker.getNextElement(null);
        }
        if (isinvokemethod) {
            Vector<Vector<Serializable>> v2 = new Vector<Vector<Serializable>>();
            v2.addElement(v);
            simple.put(method, v2);
        } else {
            simple.put(method, v);
        }
        return simple;
    }

    boolean isMultiRsp(XmlDocument response) {
        TreeWalker walker = new TreeWalker((Node)response);
        Node node = walker.getCurrent();
        while (node != null) {
            if (!node.getNodeName().equals(XmlGenericId.MULTIRSP)) continue;
            return true;
        }
        return false;
    }
}

