/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMTransportException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlNameSpace;
import com.sun.wbem.client.CIMAssociatorNamesOp;
import com.sun.wbem.client.CIMAssociatorsOp;
import com.sun.wbem.client.CIMClientAPI;
import com.sun.wbem.client.CIMCreateClassOp;
import com.sun.wbem.client.CIMCreateInstanceOp;
import com.sun.wbem.client.CIMCreateNameSpaceOp;
import com.sun.wbem.client.CIMDeleteClassOp;
import com.sun.wbem.client.CIMDeleteInstanceOp;
import com.sun.wbem.client.CIMDeleteNameSpaceOp;
import com.sun.wbem.client.CIMDeleteQualifierTypeOp;
import com.sun.wbem.client.CIMEnumClassNamesOp;
import com.sun.wbem.client.CIMEnumClassOp;
import com.sun.wbem.client.CIMEnumInstanceNamesOp;
import com.sun.wbem.client.CIMEnumInstancesOp;
import com.sun.wbem.client.CIMEnumNameSpaceOp;
import com.sun.wbem.client.CIMEnumQualifierTypesOp;
import com.sun.wbem.client.CIMExecQueryOp;
import com.sun.wbem.client.CIMGetClassOp;
import com.sun.wbem.client.CIMGetInstanceOp;
import com.sun.wbem.client.CIMGetPropertyOp;
import com.sun.wbem.client.CIMGetQualifierTypeOp;
import com.sun.wbem.client.CIMInvokeMethodOp;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.client.CIMOperation;
import com.sun.wbem.client.CIMReferencesOp;
import com.sun.wbem.client.CIMResponse;
import com.sun.wbem.client.CIMSetClassOp;
import com.sun.wbem.client.CIMSetInstanceOp;
import com.sun.wbem.client.CIMSetPropertyOp;
import com.sun.wbem.client.CIMSetQualifierTypeOp;
import com.sun.wbem.client.Errors;
import com.sun.wbem.client.XmlMessage;
import com.sun.wbem.client.XmlResponseChecker;
import com.sun.wbem.client.XmlRpcClient;
import com.sun.wbem.client.http.HttpURLConnection;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.HttpClientSecurity;
import com.sun.wbem.security.SecurityToken;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class CIMClientXML
extends XmlRpcClient
implements CIMClientAPI {
    public static final String HTTPPORT = "5988";
    private CIMNameSpace nameSpace;
    private CIMListener clientListener;
    private SecurityToken st = null;
    private HttpURLConnection conn = null;
    private static int debug = 3;
    private static boolean retryPost = true;
    private static boolean useMPost = true;
    private static final String LOCALONLY = "LocalOnly";
    private static final String DEEPINHERITANCE = "DeepInheritance";
    private static final String INCLUDEQUALIFIERS = "IncludeQualifiers";
    private static final String INCLUDECLASSORIGIN = "IncludeClassOrigin";
    private static final String PROPERTYLIST = "PropertyList";
    Resolver resolver = new Resolver();
    private boolean sendDoctype = false;
    private static HashMap requestHash = new HashMap();

    public CIMClientXML(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg) throws CIMException {
        Object ns;
        this.nameSpace = name;
        this.clientListener = clientListener;
        try {
            ns = name.getHostURL();
            if (ns == null) {
                ns = new URL("http://" + this.nameSpace.getHost() + ":" + HTTPPORT + "/CIMOM" + version);
            }
            this.setUrl((URL)ns);
        }
        catch (MalformedURLException e3) {
            CIMTransportException e = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + version);
            throw e;
        }
        debug = dbg;
        this.setCheckTypes(System.getProperty("checktypes") != null ? "true".equalsIgnoreCase(System.getProperty("checktypes")) : false);
        this.sendDoctype = System.getProperty("setdoctype") != null ? "true".equalsIgnoreCase(System.getProperty("setdoctype")) : this.sendDoctype;
        ns = new XmlNameSpace();
        this.resolver.registerCatalogEntry(((XmlNameSpace)ns).getPublicId(), "com/sun/wbem/client/cim20.dtd", this.getClass().getClassLoader());
        this.customizeResolver((EntityResolver)this.resolver);
        this.initBatch();
    }

    public synchronized void initSecurityContext(String version, ClientSecurityContext csc) throws CIMException {
        HttpClientSecurity cs = null;
        try {
            cs = (HttpClientSecurity)csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", "Bad credential");
        }
        String username = new String(cs.getUserName());
        String password = cs.getUserPassword();
        Authenticator.setDefault(new HttpAuthenticator(username, password));
    }

    boolean getUseMPost() {
        return useMPost;
    }

    void setUseMPost(boolean usempost) {
        useMPost = usempost;
        retryPost = false;
    }

    XmlDocument call(XmlDocument request) throws CIMException, IOException {
        XmlDocumentBuilder builder;
        block17: {
            ValidatingParser parser;
            URL url = this.getUrl();
            if (url == null) {
                throw new IllegalStateException("URL is not set");
            }
            this.conn = new HttpURLConnection(url, useMPost);
            this.conn.setDoOutput(true);
            this.conn.setUseCaches(false);
            this.conn.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            this.conn.setRequestProperty("Accept", "text/xml, application/xml");
            this.conn.encapsulate(request);
            if (debug == 1 || debug == 3) {
                this.conn.setDebug(true);
            }
            OutputStreamWriter out = new OutputStreamWriter(this.conn.getOutputStream(), "UTF8");
            request.write((Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
            if (this.getCheckTypes()) {
                parser = new ValidatingParser();
                parser.setErrorHandler((ErrorHandler)Errors.instance);
            } else {
                parser = new Parser();
                parser.setFastStandalone(true);
            }
            builder = new XmlDocumentBuilder();
            parser.setDocumentHandler((DocumentHandler)builder);
            if (this.resolver == null) {
                this.resolver = new Resolver();
            }
            parser.setEntityResolver((EntityResolver)this.resolver);
            try {
                InputSource in = Resolver.createInputSource((String)this.conn.getContentType(), (InputStream)this.conn.getInputStream(), (boolean)this.getCheckTypes(), (String)url.getProtocol());
                if (debug == 1 || debug == 3) {
                    this.dumpRequest(request);
                }
                if (this.conn.getResponseCode() >= 400) {
                    throw new IOException();
                }
                try {
                    parser.parse(in);
                }
                catch (SAXException e) {
                    if (debug > 0) {
                        StringBuffer buf = new StringBuffer();
                        Reader r = in.getCharacterStream();
                        int i = 0;
                        while (i >= 0) {
                            buf.append((char)i);
                            i = r.read();
                        }
                        System.out.println(buf.toString());
                        System.out.println(e.getMessage());
                        if (debug >= 2) {
                            this.dumpResponse(null);
                        }
                        break block17;
                    }
                    throw new CIMException("XMLERROR", (Object)e);
                }
            }
            catch (IOException e) {
                if (debug >= 2) {
                    this.dumpResponse(null);
                }
                if (this.conn.getResponseCode() == 401) {
                    throw new CIMException("CIM_ERR_ACCESS_DENIED");
                }
                if (retryPost && useMPost) {
                    useMPost = false;
                    return this.call(request);
                }
                throw new CIMException("XMLERROR", (Object)e);
            }
        }
        return builder.getDocument();
    }

    private void dumpRequest(XmlDocument request) throws IOException {
        System.out.println("****************************************");
        System.out.println(this.conn.getRequestHeaders());
        if (request != null) {
            request.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF REQUEST  =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private void dumpResponse(XmlDocument response) throws IOException {
        String key = null;
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
        System.out.println(this.conn.getHeaderField(0));
        int i = 1;
        while ((key = this.conn.getHeaderFieldKey(i)) != null) {
            System.out.println(key + ": " + this.conn.getHeaderField(key));
            ++i;
        }
        System.out.println("\n");
        if (response != null) {
            response.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF RESPONSE =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private Vector getResponse(XmlDocument request) throws MalformedURLException, CIMException, IOException {
        if (request == null) {
            throw new CIMException("XMLERROR", "getFirstResponse");
        }
        XmlNameSpace ns = new XmlNameSpace();
        if (this.sendDoctype) {
            request.setDoctype(ns.getPublicId(), ns.getSystemId().toString(), null);
        }
        XmlDocument response = this.call(request);
        if (debug >= 2) {
            this.dumpResponse(response);
        }
        XmlResponseChecker xrc = new XmlResponseChecker();
        xrc.checkResponse(request, response);
        CIMResponse cr = new CIMResponse();
        Vector multi = cr.getResponse(response);
        return multi;
    }

    private Vector getFirstResponse(String method, XmlDocument request) throws MalformedURLException, CIMException, IOException {
        Vector multi = this.getResponse(request);
        Hashtable simple = (Hashtable)multi.firstElement();
        Vector v = (Vector)simple.get(method);
        if (v.size() > 0 && v.elementAt(0) instanceof CIMException) {
            throw (CIMException)v.elementAt(0);
        }
        return v;
    }

    private Vector getMultiResponse(XmlDocument request) throws MalformedURLException, CIMException, IOException {
        Vector v = new Vector();
        Vector multi = this.getResponse(request);
        Vector resp = null;
        for (int i = 0; i < multi.size(); ++i) {
            Hashtable simple = (Hashtable)multi.elementAt(i);
            String method = (String)simple.keySet().iterator().next();
            resp = (Vector)simple.get(method);
            if (method.startsWith("Enum") || method.startsWith("Asso") || method.startsWith("Refe")) {
                v.addElement(resp);
                continue;
            }
            try {
                v.addElement(resp.firstElement());
                continue;
            }
            catch (Exception e) {
                v.addElement(null);
            }
        }
        return v;
    }

    public synchronized void createNameSpace(String version, CIMNameSpace currNs, CIMNameSpace relNs) throws CIMException {
        MapNamespace mns = new MapNamespace(currNs, relNs);
        try {
            Vector rsp = this.getFirstResponse("CreateInstance", this.createInstanceDo(version, mns.getMappedNs(), mns.getMappedOp(), mns.getMappedInstance()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("XMLERROR", "createNameSpace", e);
        }
    }

    public synchronized void close(String version) throws CIMException {
        this.conn.disconnect();
    }

    public synchronized void deleteNameSpace(String version, CIMNameSpace currNs, CIMNameSpace ns) throws CIMException {
        MapNamespace mns = new MapNamespace(currNs, ns);
        try {
            XmlDocument xmlDoc = this.deleteInstanceDo(version, mns.getMappedNs(), mns.getMappedOp());
            this.getFirstResponse("DeleteInstance", xmlDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("XMLERROR", "deleteNameSpace", e);
        }
    }

    public synchronized void deleteClass(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            XmlDocument xmlDoc = this.deleteClassDo(version, currNs, path);
            this.getFirstResponse("DeleteClass", xmlDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("XMLERROR", "deleteClass", e);
        }
    }

    private String deleteClassRequest(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        return this.xmlRequest("DeleteClass", xml.toString(), xm);
    }

    private XmlDocument deleteClassDo(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.deleteClassRequest(currNs, name, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void deleteInstance(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            XmlDocument xmlDoc = this.deleteInstanceDo(version, currNs, path);
            this.getFirstResponse("DeleteInstance", xmlDoc);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteInstance", e);
        }
    }

    private String deleteInstanceRequest(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        return this.xmlRequest("DeleteInstance", xml.toString(), xm);
    }

    private XmlDocument deleteInstanceDo(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.deleteInstanceRequest(currNs, name, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void deleteQualifierType(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            XmlDocument xmlDoc = this.deleteQualifierDo(version, currNs, path);
            this.getFirstResponse("DeleteQualifier", xmlDoc);
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteQualifierType", e);
        }
    }

    private String deleteQualifierTypeRequest(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        return this.xmlRequest("DeleteQualifier", xml.toString(), xm);
    }

    private XmlDocument deleteQualifierDo(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.deleteQualifierTypeRequest(currNs, name, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized Vector enumClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        try {
            XmlDocument xmlDoc = this.enumerateClassesDo(version, currNs, path, deep, localOnly, true, false);
            return this.getFirstResponse("EnumerateClasses", xmlDoc);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumClass", e);
        }
    }

    public synchronized Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        try {
            XmlDocument xmlDoc = this.enumerateClassesDo(version, currNs, path, deep, localOnly, includeQualifiers, includeClassOrigin);
            return this.getFirstResponse("EnumerateClasses", xmlDoc);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateClasses", e);
        }
    }

    private String enumerateClassesRequest(CIMNameSpace currNs, CIMObjectPath name, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        if (!localOnly) {
            this.xmlAppendBooleanParamValue(xml, xm, LOCALONLY, false);
        }
        if (deep) {
            this.xmlAppendBooleanParamValue(xml, xm, DEEPINHERITANCE, true);
        }
        if (!includeQualifiers) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDEQUALIFIERS, false);
        }
        if (includeClassOrigin) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDECLASSORIGIN, true);
        }
        return this.xmlRequest("EnumerateClasses", xml.toString(), xm);
    }

    private XmlDocument enumerateClassesDo(String version, CIMNameSpace currNs, CIMObjectPath name, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.enumerateClassesRequest(currNs, name, deep, localOnly, includeQualifiers, includeClassOrigin, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized Vector enumClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            XmlDocument xmlDoc = this.enumerateClassNamesDo(version, currNs, path, deep);
            return this.getFirstResponse("EnumerateClassNames", xmlDoc);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumClass", e);
        }
    }

    public synchronized Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            XmlDocument xmlDoc = this.enumerateClassNamesDo(version, currNs, path, deep);
            return this.getFirstResponse("EnumerateClassNames", xmlDoc);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateClassNames", e);
        }
    }

    private String enumerateClassNamesRequest(CIMNameSpace currNs, CIMObjectPath name, boolean deep, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        if (deep) {
            xml.append(xm.iParamValue(DEEPINHERITANCE, true));
        }
        return this.xmlRequest("EnumerateClassNames", xml.toString(), xm);
    }

    private XmlDocument enumerateClassNamesDo(String version, CIMNameSpace currNs, CIMObjectPath name, boolean deep) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.enumerateClassNamesRequest(currNs, name, deep, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized Vector enumNameSpace(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            path.setObjectName("__Namespace");
            Vector v = this.getFirstResponse("EnumerateInstanceNames", this.enumerateInstanceNamesDo(version, currNs, path));
            Vector<CIMObjectPath> retval = new Vector<CIMObjectPath>();
            for (int i = 0; i < v.size(); ++i) {
                Vector pv = ((CIMObjectPath)v.elementAt(i)).getKeys();
                for (int j = 0; j < pv.size(); ++j) {
                    CIMProperty p = (CIMProperty)pv.elementAt(j);
                    if (!"NameSpace".equals(p.getName())) continue;
                    retval.addElement(new CIMObjectPath("", p.getValue().getValue().toString()));
                }
            }
            return retval;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "numNameSpace", e);
        }
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstances", this.enumerateInstancesDo(version, currNs, path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateInstances", e);
        }
    }

    public synchronized Vector enumInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstances", this.enumerateInstancesDo(version, currNs, path, deep, localOnly, false, false, null));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumInstances", e);
        }
    }

    private String enumerateInstancesRequest(CIMNameSpace currNs, CIMObjectPath name, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        if (!localOnly) {
            this.xmlAppendBooleanParamValue(xml, xm, LOCALONLY, false);
        }
        if (!deep) {
            this.xmlAppendBooleanParamValue(xml, xm, DEEPINHERITANCE, false);
        }
        if (includeQualifiers) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDEQUALIFIERS, true);
        }
        if (includeClassOrigin) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDECLASSORIGIN, true);
        }
        this.xmlAppendStringsParamValue(xml, xm, PROPERTYLIST, propertyList);
        return this.xmlRequest("EnumerateInstances", xml.toString(), xm);
    }

    private XmlDocument enumerateInstancesDo(String version, CIMNameSpace currNs, CIMObjectPath name, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.enumerateInstancesRequest(currNs, name, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstanceNames", this.enumerateInstanceNamesDo(version, currNs, path));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateInstanceNames", e);
        }
    }

    public synchronized Vector enumInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstanceNames", this.enumerateInstanceNamesDo(version, currNs, path));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumInstances", e);
        }
    }

    private String enumerateInstanceNamesRequest(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        return this.xmlRequest("EnumerateInstanceNames", xml.toString(), xm);
    }

    private XmlDocument enumerateInstanceNamesDo(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.enumerateInstanceNamesRequest(currNs, name, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized Vector enumQualifierTypes(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        Vector<CIMObjectPath> retval = new Vector<CIMObjectPath>();
        try {
            Enumeration e = this.getFirstResponse("EnumerateQualifiers", this.enumerateQualifiersDo(version, currNs, path)).elements();
            while (e.hasMoreElements()) {
                retval.addElement(new CIMObjectPath(((CIMQualifierType)e.nextElement()).getName()));
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumQualifierTypes", e);
        }
        return retval;
    }

    private String enumerateQualifierTypesRequest(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        return this.xmlRequest("EnumerateQualifiers", xml.toString(), xm);
    }

    private XmlDocument enumerateQualifiersDo(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.enumerateQualifierTypesRequest(currNs, name, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("GetClass", this.getClassDo(version, currNs, name, localOnly, includeQualifiers, includeClassOrigin, propertyList));
            return (CIMClass)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getClass", e);
        }
    }

    public synchronized CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("GetClass", this.getClassDo(version, currNs, name, localOnly, true, false, null));
            return (CIMClass)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("XMLERROR", "getClass", e);
        }
    }

    private String getClassRequest(CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        if (!localOnly) {
            this.xmlAppendBooleanParamValue(xml, xm, LOCALONLY, false);
        }
        if (!includeQualifiers) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDEQUALIFIERS, false);
        }
        if (includeClassOrigin) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDECLASSORIGIN, true);
        }
        this.xmlAppendStringsParamValue(xml, xm, PROPERTYLIST, propertyList);
        return this.xmlRequest("GetClass", xml.toString(), xm);
    }

    private XmlDocument getClassDo(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.getClassRequest(currNs, name, localOnly, includeQualifiers, includeClassOrigin, propertyList, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("GetInstance", this.getInstanceDo(version, currNs, name, localOnly, includeQualifiers, includeClassOrigin, propertyList));
            return (CIMInstance)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getInstance", e);
        }
    }

    public synchronized CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("GetInstance", this.getInstanceDo(version, currNs, name, localOnly, false, false, null));
            return (CIMInstance)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getInstance", e);
        }
    }

    private String getInstanceRequest(CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, XmlMessage xm) {
        StringBuffer xml = this.xmlAppendObjectPath(currNs, name, xm);
        if (!localOnly) {
            this.xmlAppendBooleanParamValue(xml, xm, LOCALONLY, false);
        }
        if (includeQualifiers) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDEQUALIFIERS, true);
        }
        if (includeClassOrigin) {
            this.xmlAppendBooleanParamValue(xml, xm, INCLUDECLASSORIGIN, true);
        }
        this.xmlAppendStringsParamValue(xml, xm, PROPERTYLIST, propertyList);
        return this.xmlRequest("GetInstance", xml.toString(), xm);
    }

    private XmlDocument getInstanceDo(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.getInstanceRequest(currNs, name, localOnly, includeQualifiers, includeClassOrigin, propertyList, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, Vector inParams, Vector outParams) throws CIMException {
        try {
            Vector v = this.getFirstResponse(methodName, this.invokeMethodDo(version, currNs, name, methodName, inParams));
            for (int i = 1; i < v.size(); ++i) {
                outParams.addElement(v.elementAt(i));
            }
            return (CIMValue)v.firstElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("XMLERROR", "invokeMethod", e);
        }
    }

    private String invokeMethodRequest(CIMNameSpace currNs, CIMObjectPath name, String methodName, Vector params, XmlMessage xm) {
        CIMObjectPath absPath = this.fixAbsObjectPath(currNs, name);
        StringBuffer xml = new StringBuffer(xm.localObjectPath(absPath));
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                CIMValue cv = (CIMValue)params.elementAt(i);
                CIMProperty p = new CIMProperty(xm.getCIMType(cv.getType()), cv);
                xml.append(xm.paramValue(p));
            }
        }
        return xm.request(xm.xcall(methodName, xml.toString()));
    }

    private XmlDocument invokeMethodDo(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, Vector params) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.invokeMethodRequest(currNs, name, methodName, params, xm);
        try {
            return xm.pcdata2Xml(xml.toString());
        }
        catch (IOException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
        catch (SAXException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
    }

    public synchronized CIMQualifierType getQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("GetQualifier", this.getQualifierDo(version, currNs, name));
            return (CIMQualifierType)rsp.firstElement();
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getQualifierType", e);
        }
    }

    private String getQualifierTypeRequest(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue("QualifierName", name.getObjectName()));
        return this.xmlRequest("GetQualifier", xml.toString(), xm);
    }

    private XmlDocument getQualifierDo(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.getQualifierTypeRequest(currNs, name, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void createQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED", "createQualifierType");
    }

    public synchronized void createClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            this.getFirstResponse("CreateClass", this.createClassDo(version, currNs, name, cc));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createClass", e);
        }
    }

    private String createClassRequest(CIMNameSpace currNs, CIMObjectPath name, CIMClass cc, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(cc, "CreateClass"));
        return this.xmlRequest("CreateClass", xml.toString(), xm);
    }

    private XmlDocument createClassDo(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        XmlMessage xm = new XmlMessage();
        xm.setIncludeQualifiers(true);
        String xml = this.createClassRequest(currNs, name, cc, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized CIMObjectPath createInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("CreateInstance", this.createInstanceDo(version, currNs, name, ci));
            return (CIMObjectPath)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createInstance", e);
        }
    }

    private String createInstanceRequest(CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(ci));
        return this.xmlRequest("CreateInstance", xml.toString(), xm);
    }

    private XmlDocument createInstanceDo(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.createInstanceRequest(currNs, name, ci, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void setQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        try {
            this.getFirstResponse("SetQualifier", this.setQualifierDo(version, currNs, name, qt));
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setQualifierType", e);
        }
    }

    private String setQualifierTypeRequest(CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(qt));
        return this.xmlRequest("SetQualifier", xml.toString(), xm);
    }

    private XmlDocument setQualifierDo(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.setQualifierTypeRequest(currNs, name, qt, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void setClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            this.getFirstResponse("ModifyClass", this.modifyClassDo(version, currNs, name, cc));
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setClass", e);
        }
    }

    private String setClassRequest(CIMNameSpace currNs, CIMObjectPath name, CIMClass cc, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(cc, "ModifyClass"));
        return this.xmlRequest("ModifyClass", xml.toString(), xm);
    }

    private XmlDocument modifyClassDo(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.setClassRequest(currNs, name, cc, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void setInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        try {
            this.getFirstResponse("ModifyInstance", this.modifyInstanceDo(version, currNs, name, ci));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setInstance", e);
        }
    }

    private String setInstanceRequest(CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(name, ci));
        return this.xmlRequest("ModifyInstance", xml.toString(), xm);
    }

    private XmlDocument modifyInstanceDo(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.setInstanceRequest(currNs, name, ci, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized CIMValue getProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException {
        try {
            Vector rsp = this.getFirstResponse("GetProperty", this.getPropertyDo(version, currNs, name, propertyName));
            return (CIMValue)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getProperty", e);
        }
    }

    private String getPropertyRequest(CIMNameSpace currNs, CIMObjectPath name, String propertyName, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(name));
        xml.append(xm.iParamValue("PropertyName", propertyName));
        return this.xmlRequest("GetProperty", xml.toString(), xm);
    }

    private XmlDocument getPropertyDo(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.getPropertyRequest(currNs, name, propertyName, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized void setProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        try {
            this.getFirstResponse("SetProperty", this.setPropertyDo(version, currNs, name, propertyName, cv));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setProperty", e);
        }
    }

    private String setPropertyRequest(CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(name));
        xml.append(xm.iParamValue("PropertyName", propertyName));
        xml.append(xm.iParamValue(cv));
        return this.xmlRequest("SetProperty", xml.toString(), xm);
    }

    private XmlDocument setPropertyDo(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        XmlMessage xm = new XmlMessage();
        String xml = this.setPropertyRequest(currNs, name, propertyName, cv, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public synchronized Vector execQuery(String version, CIMNameSpace currNs, CIMObjectPath relNS, String query, int ql) throws CIMException {
        try {
            return this.getFirstResponse("ExecQuery", this.execQueryDo(version, currNs, relNS, query, ql));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "execQuery", e);
        }
    }

    private String execQueryRequest(CIMNameSpace currNs, CIMObjectPath name, String query, int ql, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue("QueryLanguage", Integer.toString(ql)) + xm.iParamValue("Query", query));
        return this.xmlRequest("ExecQuery", xml.toString(), xm);
    }

    private XmlDocument execQueryDo(String version, CIMNameSpace currNs, CIMObjectPath name, String query, int ql) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.execQueryRequest(currNs, name, query, ql, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public Vector associators(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            return this.getFirstResponse("Associators", this.associatorsDo(version, currNs, objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "associators", e);
        }
    }

    private String associatorsRequest(CIMNameSpace currNs, CIMObjectPath name, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue("ObjectName", name) + (assocClass != null ? xm.iParamValue("AssocClass", new CIMObjectPath(assocClass)) : "") + (resultClass != null ? xm.iParamValue("ResultClass", new CIMObjectPath(resultClass)) : "") + (resultRole != null ? xm.iParamValue("ResultRole", resultRole) : "") + (role != null ? xm.iParamValue("Role", role) : "") + (includeQualifiers ? xm.iParamValue(INCLUDEQUALIFIERS, includeQualifiers) : "") + (includeClassOrigin ? xm.iParamValue(INCLUDECLASSORIGIN, includeQualifiers) : "") + (propertyList != null ? xm.iParamValue(PROPERTYLIST, propertyList) : ""));
        return this.xmlRequest("Associators", xml.toString(), xm);
    }

    private XmlDocument associatorsDo(String version, CIMNameSpace currNs, CIMObjectPath name, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.associatorsRequest(currNs, name, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public Vector associatorNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        try {
            return this.getFirstResponse("AssociatorNames", this.associatorNamesDo(version, currNs, objectName, assocClass, resultClass, role, resultRole));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "associatorNames", e);
        }
    }

    private String associatorNamesRequest(CIMNameSpace currNs, CIMObjectPath name, String assocClass, String resultClass, String role, String resultRole, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue("ObjectName", name) + (assocClass != null ? xm.iParamValue("AssocClass", new CIMObjectPath(assocClass)) : "") + (resultClass != null ? xm.iParamValue("ResultClass", new CIMObjectPath(resultClass)) : "") + (role != null ? xm.iParamValue("Role", role) : "") + (resultRole != null ? xm.iParamValue("ResultRole", resultRole) : ""));
        return this.xmlRequest("AssociatorNames", xml.toString(), xm);
    }

    private XmlDocument associatorNamesDo(String version, CIMNameSpace currNs, CIMObjectPath name, String assocClass, String resultClass, String role, String resultRole) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.associatorNamesRequest(currNs, name, assocClass, resultClass, role, resultRole, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public Vector references(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            return this.getFirstResponse("References", this.referencesDo(version, currNs, objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "references", e);
        }
    }

    private String referencesRequest(CIMNameSpace currNs, CIMObjectPath name, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue("ObjectName", name) + (resultClass != null ? xm.iParamValue("ResultClass", new CIMObjectPath(resultClass)) : "") + (role != null ? xm.iParamValue("Role", role) : "") + (includeQualifiers ? xm.iParamValue(INCLUDEQUALIFIERS, includeQualifiers) : "") + (includeClassOrigin ? xm.iParamValue(INCLUDECLASSORIGIN, includeQualifiers) : "") + (propertyList != null ? xm.iParamValue(PROPERTYLIST, propertyList) : ""));
        return this.xmlRequest("References", xml.toString(), xm);
    }

    private XmlDocument referencesDo(String version, CIMNameSpace currNs, CIMObjectPath name, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.referencesRequest(currNs, name, resultClass, role, includeQualifiers, includeClassOrigin, propertyList, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public Vector referenceNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        try {
            return this.getFirstResponse("ReferenceNames", this.referenceNamesDo(version, currNs, objectName, resultClass, role));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "referenceNames", e);
        }
    }

    private String referenceNamesResuest(CIMNameSpace currNs, CIMObjectPath name, String resultClass, String role, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue("ObjectName", name) + (resultClass != null ? xm.iParamValue("ResultClass", new CIMObjectPath(resultClass)) : "") + (role != null ? xm.iParamValue("Role", role) : ""));
        return this.xmlRequest("ReferenceNames", xml.toString(), xm);
    }

    private XmlDocument referenceNamesDo(String version, CIMNameSpace currNs, CIMObjectPath name, String resultClass, String role) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        String xml = this.referenceNamesResuest(currNs, name, resultClass, role, xm);
        return this.xmlMsg2xmlDoc(xm, xml);
    }

    public Vector performOperations(String version, CIMOperation[] batchedOperations) throws CIMException {
        try {
            return this.getMultiResponse(this.performOperationsDo(version, batchedOperations));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "performOperations", e);
        }
    }

    private XmlDocument performOperationsDo(String version, CIMOperation[] batchedOps) throws CIMException, MalformedURLException {
        XmlMessage xm = new XmlMessage();
        Vector<String> calls = new Vector<String>();
        for (int i = 0; i < batchedOps.length; ++i) {
            String cimOpName = batchedOps[i].getClass().getName();
            XmlRequest obj = (XmlRequest)requestHash.get(cimOpName.substring(cimOpName.lastIndexOf(".") + 1));
            calls.addElement(obj.getRequest(batchedOps[i], xm));
        }
        return this.xmlMsg2xmlDoc(xm, calls);
    }

    private void xmlAppendBooleanParamValue(StringBuffer xml, XmlMessage xm, String paramName, boolean value) {
        xml.append(xm.iParamValue(paramName, value));
    }

    private void xmlAppendStringsParamValue(StringBuffer xml, XmlMessage xm, String paramName, String[] value) {
        if (value != null) {
            xml.append(xm.iParamValue(paramName, value));
        }
    }

    private StringBuffer xmlAppendObjectPath(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        StringBuffer xml = this.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(name));
        return xml;
    }

    private StringBuffer getXmlStringBuffer(CIMNameSpace currNs, CIMObjectPath name, XmlMessage xm) {
        CIMObjectPath absPath = this.fixAbsObjectPath(currNs, name);
        return new StringBuffer(xm.localNameSpacePath(absPath));
    }

    private XmlDocument xmlMsg2xmlDoc(XmlMessage xm, String xml) throws CIMException {
        StringBuffer newXml = new StringBuffer(xm.root(xm.message(xm.request(xml))));
        try {
            return xm.pcdata2Xml(newXml.toString());
        }
        catch (IOException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
        catch (SAXException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
    }

    private XmlDocument xmlMsg2xmlDoc(XmlMessage xm, Vector xml) throws CIMException {
        StringBuffer newXml = new StringBuffer(xm.root(xm.message(xm.request(xml))));
        try {
            return xm.pcdata2Xml(newXml.toString());
        }
        catch (IOException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
        catch (SAXException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
    }

    private CIMObjectPath fixAbsObjectPath(CIMNameSpace nameSpace, CIMObjectPath op) {
        String s = nameSpace.getNameSpace() + "\\" + op.getNameSpace();
        CIMObjectPath rtop = new CIMObjectPath(op.getObjectName(), (Vector)op.getKeys().clone());
        rtop.setHost(op.getHost());
        rtop.setNameSpace(s);
        return rtop;
    }

    private String xmlRequest(String method, String xml, XmlMessage xm) {
        return xm.call(method, xml);
    }

    void initBatch() {
        requestHash.put("CIMAssociatorNamesOp", new AssociatorNamesXml());
        requestHash.put("CIMAssociatorsOp", new AssociatorsXml());
        requestHash.put("CIMCreateClassOp", new CreateClassXml());
        requestHash.put("CIMCreateInstanceOp", new CreateInstanceXml());
        requestHash.put("CIMCreateNameSpaceOp", new CreateNameSpaceXml());
        requestHash.put("CIMQualifierTypeOp", new CreateQualifierTypeXml());
        requestHash.put("CIMDeleteClassOp", new DeleteClassXml());
        requestHash.put("CIMDeleteInstanceOp", new DeleteInstanceXml());
        requestHash.put("CIMDeleteNameSpaceOp", new DeleteNameSpaceXml());
        requestHash.put("CIMDeleteQualifierTypeOp", new DeleteQualifierTypeXml());
        requestHash.put("CIMEnumClassNamesOp", new EnumClassNamesXml());
        requestHash.put("CIMEnumClassOp", new EnumClassXml());
        requestHash.put("CIMEnumInstanceNamesOp", new EnumInstanceNamesXml());
        requestHash.put("CIMEnumInstancesOp", new EnumInstancesXml());
        requestHash.put("CIMEnumNameSpaceOp", new EnumNameSpaceXml());
        requestHash.put("CIMEnumQualifierTypesOp", new EnumQualifierTypesXml());
        requestHash.put("CIMExecQueryOp", new ExecQueryXml());
        requestHash.put("CIMGetClassOp", new GetClassXml());
        requestHash.put("CIMGetInstanceOp", new GetInstanceXml());
        requestHash.put("CIMGetPropertyOp", new GetPropertyXml());
        requestHash.put("CIMGetQualifierTypeOp", new GetQualifierTypeXml());
        requestHash.put("CIMInvokeMethodOp", new InvokeMethodXml());
        requestHash.put("CIMReferenceNamesOp", new ReferenceNamesXml());
        requestHash.put("CIMReferencesOp", new ReferencesXml());
        requestHash.put("CIMSetClassOp", new SetClassXml());
        requestHash.put("CIMSetInstanceOp", new SetInstanceXml());
        requestHash.put("CIMSetPropertyOp", new SetPropertyXml());
        requestHash.put("CIMSetQualifierTypeOp", new SetQualifierTypeXml());
    }

    private class SetQualifierTypeXml
    implements XmlRequest {
        private SetQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMSetQualifierTypeOp obj = (CIMSetQualifierTypeOp)cimOp;
            return CIMClientXML.this.setQualifierTypeRequest(obj.getNameSpace(), obj.getModelPath(), obj.getCIMQualifierType(), xm);
        }
    }

    private class SetPropertyXml
    implements XmlRequest {
        private SetPropertyXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMSetPropertyOp obj = (CIMSetPropertyOp)cimOp;
            return CIMClientXML.this.setPropertyRequest(obj.getNameSpace(), obj.getModelPath(), obj.getPropertyName(), obj.getCIMValue(), xm);
        }
    }

    private class SetInstanceXml
    implements XmlRequest {
        private SetInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMSetInstanceOp obj = (CIMSetInstanceOp)cimOp;
            return CIMClientXML.this.setInstanceRequest(obj.getNameSpace(), obj.getModelPath(), obj.getCIMInstance(), xm);
        }
    }

    private class SetClassXml
    implements XmlRequest {
        private SetClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMSetClassOp obj = (CIMSetClassOp)cimOp;
            return CIMClientXML.this.setClassRequest(obj.getNameSpace(), obj.getModelPath(), obj.getCIMClass(), xm);
        }
    }

    private class ReferencesXml
    implements XmlRequest {
        private ReferencesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMReferencesOp obj = (CIMReferencesOp)cimOp;
            return CIMClientXML.this.referencesRequest(obj.getNameSpace(), obj.getModelPath(), obj.getResultClass(), obj.getRole(), obj.isQualifiersIncluded(), obj.isClassOriginIncluded(), obj.getPropertyList(), xm);
        }
    }

    private class ReferenceNamesXml
    implements XmlRequest {
        private ReferenceNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMReferencesOp obj = (CIMReferencesOp)cimOp;
            return CIMClientXML.this.referenceNamesResuest(obj.getNameSpace(), obj.getModelPath(), obj.getResultClass(), obj.getRole(), xm);
        }
    }

    private class InvokeMethodXml
    implements XmlRequest {
        private InvokeMethodXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMInvokeMethodOp obj = (CIMInvokeMethodOp)cimOp;
            return CIMClientXML.this.invokeMethodRequest(obj.getNameSpace(), obj.getModelPath(), obj.getMethodName(), obj.getInParams(), xm);
        }
    }

    private class GetQualifierTypeXml
    implements XmlRequest {
        private GetQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMGetQualifierTypeOp obj = (CIMGetQualifierTypeOp)cimOp;
            return CIMClientXML.this.getQualifierTypeRequest(obj.getNameSpace(), obj.getModelPath(), xm);
        }
    }

    private class GetPropertyXml
    implements XmlRequest {
        private GetPropertyXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMGetPropertyOp obj = (CIMGetPropertyOp)cimOp;
            return CIMClientXML.this.getPropertyRequest(obj.getNameSpace(), obj.getModelPath(), obj.getPropertyName(), xm);
        }
    }

    private class GetInstanceXml
    implements XmlRequest {
        private GetInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMGetInstanceOp obj = (CIMGetInstanceOp)cimOp;
            return CIMClientXML.this.getInstanceRequest(obj.getNameSpace(), obj.getModelPath(), obj.isLocalOnly(), obj.isQualifiersIncluded(), obj.isClassOriginIncluded(), obj.getPropertyList(), xm);
        }
    }

    private class GetClassXml
    implements XmlRequest {
        private GetClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMGetClassOp obj = (CIMGetClassOp)cimOp;
            return CIMClientXML.this.getClassRequest(obj.getNameSpace(), obj.getModelPath(), obj.isLocalOnly(), obj.isQualifiersIncluded(), obj.isClassOriginIncluded(), obj.getPropertyList(), xm);
        }
    }

    private class ExecQueryXml
    implements XmlRequest {
        private ExecQueryXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMExecQueryOp obj = (CIMExecQueryOp)cimOp;
            return CIMClientXML.this.execQueryRequest(obj.getNameSpace(), obj.getModelPath(), obj.getQuery(), obj.getQueryLanguage(), xm);
        }
    }

    private class EnumQualifierTypesXml
    implements XmlRequest {
        private EnumQualifierTypesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMEnumQualifierTypesOp obj = (CIMEnumQualifierTypesOp)cimOp;
            return CIMClientXML.this.enumerateQualifierTypesRequest(obj.getNameSpace(), obj.getModelPath(), xm);
        }
    }

    private class EnumNameSpaceXml
    implements XmlRequest {
        private EnumNameSpaceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMEnumNameSpaceOp obj = (CIMEnumNameSpaceOp)cimOp;
            CIMObjectPath path = obj.getModelPath();
            path.setObjectName("__Namespace");
            return CIMClientXML.this.enumerateInstanceNamesRequest(obj.getNameSpace(), path, xm);
        }
    }

    private class EnumInstancesXml
    implements XmlRequest {
        private EnumInstancesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMEnumInstancesOp obj = (CIMEnumInstancesOp)cimOp;
            return CIMClientXML.this.enumerateInstancesRequest(obj.getNameSpace(), obj.getModelPath(), obj.isDeep(), obj.isLocalOnly(), obj.isQualifiersIncluded(), obj.isClassOriginIncluded(), obj.getPropertyList(), xm);
        }
    }

    private class EnumClassXml
    implements XmlRequest {
        private EnumClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMEnumClassOp obj = (CIMEnumClassOp)cimOp;
            return CIMClientXML.this.enumerateClassesRequest(obj.getNameSpace(), obj.getModelPath(), obj.isDeep(), obj.isLocalOnly(), obj.isQualifiersIncluded(), obj.isClassOriginIncluded(), xm);
        }
    }

    private class EnumClassNamesXml
    implements XmlRequest {
        private EnumClassNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMEnumClassNamesOp obj = (CIMEnumClassNamesOp)cimOp;
            return CIMClientXML.this.enumerateClassNamesRequest(obj.getNameSpace(), obj.getModelPath(), obj.isDeep(), xm);
        }
    }

    private class EnumInstanceNamesXml
    implements XmlRequest {
        private EnumInstanceNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMEnumInstanceNamesOp obj = (CIMEnumInstanceNamesOp)cimOp;
            return CIMClientXML.this.enumerateInstanceNamesRequest(obj.getNameSpace(), obj.getModelPath(), xm);
        }
    }

    private class DeleteQualifierTypeXml
    implements XmlRequest {
        private DeleteQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMDeleteQualifierTypeOp obj = (CIMDeleteQualifierTypeOp)cimOp;
            return CIMClientXML.this.deleteQualifierTypeRequest(obj.getNameSpace(), obj.getModelPath(), xm);
        }
    }

    private class DeleteNameSpaceXml
    implements XmlRequest {
        private DeleteNameSpaceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMDeleteNameSpaceOp obj = (CIMDeleteNameSpaceOp)cimOp;
            MapNamespace mns = new MapNamespace(obj.getNameSpace(), obj.getRelativeNameSpace());
            return CIMClientXML.this.deleteInstanceRequest(mns.getMappedNs(), mns.getMappedOp(), xm);
        }
    }

    private class DeleteInstanceXml
    implements XmlRequest {
        private DeleteInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMDeleteInstanceOp obj = (CIMDeleteInstanceOp)cimOp;
            return CIMClientXML.this.deleteInstanceRequest(obj.getNameSpace(), obj.getModelPath(), xm);
        }
    }

    private class DeleteClassXml
    implements XmlRequest {
        private DeleteClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMDeleteClassOp obj = (CIMDeleteClassOp)cimOp;
            return CIMClientXML.this.deleteClassRequest(obj.getNameSpace(), obj.getModelPath(), xm);
        }
    }

    private class CreateQualifierTypeXml
    implements XmlRequest {
        private CreateQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            return "";
        }
    }

    private class CreateNameSpaceXml
    implements XmlRequest {
        private CreateNameSpaceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMCreateNameSpaceOp obj = (CIMCreateNameSpaceOp)cimOp;
            MapNamespace mns = new MapNamespace(obj.getNameSpace(), obj.getRelativeNameSpace());
            return CIMClientXML.this.createInstanceRequest(mns.getMappedNs(), mns.getMappedOp(), mns.getMappedInstance(), xm);
        }
    }

    private class CreateInstanceXml
    implements XmlRequest {
        private CreateInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMCreateInstanceOp obj = (CIMCreateInstanceOp)cimOp;
            return CIMClientXML.this.createInstanceRequest(obj.getNameSpace(), obj.getModelPath(), obj.getCIMInstance(), xm);
        }
    }

    private class CreateClassXml
    implements XmlRequest {
        private CreateClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMCreateClassOp obj = (CIMCreateClassOp)cimOp;
            return CIMClientXML.this.createClassRequest(obj.getNameSpace(), obj.getModelPath(), obj.getCIMClass(), xm);
        }
    }

    private class AssociatorsXml
    implements XmlRequest {
        private AssociatorsXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMAssociatorsOp obj = (CIMAssociatorsOp)cimOp;
            return CIMClientXML.this.associatorsRequest(obj.getNameSpace(), obj.getModelPath(), obj.getAssociationClass(), obj.getResultClass(), obj.getRole(), obj.getResultRole(), obj.isQualifiersIncluded(), obj.isClassOriginIncluded(), obj.getPropertyList(), xm);
        }
    }

    private class AssociatorNamesXml
    implements XmlRequest {
        private AssociatorNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlMessage xm) {
            CIMAssociatorNamesOp obj = (CIMAssociatorNamesOp)cimOp;
            return CIMClientXML.this.associatorNamesRequest(obj.getNameSpace(), obj.getModelPath(), obj.getAssociationClass(), obj.getResultClass(), obj.getRole(), obj.getResultRole(), xm);
        }
    }

    private static interface XmlRequest {
        public String getRequest(CIMOperation var1, XmlMessage var2);
    }

    private class MapNamespace {
        String nstr = null;
        Vector v = null;

        MapNamespace(CIMNameSpace currNs, CIMNameSpace ns) {
            this.nstr = currNs.getNameSpace() + "\\" + ns.getNameSpace();
            this.v = new Vector();
            CIMProperty cp = new CIMProperty("NameSpace");
            cp.setValue(new CIMValue(this.nstr.substring(this.nstr.lastIndexOf("\\") + 1)));
            this.v.addElement(cp);
        }

        CIMNameSpace getMappedNs() {
            CIMNameSpace newns = new CIMNameSpace();
            newns.setNameSpace(this.nstr.substring(0, this.nstr.lastIndexOf("\\")));
            return newns;
        }

        CIMObjectPath getMappedOp() {
            return new CIMObjectPath("__Namespace", this.v);
        }

        CIMInstance getMappedInstance() {
            CIMInstance ci = new CIMInstance();
            ci.setClassName("__Namespace");
            ci.setProperties(this.v);
            return ci;
        }
    }

    private static class HttpAuthenticator
    extends Authenticator {
        private String username;
        private char[] password;

        HttpAuthenticator(String username, String password) {
            this.username = username;
            this.password = password.toCharArray();
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

