/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMTransportException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMClientAPI;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.client.CIMOM2;
import com.sun.wbem.client.CIMOperation;
import com.sun.wbem.client.CheckSumGen;
import com.sun.wbem.client.RemoteCIMListener;
import com.sun.wbem.client.RemoteListenerImpl;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.RmiClientSecurity;
import com.sun.wbem.security.SecurityMessage;
import com.sun.wbem.security.SecurityToken;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.MarshalException;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.UnknownHostException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

class CIMClientRMI
implements CIMClientAPI {
    private CIMOM2 comp;
    private CIMNameSpace nameSpace;
    private RmiClientSecurity cs;
    private CIMListener clientListener;
    private RemoteCIMListener remoteListener;
    private int debug;
    public static final String RMIPORT = "5987";
    private final String RMIPORTPROP = "com.sun.wbem.rmiport";
    private static final String FUNCTION_ENUMERATEINSTANCES = "enumerateInstances";
    private static final String FUNCTION_ENUMERATEINSTANCENAMES = "enumerateInstanceNames";
    private static final String FUNCTION_ENUMERATECLASSES = "enumerateClasses";
    private static final String FUNCTION_ENUMERATECLASSNAMES = "enumerateClassNames";
    private static final String FUNCTION_SET_LISTENER = "setListener";
    private static final String FUNCTION_ASSUME_ROLE = "assumeRole";
    private static final String FUNCTION_ASSOCIATORS = "associators";
    private static final String FUNCTION_ASSOCIATORNAMES = "associatorNames";
    private static final String FUNCTION_REFERENCES = "references";
    private static final String FUNCTION_REFERENCENAMES = "referenceNames";
    private static final String FUNCTION_PERFORMBATCHOPERATIONS = "performOperations";
    private static final String FUNCTION_GETCLASS = "getClass";
    private static final String FUNCTION_GETINSTANCE = "getInstance";
    private static final String FUNCTION_GETVERSION = "getVersion";
    private CheckSumGen csg = new CheckSumGen();
    private static Object lockObject = new Object();
    private boolean latestVersion = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMClientRMI(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg) throws CIMException {
        try {
            this.clientListener = clientListener;
            this.nameSpace = name;
            this.debug = dbg;
            this.cs = null;
            String rmiport = System.getProperty("com.sun.wbem.rmiport", RMIPORT);
            boolean mustCheck = false;
            Object object = lockObject;
            synchronized (object) {
                try {
                    this.comp = (CIMOM2)Naming.lookup("//" + this.nameSpace.getHost() + ":" + rmiport + "/CIMOM" + version);
                }
                catch (MarshalException me) {
                    int i = 0;
                    while (true) {
                        if (++i > 5) {
                            throw new CIMTransportException("TIMED_OUT", "//" + this.nameSpace.getHost() + "/CIMOM" + version);
                        }
                        CIMClientRMI cIMClientRMI = this;
                        synchronized (cIMClientRMI) {
                            try {
                                this.wait(4000L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                        try {
                            this.comp = (CIMOM2)Naming.lookup("//" + this.nameSpace.getHost() + ":" + rmiport + "/CIMOM" + version);
                        }
                        catch (Exception e1) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        catch (UnknownHostException e0) {
            CIMTransportException e = new CIMTransportException("UNKNOWNHOST", this.nameSpace.getHost());
            throw e;
        }
        catch (ConnectException e1) {
            CIMTransportException e = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + version);
            throw e;
        }
        catch (RemoteException e2) {
            if (e2.detail instanceof ClassNotFoundException) {
                throw new NoClassDefFoundError(e2.detail.toString());
            }
            CIMTransportException e = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + version);
            throw e;
        }
        catch (MalformedURLException e3) {
            CIMTransportException e = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + version);
            throw e;
        }
        catch (NotBoundException e4) {
            throw new CIMException("VER_ERROR", version);
        }
    }

    public synchronized void initSecurityContext(String version, ClientSecurityContext csc) throws CIMException {
        try {
            this.cs = (RmiClientSecurity)csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", "Invalid security context");
        }
        SecurityMessage cm = this.cs.generateHello();
        SecurityMessage sm = this.hello(version, cm);
        cm = this.cs.generateResponse(sm);
        sm = this.credentials(version, cm);
        this.cs.checkResult(sm);
        String roleName = this.cs.getRoleName();
        if (roleName != null && roleName.trim().length() > 0) {
            String rolePswd = this.cs.getRolePassword();
            String encrPswd = this.cs.trans51Format(rolePswd);
            this.assumeRole(version, roleName, encrPswd);
        }
        this.latestVersion = this.checkVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkVersion(String version) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_GETVERSION};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            Vector<Object> input = new Vector<Object>(3);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_GETVERSION);
            try {
                Vector outp = this.comp.generalAPI(input);
            }
            catch (CIMException e) {
                return false;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_GETVERSION, e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createNameSpace(String version, CIMNameSpace currNs, CIMNameSpace newNs) throws CIMException {
        String[] oarray = new String[]{version, "createNameSpace", this.csg.toString(currNs), this.csg.toString(newNs)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.createNameSpace(version, currNs, newNs, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createNameSpace", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(String version) throws CIMException {
        String[] oarray = new String[]{version, "close"};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                try {
                    UnicastRemoteObject.unexportObject(this.remoteListener, false);
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                this.comp.close(version, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "close", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteNameSpace(String version, CIMNameSpace currNs, CIMNameSpace delNs) throws CIMException {
        String[] oarray = new String[]{version, "deleteNameSpace", this.csg.toString(currNs), this.csg.toString(delNs)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteNameSpace(version, currNs, delNs, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteNameSpace", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteClass(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "deleteClass", this.csg.toString(currNs), this.csg.toString(path)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteClass(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteClass", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteInstance(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "deleteInstance", this.csg.toString(currNs), this.csg.toString(path)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteInstance(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteInstance", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteQualifierType(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "deleteQualifierType", this.csg.toString(currNs), this.csg.toString(path)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteQualifierType(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteQualifierType", e);
            }
        }
    }

    public synchronized Vector enumClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, "enumClass", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumClass(version, currNs, path, deep, localOnly, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumClass", e);
            }
        }
    }

    public synchronized Vector enumClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, "enumClass", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumClass(version, currNs, path, deep, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumClass", e);
            }
        }
    }

    public synchronized Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        if (!this.latestVersion) {
            throw new CIMException("VER_ERROR", version);
        }
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, FUNCTION_ENUMERATECLASSES, this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>();
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_ENUMERATECLASSES);
            input.addElement(currNs);
            input.addElement(path);
            input.addElement(new Boolean(deep));
            input.addElement(new Boolean(localOnly));
            input.addElement(new Boolean(includeQualifiers));
            input.addElement(new Boolean(includeClassOrigin));
            try {
                Vector out = this.comp.generalAPI(input);
                return out;
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_ENUMERATECLASSES, e);
            }
        }
    }

    public synchronized Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        return this.enumClass(version, currNs, path, deep);
    }

    public synchronized Vector enumNameSpace(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, "enumNameSpace", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumNameSpace(version, currNs, path, deep, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumNameSpace", e);
            }
        }
    }

    public synchronized Vector enumInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, "enumInstances", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumInstances(version, currNs, path, deep, localOnly, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumInstances", e);
            }
        }
    }

    public synchronized Vector enumInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, "enumInstances", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumInstances(version, currNs, path, deep, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumInstances", e);
            }
        }
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        if (!this.latestVersion) {
            throw new CIMException("VER_ERROR", version);
        }
        Boolean bln = new Boolean(deep);
        String[] oarray = new String[]{version, FUNCTION_ENUMERATEINSTANCES, this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>();
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_ENUMERATEINSTANCES);
            input.addElement(currNs);
            input.addElement(path);
            input.addElement(new Boolean(deep));
            input.addElement(new Boolean(localOnly));
            input.addElement(new Boolean(includeQualifiers));
            input.addElement(new Boolean(includeClassOrigin));
            input.addElement(propertyList);
            try {
                Vector out = this.comp.generalAPI(input);
                return out;
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_ENUMERATEINSTANCES, e);
            }
        }
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        if (!this.latestVersion) {
            throw new CIMException("VER_ERROR", version);
        }
        String[] oarray = new String[]{version, FUNCTION_ENUMERATEINSTANCENAMES, this.csg.toString(currNs), this.csg.toString(path)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>();
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_ENUMERATEINSTANCENAMES);
            input.addElement(currNs);
            input.addElement(path);
            try {
                Vector outp = this.comp.generalAPI(input);
                return outp;
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_ENUMERATEINSTANCENAMES, e);
            }
        }
    }

    public synchronized Vector enumQualifierTypes(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "enumQualifierTypes", this.csg.toString(currNs), this.csg.toString(path)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumQualifierTypes(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumQualifierTypes", e);
            }
        }
    }

    public CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        if (!this.latestVersion) {
            throw new CIMException("VER_ERROR", version);
        }
        Boolean blo = new Boolean(localOnly);
        String[] oarray = new String[]{version, FUNCTION_GETCLASS, this.csg.toString(currNs), this.csg.toString(path), blo.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>();
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_GETCLASS);
            input.addElement(currNs);
            input.addElement(path);
            input.addElement(blo);
            input.addElement(new Boolean(includeQualifiers));
            input.addElement(new Boolean(includeClassOrigin));
            input.addElement(propertyList);
            try {
                Vector outp = this.comp.generalAPI(input);
                return (CIMClass)outp.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_GETCLASS, e);
            }
        }
    }

    public CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        if (!this.latestVersion) {
            throw new CIMException("VER_ERROR", version);
        }
        Boolean blo = new Boolean(localOnly);
        String[] oarray = new String[]{version, FUNCTION_GETINSTANCE, this.csg.toString(currNs), this.csg.toString(path), blo.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>();
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_GETINSTANCE);
            input.addElement(currNs);
            input.addElement(path);
            input.addElement(blo);
            input.addElement(new Boolean(includeQualifiers));
            input.addElement(new Boolean(includeClassOrigin));
            input.addElement(propertyList);
            try {
                Vector outp = this.comp.generalAPI(input);
                return (CIMInstance)outp.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_GETINSTANCE, e);
            }
        }
    }

    public synchronized CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_GETCLASS, this.csg.toString(currNs), this.csg.toString(name)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getClass(version, currNs, name, localOnly, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_GETCLASS, e);
            }
        }
    }

    public synchronized CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_GETINSTANCE, this.csg.toString(currNs), this.csg.toString(name)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getInstance(version, currNs, name, localOnly, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_GETINSTANCE, e);
            }
        }
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, Vector inParams, Vector outParams) throws CIMException {
        String[] oarray = new String[]{version, "invokeMethod", this.csg.toString(currNs), this.csg.toString(name), methodName, this.csg.toString(inParams)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                Vector v = this.comp.invokeMethod(version, currNs, name, methodName, inParams, st);
                for (int i = 1; i < v.size(); ++i) {
                    outParams.addElement(v.elementAt(i));
                }
                return (CIMValue)v.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "invokeMethod", e);
            }
        }
    }

    public synchronized CIMQualifierType getQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        String[] oarray = new String[]{version, "getQualifierType", this.csg.toString(currNs), this.csg.toString(name)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getQualifierType(version, currNs, name, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "getQualifierType", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        String[] oarray = new String[]{version, "createQualifierType", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(qt)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.addCIMElement(version, currNs, name, qt, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createQualifierType", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        String[] oarray = new String[]{version, "createClass", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(cc)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.addCIMElement(version, currNs, name, cc, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createClass", e);
            }
        }
    }

    public synchronized CIMObjectPath createInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        String[] oarray = new String[]{version, "createInstance", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(ci)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.addCIMElement(version, currNs, name, ci, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createInstance", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        String[] oarray = new String[]{version, "setQualifierType", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(qt)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setCIMElement(version, currNs, name, qt, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setQualifierType", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        String[] oarray = new String[]{version, "setClass", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(cc)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setCIMElement(version, currNs, name, cc, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setClass", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        String[] oarray = new String[]{version, "setInstance", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(ci)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setCIMElement(version, currNs, name, ci, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setInstance", e);
            }
        }
    }

    public synchronized CIMValue getProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException {
        String[] oarray = new String[]{version, "getProperty", this.csg.toString(currNs), this.csg.toString(name), propertyName};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getProperty(version, currNs, name, propertyName, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "getProperty", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        String[] oarray = new String[]{version, "setProperty", this.csg.toString(currNs), this.csg.toString(name), propertyName, this.csg.toString(cv)};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setProperty(version, currNs, name, propertyName, cv, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setProperty", e);
            }
        }
    }

    public synchronized Vector execQuery(String version, CIMNameSpace currNs, CIMObjectPath relNS, String query, int ql) throws CIMException {
        String[] oarray = new String[]{version, "execQuery", this.csg.toString(currNs), this.csg.toString(relNS), query, ql + ""};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.execQuery(version, currNs, relNS, query, ql, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "execQuery", e);
            }
        }
    }

    public Vector associators(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_ASSOCIATORS, this.csg.toString(currNs), this.csg.toString(objectName), assocClass, resultClass, role, resultRole};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>(12);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_ASSOCIATORS);
            input.addElement(currNs);
            input.addElement(objectName);
            input.addElement(assocClass);
            input.addElement(resultClass);
            input.addElement(role);
            input.addElement(resultRole);
            input.addElement(new Boolean(includeQualifiers));
            input.addElement(new Boolean(includeClassOrigin));
            input.addElement(propertyList);
            try {
                Vector outp = this.comp.generalAPI(input);
                return (Vector)outp.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_ASSOCIATORS, e);
            }
        }
    }

    public Vector associatorNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_ASSOCIATORNAMES, this.csg.toString(currNs), this.csg.toString(objectName), assocClass, resultClass, role, resultRole};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>(9);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_ASSOCIATORNAMES);
            input.addElement(currNs);
            input.addElement(objectName);
            input.addElement(assocClass);
            input.addElement(resultClass);
            input.addElement(role);
            input.addElement(resultRole);
            try {
                Vector outp = this.comp.generalAPI(input);
                return (Vector)outp.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_ASSOCIATORNAMES, e);
            }
        }
    }

    public Vector references(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_REFERENCES, this.csg.toString(currNs), this.csg.toString(objectName), resultClass, role};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>(10);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_REFERENCES);
            input.addElement(currNs);
            input.addElement(objectName);
            input.addElement(resultClass);
            input.addElement(role);
            input.addElement(new Boolean(includeQualifiers));
            input.addElement(new Boolean(includeClassOrigin));
            input.addElement(propertyList);
            try {
                Vector outp = this.comp.generalAPI(input);
                return (Vector)outp.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_REFERENCES, e);
            }
        }
    }

    public Vector referenceNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_REFERENCENAMES, this.csg.toString(currNs), this.csg.toString(objectName), resultClass, role};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>(7);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_REFERENCENAMES);
            input.addElement(currNs);
            input.addElement(objectName);
            input.addElement(resultClass);
            input.addElement(role);
            try {
                Vector outp = this.comp.generalAPI(input);
                return (Vector)outp.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_REFERENCENAMES, e);
            }
        }
    }

    public Vector performOperations(String version, CIMOperation[] batchedOperations) throws CIMException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < batchedOperations.length; ++i) {
            buff.append(batchedOperations[i].getClass().getName());
        }
        String[] oarray = new String[]{version, buff.toString()};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>(4);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_PERFORMBATCHOPERATIONS);
            input.addElement(batchedOperations);
            try {
                return this.comp.generalAPI(input);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_PERFORMBATCHOPERATIONS, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assumeRole(String version, String roleName, String encrPswd) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_ASSUME_ROLE, roleName, encrPswd};
        RmiClientSecurity rmiClientSecurity = this.cs;
        synchronized (rmiClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            Vector<Object> input = new Vector<Object>(5);
            input.addElement(st);
            input.addElement(version);
            input.addElement(FUNCTION_ASSUME_ROLE);
            input.addElement(roleName);
            input.addElement(encrPswd);
            try {
                Vector outp = this.comp.generalAPI(input);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", FUNCTION_ASSUME_ROLE, e);
            }
        }
    }

    private SecurityMessage hello(String version, SecurityMessage cm) throws CIMException {
        try {
            return this.comp.hello(version, cm);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("RMIERROR", "hello", e);
        }
    }

    private SecurityMessage credentials(String version, SecurityMessage cm) throws CIMException {
        try {
            return this.comp.credentials(version, cm);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("RMIERROR", "credentials", e);
        }
    }

    public void setListener(String version) throws CIMException {
        String[] oarray = new String[]{version, FUNCTION_SET_LISTENER};
        SecurityToken st = this.cs.getSecurityToken(oarray);
        Vector<Object> input = new Vector<Object>(4);
        input.addElement(st);
        input.addElement(version);
        input.addElement(FUNCTION_SET_LISTENER);
        try {
            this.remoteListener = new RemoteListenerImpl(this.clientListener);
            input.addElement(this.remoteListener);
            Vector outp = this.comp.generalAPI(input);
        }
        catch (CIMException e) {
            try {
                UnicastRemoteObject.unexportObject(this.remoteListener, false);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (!e.getID().equals("CIM_ERR_NOT_SUPPORTED")) {
                throw e;
            }
        }
        catch (Exception e) {
            try {
                UnicastRemoteObject.unexportObject(this.remoteListener, false);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (e instanceof ServerException) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            throw new CIMException("RMIERROR", FUNCTION_SET_LISTENER, e);
        }
    }
}

