/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class CIMInstance
extends CIMElement
implements Serializable {
    static final long serialVersionUID = 200L;
    private String className = new String("");
    private String alias = "";
    private Vector qualifiers = new Vector();
    private Vector properties = new Vector();
    private Vector allproperties = new Vector();
    private Vector keyproperties;

    public CIMInstance() {
        super("");
    }

    public CIMInstance(String name) {
        super(name);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = new String(className);
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Vector table) {
        this.qualifiers = table;
    }

    public Vector getProperties() {
        return this.properties;
    }

    private void addProperty(CIMProperty p) {
        if (p.getOverridingProperty() == null) {
            this.properties.addElement(p);
        }
        this.allproperties.addElement(p);
    }

    public void setProperties(Vector Table) {
        if (Table == null || Table.size() == 0) {
            this.properties = null;
            this.allproperties = null;
        }
        this.properties = new Vector();
        this.allproperties = new Vector();
        int size = Table.size();
        for (int i = 0; i < size; ++i) {
            this.addProperty((CIMProperty)Table.elementAt(i));
        }
    }

    public CIMProperty getProperty(String name, String originClass) {
        if (this.allproperties == null || name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getProperty(name);
        }
        int size = this.allproperties.size();
        for (int i = 0; i < size; ++i) {
            CIMProperty pe = (CIMProperty)this.allproperties.elementAt(i);
            if (!pe.getName().equalsIgnoreCase(name) || !pe.getOriginClass().equalsIgnoreCase(originClass)) continue;
            if (pe.getOverridingProperty() != null) {
                return this.getProperty(pe.getOverridingProperty());
            }
            return pe;
        }
        return null;
    }

    public CIMProperty getProperty(String propertyName) {
        if (this.allproperties == null || propertyName == null) {
            return null;
        }
        StringTokenizer st = null;
        try {
            st = new StringTokenizer(propertyName, ".");
        }
        catch (Exception e) {
            return null;
        }
        String token1 = (String)st.nextElement();
        String token2 = null;
        try {
            token2 = (String)st.nextElement();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (token2 != null) {
            CIMProperty cp = this.intgetProperty(token1);
            if (cp != null) {
                while (true) {
                    CIMInstance ci = null;
                    try {
                        ci = (CIMInstance)cp.getValue().getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                    cp = ci.getProperty(token2);
                    if (!st.hasMoreElements()) break;
                    token2 = (String)st.nextElement();
                }
                return cp;
            }
            return this.getProperty(token2, token1);
        }
        return this.intgetProperty(token1);
    }

    private CIMProperty intgetProperty(String propertyName) {
        int tempIndex = this.allproperties.indexOf(new CIMProperty(propertyName));
        if (tempIndex < 0) {
            return null;
        }
        CIMProperty pe = (CIMProperty)this.allproperties.elementAt(tempIndex);
        if (pe.getOverridingProperty() != null) {
            return this.getProperty(pe.getOverridingProperty());
        }
        return pe;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String aliasName) {
        this.alias = new String(aliasName);
    }

    public String getName() {
        String name = this.className.toLowerCase();
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (!pe.isKey() || pe.getOverridingProperty() != null) continue;
            CIMValue cv = pe.getValue();
            if (cv == null) {
                name = name.concat(":" + pe.getOriginClass().toLowerCase() + "." + pe.getName().toLowerCase() + "=null");
                continue;
            }
            name = name.concat(":" + pe.getOriginClass().toLowerCase() + "." + pe.getName().toLowerCase() + "=" + this.toString(cv));
        }
        return name;
    }

    private String toString(CIMValue cv) {
        String s = "null";
        Object o = cv.getValue();
        if (o != null) {
            if (cv.isArrayValue()) {
                throw new IllegalArgumentException(o.toString());
            }
            String q = "";
            if (new CIMDataType(8).equals(cv.getType())) {
                q = "\"";
            }
            s = q + this.values(o) + q;
        }
        return s;
    }

    private String values(Object o) {
        if (o instanceof CIMObjectPath) {
            return this.toString((CIMObjectPath)o);
        }
        if (o instanceof CIMDateTime) {
            return this.toString((CIMDateTime)o);
        }
        if (o instanceof CIMInstance) {
            throw new IllegalArgumentException(o.toString());
        }
        return o.toString();
    }

    private String toString(CIMDateTime cdt) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
        Calendar cal = cdt.getCalendar();
        TimeZone tz = cal.getTimeZone();
        if (cdt.isInterval()) {
            return formatter.format(cal.getTime()) + ":000";
        }
        int offset = cal.get(15) + cal.get(16);
        double minutes = (double)offset * 0.001 / 60.0;
        return formatter.format(cal.getTime()) + (int)minutes;
    }

    private String toString(CIMObjectPath op) {
        Vector keys = op.getKeys();
        String nameSpace = op.getNameSpace();
        String objectName = op.getObjectName();
        if (keys == null || keys.size() == 0) {
            if (objectName != null && objectName.length() != 0) {
                return nameSpace + "\\" + objectName;
            }
            return nameSpace;
        }
        String s = "";
        int i = 0;
        Enumeration e = keys.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (pe == null) continue;
            String oc = pe.getOriginClass();
            s = oc != null && oc.length() != 0 ? s + oc + "." + pe.getName() : s + pe.getName();
            s = s + "=" + this.toString(pe.getValue()) + ":";
            ++i;
        }
        if (i > 0) {
            return nameSpace + "\\" + objectName + ":" + s.substring(0, s.lastIndexOf(":"));
        }
        return nameSpace + "\\" + objectName;
    }

    public Vector getKeyValuePairs() {
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (!pe.isKey() || pe.getOverridingProperty() != null) continue;
            CIMProperty cp = new CIMProperty(pe.getName(), pe.getValue());
            cp.setOriginClass(pe.getOriginClass());
            cp.setType(pe.getType());
            cp.setSize(pe.getSize());
            v.addElement(cp);
        }
        return v;
    }

    public void updatePropertyValues(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            CIMProperty ipe = this.getProperty(pe.getName(), pe.getOriginClass());
            if (ipe == null) {
                throw new IllegalArgumentException(pe.getName());
            }
            ipe.setValue(pe.getValue());
        }
    }

    public void updatePropertyValue(CIMProperty pe) {
        CIMProperty ipe = this.getProperty(pe.getName(), pe.getOriginClass());
        if (ipe == null) {
            throw new IllegalArgumentException(pe.getOriginClass() + "." + pe.getName());
        }
        ipe.setValue(pe.getValue());
    }

    public void setProperty(String name, CIMValue cv) {
        CIMProperty ipe = this.getProperty(name);
        if (ipe == null) {
            throw new IllegalArgumentException(name);
        }
        ipe.setValue(cv);
    }

    public CIMInstance localElements() {
        CIMInstance ci = new CIMInstance();
        ci.className = this.className;
        ci.qualifiers = this.qualifiers;
        if (this.properties == null) {
            ci.setProperties(null);
        } else {
            Vector<CIMProperty> ov = new Vector<CIMProperty>();
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)e.nextElement();
                if (!pe.getOriginClass().equalsIgnoreCase(this.className)) continue;
                ov.addElement(pe);
            }
            ci.setProperties(ov);
        }
        return ci;
    }

    public CIMInstance localElements(List classNames) {
        if (classNames == null) {
            return this;
        }
        Iterator i = classNames.iterator();
        HashMap<String, String> m = new HashMap<String, String>();
        while (i.hasNext()) {
            String s = (String)i.next();
            m.put(s.toLowerCase(), "");
        }
        CIMInstance ci = new CIMInstance();
        ci.className = this.className;
        ci.qualifiers = this.qualifiers;
        if (this.allproperties == null) {
            ci.setProperties(null);
        } else {
            Vector<CIMProperty> ov = new Vector<CIMProperty>();
            Enumeration e = this.allproperties.elements();
            while (e.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)e.nextElement();
                if (m.get(pe.getOriginClass().toLowerCase()) == null) continue;
                ov.addElement(pe);
            }
            ci.setProperties(ov);
        }
        return ci;
    }

    public CIMInstance filterProperties(String[] propertyList, boolean includeQualifier, boolean includeClassOrigin) {
        CIMInstance ci = new CIMInstance();
        Vector<Object> propList = null;
        if (propertyList == null || this.allproperties == null || this.allproperties.size() == 0) {
            if (this.allproperties != null) {
                propList = new Vector<Object>();
                Enumeration e = this.allproperties.elements();
                while (e.hasMoreElements()) {
                    CIMProperty pe = (CIMProperty)e.nextElement();
                    propList.addElement(pe.clone(includeQualifier, includeClassOrigin));
                }
            } else {
                propList = null;
            }
        } else {
            HashMap<String, String> hm = new HashMap<String, String>();
            propList = new Vector();
            for (int i = 0; i < propertyList.length; ++i) {
                String propName;
                CIMProperty cp = this.getProperty(propertyList[i]);
                if (cp == null || hm.get(propName = cp.getOriginClass() + "." + cp.getName()) != null) continue;
                hm.put(propName, propName);
                propList.addElement(cp.clone(includeQualifier, includeClassOrigin));
            }
        }
        ci.className = this.className;
        ci.setProperties(propList);
        if (includeQualifier) {
            ci.qualifiers = this.qualifiers;
        }
        return ci;
    }

    public String toXml() {
        CIMObjectPath cop = new CIMObjectPath();
        String host = "";
        return this.toXml(cop, host);
    }

    public String toXml(CIMObjectPath cop) {
        String host = "";
        return this.toXml(cop, host);
    }

    public String toXml(CIMObjectPath cop, String host) {
        XmlInstance xi = new XmlInstance();
        return xi.toXml(this, cop, host);
    }
}

