/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.security;

import com.sun.audit.AuditEvent_admin_authenticate;
import com.sun.audit.AuditEvent_role_login;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.CIMOMLibrary;
import com.sun.wbem.cimom.audit.SolarisWbemAuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.cimom.security.UserPasswordProvider;
import com.sun.wbem.client.SolarisPswdEncryptionProvider;
import com.sun.wbem.client.SolarisUserRolePrincipal;
import java.security.Principal;
import javax.wbem.cim.CIMException;
import javax.wbem.client.Debug;
import javax.wbem.security.UserPasswordEncryptionProvider;

public final class SolarisUserPasswordProvider
implements UserPasswordProvider {
    private static final String DFLT_SALT = "AA";
    private UserPasswordEncryptionProvider pep = new SolarisPswdEncryptionProvider();

    public String getEncryptedPassword(String username, int type) throws CIMException {
        String hash = CIMOMLibrary.getEncryptedPassword(username, type);
        if (hash != null && hash.length() < 3) {
            hash = this.pep.encryptPassword(username, DFLT_SALT, "");
        }
        return hash;
    }

    public String writeLocalAuthenticator(String username, String dir, String value) throws CIMException {
        return CIMOMLibrary.writeLocalAuthenticator(username, dir, value);
    }

    public boolean authenticateUser(String username, String password) throws CIMException {
        if (password == null || password.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUser(username, password);
    }

    public boolean authenticateRole(String rolename, String password, String roleuser) throws CIMException {
        if (password == null || password.trim().length() == 0 || roleuser == null || roleuser.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateRole(rolename, password, roleuser);
    }

    public void auditLogin(WbemAuditSession auditSession, String hostName, String userName, long event) throws CIMException {
        this.auditLogin(auditSession, hostName, userName, null, event);
    }

    public void auditLogin(WbemAuditSession auditSession, String hostName, String userName, String roleName, long event) throws CIMException {
        if (auditSession == null || hostName == null || userName == null) {
            Debug.trace3((String)"null WbemAuditSession");
            return;
        }
        if (!(auditSession instanceof SolarisWbemAuditSession)) {
            Debug.trace3((String)"auditSession is not SolarisWbemAuditSession");
            return;
        }
        SolarisWbemAuditSession swas = (SolarisWbemAuditSession)auditSession;
        SolarisUserRolePrincipal sup = new SolarisUserRolePrincipal(userName, roleName);
        this.auditLogin(swas, sup, hostName, event);
    }

    private void auditLogin(SolarisWbemAuditSession swAuditSession, SolarisUserRolePrincipal sup, String hostname, long event) throws CIMException {
        if (swAuditSession == null || hostname == null || sup == null) {
            Debug.trace3((String)("SolarisUserPasswordProvider.auditLogin: null parameters, event: " + event));
            return;
        }
        Debug.trace3((String)("auditLogin: clientHost : " + hostname + ", userName : " + sup.getUserName() + ", event : " + event));
        swAuditSession.setIdentity((Principal)sup, hostname);
        AuditSession auditSession = (AuditSession)swAuditSession.getPlatformAuditSession();
        if (auditSession == null) {
            Debug.trace3((String)"null platform audit session.");
            return;
        }
        if (event == -1L) {
            this.authenticateEvent(auditSession, 3, -1, 0);
        } else if (event == -2L) {
            this.authenticateEvent(auditSession, 4, -1, 0);
        } else if (event == 1L) {
            this.authenticateEvent(auditSession, 0, 0, 0);
        } else if (event == 2L) {
            this.roleloginEvent(auditSession, 0, 0, 0);
        } else if (event == -3L) {
            this.roleloginEvent(auditSession, 3, -1, 0);
        } else {
            Debug.trace3((String)("SolarisUserPasswordProvider.auditLogin: Unknown event: " + event));
            return;
        }
    }

    private void authenticateEvent(AuditSession auditSession, int msg, int status, int ret_val) {
        try {
            AuditEvent_admin_authenticate loginEvent = new AuditEvent_admin_authenticate(auditSession);
            loginEvent.message(msg);
            loginEvent.putEvent(status, ret_val);
        }
        catch (Exception e) {
            Debug.trace3((String)("authenticateEvent: msg = " + msg + ", status" + status + "\nThrew exception."), (Throwable)e);
        }
    }

    private void roleloginEvent(AuditSession auditSession, int msg, int status, int ret_val) {
        try {
            AuditEvent_role_login roleLoginEvent = new AuditEvent_role_login(auditSession);
            roleLoginEvent.message(msg);
            roleLoginEvent.putEvent(status, ret_val);
        }
        catch (Exception e) {
            Debug.trace3((String)("roleloginEvent: msg = " + msg + ", status = " + status + "\nThrew exception."), (Throwable)e);
        }
    }
}

