/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.snmp;

import com.sun.wbem.cimom.adapters.client.snmp.SnmpImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.wbem.client.Debug;

public class SnmpService
extends Thread {
    private static final String REQUEST_PIPE = "/var/sadm/wbem/snmp/_adapter_snd.fifo";
    private static final String RESPONSE_PIPE = "/var/sadm/wbem/snmp/_adapter_rcv.fifo";
    private boolean debugOn = false;
    private SnmpImpl snmpImpl = null;
    private InputStream in = null;
    private OutputStream out = null;
    private static byte[] outOfBandBytes = new byte[]{1};
    private static byte[] systemBytesTest = new byte[]{48, -126, 0, 83, 2, 1, 0, 4, 6, 112, 117, 98, 108, 105, 99, -96, 70, 2, 4, 87, 108, 111, 76, 2, 1, 0, 2, 1, 0, 48, 56, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 5, 0, 5, 0, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 1, 0, 5, 0, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 3, 0, 5, 0, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 7, 0, 5, 0};
    private static byte[] systemBytes = new byte[]{48, 83, 2, 1, 0, 4, 6, 112, 117, 98, 108, 105, 99, -96, 70, 2, 4, 87, 108, 111, 76, 2, 1, 0, 2, 1, 0, 48, 56, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 5, 0, 5, 0, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 1, 0, 5, 0, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 3, 0, 5, 0, 48, 12, 6, 8, 43, 6, 1, 2, 1, 1, 4, 0, 5, 0};
    private static byte[] hrBytes = new byte[]{48, 87, 2, 1, 0, 4, 6, 112, 117, 98, 108, 105, 99, -96, 74, 2, 4, 87, 108, 111, 76, 2, 1, 0, 2, 1, 0, 48, 60, 48, 13, 6, 9, 43, 6, 1, 2, 1, 25, 1, 2, 0, 5, 0, 48, 13, 6, 9, 43, 6, 1, 2, 1, 25, 1, 5, 0, 5, 0, 48, 13, 6, 9, 43, 6, 1, 2, 1, 25, 1, 6, 0, 5, 0, 48, 13, 6, 9, 43, 6, 1, 2, 1, 25, 1, 7, 0, 5, 0};
    private static byte[] securityBytes = new byte[]{16, 4, 114, 111, 111, 116};

    public SnmpService(boolean verbose, SnmpImpl snmpImpl) throws IOException {
        this.snmpImpl = snmpImpl;
        String level = System.getProperty("wbem.debug.level");
        if (level != null && level.length() > 0) {
            this.debugOn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        try {
            Debug.trace1((String)"Starting SNMP Adapter service...");
            this.in = new FileInputStream(REQUEST_PIPE);
            OutputPipe outPipe = new OutputPipe(RESPONSE_PIPE);
            while (true) {
                byte[] inputBytes;
                byte[] secBytes;
                int byteCount;
                if ((byteCount = this.readCount(this.in)) == 0) {
                    Debug.trace2((String)"Request pipe closed, exit adapter");
                    return;
                }
                int secCount = this.readCount(this.in);
                if (secCount == 0) {
                    Debug.trace2((String)"Request pipe closed, re-opening");
                    this.in = new FileInputStream(REQUEST_PIPE);
                    continue;
                }
                try {
                    secBytes = this.readMessage(this.in, secCount);
                    inputBytes = this.readMessage(this.in, byteCount - secCount - 2);
                }
                catch (Exception x) {
                    Debug.trace2((String)"Request pipe closed, re-opening");
                    this.in = new FileInputStream(REQUEST_PIPE);
                    continue;
                }
                if (inputBytes.length == 1) {
                    this.snmpImpl.mgmtRequest(secBytes, inputBytes);
                    continue;
                }
                byte[] outputBytes = this.snmpImpl.snmpRequest(secBytes, inputBytes);
                outPipe.writeResponse(outputBytes);
                continue;
                break;
            }
        }
        catch (IOException e) {
            Debug.trace2((String)("SNMP Adapter run error:\n" + e.getMessage()));
            return;
        }
        catch (Exception e) {
            Debug.trace2((String)("SNMP Adapter run error:\n" + e.getMessage()));
            return;
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private String byteToHex(byte b) {
        int[] num = new int[2];
        String s = new String("0x");
        int ch = b < 0 ? (b & 0x7F) + 127 + 1 : b;
        num[1] = ch % 16;
        num[0] = ch >> 4;
        for (int i = 0; i < num.length; ++i) {
            char c = Character.forDigit(num[i], 16);
            s = s + c;
        }
        return s;
    }

    private int readCount(InputStream in) {
        int byteCount = 0;
        try {
            byteCount = in.read();
            if (byteCount < 0) {
                return 0;
            }
            byteCount <<= 8;
            int i = in.read();
            if (i < 0) {
                return 0;
            }
            byteCount += i;
        }
        catch (Exception e) {
            Debug.trace1((String)"readCount", (Throwable)e);
            byteCount = 0;
        }
        return byteCount;
    }

    private byte[] readMessage(InputStream in, int count) throws Exception, IOException {
        byte[] inBytes = null;
        boolean byteCount = false;
        int index = 0;
        try {
            if (count < 0) {
                throw new Exception();
            }
            int len = count;
            inBytes = new byte[count];
            while (index < count) {
                int readCount = in.read(inBytes, index, len);
                if (readCount < 0) {
                    throw new Exception();
                }
                index += readCount;
                len -= readCount;
            }
        }
        catch (IOException e) {
            Debug.trace1((String)"readMessage", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Debug.trace1((String)"readMessage", (Throwable)e);
            throw e;
        }
        return inBytes;
    }

    private void createNamedPipe() {
        int zero_len = 0;
        Debug.trace1((String)"Remember to uncomment call to create* before putback");
        Debug.trace1((String)"If test/release sees this, it is a bug!");
        try {
            FileOutputStream out = new FileOutputStream(REQUEST_PIPE);
            ((OutputStream)out).write(zero_len);
            int ch = systemBytes.length + securityBytes.length + 2;
            ((OutputStream)out).write(ch);
            ((OutputStream)out).write(zero_len);
            ch = securityBytes.length;
            ((OutputStream)out).write(ch);
            ((OutputStream)out).write(securityBytes);
            ((OutputStream)out).write(systemBytes);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Debug.trace1((String)"Couldn't create named pipe", (Throwable)e);
        }
    }

    private void createNamedPipeBand() {
        int zero_len = 0;
        Debug.trace1((String)"Remember to uncomment call to create* before putback");
        Debug.trace1((String)"If test/release sees this, it is a bug!");
        try {
            FileOutputStream out = new FileOutputStream(REQUEST_PIPE);
            ((OutputStream)out).write(zero_len);
            int ch = outOfBandBytes.length + securityBytes.length + 2;
            ((OutputStream)out).write(ch);
            ((OutputStream)out).write(zero_len);
            ch = securityBytes.length;
            ((OutputStream)out).write(ch);
            ((OutputStream)out).write(securityBytes);
            ((OutputStream)out).write(outOfBandBytes);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void traceHexBytes(String title, byte[] bytes) {
        if (!this.debugOn) {
            return;
        }
        String s = "";
        Debug.trace3((String)(title + ", len = " + bytes.length));
        for (int i = 0; i < bytes.length; ++i) {
            s = s + this.byteToHex(bytes[i]) + " ";
        }
        Debug.trace3((String)s);
    }

    public class OutputPipe
    implements OutputResponse {
        String pipeName = null;

        public OutputPipe(String pipeName) {
            this.pipeName = pipeName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void writeResponse(byte[] outputBytes) {
            byte[] b = null;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(SnmpService.RESPONSE_PIPE);
                if (outputBytes == null) {
                    Debug.trace2((String)"No response to write into pipe, write 1 byte");
                    b = new byte[]{0, 1, 1};
                    ((OutputStream)out).write(b);
                } else {
                    b = new byte[]{(byte)(outputBytes.length >> 8), (byte)(outputBytes.length & 0xFF)};
                    ((OutputStream)out).write(b);
                    SnmpService.this.traceHexBytes("writeResponse - byte count", b);
                    ((OutputStream)out).write(outputBytes);
                }
            }
            catch (Exception e) {
                Debug.trace1((String)"writeResponse", (Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception x) {}
            }
            SnmpService.this.traceHexBytes("writeResponse - message", outputBytes);
        }
    }

    private static interface OutputResponse {
        public void writeResponse(byte[] var1);
    }
}

