/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.snmp;

import com.sun.wbem.cimom.CIMOMServer;
import com.sun.wbem.cimom.ServerSecurity;
import com.sun.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpCache;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpMapEntry;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpNull;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;

public class SnmpImpl
implements ClientProtocolAdapterIF {
    private static final byte CTXTCONSFLAG = -96;
    private static final byte TAG_SEQ = 48;
    private static final byte SECURITY_TAG_USER = 16;
    private static final byte MGMT_REQ_REREAD_CACHE = 1;
    private static final byte SEQ_TAG_LONG2_CNT_FIELD = -126;
    private static final int SEQ_TAG_LONG2_MINUS_SHORT = 2;
    private static final int SEQ_TAG_LONG2_MINUS_LONG1 = 1;
    private static final int REQUEST_TYPE_FIELD_LEN = 2;
    private static final int HEADER_ERR_STAT_OFFSET_FROM_VARBINDLIST_CNT = -5;
    private static final int HEADER_ERR_INDEX_OFFSET_FROM_VARBINDLIST_CNT = -2;
    private static final int HEADER_CNT_FIELD_INDEX_VARBINDLIST = 2;
    private static final int MAX_PDU_BYTE_LEN = 1500;
    private static final int MILLISECS_IN_HOUR = 3600000;
    private static final int MILLISECS_IN_MINUTE = 60000;
    private static final String ROOT_NAMESPACE = "root/cimv2";
    private static final String HARDCODED_USERNAME = "root";
    private static final String MAP_DIRECTORY = "/var/sadm/wbem/snmp/map/";
    private static final String MAP_TABLE_SUFFIX = ".map";
    private static final String SNMP_MAP_TABLE_VERSION = "1.0";
    private static final String MAP_TABLE_VERSION_LABEL = "Version";
    private static final String LOG_RESOURCE = "com.sun.wbem.utility.log.SnmpAdapterLogMessages";
    private static final String ADAPTERNAME = "SNMP Adapter";
    private boolean debugOn = false;
    private CIMOMServer cimomhandle = null;
    private SnmpCache mapCache = null;

    public void initialize(CIMOMServer cimom, CIMOMHandle ch) {
        this.cimomhandle = cimom;
        Debug.trace1((String)"Starting SNMP Adapter Impl...");
        String level = System.getProperty("wbem.debug.level");
        if (level != null && level.length() > 0) {
            this.debugOn = true;
        }
        this.mapCache = new SnmpCache(this, this.debugOn);
    }

    public int startService(CIMInstance cpa) {
        try {
            new SnmpService(false, this).start();
        }
        catch (Exception e) {
            Debug.trace1((String)"Snmp service error", (Throwable)e);
        }
        return 0;
    }

    public int stopService() {
        return -1;
    }

    private void checkSecurity(byte[] securityBytes) throws CIMException {
        boolean passed = false;
        int index = 0;
        try {
            if (securityBytes == null || securityBytes.length < 2) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            while (index < securityBytes.length) {
                int len;
                byte tag = securityBytes[index++];
                if ((len = securityBytes[index++] & 0x7F) != securityBytes.length - 2) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                StringBuffer sb = new StringBuffer(len);
                for (int i = 0; i < len; ++i) {
                    sb.append((char)securityBytes[index++]);
                }
                String s = sb.toString();
                if (tag == 16 && s.equals(HARDCODED_USERNAME)) {
                    passed = true;
                    continue;
                }
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            if (!passed) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{};
            String logMsg = this.logError("SNMPA_100", "SNMPA_201", subArgs);
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"checkSecurity"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] snmpRequest(byte[] securityBytes, byte[] messageBytes) {
        byte[] outputBytes = null;
        SnmpPduRequest pdu = null;
        SnmpPduRequest pduRsp = null;
        try {
            byte[] inputBytes;
            try {
                inputBytes = this.formatInputTags(messageBytes);
            }
            catch (CIMException x) {
                throw x;
            }
            catch (Exception x) {
                String[] subArgs = new String[]{"formatInputTags"};
                String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, x);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            pdu = this.decodePduRequest(inputBytes);
            this.checkSecurity(securityBytes);
            switch (pdu.type) {
                case 160: {
                    pduRsp = this.snmpGetPdu(pdu);
                    break;
                }
                default: {
                    pduRsp = this.snmpErrorResponse(pdu, 130);
                }
            }
            this.tracePdu(pduRsp);
            outputBytes = this.encodePduResponse(pduRsp);
            this.traceHexBytes("response bytes", outputBytes);
        }
        catch (CIMException e) {
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"snmpRequest"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
        }
        finally {
            if (pdu != null && pduRsp == null) {
                try {
                    pduRsp = this.snmpErrorResponse(pdu, 130);
                    outputBytes = this.encodePduResponse(pduRsp);
                }
                catch (Exception x) {}
            }
            if (outputBytes == null) {
                outputBytes = this.snmpLastDitchError(messageBytes);
            }
        }
        return outputBytes;
    }

    public void mgmtRequest(byte[] securityBytes, byte[] messageBytes) {
        try {
            this.checkSecurity(securityBytes);
            if (messageBytes == null || messageBytes.length == 0) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            switch (messageBytes[0]) {
                case 1: {
                    this.mapCache.write();
                    break;
                }
                default: {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{};
            String logMsg = this.logError("SNMPA_102", "SNMPA_202", subArgs);
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"mgmtRequest"};
            String logMsg = this.logException("SNMPA_102", "SNMPA_200", subArgs, e);
        }
    }

    private byte[] formatInputTags(byte[] inBytes) throws Exception, CIMException {
        int len;
        byte tag;
        int inIndex = 0;
        int offsetTotal = 0;
        int outIndex = 0;
        int tagIndex = 0;
        ArrayList<Integer> tags = new ArrayList<Integer>();
        ArrayList<Integer> tagOffsets = new ArrayList<Integer>();
        if (inBytes == null || inBytes.length == 0) {
            String[] subArgs = new String[]{};
            String logMsg = this.logError("SNMPA_100", "SNMPA_210", subArgs);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        while (inIndex < inBytes.length) {
            tag = inBytes[inIndex];
            if (tag == 48 || (tag & 0xFFFFFFA0) == -96) {
                tags.add(new Integer(inIndex++));
                if (inBytes[inIndex] < 0) {
                    byte b = (byte)(inBytes[inIndex] & 0x7F);
                    if (b == 1) {
                        tagOffsets.add(new Integer(1));
                        ++offsetTotal;
                    } else {
                        tagOffsets.add(new Integer(0));
                    }
                    inIndex += b;
                } else {
                    tagOffsets.add(new Integer(2));
                    offsetTotal += 2;
                }
                ++inIndex;
                continue;
            }
            int n = ++inIndex;
            ++inIndex;
            len = inBytes[n];
            inIndex += len;
        }
        byte[] outBytes = new byte[inBytes.length + offsetTotal];
        inIndex = 0;
        tagIndex = 0;
        while (inIndex < inBytes.length) {
            Integer offset;
            int i;
            tag = inBytes[inIndex];
            outBytes[outIndex++] = inBytes[inIndex++];
            offsetTotal = 0;
            for (i = tagIndex + 1; tagIndex < 3 && i < tagOffsets.size(); ++i) {
                offset = (Integer)tagOffsets.get(i);
                offsetTotal += offset.intValue();
            }
            byte[] hdrBytes = (i = (offset = (Integer)tagOffsets.get(tagIndex++)).intValue()) == 0 ? this.writeCountBytes(inBytes[inIndex + 1], inBytes[inIndex + 2], offsetTotal) : (i == 1 ? this.writeCountBytes((byte)0, inBytes[inIndex + 1], offsetTotal) : this.writeCountBytes((byte)0, inBytes[inIndex], offsetTotal));
            inIndex = inIndex + 3 - i;
            for (i = 0; i < hdrBytes.length; ++i) {
                outBytes[outIndex++] = hdrBytes[i];
            }
            if (tagIndex < tags.size()) {
                offset = (Integer)tags.get(tagIndex);
                len = offset;
            } else {
                len = inBytes.length;
            }
            for (i = inIndex; i < len; ++i) {
                outBytes[outIndex++] = inBytes[i];
            }
            inIndex = len;
        }
        return outBytes;
    }

    private byte[] writeCountBytes(byte high, byte low, int offset) throws CIMException {
        byte[] bytes = null;
        try {
            if (high < 0) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            int byteCount = high << 8;
            byteCount = low < 0 ? byteCount + (low & 0x7F) + 127 + 1 : (byteCount += low);
            low = (byte)((byteCount += offset) & 0xFF);
            high = (byte)(byteCount >> 8);
            bytes = new byte[]{-126, high, low};
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{this.byteToHex(high), this.byteToHex(low)};
            String logMsg = this.logError("SNMPA_100", "SNMPA_205", subArgs);
            throw e;
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"writeCount"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return bytes;
    }

    private SnmpPduRequest snmpGetPdu(SnmpPduRequest pdu) {
        SnmpPduRequest pduRsp = null;
        if (pdu == null || pdu.varBindList == null) {
            return pduRsp;
        }
        SnmpVarBind[] varbindList = new SnmpVarBind[pdu.varBindList.length];
        pduRsp = new SnmpPduRequest();
        pduRsp.requestId = pdu.requestId;
        pduRsp.community = pdu.community;
        pduRsp.version = pdu.version;
        pduRsp.type = 162;
        try {
            for (int i = 0; i < pdu.varBindList.length; ++i) {
                SnmpVarBind varbindRsp;
                SnmpVarBind varbind = pdu.varBindList[i];
                SnmpOid oid = varbind.oid;
                SnmpMapEntry mapEntry = (SnmpMapEntry)this.mapCache.read(oid.toString());
                varbindList[i] = varbindRsp = this.getVarBindRsp(pduRsp, varbind, i + 1, mapEntry);
                if (pduRsp.errorIndex > 0) break;
            }
            pduRsp.varBindList = varbindList;
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"snmpGetPdu"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
        }
        return pduRsp;
    }

    private CIMValue getCIMValue(SnmpMapEntry mapEntry) throws Exception, CIMException {
        CIMValue cv = null;
        String[] propList = new String[1];
        try {
            CIMProperty cp;
            CIMObjectPath op = new CIMObjectPath(mapEntry.className, ROOT_NAMESPACE);
            propList[0] = mapEntry.propertyName;
            ServerSecurity ss = new ServerSecurity(HARDCODED_USERNAME, "", "snmpadapter", new byte[4]);
            Enumeration enum1 = this.cimomhandle.enumerateInstances("1", new CIMNameSpace("", ""), op, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, propList, ss).elements();
            if (enum1 != null && enum1.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enum1.nextElement();
                if (ci == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                cp = ci.getProperty(mapEntry.propertyName);
                if (cp == null) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_FOUND");
            }
            cv = cp.getValue();
        }
        catch (CIMException e) {
            Debug.trace2((String)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"getCIMValue"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return cv;
    }

    private SnmpVarBind createVarbindErrRsp(SnmpPduRequest pduRsp, SnmpVarBind varbind, SnmpStatusException status) {
        SnmpVarBind svar;
        SnmpOid oid = varbind.oid;
        if (pduRsp.version == 0) {
            svar = new SnmpVarBind((SnmpOid)oid.clone(), (SnmpValue)new SnmpNull());
            pduRsp.errorIndex = status.getErrorIndex();
            int errorStatus = status.getStatus();
            errorStatus = errorStatus == 129 ? 2 : 5;
            pduRsp.errorStatus = errorStatus;
        } else {
            svar = new SnmpVarBind((SnmpOid)oid.clone(), (SnmpValue)new SnmpNull(status.getStatus()));
        }
        return svar;
    }

    private String extractCIMValueDateTime(CIMValue cv) throws CIMException {
        String s = null;
        try {
            CIMDateTime cdt = (CIMDateTime)cv.getValue();
            Calendar cProp = cdt.getCalendar();
            int n = cProp.get(1);
            s = "" + (char)(n >> 8);
            s = s + (char)(n & 0xFF);
            s = s + (char)(cProp.get(2) + 1);
            s = s + (char)cProp.get(5);
            s = s + (char)cProp.get(10);
            s = s + (char)cProp.get(12);
            s = s + (char)cProp.get(13);
            s = s + (char)(cProp.get(14) / 100);
            n = cProp.get(15);
            if (n > 0) {
                s = s + '+';
            } else {
                n *= -1;
                s = s + '-';
            }
            int h = n / 3600000;
            s = s + (char)h;
            int m = (n - h * 3600000) / 60000;
            s = s + (char)m;
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"extractCIMValueDateTime"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return s;
    }

    private long extractCIMValueLong(CIMValue cv, boolean unSigned) throws CIMException {
        long num;
        block6: {
            num = 0L;
            try {
                Object obj = cv.getValue();
                if (obj instanceof Number) {
                    num = ((Number)obj).longValue();
                    if (num < 0L & unSigned) {
                        num *= -1L;
                    }
                    break block6;
                }
                if (obj instanceof String) {
                    Long L = new Long((String)obj);
                    num = L;
                    break block6;
                }
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        return num;
    }

    private SnmpVarBind copyCIMValueToVarbind(SnmpMapEntry mapEntry, CIMValue cv) throws CIMException {
        SnmpVarBind svar;
        block19: {
            SnmpOid oid = new SnmpOid(mapEntry.oid);
            if (cv == null || cv.getValue() == null) {
                SnmpVarBind svar2 = new SnmpVarBind(oid, (SnmpValue)new SnmpNull());
                return svar2;
            }
            svar = new SnmpVarBind(oid);
            try {
                String asn1Type = mapEntry.asn1Type;
                CIMDataType cimDatatype = cv.getType();
                int cimType = cimDatatype.getType();
                if (asn1Type.equals("SnmpString")) {
                    Object o = cv.getValue();
                    if (o instanceof String) {
                        svar.setSnmpStringValue((String)cv.getValue());
                        break block19;
                    }
                    if (o instanceof CIMDateTime) {
                        svar.setSnmpStringValue(this.extractCIMValueDateTime(cv));
                        break block19;
                    }
                    if (o instanceof Number) {
                        svar.setSnmpStringValue(o.toString());
                        break block19;
                    }
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                if (asn1Type.equals("SnmpTimeticks")) {
                    CIMDateTime cdt = (CIMDateTime)cv.getValue();
                    Calendar cProp = cdt.getCalendar();
                    Date dProp = cProp.getTime();
                    Calendar cNow = Calendar.getInstance();
                    Date dNow = cNow.getTime();
                    long l = (dNow.getTime() - dProp.getTime()) / 10L;
                    svar.setSnmpTimeticksValue(l);
                    break block19;
                }
                if (asn1Type.equals("SnmpCounter")) {
                    long l = this.extractCIMValueLong(cv, true);
                    svar.setSnmpCounterValue(l);
                    break block19;
                }
                if (asn1Type.equals("SnmpInt")) {
                    long l = this.extractCIMValueLong(cv, false);
                    svar.setSnmpIntValue(l);
                    break block19;
                }
                if (asn1Type.equals("SnmpGauge")) {
                    long l = this.extractCIMValueLong(cv, true);
                    svar.setSnmpGaugeValue(l);
                    break block19;
                }
                if (asn1Type.equals("SnmpOid")) {
                    svar.setSnmpOidValue((String)cv.getValue());
                    break block19;
                }
                if (asn1Type.equals("SnmpIpAddress")) {
                    svar.setSnmpIpAddressValue((String)cv.getValue());
                    break block19;
                }
                if (asn1Type.equals("SnmpOpaque")) {
                    Object o = cv.getValue();
                    if (!(o instanceof Vector)) {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                    }
                    Vector byteVec = (Vector)cv.getValue();
                    byte[] value = new byte[byteVec.size()];
                    o = byteVec.elementAt(0);
                    if (!(o instanceof Byte)) {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                    }
                    for (int i = 0; i < byteVec.size(); ++i) {
                        Byte B = (Byte)byteVec.elementAt(i);
                        value[i] = B;
                    }
                    svar.setSnmpOpaqueValue(value);
                    break block19;
                }
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                String[] subArgs = new String[]{e.getMessage()};
                String logMsg = this.logError("SNMPA_101", "SNMPA_209", subArgs);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (Exception e) {
                String[] subArgs = new String[]{"copyCIMValueToVarbind"};
                String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        return svar;
    }

    private SnmpVarBind getVarBindRsp(SnmpPduRequest pduRsp, SnmpVarBind varbindReq, int index, SnmpMapEntry mapEntry) {
        SnmpStatusException status = null;
        SnmpVarBind varbind = null;
        try {
            if (mapEntry == null) {
                status = new SnmpStatusException(129, index);
            } else {
                CIMValue cv = this.getCIMValue(mapEntry);
                varbind = this.copyCIMValueToVarbind(mapEntry, cv);
            }
        }
        catch (CIMException e) {
            status = new SnmpStatusException(129, index);
        }
        catch (Exception e) {
            status = new SnmpStatusException(130, index);
        }
        if (status != null) {
            varbind = this.createVarbindErrRsp(pduRsp, varbindReq, status);
        }
        return varbind;
    }

    private SnmpPduRequest snmpErrorResponse(SnmpPduRequest pdu, int errCode) throws CIMException {
        SnmpPduRequest pduRsp = null;
        SnmpStatusException status = null;
        if (pdu == null) {
            return pduRsp;
        }
        int length = pdu.version == 0 ? 1 : pdu.varBindList.length;
        SnmpVarBind[] varbindList = new SnmpVarBind[length];
        pduRsp = new SnmpPduRequest();
        pduRsp.requestId = pdu.requestId;
        pduRsp.community = pdu.community;
        pduRsp.version = pdu.version;
        pduRsp.type = 162;
        try {
            for (int i = 0; i < length; ++i) {
                SnmpVarBind varbindRsp;
                SnmpVarBind varbind = pdu.varBindList[i];
                status = new SnmpStatusException(errCode, i + 1);
                varbindList[i] = varbindRsp = this.createVarbindErrRsp(pduRsp, varbind, status);
            }
            pduRsp.varBindList = varbindList;
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"snmpErrorResponse"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return pduRsp;
    }

    private byte[] snmpLastDitchError(byte[] inBytes) {
        int i;
        byte[] outBytes = new byte[100];
        int cntIndex = 0;
        int countLim = 4;
        int[] counts = new int[countLim];
        int fields = 10;
        int inIndex = 0;
        int outIndex = 0;
        try {
            for (i = 0; i < fields; ++i) {
                byte tag = inBytes[inIndex++];
                outBytes[outIndex++] = tag;
                if (tag == 48 || (tag & 0xFFFFFFA0) == -96) {
                    if (tag != 48) {
                        outBytes[outIndex - 1] = -94;
                    }
                    counts[cntIndex++] = outIndex;
                    outBytes[outIndex++] = 0;
                    if (inBytes[inIndex] < 0) {
                        byte b = (byte)(inBytes[inIndex] & 0x7F);
                        inIndex += b;
                    }
                    ++inIndex;
                    continue;
                }
                int n = outIndex++;
                int n2 = inBytes[inIndex++];
                outBytes[n] = n2;
                int len = n2;
                for (int j = 0; j < len; ++j) {
                    outBytes[outIndex++] = inBytes[inIndex++];
                }
            }
            outBytes[outIndex++] = 5;
            outBytes[outIndex++] = 0;
            for (i = 0; i < countLim; ++i) {
                outBytes[counts[i]] = (byte)(outIndex - counts[i] - 1);
            }
            outBytes[counts[2] + -5] = 5;
            outBytes[counts[2] + -2] = 1;
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"snmpLastDitchError"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
        }
        byte[] returnBytes = new byte[outIndex];
        for (i = 0; i < outIndex; ++i) {
            returnBytes[i] = outBytes[i];
        }
        return returnBytes;
    }

    private SnmpPduRequest decodePduRequest(byte[] inputBytes) throws Exception, CIMException {
        SnmpMessage msg = new SnmpMessage();
        SnmpPduRequest pdu = null;
        try {
            msg.decodeMessage(inputBytes, inputBytes.length);
        }
        catch (SnmpStatusException e) {
            String[] subArgs = new String[]{e.getMessage()};
            String logMsg = this.logError("SNMPA_100", "SNMPA_206", subArgs);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"decodePduRequest"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        try {
            pdu = (SnmpPduRequest)msg.decodePdu();
        }
        catch (SnmpStatusException e) {
            String[] subArgs = new String[]{e.getMessage()};
            String logMsg = this.logError("SNMPA_100", "SNMPA_207", subArgs);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"decodePduRequest"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return pdu;
    }

    private byte[] encodePduResponse(SnmpPduRequest pdu) throws Exception, CIMException {
        byte[] outputBytes = new byte[1500];
        byte[] returnBytes = null;
        SnmpMessage msg = new SnmpMessage();
        if (pdu == null) {
            return null;
        }
        try {
            msg.encodePdu((SnmpPduPacket)pdu, 1500);
            int len = msg.encodeMessage(outputBytes);
            returnBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                returnBytes[i] = outputBytes[i];
            }
        }
        catch (SnmpStatusException e) {
            String[] subArgs = new String[]{e.getMessage()};
            String logMsg = this.logError("SNMPA_100", "SNMPA_208", subArgs);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (SnmpTooBigException e) {
            String[] subArgs = new String[]{e.getMessage()};
            String logMsg = this.logError("SNMPA_100", "SNMPA_208", subArgs);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"encodePduResponse"};
            String logMsg = this.logException("SNMPA_100", "SNMPA_200", subArgs, e);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return returnBytes;
    }

    private String byteToHex(byte b) {
        int[] num = new int[2];
        String s = new String("0x");
        int ch = b < 0 ? (b & 0x7F) + 127 + 1 : b;
        num[1] = ch % 16;
        num[0] = ch >> 4;
        for (int i = 0; i < num.length; ++i) {
            char c = Character.forDigit(num[i], 16);
            s = s + c;
        }
        return s;
    }

    protected String logError(String summaryMsg, String detailMsg, String[] subArgs) {
        String msg = "";
        String summaryLogMsg = "";
        return summaryLogMsg + "\n" + msg;
    }

    protected String logException(String summaryMsg, String detailMsg, String[] args, Exception x) {
        String msg = "";
        String summaryLogMsg = "";
        return summaryLogMsg + "\n" + msg;
    }

    private void tracePdu(SnmpPduRequest pdu) {
        if (!this.debugOn) {
            return;
        }
        try {
            SnmpVarBind varbind;
            int i;
            String s;
            if (pdu == null) {
                Debug.trace3((String)"tracePdu, pdu is null");
                return;
            }
            if (pdu.community != null) {
                s = "community = ";
                for (i = 0; i < pdu.community.length; ++i) {
                    s = s + (char)pdu.community[i];
                }
            } else {
                s = "no community string found";
            }
            Debug.trace3((String)s);
            Debug.trace3((String)("requestId = " + pdu.requestId));
            s = "type = " + pdu.type + ", ";
            s = pdu.type == 160 ? s + "GetRequest" : (pdu.type == 162 ? s + "GetResponse" : (pdu.type == 165 ? s + "GetBulkRequest" : (pdu.type == 161 ? s + "GetNextRequest" : (pdu.type == 163 ? s + "SetRequest" : (pdu.type == 253 ? s + "WalkRequest" : s + "Undefined Request")))));
            Debug.trace3((String)s);
            s = "version = " + pdu.version + ", ";
            s = pdu.version == 0 ? s + "SNMP V1" : s + "SNMP V2";
            Debug.trace3((String)s);
            Debug.trace3((String)("varBindList length = " + pdu.varBindList.length));
            Debug.trace3((String)"varBindList = ");
            for (i = 0; i < pdu.varBindList.length && (varbind = pdu.varBindList[i]) != null; ++i) {
                Debug.trace3((String)varbind.toString());
            }
            Debug.trace3((String)"");
            Debug.trace3((String)"***tracePdu complete***");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void traceHexBytes(String title, byte[] bytes) {
        if (!this.debugOn) {
            return;
        }
        String s = "";
        Debug.trace3((String)(title + ", len = " + bytes.length));
        for (int i = 0; i < bytes.length; ++i) {
            s = s + this.byteToHex(bytes[i]) + " ";
        }
        Debug.trace3((String)s);
    }

    private void traceTags(ArrayList tags, ArrayList tagOffsets) {
        if (!this.debugOn) {
            return;
        }
        for (int i = 0; i < tags.size(); ++i) {
            Integer n = (Integer)tags.get(i);
            Debug.trace3((String)("tag index = " + n));
            n = (Integer)tagOffsets.get(i);
            Debug.trace3((String)("tag offset adjustment = " + n));
        }
    }

    private void traceHeaderFormats(String title, byte[] inBytes, byte[] outBytes) {
        if (!this.debugOn) {
            return;
        }
        int inIndex = 0;
        int outIndex = 0;
        Debug.trace3((String)"traceHeaderFormats");
        Debug.trace3((String)title);
        while (inIndex < inBytes.length) {
            byte tag = inBytes[inIndex];
            if (tag == 48 || (tag & 0xFFFFFFA0) == -96) {
                int j;
                int b;
                String inTag = this.byteToHex(inBytes[inIndex]);
                inTag = inTag + " " + this.byteToHex(inBytes[++inIndex]);
                if (inBytes[inIndex] < 0) {
                    b = inBytes[inIndex] & 0x7F;
                    for (j = 0; j < b; ++j) {
                        inTag = inTag + " " + this.byteToHex(inBytes[inIndex + j + 1]);
                    }
                    inIndex += b;
                }
                ++inIndex;
                Debug.trace3((String)"***************");
                Debug.trace3((String)("inBytes header: " + inTag));
                String outTag = this.byteToHex(outBytes[outIndex]);
                outTag = outTag + " " + this.byteToHex(outBytes[++outIndex]);
                if (outBytes[outIndex] < 0) {
                    b = (byte)(outBytes[outIndex] & 0x7F);
                    for (j = 0; j < b; ++j) {
                        outTag = outTag + " " + this.byteToHex(outBytes[outIndex + j + 1]);
                    }
                    outIndex += b;
                }
                ++outIndex;
                Debug.trace3((String)("outBytes header: " + outTag));
                continue;
            }
            if ((tag & 0xFFFFFFA0) == -96) {
                inIndex += 2;
                outIndex += 2;
                continue;
            }
            int n = ++inIndex;
            ++inIndex;
            byte len = inBytes[n];
            inIndex += len;
            int n2 = ++outIndex;
            ++outIndex;
            len = outBytes[n2];
            outIndex += len;
        }
    }
}

