/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class NisTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 21;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int TABLE_TYPE = 8;
    static int NUMBER_OF_COLUMNS = 9;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"ethers", "%DIR%/ethers", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "ethers", "3", "addr", Integer.toString(3), "name", Integer.toString(9), "comment", Integer.toString(8)}, {"bootparams", "%DIR%/bootparams", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(36), "bootparams", "3", "clientname", Integer.toString(9), "identifiers", Integer.toString(72), "comment", Integer.toString(8)}, {"timezone", "%DIR%/timezone", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "timezone", "3", "timezone", Integer.toString(8), "domain", Integer.toString(9), "comment", Integer.toString(8)}, {"netmasks", "%DIR%/netmasks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "netmasks", "3", "addr", Integer.toString(3), "mask", Integer.toString(3), "comment", Integer.toString(8)}, {"group", "%DIR%/group", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "group", "4", "name", Integer.toString(9), "passwd", Integer.toString(8), "gid", Integer.toString(5), "members", Integer.toString(8)}, {"hosts", "%DIR%/hosts", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "hosts", "4", "addr", Integer.toString(3), "cname", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"networks", "%DIR%/networks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "networks", "4", "cname", Integer.toString(9), "addr", Integer.toString(3), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"passwd", "%PWDIR%/passwd", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "passwd", "7", "name", Integer.toString(9), "passwd", Integer.toString(8), "uid", Integer.toString(5), "gid", Integer.toString(4), "gcos", Integer.toString(8), "home", Integer.toString(8), "shell", Integer.toString(8)}, {"shadow", "%PWDIR%/shadow", ":", "#", "0", "3", Integer.toString(1), Integer.toString(10), "passwd", "9", "name", Integer.toString(9), "passwd", Integer.toString(8), "lastchg", Integer.toString(8), "min", Integer.toString(8), "max", Integer.toString(8), "warn", Integer.toString(8), "inactive", Integer.toString(8), "expire", Integer.toString(8), "flag", Integer.toString(8)}, {"protocols", "%DIR%/protocols", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "protocols", "4", "cname", Integer.toString(9), "number", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"services", "%DIR%/services", " \t/", "#", "0", "3", Integer.toString(273), Integer.toString(4), "services", "5", "cname", Integer.toString(9), "port", Integer.toString(5), "proto", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"rpc", "%DIR%/rpc", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "rpc", "4", "cname", Integer.toString(9), "number", Integer.toString(5), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"aliases", "%ALIASES%", ":", "#", "0", "3", Integer.toString(287), Integer.toString(70), "aliases", "3", "alias", Integer.toString(9), "expansion", Integer.toString(72), "comment", Integer.toString(8)}, {"auto_master", "%DIR%/auto_master", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(8), "auto.master", "2", "key", Integer.toString(9), "value", Integer.toString(73)}, {"auto_home", "%DIR%/auto_home", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(8), "auto.home", "2", "key", Integer.toString(9), "value", Integer.toString(72)}, {"user_attr", "%DIR%/user_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(26), "user.attr", "5", "name", Integer.toString(9), "qualifier", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "attr", Integer.toString(8)}, {"auth_attr", "%RBACDIR%/auth_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(26), "auth.attr", "6", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "short_descr", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}, {"prof_attr", "%RBACDIR%/prof_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "prof.attr", "5", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}, {"exec_attr", "%RBACDIR%/exec_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "exec.attr", "7", "name", Integer.toString(9), "policy", Integer.toString(9), "type", Integer.toString(8), "res1", Integer.toString(8), "res2", Integer.toString(8), "id", Integer.toString(9), "attr", Integer.toString(8)}, {"audit_user", "%RBACDIR%/audit_user", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "audit.user", "3", "name", Integer.toString(9), "alwaysauditflags", Integer.toString(8), "neverauditflags", Integer.toString(8)}, {"project", "%DIR%/project", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "project", "6", "name", Integer.toString(9), "id", Integer.toString(8), "comment", Integer.toString(8), "user", Integer.toString(8), "group", Integer.toString(8), "keyvalue", Integer.toString(8)}};
    String path_pwdir;
    String path_aliases;
    String path_dir;
    String path_rbacdir;
    int tableIndex;
    String tableName;
    String tableType;
    String mappedTableName;
    String columnSeparators;
    String commentSeparators;
    int userId;
    int groupId;
    int access;
    int numberOfColumns;
    int tableAttributes;
    int[] columnAttributes;
    String[] columnNames;
    String[] mappedColumnNames;
    String[] secondaryMappedColumnNames;
    String serverName;
    String domainName;

    public NisTableDefinitions(String server, String domain) {
        this.serverName = server;
        this.domainName = domain;
        this.tableIndex = USER_DEFINED;
        this.tableName = "";
        this.tableType = "";
        this.mappedTableName = "";
        this.columnSeparators = " \t";
        this.commentSeparators = "#";
        this.tableAttributes = 0;
        this.columnNames = null;
        this.mappedColumnNames = null;
        this.secondaryMappedColumnNames = null;
        this.columnAttributes = null;
        try {
            this.path_pwdir = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.pwdir");
            if (this.path_pwdir == null || this.path_pwdir.equals("")) {
                this.path_pwdir = "/etc";
            }
        }
        catch (UException a) {
            this.path_pwdir = "/etc";
        }
        try {
            this.path_dir = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.dir");
            if (this.path_dir == null || this.path_dir.equals("")) {
                this.path_dir = "/etc";
            }
        }
        catch (UException a) {
            this.path_dir = "/etc";
        }
        try {
            this.path_rbacdir = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.rbacdir");
            if (this.path_rbacdir == null || this.path_rbacdir.equals("")) {
                this.path_rbacdir = "/etc/security";
            }
        }
        catch (UException a) {
            this.path_rbacdir = "/etc/security";
        }
        try {
            this.path_aliases = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.aliases");
            if (this.path_aliases == null || this.path_aliases.equals("")) {
                this.path_aliases = "/etc/mail/aliases";
            }
        }
        catch (UException a) {
            this.path_aliases = "/etc/mail/aliases";
        }
        this.userId = 0;
        this.groupId = 3;
        this.access = 273;
    }

    public void loadTableDefinitions(String tableName) throws DirectoryTableInvalidParameterException {
        int i;
        this.tableName = tableName;
        for (i = 0; i < NUMBER_OF_TABLES; ++i) {
            if (!tableName.equalsIgnoreCase(definitions[i][TABLE_NAME])) continue;
            this.tableIndex = i;
            this.tableName = definitions[i][TABLE_NAME];
            this.mappedTableName = definitions[i][MAPPED_TABLE_NAME];
            this.columnSeparators = definitions[i][COLUMN_SEPARATORS];
            this.commentSeparators = definitions[i][COMMENT_SEPARATORS];
            this.userId = Integer.valueOf(definitions[i][USERID]);
            this.groupId = Integer.valueOf(definitions[i][GROUPID]);
            this.access = Integer.valueOf(definitions[i][ACCESS]);
            this.tableAttributes = Integer.valueOf(definitions[i][TABLE_ATTRIBUTES]);
            this.tableType = definitions[i][TABLE_TYPE];
            this.numberOfColumns = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS]);
            this.columnNames = new String[this.numberOfColumns];
            this.mappedColumnNames = new String[this.numberOfColumns];
            this.secondaryMappedColumnNames = new String[this.numberOfColumns];
            this.columnAttributes = new int[this.numberOfColumns];
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.columnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 2 + 1];
                this.mappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 2 + 1];
                this.secondaryMappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 2 + 1];
                this.columnAttributes[j] = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS + j * 2 + 2]);
            }
            break;
        }
        if (i == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", tableName);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[col - 1];
    }

    public String getMappedColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[col - 1];
    }

    public String getAuxilliaryColumnData(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[col - 1];
    }

    public int getColumnNumber(String name) throws DirectoryTableInvalidParameterException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (!this.columnNames[i].equalsIgnoreCase(name)) continue;
            return i + 1;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int col) throws DirectoryTableInvalidParameterException {
        if (col <= this.numberOfColumns && col > 0) {
            return this.columnAttributes[col - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int size) throws DirectoryTableInvalidParameterException {
        if (size < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = size;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[col - 1] = name;
    }

    public void setMappedColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[col - 1] = name;
    }

    public void setAuxilliaryColumnData(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[col - 1] = name;
    }

    public void setColumnAttributes(int col, int attributes) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[col - 1] = attributes;
    }

    public void setTableAttributes(int attributes) {
        this.tableAttributes = attributes;
    }

    public void setMappedTableName(String mappedName) {
        this.mappedTableName = mappedName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setTableType(String tblType) {
        this.tableType = tblType;
    }

    public void setCommentSeparators(String separators) {
        this.commentSeparators = separators;
    }

    public void setColumnSeparators(String separators) {
        this.columnSeparators = separators;
    }

    public void setUser(int user) {
        this.userId = user;
    }

    public void setGroup(int group) {
        this.groupId = group;
    }

    public void setAccess(int acc) {
        this.access = acc;
    }

    private String expandMacros(String unexpanded) {
        String expanded = "";
        String tok = null;
        StringTokenizer unexpandedTokens = null;
        unexpandedTokens = new StringTokenizer(unexpanded, "%");
        while (unexpandedTokens.hasMoreTokens()) {
            tok = unexpandedTokens.nextToken();
            if (tok.compareTo("DIR") == 0) {
                expanded = expanded + this.path_dir;
                continue;
            }
            if (tok.compareTo("RBACDIR") == 0) {
                expanded = expanded + this.path_rbacdir;
                continue;
            }
            if (tok.compareTo("PWDIR") == 0) {
                expanded = expanded + this.path_pwdir;
                continue;
            }
            if (tok.compareTo("ALIASES") == 0) {
                expanded = expanded + this.path_aliases;
                continue;
            }
            expanded = expanded + tok;
        }
        return expanded;
    }
}

