/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class LdapTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 17;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int TABLE_TYPE = 8;
    static int NUMBER_OF_COLUMNS = 9;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"ethers", "ou = Hosts, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ieee802Device", "3", "name", "cn", "", Integer.toString(41), "addr", "macAddress", "", Integer.toString(3), "comment", "", "", Integer.toString(8)}, {"netmasks", "ou = Hosts, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipNetwork", "3", "addr", "ipNetworkNumber", "", Integer.toString(35), "mask", "ipNetmaskNumber", "", Integer.toString(3), "comment", "description", "", Integer.toString(8)}, {"group", "ou = Group, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "posixGroup", "4", "name", "cn", "", Integer.toString(41), "passwd", "userPassword", "", Integer.toString(8), "gid", "gidNumber", "", Integer.toString(5), "members", "memberUid", "", Integer.toString(8)}, {"hosts", "ou = Hosts, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipHost", "3", "cname", "cn", "", Integer.toString(41), "addr", "ipHostNumber", "", Integer.toString(3), "comment", "description", "", Integer.toString(8)}, {"networks", "ou = Networks, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipNetwork", "4", "cname", "cn", "", Integer.toString(41), "aliases", "cn", "", Integer.toString(9), "addr", "ipNetworkNumber", "", Integer.toString(3), "comment", "description", "", Integer.toString(8)}, {"passwd", "ou = people, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "posixAccount", "8", "name", "uid", "", Integer.toString(41), "cn", "cn", "name", Integer.toString(9), "passwd", "userPassword", "", Integer.toString(8), "uid", "uidNumber", "", Integer.toString(5), "gid", "gidNumber", "", Integer.toString(4), "gcos", "gecos", "", Integer.toString(8), "home", "homeDirectory", "", Integer.toString(8), "shell", "loginShell", "", Integer.toString(8), "description", "description", "", Integer.toString(8)}, {"shadow", "ou = People, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "shadowAccount", "10", "name", "uid", "", Integer.toString(41), "passwd", "userPassword", "", Integer.toString(8), "lastchg", "shadowLastChange", "", Integer.toString(8), "min", "shadowMin", "", Integer.toString(8), "max", "shadowMax", "", Integer.toString(8), "warn", "shadowWarning", "", Integer.toString(8), "inactive", "shadowInactive", "", Integer.toString(8), "expire", "shadowExpire", "", Integer.toString(8), "flag", "shadowFlag", "", Integer.toString(8), "description", "description", "", Integer.toString(8)}, {"protocols", "ou = protocols, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipProtocol", "4", "cname", "cn", "", Integer.toString(41), "aliases", "cn", "", Integer.toString(9), "number", "ipProtocolNumber", "", Integer.toString(9), "comment", "description", "", Integer.toString(8)}, {"rpc", "ou = rpc, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "oncRpc", "4", "cname", "cn", "", Integer.toString(41), "aliases", "cn", "", Integer.toString(9), "number", "oncRpcNumber", "", Integer.toString(5), "comment", "description", "", Integer.toString(8)}, {"aliases", "ou = aliases, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(6), "mailGroup", "2", "alias", "cn", "", Integer.toString(41), "expansion", "mail", "", Integer.toString(8)}, {"auto_home", "nismapname = auto_home, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(6), "nisObject", "3", "key", "cn", "", Integer.toString(41), "value", "nismapentry", "", Integer.toString(8), "nismapname", "nismapname", "auto_home", Integer.toString(8)}, {"user_attr", "ou = People, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisUserAttr", "5", "name", "uid", "", Integer.toString(41), "qualifier", "SolarisUserQualifier", "", Integer.toString(9), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"auth_attr", "ou = SolarisAuthAttr, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisAuthAttr", "6", "name", "cn", "", Integer.toString(41), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "short_descr", "SolarisAttrShortDesc", "", Integer.toString(8), "long_descr", "SolarisAttrLongDesc", "", Integer.toString(8), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"prof_attr", "ou = SolarisProfAttr, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisProfAttr", "5", "name", "cn", "", Integer.toString(41), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "long_descr", "SolarisAttrLongDesc", "", Integer.toString(8), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"exec_attr", "ou = SolarisProfAttr, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisExecAttr", "7", "name", "cn", "", Integer.toString(41), "policy", "SolarisKernelSecurityPolicy", "", Integer.toString(41), "type", "SolarisProfileType", "", Integer.toString(41), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "id", "SolarisProfileId", "", Integer.toString(41), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"project", "ou = projects, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "SolarisProject", "6", "name", "SolarisProjectName", "", Integer.toString(41), "id", "SolarisProjectID", "", Integer.toString(8), "user", "memberUid", "", Integer.toString(8), "group", "memberGid", "", Integer.toString(8), "keyvalue", "SolarisProjectAttr", "", Integer.toString(8), "comment", "description", "", Integer.toString(8)}, {"audit_user", "ou = People, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisAuditUser", "3", "name", "uid", "", Integer.toString(41), "alwaysauditflags", "SolarisAuditAlways", "", Integer.toString(8), "neverauditflags", "SolarisAuditNever", "", Integer.toString(8)}};
    int tableIndex;
    String tableName;
    String tableType;
    String mappedTableName;
    String columnSeparators;
    String commentSeparators;
    int numberOfColumns;
    int tableAttributes;
    int[] columnAttributes;
    String[] columnNames;
    String[] mappedColumnNames;
    String[] secondaryMappedColumnNames;
    String serverName;
    String domainName;
    int userId;
    int groupId;
    int access;
    int ldap_scoping_form;

    public LdapTableDefinitions(String server, String domain) {
        this.serverName = server;
        this.domainName = domain;
        this.tableIndex = USER_DEFINED;
        this.tableName = "";
        this.tableType = "";
        this.mappedTableName = "";
        this.columnSeparators = " \t";
        this.commentSeparators = "#";
        this.tableAttributes = 0;
        this.columnNames = null;
        this.mappedColumnNames = null;
        this.secondaryMappedColumnNames = null;
        this.columnAttributes = null;
        this.userId = 0;
        this.groupId = 3;
        this.access = 4351;
    }

    public void loadTableDefinitions(String tableName) throws DirectoryTableInvalidParameterException {
        int i;
        this.tableName = tableName;
        for (i = 0; i < NUMBER_OF_TABLES; ++i) {
            if (!tableName.equalsIgnoreCase(definitions[i][TABLE_NAME])) continue;
            this.tableIndex = i;
            this.tableName = definitions[i][TABLE_NAME];
            this.mappedTableName = definitions[i][MAPPED_TABLE_NAME];
            this.columnSeparators = definitions[i][COLUMN_SEPARATORS];
            this.commentSeparators = definitions[i][COMMENT_SEPARATORS];
            this.userId = Integer.valueOf(definitions[i][USERID]);
            this.groupId = Integer.valueOf(definitions[i][GROUPID]);
            this.access = Integer.valueOf(definitions[i][ACCESS]);
            this.tableAttributes = Integer.valueOf(definitions[i][TABLE_ATTRIBUTES]);
            this.tableType = definitions[i][TABLE_TYPE];
            this.numberOfColumns = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS]);
            this.columnNames = new String[this.numberOfColumns];
            this.mappedColumnNames = new String[this.numberOfColumns];
            this.secondaryMappedColumnNames = new String[this.numberOfColumns];
            this.columnAttributes = new int[this.numberOfColumns];
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.columnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 4 + 1];
                this.mappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 4 + 2];
                this.secondaryMappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 4 + 3];
                this.columnAttributes[j] = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS + j * 4 + 4]);
            }
            break;
        }
        if (i == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", tableName);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[col - 1];
    }

    public String getMappedColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[col - 1];
    }

    public String getAuxilliaryColumnData(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[col - 1];
    }

    public int getColumnNumber(String name) throws DirectoryTableInvalidParameterException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (!this.columnNames[i].equalsIgnoreCase(name)) continue;
            return i + 1;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int col) throws DirectoryTableInvalidParameterException {
        if (col <= this.numberOfColumns && col > 0) {
            return this.columnAttributes[col - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int size) throws DirectoryTableInvalidParameterException {
        if (size < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = size;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[col - 1] = name;
    }

    public void setMappedColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[col - 1] = name;
    }

    public void setAuxilliaryColumnData(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[col - 1] = name;
    }

    public void setColumnAttributes(int col, int attributes) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[col - 1] = attributes;
    }

    public void setTableAttributes(int attributes) {
        this.tableAttributes = attributes;
    }

    public void setMappedTableName(String mappedName) {
        this.mappedTableName = mappedName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setTableType(String tblType) {
        this.tableType = tblType;
    }

    public void setCommentSeparators(String separators) {
        this.commentSeparators = separators;
    }

    public void setColumnSeparators(String separators) {
        this.columnSeparators = separators;
    }

    public void setUser(int user) {
        this.userId = user;
    }

    public void setGroup(int group) {
        this.groupId = group;
    }

    public void setAccess(int acc) {
        this.access = acc;
    }

    private String expandMacros(String unexpanded) {
        String expanded = "";
        String tok = null;
        StringTokenizer unexpandedTokens = null;
        unexpandedTokens = new StringTokenizer(unexpanded, "%");
        while (unexpandedTokens.hasMoreTokens()) {
            tok = unexpandedTokens.nextToken();
            if (tok.compareTo("DN") == 0) {
                expanded = expanded + this.domainName;
                continue;
            }
            expanded = expanded + tok;
        }
        return expanded;
    }
}

