/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectoryTableSetup
implements TableSetup {
    protected static final int NUM_OF_DIRSERVICES = 5;
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private static final String nssFileName = "/etc/nsswitch.conf";
    protected static final String[] dirServiceName = new String[]{"File", "Nis", "Nisplus", "Dns", "Ldap"};

    public Vector getNameServiceSwitchOrder(String tableName) {
        Vector<String> nssOrder = null;
        String[] cmd = new String[]{"sh", "-c", "/bin/grep '^" + tableName + ":' " + nssFileName + " | " + sedCmd + " 's/^" + tableName + "://'"};
        String[] outputArr = CommonTools.CMN_exec(cmd);
        if (outputArr.length < 1) {
            return nssOrder;
        }
        outputArr[0].trim();
        StringTokenizer st = new StringTokenizer(outputArr[0], " \t\n\r");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token.trim();
            if (token.equals("files")) {
                if (nssOrder == null) {
                    nssOrder = new Vector<String>();
                }
                nssOrder.addElement("file");
            }
            if (token.equals("nisplus")) {
                if (nssOrder == null) {
                    nssOrder = new Vector();
                }
                nssOrder.addElement("nisplus");
            }
            if (token.equals("nis")) {
                if (nssOrder == null) {
                    nssOrder = new Vector();
                }
                nssOrder.addElement("nis");
            }
            if (token.equals("dns")) {
                if (nssOrder == null) {
                    nssOrder = new Vector();
                }
                nssOrder.addElement("dns");
            }
            if (token.equals("ldap")) {
                if (nssOrder == null) {
                    nssOrder = new Vector();
                }
                nssOrder.addElement("ldap");
            }
            if (token.indexOf("NOTFOUND = return") == -1) continue;
            return nssOrder;
        }
        return nssOrder;
    }

    public Vector getScopes(String dataStore, int flags) {
        Vector singleScopes = null;
        String convertedDataStore = dataStore.substring(0, 1).toUpperCase() + dataStore.substring(1, dataStore.length()).toLowerCase();
        String className = "com.sun.wbem.utility.directorytable." + convertedDataStore + "DirectoryTable";
        try {
            TableSetup tableSetupInstance = (TableSetup)Class.forName(className).newInstance();
            if (tableSetupInstance != null) {
                singleScopes = tableSetupInstance.getScopes(flags);
            }
            tableSetupInstance = null;
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return singleScopes;
    }

    public Vector getScopes(int flags) {
        Vector allScopes = null;
        Vector<String> nssOrder = null;
        if ((flags & 1) == 1) {
            nssOrder = this.getNameServiceSwitchOrder("group");
            if (nssOrder == null) {
                return allScopes;
            }
        } else {
            nssOrder = new Vector<String>(4);
            nssOrder.addElement("File");
            nssOrder.addElement("Nis");
            nssOrder.addElement("Nisplus");
            nssOrder.addElement("Dns");
            nssOrder.addElement("Ldap");
        }
        for (int i = 0; i < nssOrder.size(); ++i) {
            String dataStore = (String)nssOrder.elementAt(i);
            Vector singleScopes = this.getScopes(dataStore = dataStore.substring(0, 1).toUpperCase() + dataStore.substring(1, dataStore.length()).toLowerCase(), flags);
            if (singleScopes == null) continue;
            if (allScopes == null) {
                allScopes = new Vector();
            }
            for (int j = 0; j < singleScopes.size(); ++j) {
                allScopes.addElement(singleScopes.elementAt(j));
            }
        }
        return allScopes;
    }

    public boolean isValidScope(String scope) {
        int separator = 0;
        separator = scope.indexOf(":/");
        if (separator == -1 || separator < 2) {
            return false;
        }
        String directoryServiceName = scope.substring(0, 1).toUpperCase() + scope.substring(1, separator).toLowerCase();
        if (scope.length() <= separator + 2) {
            return false;
        }
        String remainingContext = scope.substring(separator + 2);
        String serverName = DirectoryUtility.getContextProperty(remainingContext, "serverName");
        String domainName = DirectoryUtility.getContextProperty(remainingContext, "domainName");
        if (!DirectoryUtility.isLocalServer(serverName)) {
            return false;
        }
        Vector scopesForServer = this.getScopes(0);
        if (scopesForServer.size() == 0) {
            return false;
        }
        for (int i = 0; i < scopesForServer.size(); ++i) {
            String validDirectoryServiceName;
            String validScope = (String)scopesForServer.elementAt(i);
            separator = validScope.indexOf(":/");
            if (separator == -1 || separator < 2 || !(validDirectoryServiceName = validScope.substring(0, 1).toUpperCase() + validScope.substring(1, separator).toLowerCase()).equals(directoryServiceName) || validScope.length() <= separator + 2) continue;
            String validContext = validScope.substring(separator + 2);
            if (validDirectoryServiceName.equals("File")) {
                return DirectoryUtility.isLocalServer(domainName);
            }
            String validDomainName = DirectoryUtility.getContextProperty(validContext, "domainName");
            if (!validDomainName.equals(domainName)) continue;
            return true;
        }
        return false;
    }

    public void setup() {
        for (int i = 0; i < 5; ++i) {
            String className = "com.sun.wbem.utility.directorytable." + dirServiceName[i] + "DirectoryTable";
            try {
                TableSetup tableSetupInstance = (TableSetup)Class.forName(className).newInstance();
                if (tableSetupInstance != null) {
                    tableSetupInstance.setup();
                }
                tableSetupInstance = null;
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public void refreshSetup() {
        for (int i = 0; i < 5; ++i) {
            String className = "com.sun.wbem.utility.directorytable." + dirServiceName[i] + "DirectoryTable";
            try {
                TableSetup tableSetupInstance = (TableSetup)Class.forName(className).newInstance();
                if (tableSetupInstance != null) {
                    tableSetupInstance.refreshSetup();
                }
                tableSetupInstance = null;
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        block27: {
            block32: {
                DirectoryTableSetup directoryTableSetup;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    directoryTableSetup = new DirectoryTableSetup();
                                    if (!args[0].equals("initial")) break block26;
                                    directoryTableSetup.setup();
                                    break block27;
                                }
                                if (!args[0].equals("refresh")) break block28;
                                directoryTableSetup.refreshSetup();
                                break block27;
                            }
                            if (!args[0].equals("validate")) break block29;
                            if (directoryTableSetup.isValidScope(args[1])) {
                                System.out.println("Scope is valid");
                            } else {
                                System.out.println("Scope is not valid");
                            }
                            break block27;
                        }
                        if (!args[0].equals("transfer")) break block30;
                        try {
                            DirectoryTable directoryTable1 = DirectoryTableFactory.getDirectoryTableInstance(args[1]);
                            DirectoryTable directoryTable2 = DirectoryTableFactory.getDirectoryTableInstance(args[2]);
                            TableDefinitions tableDefinitions1 = directoryTable1.getTableDefinitionsInstance();
                            tableDefinitions1.loadTableDefinitions(args[3]);
                            TableDefinitions tableDefinitions2 = directoryTable2.getTableDefinitionsInstance();
                            tableDefinitions2.loadTableDefinitions(args[3]);
                            try {
                                directoryTable1.open(tableDefinitions1);
                            }
                            catch (DirectoryTableDoesNotExistException e) {
                                directoryTable1.create(tableDefinitions1);
                            }
                            try {
                                directoryTable2.open(tableDefinitions2);
                            }
                            catch (DirectoryTableDoesNotExistException e) {
                                directoryTable2.create(tableDefinitions2);
                            }
                            DirectoryRow row1 = directoryTable1.getAll();
                            if (row1 != null) {
                                DirectoryRow row2 = directoryTable2.getRowInstance(row1.getNumberOfRows());
                                for (int j = 1; j <= row1.getNumberOfRows(); ++j) {
                                    System.out.print("Row " + j + ": ");
                                    for (int i = 1; i <= row1.getNumberOfColumns(); ++i) {
                                        try {
                                            System.out.print(tableDefinitions1.getColumnName(i) + " = " + row1.getColumn(i, j) + " ");
                                            row2.putColumn(tableDefinitions2.getColumnNumber(tableDefinitions1.getColumnName(i)), j, row1.getColumn(i, j));
                                            continue;
                                        }
                                        catch (DirectoryTableException d) {
                                            // empty catch block
                                        }
                                    }
                                    System.out.println("");
                                }
                                directoryTable2.addRow(row2);
                            }
                            directoryTable1.close();
                            directoryTable2.close();
                        }
                        catch (DirectoryTableException d) {
                            System.out.println(d.getMessage());
                        }
                        break block27;
                    }
                    if (!args[0].equals("dump")) break block31;
                    try {
                        DirectoryTable directoryTable1 = DirectoryTableFactory.getDirectoryTableInstance(args[1]);
                        TableDefinitions tableDefinitions1 = directoryTable1.getTableDefinitionsInstance();
                        tableDefinitions1.loadTableDefinitions(args[2]);
                        try {
                            directoryTable1.open(tableDefinitions1);
                        }
                        catch (DirectoryTableDoesNotExistException e) {
                            System.out.println(e.getMessage());
                            return;
                        }
                        DirectoryRow row1 = directoryTable1.getAll();
                        if (row1 != null) {
                            for (int j = 1; j <= row1.getNumberOfRows(); ++j) {
                                System.out.print("Row " + j + ": ");
                                for (int i = 1; i <= row1.getNumberOfColumns(); ++i) {
                                    try {
                                        System.out.print(tableDefinitions1.getColumnName(i) + " = " + row1.getColumn(i, j) + " ");
                                        continue;
                                    }
                                    catch (DirectoryTableException d) {
                                        // empty catch block
                                    }
                                }
                                System.out.println("");
                            }
                        }
                        directoryTable1.close();
                    }
                    catch (DirectoryTableException d) {
                        System.out.println(d.getMessage());
                    }
                    break block27;
                }
                if (!args[0].equals("scopes")) break block32;
                System.out.println("Getting list of managable scopes...");
                Vector scopes = directoryTableSetup.getScopes(0);
                if (scopes == null) break block27;
                for (int i = 0; i < scopes.size(); ++i) {
                    System.out.println("Scope " + (i + 1) + " " + scopes.elementAt(i));
                }
                break block27;
            }
            if (!args[0].equals("storeCred")) break block27;
            String admindn = "";
            String adminpassword1 = "";
            String adminpassword2 = "";
            boolean same = false;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                System.out.print("Administrator DN:");
                admindn = in.readLine();
                while (!same) {
                    System.out.print("Password:");
                    adminpassword1 = in.readLine();
                    System.out.print("Password (confirm):");
                    adminpassword2 = in.readLine();
                    if (adminpassword1.compareTo(adminpassword2) != 0) continue;
                    same = true;
                }
                DirectoryTableLibrary.storeCred(admindn, adminpassword1);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

