/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import com.sun.wbem.utility.common.PropertyNotFoundException;
import com.sun.wbem.utility.common.UException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class UProps {
    public static final String UTILITY_PROP_PATH = "propdir";
    public static final String UTILITY_PROP_FILE = "WbemUtilityServices.properties";
    public static final String SOLARISPROVIDER_CLASS_MAPPING = "SolarisProviderClassMapping.properties";
    public static final int UTILITY_PROP_MODE_READ = 0;
    public static final int UTILITY_PROP_MODE_WRITE = 1;
    public static final int UTILITY_PROP_MODE_CREATE = 2;
    public static final String UTILITY_PROP_ON_VALUE = "on";
    public static final String UTILITY_PROP_OFF_VALUE = "off";
    public static final String UTILITY_PROP_SERVER_HDR = "off";
    private String propfile;
    private int propmode;
    private Properties props = null;

    public UProps(String propPath, String propFileName, int propMode) throws UException {
        String path = null;
        if (propPath == null || propPath.trim().length() == 0) {
            throw new UException("EXM_NPF");
        }
        try {
            path = System.getProperty(propPath);
        }
        catch (Exception x) {
            path = null;
        }
        if (path == null) {
            throw new UException("EXM_NPF");
        }
        if (propFileName == null || propFileName.trim().length() == 0) {
            throw new UException("EXM_NPF");
        }
        this.propmode = propMode;
        path = path.concat(File.separator);
        this.propfile = path.concat(propFileName);
    }

    public UProps(String propFilePath, int propMode) throws UException {
        this.propfile = propFilePath;
        this.propmode = propMode;
    }

    public String getProp(String propName) throws UException {
        String val;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            val = this.props.getProperty(propName);
        }
        catch (Exception ex) {
            throw new PropertyNotFoundException(propName);
        }
        if (val == null) {
            val = "";
        }
        return val;
    }

    public Vector getPropList(String propNamePrefix) throws UException {
        Vector<String> vec = new Vector<String>();
        boolean sw = true;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        int i = 1;
        String name = propNamePrefix.concat(".");
        while (sw) {
            name = propNamePrefix + "." + i;
            try {
                String val = this.props.getProperty(name);
                if (val == null) {
                    sw = false;
                } else {
                    vec.addElement(val);
                }
            }
            catch (Exception x) {
                sw = false;
            }
            ++i;
        }
        return vec;
    }

    public Vector getPropNames() throws UException {
        Vector<String> vec = new Vector<String>();
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        Enumeration<?> en = this.props.propertyNames();
        while (en.hasMoreElements()) {
            String name = new String((String)en.nextElement());
            vec.addElement(name);
        }
        return vec;
    }

    public void putProp(String propName, String propValue) throws UException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        String val = propValue == null ? "" : propValue.trim();
        try {
            this.props.put(propName, val);
        }
        catch (Exception ex) {
            UException ue = new UException("EXM_PNS");
            ue.addArg(propName);
            throw ue;
        }
    }

    public void delProp(String propName) throws UException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            String val = (String)this.props.remove(propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveProps(String headInfo) throws UException {
        this.saveProps(this.propfile, headInfo);
    }

    public void saveProps(String propFile, String headInfo) throws UException {
        if (this.props != (Properties)null) {
            if (headInfo == null) {
                this.saveProperties(propFile, "*** DO NOT EDIT THIS FILE ***");
            } else {
                this.saveProperties(propFile, headInfo);
            }
        }
    }

    private void loadProperties() throws UException {
        boolean fnf = false;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        try {
            fin = new FileInputStream(this.propfile);
            bin = new BufferedInputStream(fin);
        }
        catch (FileNotFoundException fex) {
            fnf = true;
        }
        if (fnf && (this.propmode ^ 2) == 0) {
            UException ue = new UException("EXM_BPF");
            ue.addArg(this.propfile);
            throw ue;
        }
        this.props = new Properties();
        if (!fnf) {
            try {
                this.props.load(bin);
            }
            catch (IOException ex) {
                UException ue = new UException("EXM_LPF", ex);
                ue.addArg(this.propfile);
                throw ue;
            }
        }
        try {
            fin.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void saveProperties(String propFile, String header) throws UException {
        BufferedOutputStream bout;
        FileOutputStream fout;
        try {
            fout = new FileOutputStream(propFile);
            bout = new BufferedOutputStream(fout);
        }
        catch (SecurityException fex) {
            UException ue = new UException("EXM_NAP");
            ue.addArg(propFile);
            throw ue;
        }
        catch (IOException fex) {
            UException ue = new UException("EXM_NWP");
            ue.addArg(propFile);
            throw ue;
        }
        try {
            this.props.store(bout, header);
        }
        catch (Exception ex) {
            UException ue = new UException("EXM_NWP", ex);
            ue.addArg(propFile);
            throw ue;
        }
        try {
            bout.flush();
            fout.close();
        }
        catch (Exception ex) {
            UException ue = new UException("EXM_NWP", ex);
            ue.addArg(propFile);
            throw ue;
        }
    }
}

