/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_SyslogRecord
implements InstanceProvider,
Authorizable {
    public static final String LOGSVC_WRITE_RIGHT = "solaris.admin.logsvc.write";
    public static final String LOGSVC_PURGE_RIGHT = "solaris.admin.logsvc.purge";
    public static final String LOGSVC_READ_RIGHT = "solaris.admin.logsvc.read";
    public static final String LOG_CCN = "LogCreationClassName";
    public static final String LOG_NAME = "LogName";
    public static final String RECORD_ID = "RecordID";
    public static final String RECORD_CCN = "CreationClassName";
    public static final String RECORD_TIME = "MessageTimestamp";
    public static final String RECORD_FORMAT = "DataFormat";
    public static final String RECORD_DATA = "RecordData";
    private LogService logsvc = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, "Logging Service");
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        String[] syslogFiles = null;
        try {
            syslogFiles = this.logsvc.listSyslogFiles();
        }
        catch (AdminLogException ex) {
            AdminLogException aex = new AdminLogException("EXLOG_SYLOGEX");
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)aex.getLocalizedMessage());
        }
        Vector<CIMInstance> records = new Vector<CIMInstance>();
        try {
            for (int i = 0; i < syslogFiles.length; ++i) {
                String[] sysrec = this.logsvc.getSyslogRecords(syslogFiles[i]);
                for (int j = 0; sysrec != null && sysrec.length > 0 && j < sysrec.length; ++j) {
                    CIMInstance ci = cc.newInstance();
                    ci.setProperty(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
                    ci.setProperty(LOG_NAME, new CIMValue((Object)syslogFiles[i]));
                    ci.setProperty(RECORD_CCN, new CIMValue((Object)"Solaris_SyslogRecord"));
                    ci.setProperty(RECORD_FORMAT, new CIMValue((Object)"Unknown"));
                    ci.setProperty(RECORD_DATA, new CIMValue((Object)sysrec[j]));
                    ci.setProperty(RECORD_ID, new CIMValue((Object)String.valueOf(j)));
                    ci.setProperty(RECORD_TIME, new CIMValue((Object)new CIMDateTime(new Date())));
                    if (localOnly) {
                        ci = ci.localElements();
                    }
                    records.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                }
            }
            CIMInstance[] ciArray = new CIMInstance[records.size()];
            records.toArray(ciArray);
            return ciArray;
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }
}

