/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.audit.AuditEvent_uauth;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.audit.WbemAuditService;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.directorytable.DirectoryTableSetup;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;

public class ProviderUtility {
    public static final String MGMT_DOMAIN_KEY = "SystemName";
    public static final String MGMT_TYPE_KEY = "SystemCreationClassName";
    public static final String FILE_SCOPE_TYPE = "file";
    public static final String NIS_SCOPE_TYPE = "nis";
    public static final String NISPLUS_SCOPE_TYPE = "nisplus";
    public static final String LDAP_SCOPE_TYPE = "ldap";
    public static final String DNS_SCOPE_TYPE = "dns";
    public static final String DFLT_SCOPE_TYPE = "file";
    public static final String FILES_SCOPE = "files";
    private static final String[] MGMT_CLASS_TABLE = new String[]{"Solaris_SystemAdminDomain", "Solaris_NisAdminDomain", "Solaris_NisplusAdminDomain", "Solaris_LdapAdminDomain", "Solaris_DnsAdminDomain"};
    private static final String[] MGMT_TYPE_TABLE = new String[]{"file", "nis", "nisplus", "ldap", "dns"};
    private ProviderCIMOMHandle cimomhandle = null;
    private String providerName = null;
    private LogUtil logUtil = null;
    private String hostname = null;
    private Vector mgmtScopes = null;
    private DirectoryTableSetup dirtbl = null;
    private String GMT_TIMEZONE = "GMT";

    public ProviderUtility(CIMOMHandle handle, String name) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)handle;
        this.providerName = name;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)this.cimomhandle);
    }

    public ProviderCIMOMHandle getCimomHandle() {
        return this.cimomhandle;
    }

    public UnsignedInt32 convertIntToCIMUnsignedInt(int intValue) {
        try {
            return new UnsignedInt32(Integer.toString(intValue));
        }
        catch (Exception e) {
            return new UnsignedInt32("0");
        }
    }

    public UnsignedInt16 convertShortToCIMUnsignedInt16(short shortValue) {
        try {
            return new UnsignedInt16(Short.toString(shortValue));
        }
        catch (Exception e) {
            return new UnsignedInt16("0");
        }
    }

    public String getClientUserName() {
        String user = this.cimomhandle.getCurrentRole();
        if (user == null || user.trim().length() == 0) {
            user = this.cimomhandle.getCurrentUser();
        }
        return user;
    }

    public boolean isClientRole() {
        boolean bool = false;
        String role = this.cimomhandle.getCurrentRole();
        if (role != null && role.trim().length() > 0) {
            bool = true;
        }
        return bool;
    }

    public String getMgmtScope(CIMObjectPath op) throws CIMException {
        String domain_name = null;
        String class_name = null;
        Vector keys = null;
        if (op != null) {
            keys = op.getKeys();
        }
        if (keys != null) {
            for (int i = 0; i < keys.size(); ++i) {
                CIMValue cv;
                CIMProperty cp = (CIMProperty)keys.elementAt(i);
                if (cp.getName().equalsIgnoreCase(MGMT_DOMAIN_KEY) && (cv = cp.getValue()) != null) {
                    domain_name = (String)cv.getValue();
                }
                if (!cp.getName().equalsIgnoreCase(MGMT_TYPE_KEY) || (cv = cp.getValue()) == null) continue;
                class_name = (String)cv.getValue();
            }
        }
        return this.getMgmtScope(class_name, domain_name);
    }

    public String getMgmtScope(CIMInstance ci) throws CIMException {
        String domain_name = null;
        String class_name = null;
        if (ci != null) {
            CIMValue cv;
            CIMProperty cp = ci.getProperty(MGMT_DOMAIN_KEY);
            if (cp != null && (cv = cp.getValue()) != null) {
                domain_name = (String)cv.getValue();
            }
            if ((cp = ci.getProperty(MGMT_TYPE_KEY)) != null && (cv = cp.getValue()) != null) {
                class_name = (String)cv.getValue();
            }
        }
        return this.getMgmtScope(class_name, domain_name);
    }

    public String getMgmtScope(String className, String domainName) throws CIMException {
        int i;
        String type = null;
        String domain = null;
        String server = null;
        String scope = null;
        String msg = null;
        boolean bDflt = false;
        if (className == null && domainName == null) {
            return this.getDefaultScope();
        }
        type = this.getScopeTypeFromClass(className);
        if (type == null) {
            msg = this.writeLog(2, "LM_2410", "LM_2414", className, null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (type.equals("file")) {
            bDflt = true;
        }
        server = this.getServerHostName();
        if (domainName == null || domainName.trim().length() == 0) {
            if (bDflt) {
                return this.getDefaultScope();
            }
            msg = this.writeLog(2, "LM_2410", "LM_2413", type, null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        domain = domainName;
        if (bDflt && (i = domainName.indexOf(46)) > 0) {
            domain = domainName.substring(0, i);
        }
        scope = type + ":/" + server + "/" + domain;
        if (this.dirtbl == null) {
            this.dirtbl = new DirectoryTableSetup();
        }
        if (!this.dirtbl.isValidScope(scope)) {
            msg = this.writeLog(2, "LM_2410", "LM_2411", scope, server, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        return scope;
    }

    public String getScopeClassType(String scope) {
        int i;
        if (scope == null || scope.trim().length() == 0) {
            String string = "file";
        }
        String type = (i = scope.indexOf(58)) < 1 ? "file" : scope.substring(0, i);
        return this.getScopeClassFromType(type);
    }

    public String getScopeType(String scope) {
        int i;
        if (scope != null && scope.trim().length() > 0 && (i = scope.indexOf(58)) > 0) {
            return scope.substring(0, i);
        }
        return "";
    }

    public String getScopeDomainName(String scope) {
        int i;
        if (scope != null && scope.trim().length() > 0 && (i = scope.lastIndexOf(47)) > 0 && i < scope.length()) {
            return scope.substring(i + 1);
        }
        if (scope.startsWith("file")) {
            return this.getServerHostName();
        }
        return "";
    }

    public String getDefaultScope() {
        String server = this.getServerHostName();
        String scope = "file:/" + server + "/" + server;
        return scope;
    }

    public String checkAuthenticated() throws CIMException {
        String user_name = this.getClientUserName();
        if (user_name == null || user_name.trim().length() == 0) {
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1010", null, "", false, 1, 2, null);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        return user_name;
    }

    public void checkRights(String permission, CIMObjectPath op) throws CIMException {
        String user_name = this.checkAuthenticated();
        if (!AuthorizationUtility.checkAuthName(user_name, permission)) {
            String[] args = new String[]{user_name};
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1012", args, "", false, 1, 1, null);
            this.unAuthorizedAudit(op, permission);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    public boolean testRights(String permission, CIMObjectPath op) {
        boolean bool = false;
        String user_name = this.getClientUserName();
        if (user_name != null && user_name.trim().length() > 0) {
            return AuthorizationUtility.checkAuthName(user_name, permission);
        }
        return false;
    }

    public String decryptPassword(String encryptedPswd) {
        return this.cimomhandle.decryptData(encryptedPswd);
    }

    public String writeLog(int severity, Exception pex) {
        String retStr = null;
        String msg = null;
        boolean syslog = false;
        if (severity == 2) {
            syslog = true;
        }
        try {
            msg = pex.getLocalizedMessage();
            String[] args = new String[]{msg};
            retStr = this.logUtil.writeLog(this.providerName, "LM_2001", "LM_2100", args, null, syslog, 0, severity, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (retStr == null) {
            retStr = msg;
        }
        return retStr;
    }

    public String writeLog(int severity, String msgId, String detailMsgId, String arg1, String arg2, String arg3, String arg4) {
        return this.writeLog(severity, msgId, detailMsgId, arg1, arg2, arg3, arg4, null);
    }

    public String writeLog(int severity, String msgId, String detailMsgId, String arg1, String arg2, String arg3, String arg4, String bundleName) {
        String logmsg = null;
        boolean syslog = false;
        if (severity == 2) {
            syslog = true;
        }
        try {
            String[] args = new String[]{arg1, arg2, arg3, arg4};
            logmsg = this.logUtil.writeLog(this.providerName, msgId, detailMsgId, args, "", syslog, 0, severity, bundleName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return logmsg;
    }

    public String getScopeTypeFromClass(String className) {
        String type = null;
        if (className != null) {
            for (int i = 0; i < MGMT_CLASS_TABLE.length; ++i) {
                if (!className.equals(MGMT_CLASS_TABLE[i])) continue;
                type = MGMT_TYPE_TABLE[i];
                break;
            }
        }
        return type;
    }

    public String getScopeClassFromType(String type) {
        String class_name = "";
        for (int i = 0; i < MGMT_TYPE_TABLE.length; ++i) {
            if (!type.equals(MGMT_TYPE_TABLE[i])) continue;
            class_name = MGMT_CLASS_TABLE[i];
            break;
        }
        return class_name;
    }

    public String getServerHostName() {
        if (this.hostname == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                this.hostname = "??";
            }
            int i = this.hostname.indexOf(46);
            if (i > 0) {
                this.hostname = this.hostname.substring(0, i);
            }
        }
        return this.hostname;
    }

    private Vector getScopeList() {
        Vector v = null;
        try {
            DirectoryTableSetup dirtbl = new DirectoryTableSetup();
            v = dirtbl.getScopes(2);
        }
        catch (Exception ex) {
            v = new Vector(0);
        }
        return v;
    }

    public String formatAuditToken(CIMInstance cimInst) {
        String propertyString = "";
        Vector propV = cimInst.getProperties();
        Enumeration e = propV.elements();
        while (e.hasMoreElements()) {
            CIMValue cimValue;
            CIMProperty cimProp = (CIMProperty)e.nextElement();
            if (cimProp == null || (cimValue = cimProp.getValue()) == null) continue;
            int cimtype = CIMDataType.findType((Object)cimValue.getValue());
            if (cimProp.getName().equals("loginPassword")) continue;
            switch (cimtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 13: {
                    Object objVal = cimValue.getValue();
                    if (objVal == null || objVal.equals("")) break;
                    propertyString = propertyString.concat(cimProp.getName());
                    propertyString = propertyString.concat("=");
                    propertyString = propertyString.concat(objVal.toString());
                    propertyString = propertyString.concat(";");
                    break;
                }
                case 9: {
                    boolean bValue = (Boolean)cimValue.getValue();
                    String sValue = "0";
                    sValue = !bValue ? "0" : "1";
                    propertyString = propertyString.concat(cimProp.getName());
                    propertyString = propertyString.concat("=");
                    propertyString = propertyString.concat(sValue);
                    propertyString = propertyString.concat(";");
                    break;
                }
                case 12: {
                    CIMDateTime dateValue = (CIMDateTime)cimValue.getValue();
                    if (dateValue == null) break;
                    Calendar cal = dateValue.getCalendar();
                    Date tempDate = cal.getTime();
                    String expDate = this.convertDateToString(tempDate);
                    propertyString = propertyString.concat(cimProp.getName());
                    propertyString = propertyString.concat("=");
                    propertyString = propertyString.concat(expDate);
                    propertyString = propertyString.concat(";");
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: {
                    Vector cimV = (Vector)cimValue.getValue();
                    String dataString = "";
                    for (int i = 0; i < cimV.size(); ++i) {
                        Object cimObj = cimV.elementAt(i);
                        if (cimObj == null || cimObj.equals("")) continue;
                        dataString = dataString.concat(cimObj.toString());
                        dataString = dataString.concat(",");
                    }
                    if (dataString.equals("")) break;
                    propertyString = propertyString.concat(cimProp.getName());
                    propertyString = propertyString.concat("=");
                    int datalen = dataString.length();
                    propertyString = propertyString.concat(dataString.substring(0, datalen - 1));
                    propertyString = propertyString.concat(";");
                    break;
                }
                case 23: {
                    Vector booleanV = (Vector)cimValue.getValue();
                    String bString = "";
                    for (int i = 0; i < booleanV.size(); ++i) {
                        boolean bData = (Boolean)booleanV.elementAt(i);
                        String sData = "0";
                        sData = !bData ? "0" : "1";
                        bString = bString.concat(sData);
                        bString = bString.concat(",");
                    }
                    if (bString.equals("")) break;
                    propertyString = propertyString.concat(cimProp.getName());
                    propertyString = propertyString.concat("=");
                    int blen = bString.length();
                    propertyString = propertyString.concat(bString.substring(0, blen - 1));
                    propertyString = propertyString.concat(";");
                    break;
                }
                case 26: {
                    Vector datetimeV = (Vector)cimValue.getValue();
                    String datetimeString = "";
                    for (int i = 0; i < datetimeV.size(); ++i) {
                        CIMDateTime dateval = (CIMDateTime)datetimeV.elementAt(i);
                        if (dateval == null) continue;
                        Calendar cal = dateval.getCalendar();
                        Date tempDate = cal.getTime();
                        String expDate = this.convertDateToString(tempDate);
                        datetimeString = datetimeString.concat(expDate);
                        datetimeString = datetimeString.concat(",");
                    }
                    if (datetimeString.equals("")) break;
                    propertyString = propertyString.concat(cimProp.getName());
                    propertyString = propertyString.concat("=");
                    int datetimelen = datetimeString.length();
                    propertyString = propertyString.concat(datetimeString.substring(0, datetimelen - 1));
                    propertyString = propertyString.concat(";");
                    break;
                }
                case 28: {
                    break;
                }
                case 30: {
                    break;
                }
            }
        }
        return propertyString;
    }

    private String convertDateToString(Date theDate) {
        String dateStr = null;
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        sdf.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        sdf.setLenient(false);
        try {
            dateStr = sdf.format(theDate);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return dateStr;
    }

    public void unAuthorizedAudit(CIMObjectPath objPath, String permission) {
        try {
            WbemAuditSession wbemAuditSession = this.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"ProviderUtility unAuthorizedAudit : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"ProviderUtility unAuthorizedAudit : null platform AuditSession.");
                return;
            }
            AuditEvent_uauth uauthEvent = new AuditEvent_uauth(auditSession);
            if (uauthEvent == null) {
                Debug.trace3((String)"ProviderUtility unAuthorizedAudit : null AuditEvent_uauth.");
                return;
            }
            if (objPath != null) {
                uauthEvent.objectname(objPath.getObjectName());
            } else {
                uauthEvent.objectname(null);
            }
            uauthEvent.auth_used(permission);
            uauthEvent.putEvent(-1, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"ProviderUtility unAuthorizedAudit : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public WbemAuditSession getAuditSession() {
        WbemAuditService auditService = (WbemAuditService)ServiceRegistry.getService((String)"auditservice");
        if (auditService != null) {
            return auditService.getAuditSession();
        }
        return null;
    }

    public String getDomainToken(String urlScope) {
        String scopeType = null;
        scopeType = this.getScopeType(urlScope);
        if (!scopeType.equalsIgnoreCase("file")) {
            return this.getScopeDomainName(urlScope);
        }
        return null;
    }

    public String getNameServiceToken(String urlScope) {
        String scopeType = null;
        scopeType = this.getScopeType(urlScope);
        if (scopeType.equalsIgnoreCase("file")) {
            scopeType = FILES_SCOPE;
        }
        return scopeType;
    }

    public StringBuffer assembleRequiredAuth(StringBuffer requiredAuth, String auth) {
        if (requiredAuth == null) {
            requiredAuth = new StringBuffer();
        } else {
            requiredAuth.append(";");
        }
        requiredAuth.append(auth);
        return requiredAuth;
    }
}

