/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.wbem.solarisprovider.common.ProviderException;
import com.sun.wbem.solarisprovider.common.ProviderFilter;
import com.sun.wbem.solarisprovider.common.ProviderFilterException;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.List;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMProperty;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NumericValue;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;

public abstract class ProviderDirectoryFilter {
    private static final int MAX_ELEMENTS = 2;
    private ProviderFilter filter;
    private TableDefinitions tdef;
    private String tableName;
    private String sortName;
    private int sortCol;
    private boolean sortAsc;
    private int numElements;

    public ProviderDirectoryFilter(ProviderFilter filter, String table) throws ProviderException {
        this.filter = filter;
        this.tableName = table;
        this.sortName = null;
        this.sortCol = -1;
        this.sortAsc = false;
        this.numElements = 0;
        this.verifyFilter(filter);
    }

    public ProviderFilter getProviderFilter() {
        return this.filter;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSortColumnName() {
        return this.sortName;
    }

    public boolean isSortAscending() {
        return this.sortAsc;
    }

    public DirectoryFilter getDirectoryFilter(DirectoryTable dirTbl) throws ProviderException {
        TableDefinitions defs = null;
        try {
            defs = dirTbl.getCurrentTableDefinitions();
            defs.loadTableDefinitions(this.tableName);
        }
        catch (Exception ex) {
            throw new ProviderFilterException("EXCOM_DFTNF", this.tableName);
        }
        DirectoryFilter df = new DirectoryFilter(this.numElements);
        int op = -1;
        int bop = 1;
        int fop = -1;
        int col = -1;
        String val = null;
        AttributeExp aexp = null;
        ValueExp vexp = null;
        BinaryRelQueryExp bexp = null;
        List orList = this.filter.getCanonicalWhere();
        if (orList != null && orList.size() > 0) {
            for (int i = 0; i < orList.size(); ++i) {
                List andList = (List)orList.get(i);
                for (int j = 0; j < andList.size(); ++j) {
                    try {
                        bexp = (BinaryRelQueryExp)andList.get(j);
                        aexp = (AttributeExp)bexp.getLeftValue();
                        op = bexp.getOperator();
                        vexp = bexp.getRightValue();
                        String colName = this.mapPropertyToColumnName(aexp.getAttributeName());
                        if (colName == null) {
                            throw new NullPointerException();
                        }
                        col = defs.getColumnNumber(colName);
                    }
                    catch (Exception ex) {
                        throw new ProviderFilterException("EXCOM_DFBRE");
                    }
                    fop = this.mapOperator(op);
                    val = this.mapExpValue(vexp);
                    if (op == 6) {
                        fop = this.mapLikeOperator(val);
                    }
                    if (op == 6 || op == 7) {
                        val = this.mapLikeValue(val);
                    }
                    try {
                        df.add(col, bop, fop, val);
                    }
                    catch (Exception ex) {
                        throw new ProviderFilterException("EXCOM_DFCAE");
                    }
                    bop = 2;
                }
                bop = 3;
            }
        }
        return df;
    }

    public abstract String mapPropertyToColumnName(String var1);

    private void verifyFilter(ProviderFilter filter) throws ProviderException {
        int num = 0;
        int op = -1;
        int fop = -1;
        String val = null;
        AttributeExp aexp = null;
        ValueExp vexp = null;
        BinaryRelQueryExp bexp = null;
        List orList = filter.getCanonicalWhere();
        if (orList != null && orList.size() > 0) {
            for (int i = 0; i < orList.size(); ++i) {
                List andList = (List)orList.get(i);
                for (int j = 0; j < andList.size(); ++j) {
                    try {
                        bexp = (BinaryRelQueryExp)andList.get(j);
                        aexp = (AttributeExp)bexp.getLeftValue();
                        op = bexp.getOperator();
                        vexp = bexp.getRightValue();
                        String colName = this.mapPropertyToColumnName(aexp.getAttributeName());
                        if (colName == null) {
                            throw new NullPointerException();
                        }
                    }
                    catch (Exception ex) {
                        throw new ProviderFilterException("EXCOM_DFBRE");
                    }
                    fop = this.mapOperator(op);
                    if (fop == -1) {
                        throw new ProviderFilterException("EXCOM_DFBOP");
                    }
                    val = this.mapExpValue(vexp);
                    if (val == null) {
                        throw new ProviderFilterException("EXCOM_DFBEV");
                    }
                    ++num;
                }
            }
        }
        if (num > 2) {
            throw new ProviderFilterException("EXCOM_DFTME", new Integer(2));
        }
        this.numElements = num;
        String name = null;
        CIMProperty cp = filter.getSortProperty();
        if (cp != null && (name = this.mapPropertyToColumnName(cp.getName())) == null) {
            throw new ProviderFilterException("EXCOM_DFBSP", cp.getName());
        }
        this.sortName = name;
        this.sortAsc = filter.isSortAscending();
    }

    private String mapExpValue(ValueExp vexp) {
        String rval = null;
        if (vexp instanceof StringValueExp) {
            rval = ((StringValueExp)vexp).getValue();
        } else if (vexp instanceof NumericValue) {
            rval = ((NumericValue)vexp).toString();
        } else if (vexp instanceof DateTimeExp) {
            CIMDateTime cdt = ((DateTimeExp)vexp).getValue();
            rval = cdt.toString();
        }
        return rval;
    }

    private int mapOperator(int op) {
        int fop;
        switch (op) {
            case 0: {
                fop = 8;
                break;
            }
            case 1: {
                fop = 7;
                break;
            }
            case 2: {
                fop = -1;
                break;
            }
            case 3: {
                fop = -1;
                break;
            }
            case 4: {
                fop = 5;
                break;
            }
            case 5: {
                fop = 6;
                break;
            }
            case 6: {
                fop = 1;
                break;
            }
            case 7: {
                fop = 2;
                break;
            }
            default: {
                fop = -1;
            }
        }
        return fop;
    }

    private int mapLikeOperator(String value) {
        int fop = -1;
        if (value != null & value.length() > 0) {
            int len = value.length();
            fop = value.charAt(0) == '%' ? (len > 1 && value.charAt(len - 1) == '%' ? 1 : 4) : (len > 1 && value.charAt(len - 1) == '%' ? 3 : 5);
        }
        return fop;
    }

    private String mapLikeValue(String value) {
        String rval = value;
        int len = rval.length();
        if (rval.length() > 0) {
            if (rval.charAt(0) == '%') {
                rval = rval.substring(1);
                --len;
            }
            if (len > 0 && rval.charAt(len - 1) == '%') {
                rval = rval.substring(0, len - 1);
            }
        }
        return rval;
    }
}

