/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.wbem.solarisprovider.common.PropertyUtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PropertyUtil {
    public static final String ADMIN_SERVER_PROP_PATH = "/usr/sadm/lib/wbem";
    public static final String ADMIN_SERVER_PROP_FILE = "WbemServices.properties";
    public static final String ADMIN_PROP_SERVER_HDR = "Wbem Services properties file";
    public static final int ADMIN_PROP_MODE_READ = 0;
    public static final int ADMIN_PROP_MODE_WRITE = 1;
    public static final int ADMIN_PROP_MODE_CREATE = 2;
    public static final String ADMIN_PROP_ON_VALUE = "on";
    public static final String ADMIN_PROP_OFF_VALUE = "off";
    private String propfile;
    private int propmode;
    private Properties props = null;

    public PropertyUtil(String propPath, String propFileName, int propMode) throws PropertyUtilException {
        String path = null;
        if (propPath == null || propPath.trim().length() == 0) {
            throw new PropertyUtilException("EXCOM_PROP_PATH");
        }
        try {
            path = System.getProperty(propPath);
        }
        catch (Exception x) {
            path = null;
        }
        if (path == null) {
            throw new PropertyUtilException("EXCOM_PROP_PATH");
        }
        if (propFileName == null || propFileName.trim().length() == 0) {
            throw new PropertyUtilException("EXCOM_PROP_PATH");
        }
        this.propmode = propMode;
        path = path.concat(File.separator);
        this.propfile = path.concat(propFileName);
    }

    public PropertyUtil(String propFilePath, int propMode) throws PropertyUtilException {
        this.propfile = propFilePath;
        this.propmode = propMode;
    }

    public String getProp(String propName) throws PropertyUtilException {
        String val;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            val = this.props.getProperty(propName);
        }
        catch (Exception ex) {
            throw new PropertyUtilException("EXCOM_PROP_NOT_FOUND", propName);
        }
        if (val == null) {
            val = "";
        }
        return val;
    }

    public Vector getPropList(String propNamePrefix) throws PropertyUtilException {
        Vector<String> vec = new Vector<String>();
        boolean sw = true;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        int i = 1;
        String name = propNamePrefix.concat(".");
        while (sw) {
            name = propNamePrefix + "." + i;
            try {
                String val = this.props.getProperty(name);
                if (val == null) {
                    sw = false;
                } else {
                    vec.addElement(val);
                }
            }
            catch (Exception x) {
                sw = false;
            }
            ++i;
        }
        return vec;
    }

    public Vector getPropNames() throws PropertyUtilException {
        Vector<String> vec = new Vector<String>();
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        Enumeration<?> en = this.props.propertyNames();
        while (en.hasMoreElements()) {
            String name = new String((String)en.nextElement());
            vec.addElement(name);
        }
        return vec;
    }

    public void putProp(String propName, String propValue) throws PropertyUtilException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        String val = propValue == null ? "" : propValue.trim();
        try {
            this.props.put(propName, val);
        }
        catch (Exception ex) {
            throw new PropertyUtilException("EXCOM_PNS", propName);
        }
    }

    public void delProp(String propName) throws PropertyUtilException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            String val = (String)this.props.remove(propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveProps(String headInfo) throws PropertyUtilException {
        this.saveProps(this.propfile, headInfo);
    }

    public void saveProps(String propFile, String headInfo) throws PropertyUtilException {
        if (this.props != (Properties)null) {
            if (headInfo == null) {
                this.saveProperties(propFile, "*** DO NOT EDIT THIS FILE ***");
            } else {
                this.saveProperties(propFile, headInfo);
            }
        }
    }

    private void loadProperties() throws PropertyUtilException {
        boolean fnf = false;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        try {
            fin = new FileInputStream(this.propfile);
            bin = new BufferedInputStream(fin);
        }
        catch (FileNotFoundException fex) {
            fnf = true;
        }
        if (fnf && (this.propmode ^ 2) == 0) {
            throw new PropertyUtilException("EXCOM_BPF", this.propfile);
        }
        this.props = new Properties();
        if (!fnf) {
            try {
                this.props.load(bin);
            }
            catch (IOException ex) {
                throw new PropertyUtilException("EXCOM_LPF", (Object)this.propfile, ex.getMessage());
            }
        }
        try {
            fin.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void saveProperties(String propFile, String header) throws PropertyUtilException {
        BufferedOutputStream bout;
        FileOutputStream fout;
        try {
            fout = new FileOutputStream(propFile);
            bout = new BufferedOutputStream(fout);
        }
        catch (SecurityException fex) {
            throw new PropertyUtilException("EXCOM_NAP", propFile);
        }
        catch (IOException fex) {
            throw new PropertyUtilException("EXCOM_NWP", propFile);
        }
        try {
            this.props.store(bout, header);
        }
        catch (Exception ex) {
            throw new PropertyUtilException("EXCOM_NWP", (Object)propFile, ex);
        }
        try {
            bout.flush();
            fout.close();
        }
        catch (Exception ex) {
            throw new PropertyUtilException("EXCOM_NWP", (Object)propFile, ex);
        }
    }
}

