/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.UserAttrUtil;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserRightsUtil;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisPasswdTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisUserAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.UMgrNative;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;

public class UserAttrUpdate {
    private static final String ROLE_TYPE = "role";
    private static final String USER_TYPE = "normal";
    private static final String USER_LIST = "members";
    private static final String ROLE_LIST = "roles";
    private static final String PRIM_PROJ = "project";
    private static final int CK_BAD = -1;
    private static final int CK_USER = 0;
    private static final int CK_ROLE = 1;
    private ProviderUtility provUtil;
    private UserAttrUtil validUtil;
    private String scope;

    public UserAttrUpdate(ProviderUtility provUtility, String scopeURL) {
        this.provUtil = provUtility;
        this.scope = scopeURL;
        this.validUtil = new UserAttrUtil(this.scope);
    }

    public UserAttrObj userAttrRead(String userName) throws UserException {
        String userType;
        UserAttrObj uao = null;
        SolarisUserAttrTable uat = new SolarisUserAttrTable(this.scope);
        try {
            uao = uat.readUserAttr(userName);
        }
        catch (DirectoryTableDoesNotExistException dex) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (DirectoryTableRowNotFoundException dex) {
            throw new UserException("EXM_UAU_RD1", (Object)this.scope, userName);
        }
        catch (Exception ex) {
            throw new UserException("EXM_UAU_RD2", (Object)this.scope, (Object)userName, ex.getLocalizedMessage());
        }
        if (uao != null && (userType = uao.getUserType()).equals(ROLE_TYPE)) {
            Vector vMembers = null;
            try {
                vMembers = uat.getUsersInRole(userName);
            }
            catch (Exception ex) {
                throw new UserException("EXM_UAU_RD3", (Object)userName, this.scope);
            }
            if (vMembers != null && vMembers.size() > 0) {
                uao.setAttribute(USER_LIST, vMembers);
            }
        }
        return uao;
    }

    public void userAttrAdd(String userName, String userType, UserAttrObj newAttr, CIMObjectPath objPath) throws UserException {
        boolean bRole = userType.equals(ROLE_TYPE);
        if (newAttr == null) {
            if (bRole) {
                this.createEmptyRoleEntry(userName);
            }
            return;
        }
        this.validUtil.validateUserAttrKeys(newAttr);
        this.validUtil.validateAuthNames(null, newAttr);
        this.validUtil.validateProfNames(null, newAttr);
        UserRightsUtil uru = new UserRightsUtil(this.provUtil);
        try {
            uru.checkAuthAssignRights(null, newAttr);
            uru.checkProfAssignRights(null, newAttr, objPath);
            uru.checkRoleAssignRights(userName, userType, null, newAttr, objPath);
            uru.checkAttrAssignRights(null, newAttr);
        }
        catch (UserException ex) {
            if (bRole) {
                try {
                    this.createEmptyRoleEntry(userName);
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
            throw ex;
        }
        SolarisUserAttrTable uat = new SolarisUserAttrTable(this.scope);
        String type = this.provUtil.getScopeType(this.scope);
        boolean bLocal = false;
        if (type.equalsIgnoreCase("file")) {
            bLocal = true;
        }
        Vector vMembers = null;
        Vector vBad = null;
        if (bRole) {
            vMembers = newAttr.getAttribute(USER_LIST);
            newAttr.clearAttribute(USER_LIST);
            vBad = this.checkList(uat, vMembers, bRole, bLocal);
            if (vBad.size() > 0) {
                vMembers = this.getVectorDiff(vMembers, vBad);
            }
        } else {
            vMembers = newAttr.getAttribute(ROLE_LIST);
            vBad = this.checkList(uat, vMembers, bRole, bLocal);
            if (vBad.size() > 0) {
                vMembers = this.getVectorDiff(vMembers, vBad);
                newAttr.setAttribute(ROLE_LIST, vMembers);
            }
        }
        try {
            uat.writeUserAttr(newAttr);
        }
        catch (DirectoryTableDoesNotExistException dex) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (Exception ex) {
            throw new UserException("EXM_UAU_AD1", (Object)this.scope, (Object)userName, ex.getLocalizedMessage());
        }
        if (bRole && vMembers != null && vMembers.size() > 0) {
            try {
                uat.addRoleToUsers(userName, vMembers);
            }
            catch (Exception ex) {
                throw new UserException("EXM_UAU_AD2", (Object)userName, (Object)this.scope, ex.getLocalizedMessage());
            }
        }
        if (vBad.size() > 0) {
            String ul = this.getBadUserList(vBad);
            if (bRole) {
                throw new UserException("EXM_UAU_CK1", (Object)userName, (Object)this.scope, ul);
            }
            throw new UserException("EXM_UAU_CK3", (Object)userName, (Object)this.scope, ul);
        }
    }

    public void userAttrDelete(String userName, UserAttrObj oldAttr) throws UserException {
        Throwable sex = null;
        UserAttrObj uao = oldAttr;
        if (uao == null) {
            uao = this.userAttrRead(userName);
        }
        if (uao != null) {
            Vector vMembers;
            SolarisUserAttrTable uat = new SolarisUserAttrTable(this.scope);
            String userType = uao.getUserType();
            boolean bError = false;
            if (userType.equals(ROLE_TYPE) && (vMembers = uao.getAttribute(USER_LIST)) != null && vMembers.size() > 0) {
                try {
                    uat.removeRoleFromUsers(userName, vMembers);
                }
                catch (DirectoryTableDoesNotExistException dex) {
                    throw new UserException("EXM_UAU_DB1", this.scope);
                }
                catch (Exception ex) {
                    bError = true;
                    sex = ex;
                }
            }
            try {
                uat.removeUserAttr(userName);
            }
            catch (DirectoryTableDoesNotExistException dex) {
            }
            catch (DirectoryTableRowNotFoundException dex) {
            }
            catch (Exception ex) {
                throw new UserException("EXM_UAU_DL1", (Object)this.scope, (Object)userName, ex.getLocalizedMessage());
            }
            if (bError) {
                throw new UserException("EXM_UAU_DL2", (Object)userName, (Object)this.scope, sex.getLocalizedMessage());
            }
        }
    }

    public void userAttrModify(String userName, UserAttrObj newAttr, CIMObjectPath objPath) throws UserException {
        UserAttrObj oldAttr;
        if (newAttr == null) {
            return;
        }
        String oldUser = userName;
        String userType = newAttr.getUserType();
        String newUser = newAttr.getUserName();
        boolean bChg = false;
        if (!oldUser.equals(newUser)) {
            bChg = true;
        }
        if ((oldAttr = this.userAttrRead(oldUser)) == null) {
            this.userAttrAdd(newUser, userType, newAttr, objPath);
            return;
        }
        if (oldAttr.equals(newAttr) && !bChg) {
            return;
        }
        this.validUtil.validateUserAttrKeys(newAttr);
        this.validUtil.validateAuthNames(oldAttr, newAttr);
        this.validUtil.validateProfNames(oldAttr, newAttr);
        UserRightsUtil uru = new UserRightsUtil(this.provUtil);
        uru.checkAuthAssignRights(oldAttr, newAttr);
        uru.checkProfAssignRights(oldAttr, newAttr, objPath);
        uru.checkRoleAssignRights(oldUser, userType, oldAttr, newAttr, objPath);
        uru.checkAttrAssignRights(oldAttr, newAttr);
        boolean bRole = userType.equals(ROLE_TYPE);
        SolarisUserAttrTable uat = new SolarisUserAttrTable(this.scope);
        String type = this.provUtil.getScopeType(this.scope);
        boolean bLocal = false;
        if (type.equalsIgnoreCase("file")) {
            bLocal = true;
        }
        Vector vOldMembers = null;
        Vector vNewMembers = null;
        Vector vBad = null;
        if (bRole) {
            vOldMembers = oldAttr.getAttribute(USER_LIST);
            vNewMembers = newAttr.getAttribute(USER_LIST);
            newAttr.clearAttribute(USER_LIST);
            vBad = this.checkList(uat, vNewMembers, bRole, bLocal);
            if (vBad.size() > 0) {
                vNewMembers = this.getVectorDiff(vNewMembers, vBad);
            }
        } else {
            vNewMembers = newAttr.getAttribute(ROLE_LIST);
            vBad = this.checkList(uat, vNewMembers, bRole, bLocal);
            if (vBad.size() > 0) {
                vNewMembers = this.getVectorDiff(vNewMembers, vBad);
                newAttr.setAttribute(ROLE_LIST, vNewMembers);
            }
        }
        try {
            if (!bRole && uat.isEmpty(newAttr)) {
                uat.removeUserAttr(newAttr);
            } else {
                uat.writeUserAttr(newAttr);
            }
        }
        catch (DirectoryTableDoesNotExistException dex) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (Exception ex) {
            throw new UserException("EXM_UAU_MD1", (Object)this.scope, (Object)oldUser, ex.getLocalizedMessage());
        }
        if (bChg) {
            try {
                uat.removeUserAttr(oldAttr);
            }
            catch (DirectoryTableRowNotFoundException dex) {
            }
            catch (Exception ex) {
                throw new UserException("EXM_UAU_DL1", (Object)this.scope, (Object)oldUser, ex.getLocalizedMessage());
            }
        }
        if (bRole) {
            Vector v1 = null;
            Vector v2 = null;
            if (bChg) {
                v1 = vOldMembers;
                v2 = vNewMembers;
            } else {
                v1 = this.getVectorDiff(vOldMembers, vNewMembers);
                v2 = this.getVectorDiff(vNewMembers, vOldMembers);
            }
            try {
                if (v1 != null && v1.size() > 0) {
                    uat.removeRoleFromUsers(oldUser, v1);
                }
                if (v2 != null && v2.size() > 0) {
                    uat.addRoleToUsers(newUser, v2);
                }
            }
            catch (Exception ex) {
                throw new UserException("EXM_UAU_MD2", (Object)oldUser, (Object)this.scope, ex.getLocalizedMessage());
            }
        }
        if (vBad.size() > 0) {
            String ul = this.getBadUserList(vBad);
            if (bRole) {
                throw new UserException("EXM_UAU_CK1", (Object)oldUser, (Object)this.scope, ul);
            }
            throw new UserException("EXM_UAU_CK3", (Object)oldUser, (Object)this.scope, ul);
        }
    }

    Vector checkList(SolarisUserAttrTable uat, Vector vMem, boolean bRole, boolean bLocal) {
        SolarisPasswdTable spt = null;
        Vector<String> vBad = new Vector<String>();
        if (vMem == null) {
            return vBad;
        }
        int ckValue = bRole ? 0 : 1;
        if (!bLocal) {
            spt = new SolarisPasswdTable(this.scope);
        }
        Enumeration en = vMem.elements();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            int i = bLocal ? UMgrNative.checkUserName(name) : this.checkUserInScope(name, spt, uat);
            if (i == ckValue) continue;
            vBad.addElement(name);
        }
        return vBad;
    }

    private int checkUserInScope(String name, SolarisPasswdTable spt, SolarisUserAttrTable uat) {
        FlatUserObj fuo = new FlatUserObj();
        fuo.setUserName(name);
        int i = -1;
        try {
            fuo = spt.getPasswdRow(fuo);
        }
        catch (Exception ex) {
            fuo = null;
        }
        if (fuo != null) {
            i = 0;
            UserAttrObj uao = null;
            try {
                uao = uat.readUserAttr(name);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (uao != null && uao.getUserType().equals(ROLE_TYPE)) {
                i = 1;
            }
        }
        return i;
    }

    private String getBadUserList(Vector vBad) {
        String ul = "";
        String name = null;
        boolean sw = false;
        Enumeration en = vBad.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (sw) {
                ul = ul + ", ";
            }
            ul = ul + name;
            sw = true;
        }
        return ul;
    }

    private Vector getVectorDiff(Vector v1, Vector v2) {
        if (v1 == null) {
            return new Vector(0);
        }
        Vector v3 = (Vector)v1.clone();
        if (v2 != null) {
            for (int i = 0; i < v2.size(); ++i) {
                v3.removeElement(v2.elementAt(i));
            }
        }
        return v3;
    }

    private void createEmptyRoleEntry(String roleName) throws UserException {
        try {
            SolarisUserAttrTable uat = new SolarisUserAttrTable(this.scope);
            UserAttrObj uao = new UserAttrObj(roleName, ROLE_TYPE);
            uat.writeUserAttr(uao);
        }
        catch (DirectoryTableDoesNotExistException dex) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (Exception ex) {
            throw new UserException("EXM_UAU_AD1", (Object)this.scope, (Object)roleName, ex.getLocalizedMessage());
        }
    }
}

