/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.solarisprovider.usermgr.aliases.EmailAliasObj;
import com.sun.wbem.solarisprovider.usermgr.aliases.SolarisAliasesTable;
import com.sun.wbem.solarisprovider.usermgr.common.GroupNotFoundException;
import com.sun.wbem.solarisprovider.usermgr.common.PartialSuccessException;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameNotFoundException;
import com.sun.wbem.solarisprovider.usermgr.groups.GroupObj;
import com.sun.wbem.solarisprovider.usermgr.groups.SolGroupAttr;
import com.sun.wbem.solarisprovider.usermgr.groups.SolarisGroupTable;
import com.sun.wbem.solarisprovider.usermgr.users.CheckSyntax;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.LightUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.PartialSuccessObject;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisAutoHomeTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisPasswdTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisShadowTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisUserAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.UMgrNative;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrUpdate;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;

public class UMgrWrapper {
    public static int NOBODY = 60001;
    public static int NOACCESS = 60002;
    public static int NOBODY4 = 65534;
    ProviderUtility provUtil = null;
    private String scope = "";
    private static final String USER_PSWD_RIGHT = "solaris.admin.usermgr.pswd";
    private boolean isNISPlusScope = false;
    PartialSuccessObject psObj;

    public UMgrWrapper(ProviderUtility provUtil, String strScope) {
        this.provUtil = provUtil;
        this.scope = strScope;
        this.isScopeNISPlus();
    }

    public synchronized Vector getAllFlatUsers() throws UserException {
        String msg = null;
        try {
            SolarisPasswdTable passwd = new SolarisPasswdTable(this.scope);
            return passwd.getAllFlatRows();
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2090", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2092", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2094", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2096", null, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2095", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
    }

    public synchronized Vector getAllLightUsers() throws UserException {
        Vector vUserList = null;
        vUserList = this.getAllLightUsers(null);
        return vUserList;
    }

    public synchronized Vector getAllLightUsers(ProviderDirectoryFilter pdf) throws UserException {
        Vector vUserList = null;
        Vector vJustUsers = new Vector();
        String[] roleList = null;
        String msg = null;
        try {
            SolarisPasswdTable passwd = new SolarisPasswdTable(this.scope);
            vUserList = pdf == null ? passwd.getAllLightRows() : passwd.getAllLightRows(pdf);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2090", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2092", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2094", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2096", null, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2095", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        boolean roleError = false;
        try {
            SolarisUserAttrTable attrTable = new SolarisUserAttrTable(this.scope);
            roleList = attrTable.getRolesList();
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2610", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2612", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2614", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2617", null, null, null, null);
            roleError = true;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2611", null, null, null, null);
            roleError = true;
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2042", "LM_2615", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        if (roleError || roleList.length == 0) {
            return vUserList;
        }
        Hashtable<String, String> hTable = new Hashtable<String, String>();
        for (int i = 0; i < roleList.length; ++i) {
            hTable.put(roleList[i], roleList[i]);
        }
        for (int j = 0; j < vUserList.size(); ++j) {
            String userName = ((LightUserObj)vUserList.elementAt(j)).getUserName();
            String hashName = (String)hTable.get(userName);
            if (hashName != null) continue;
            vJustUsers.addElement(vUserList.elementAt(j));
        }
        return vJustUsers;
    }

    public synchronized Vector getAllLightRoles(ProviderDirectoryFilter pdf) throws UserException {
        Vector vUserList = null;
        Vector vJustRoles = new Vector();
        String[] roleList = null;
        boolean roleError = false;
        String msg = null;
        try {
            SolarisUserAttrTable attrTable = new SolarisUserAttrTable(this.scope);
            roleList = attrTable.getRolesList();
            SolarisPasswdTable passwd = new SolarisPasswdTable(this.scope);
            if (roleList != null && roleList.length > 0) {
                vUserList = pdf == null ? passwd.getAllLightRows() : passwd.getAllLightRows(pdf);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2610", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2612", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2614", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2617", null, null, null, null);
            roleError = true;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2611", null, null, null, null);
            roleError = true;
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2615", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        if (roleError || roleList.length == 0) {
            return vJustRoles;
        }
        Hashtable<String, String> hTable = new Hashtable<String, String>();
        for (int i = 0; i < roleList.length; ++i) {
            hTable.put(roleList[i], roleList[i]);
        }
        for (int j = 0; j < vUserList.size(); ++j) {
            String userName = ((LightUserObj)vUserList.elementAt(j)).getUserName();
            String hashName = (String)hTable.get(userName);
            if (hashName == null) continue;
            vJustRoles.addElement(vUserList.elementAt(j));
        }
        return vJustRoles;
    }

    public synchronized Vector getAllLightRoles() throws UserException {
        String[] roleList = null;
        Vector<LightUserObj> vRoles = new Vector<LightUserObj>();
        boolean roleError = false;
        String msg = null;
        try {
            SolarisUserAttrTable attrTable = new SolarisUserAttrTable(this.scope);
            roleList = attrTable.getRolesList();
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2610", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2612", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2614", null, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2617", null, null, null, null);
            roleError = true;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2611", null, null, null, null);
            roleError = true;
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2312", "LM_2615", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        if (roleError || roleList.length == 0) {
            return vRoles;
        }
        for (int i = 0; i < roleList.length; ++i) {
            LightUserObj lUserObj = new LightUserObj();
            lUserObj.setUserName(roleList[i]);
            try {
                lUserObj = this.getUser(lUserObj);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (lUserObj != null) {
                lUserObj.setUserType("role");
            }
            if (vRoles == null) continue;
            vRoles.addElement(lUserObj);
        }
        return vRoles;
    }

    public synchronized LightUserObj getUser(LightUserObj lUserObj) throws Exception {
        SolarisPasswdTable passwd = new SolarisPasswdTable(this.scope);
        return passwd.getPasswdRow(lUserObj);
    }

    public synchronized FlatUserObj getUser(FlatUserObj fUserObj, ProviderUtility provUtil) throws Exception {
        SolarisPasswdTable pwdTable = new SolarisPasswdTable(this.scope);
        SolarisShadowTable sdTable = new SolarisShadowTable(this.scope);
        SolGroupAttr grp = new SolGroupAttr();
        String userName = fUserObj.getUserName();
        String msg = null;
        try {
            fUserObj = pwdTable.getPasswdRow(fUserObj);
        }
        catch (DirectoryTableRowNotFoundException e) {
            msg = provUtil.writeLog(2, "LM_2042", "LM_2506", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = provUtil.writeLog(2, "LM_2042", "LM_2500", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2042", "LM_2502", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = provUtil.writeLog(2, "LM_2042", "LM_2504", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2042", "LM_2505", userName, ex.getLocalizedMessage(), null, null);
            throw new UserException(msg);
        }
        try {
            fUserObj = sdTable.getShadowRow(fUserObj);
        }
        catch (DirectoryTableRowNotFoundException e) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2717", null, null, null, null);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2170", null, null, null, null);
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2172", null, null, null, null);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2174", null, null, null, null);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2176", null, null, null, null);
        }
        try {
            SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
            Vector vSecGroups = tbl.getAllSecondaryGroups(fUserObj);
            fUserObj.setSecondaryGroups(vSecGroups);
        }
        catch (DirectoryTableRowNotFoundException e) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2186", null, null, null, null);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2180", null, null, null, null);
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2182", null, null, null, null);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2184", null, null, null, null);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2186", null, null, null, null);
        }
        try {
            SolarisAutoHomeTable ah = new SolarisAutoHomeTable(this.scope);
            fUserObj = ah.getAutoHomeRow(fUserObj);
        }
        catch (Exception e) {
            fUserObj.setAutoMountHomeDir(false);
            try {
                InetAddress homename = InetAddress.getLocalHost();
                fUserObj.setHomeDirServer(homename.getHostName());
            }
            catch (Exception ex) {
                fUserObj.setHomeDirServer("");
            }
        }
        try {
            SolarisAliasesTable al = new SolarisAliasesTable(this.scope);
            EmailAliasObj em = al.getEmailRow(fUserObj.getUserName());
            String exp = em.getAliasExpansion();
            fUserObj.setMailServer(this.parseForMailServer(exp, fUserObj.getUserName()));
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2125", null, null, null, null);
        }
        catch (Exception ex) {
            fUserObj.setMailBoxForceModify(true);
            fUserObj.setMailBoxAllowModifyServer(false);
        }
        UserAttrObj userAttr = null;
        try {
            UserAttrUpdate attrUpdate = new UserAttrUpdate(provUtil, this.scope);
            userAttr = attrUpdate.userAttrRead(fUserObj.getUserName());
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2026", "LM_2615", ex.getLocalizedMessage(), null, null, null);
        }
        if (userAttr != null) {
            if (userAttr.getUserType().equals("role")) {
                fUserObj.setUserType("role");
            } else if (userAttr.getUserType().equals("normal")) {
                fUserObj.setUserType("normal");
            }
            fUserObj.setAttrKey(userAttr.getAttributeString());
        } else {
            fUserObj.setUserType("normal");
        }
        fUserObj.setPrimaryProject(UMgrNative.getPrimaryProject(fUserObj.getUserName()));
        fUserObj.setSecondaryProjects(this.getSecondaryProjectNames(fUserObj.getUserName(), null));
        return fUserObj;
    }

    public synchronized void addUser(FlatUserObj fUserObj, ProviderUtility provUtil, CIMObjectPath objPath) throws Exception {
        String userName = fUserObj.getUserName();
        String msg = null;
        if (!CheckSyntax.isNameOK(fUserObj.getUserName())) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2088", userName, null, null, null);
            throw new UserException(msg);
        }
        if (fUserObj.getUserUID() == null || fUserObj.getUserUID().trim().length() == 0) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2517", userName, null, null, null);
            throw new UserException(msg);
        }
        SolarisPasswdTable pwTable = null;
        SolarisShadowTable sdTable = null;
        try {
            pwTable = new SolarisPasswdTable(this.scope);
            sdTable = new SolarisShadowTable(this.scope);
            pwTable.addPasswdRow(fUserObj);
        }
        catch (UserMgrIDAlreadyInUseException ex) {
            msg = provUtil.writeLog(2, "LM_2048", "LM_2519", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (UserMgrNameAlreadyInUseException ex) {
            msg = provUtil.writeLog(2, "LM_2048", "LM_2518", userName, null, null, null);
            throw new UserMgrNameAlreadyInUseException(msg);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2510", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2512", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2511", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2514", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2515", userName, ex.getLocalizedMessage(), null, null);
            throw new UserException(msg);
        }
        if (fUserObj.getCurPassword() != null && fUserObj.getCurPassword().trim().length() > 0) {
            fUserObj.setHasPasswd(true);
        }
        try {
            sdTable.addShadowRow(fUserObj, provUtil);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            this.psObj = new PartialSuccessObject();
            this.psObj.setShadowFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2024", "LM_2730", userName, null, null, null);
        }
        catch (DirectoryTableAccessException ex) {
            this.psObj = new PartialSuccessObject();
            this.psObj.setShadowFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2024", "LM_2732", userName, null, null, null);
        }
        catch (DirectoryTableConnectionException ex) {
            this.psObj = new PartialSuccessObject();
            this.psObj.setShadowFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2024", "LM_2734", userName, null, null, null);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = provUtil.writeLog(2, "LM_2043", "LM_2731", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            this.psObj = new PartialSuccessObject();
            this.psObj.setShadowFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2024", "LM_2735", userName, ex.getLocalizedMessage(), null, null);
        }
        if (fUserObj.getSecondaryGroups() != null && fUserObj.getSecondaryGroups().size() != 0) {
            Vector vGrps = fUserObj.getSecondaryGroups();
            String[] members = new String[]{""};
            members[0] = fUserObj.getUserName();
            GroupObj mygrp = new GroupObj();
            for (int i = 0; i < vGrps.size(); ++i) {
                mygrp.setGroupName((String)vGrps.elementAt(i));
                try {
                    this.performAddUsersToGroup(mygrp, members);
                    continue;
                }
                catch (DirectoryTableInvalidParameterException ex) {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setGroupFailed(true);
                    fUserObj.setPSobj(this.psObj);
                    msg = provUtil.writeLog(2, "LM_2024", "LM_2180", null, null, null, null);
                    continue;
                }
                catch (DirectoryTableAccessException ex) {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setGroupFailed(true);
                    fUserObj.setPSobj(this.psObj);
                    msg = provUtil.writeLog(2, "LM_2024", "LM_2182", null, null, null, null);
                    continue;
                }
                catch (DirectoryTableConnectionException ex) {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setGroupFailed(true);
                    fUserObj.setPSobj(this.psObj);
                    msg = provUtil.writeLog(2, "LM_2024", "LM_2184", null, null, null, null);
                    continue;
                }
                catch (GroupNotFoundException ex) {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setGroupFailed(true);
                    fUserObj.setPSobj(this.psObj);
                    String grpName = mygrp.getGroupName();
                    msg = provUtil.writeLog(2, "LM_2024", "LM_2921", userName, grpName, null, null);
                    continue;
                }
                catch (Exception ex) {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setGroupFailed(true);
                    fUserObj.setPSobj(this.psObj);
                    msg = provUtil.writeLog(2, "LM_2024", "LM_2185", ex.getLocalizedMessage(), null, null, null);
                }
            }
        }
        UserAttrObj userAttr = null;
        if (fUserObj.getAttrKey() != null) {
            userAttr = new UserAttrObj(fUserObj.getUserName());
            userAttr.putAttributeString(fUserObj.getAttrKey());
            if (fUserObj.getUserType() == null) {
                fUserObj.setUserType("normal");
            }
            if (!fUserObj.getUserType().equals("normal") && !fUserObj.getUserType().equals("role")) {
                fUserObj.setUserType("normal");
            }
            userAttr.setUserType(fUserObj.getUserType());
            try {
                UserAttrUpdate attrUpdate = new UserAttrUpdate(provUtil, this.scope);
                attrUpdate.userAttrAdd(fUserObj.getUserName(), fUserObj.getUserType(), userAttr, objPath);
            }
            catch (UserException ex) {
                msg = provUtil.writeLog(2, "LM_2024", "LM_2914", userName, ex.getLocalizedMessage(), null, null);
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setUserattrFailed(true);
                fUserObj.setPSobj(this.psObj);
            }
            catch (Exception ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setUserattrFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2024", "LM_2914", userName, ex.getLocalizedMessage(), null, null);
            }
        }
        if (fUserObj.getAutoMountHomeDir()) {
            SolarisAutoHomeTable ahTable = new SolarisAutoHomeTable(this.scope);
            try {
                ahTable.addAutoHomeRow(fUserObj);
            }
            catch (DirectoryTableInvalidParameterException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2024", "LM_2830", userName, null, null, null);
            }
            catch (DirectoryTableAccessException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2024", "LM_2832", userName, null, null, null);
            }
            catch (DirectoryTableConnectionException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2024", "LM_2834", userName, null, null, null);
            }
            catch (Exception ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2024", "LM_2835", userName, ex.getLocalizedMessage(), null, null);
            }
        }
        boolean result = true;
        if (fUserObj.getUserType().equals("normal")) {
            try {
                String flatPrimaryProject = fUserObj.getPrimaryProject();
                if (flatPrimaryProject != null) {
                    result = this.modifyPrimaryProject(fUserObj.getUserName(), flatPrimaryProject);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!result) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setProjectFailed(true);
                fUserObj.setPSobj(this.psObj);
            }
        }
        result = true;
        try {
            result = this.modifySecondaryProjects(fUserObj.getUserName(), fUserObj.getSecondaryProjects());
            if (!result) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setProjectFailed(true);
                fUserObj.setPSobj(this.psObj);
            }
        }
        catch (Exception e) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setProjectFailed(true);
            fUserObj.setPSobj(this.psObj);
        }
        if (fUserObj.getUserType().equals("normal")) {
            EmailAliasObj myalias = new EmailAliasObj(fUserObj.getUserName());
            SolarisAliasesTable em = new SolarisAliasesTable(this.scope);
            String aliasExp = new String(fUserObj.getUserName() + "@" + fUserObj.getMailServer());
            myalias.setAliasExpansion(aliasExp);
            try {
                em.addEmailRow(myalias);
            }
            catch (DirectoryTableRowNotUniqueException ex) {
                String[] args = new String[]{myalias.getAliasName()};
                try {
                    em.modifyEmailRow(myalias, fUserObj.getUserName());
                }
                catch (Exception e) {}
            }
            catch (Exception ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAliasFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2024", "LM_2900", userName, ex.getLocalizedMessage(), null, null);
            }
        }
        if (this.psObj != null) {
            msg = provUtil.writeLog(2, "LM_2024", "LM_2903", userName, null, null, null);
            throw new PartialSuccessException(msg);
        }
        msg = provUtil.writeLog(0, "LM_2045", "LM_2051", userName, null, null, null);
    }

    public synchronized void deleteUser(FlatUserObj fUserObj, ProviderUtility provUtil) throws Exception {
        long uid = 100L;
        try {
            uid = Long.parseLong(fUserObj.getUserUID());
        }
        catch (Exception e) {
            // empty catch block
        }
        String msg = null;
        String userName = fUserObj.getUserName();
        if (uid < 100L || uid == (long)NOBODY || uid == (long)NOBODY4 || uid == (long)NOACCESS) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2901", userName, null, null, null);
            throw new UserException(msg);
        }
        SolarisShadowTable sdTable = null;
        SolarisPasswdTable pwTable = null;
        this.psObj = null;
        try {
            pwTable = new SolarisPasswdTable(this.scope);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2530", userName, null, null, null);
            throw new UserException(msg);
        }
        try {
            sdTable = new SolarisShadowTable(this.scope);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2750", userName, null, null, null);
            throw new UserException(msg);
        }
        try {
            SolarisAutoHomeTable ah = new SolarisAutoHomeTable(this.scope);
            ah.deleteAutoHomeRow(fUserObj);
        }
        catch (DirectoryTableRowNotFoundException e) {
        }
        catch (Exception e) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAutohomeFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2047", "LM_2855", userName, e.getLocalizedMessage(), null, null);
        }
        try {
            sdTable.deleteShadowRow(fUserObj, provUtil);
        }
        catch (Exception e) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setShadowFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2047", "LM_2755", userName, e.getLocalizedMessage(), null, null);
        }
        GroupObj mygrp = new GroupObj();
        mygrp.setGroupName(fUserObj.getPrimaryGroup());
        String[] members = new String[]{""};
        members[0] = fUserObj.getUserName();
        try {
            this.performDeleteUsersFromGroup(mygrp, members);
        }
        catch (DirectoryTableRowNotFoundException e) {
        }
        catch (Exception ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setGroupFailed(true);
            msg = provUtil.writeLog(2, "LM_2047", "LM_2902", userName, fUserObj.getPrimaryGroup(), ex.getLocalizedMessage(), null);
        }
        try {
            SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
            Vector vSecGroups = tbl.getAllSecondaryGroups(fUserObj);
            for (int i = 0; i < vSecGroups.size(); ++i) {
                mygrp.setGroupName((String)vSecGroups.elementAt(i));
                this.performDeleteUsersFromGroup(mygrp, members);
            }
        }
        catch (DirectoryTableRowNotFoundException e) {
        }
        catch (Exception ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setGroupFailed(true);
            msg = provUtil.writeLog(2, "LM_2047", "LM_2904", userName, mygrp.getGroupName(), ex.getLocalizedMessage(), null);
        }
        try {
            EmailAliasObj em = new EmailAliasObj(fUserObj.getUserName());
            SolarisAliasesTable alias = new SolarisAliasesTable(this.scope);
            alias.deleteEmailRow(em);
        }
        catch (DirectoryTableRowNotFoundException e) {
        }
        catch (UserMgrNameNotFoundException ne) {
        }
        catch (Exception ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2047", "LM_2905", userName, ex.getLocalizedMessage(), null, null);
        }
        UserAttrObj userAttr = null;
        if (fUserObj.getAttrKey() != null) {
            userAttr = new UserAttrObj(fUserObj.getUserName());
            userAttr.putAttributeString(fUserObj.getAttrKey());
            userAttr.setUserType(fUserObj.getUserType());
        }
        try {
            UserAttrUpdate attrUpdate = new UserAttrUpdate(provUtil, this.scope);
            attrUpdate.userAttrDelete(fUserObj.getUserName(), userAttr);
        }
        catch (Exception ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setUserattrFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2047", "LM_2906", userName, ex.getLocalizedMessage(), null, null);
        }
        if (!this.deletePrimaryProject(userName)) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setProjectFailed(true);
            fUserObj.setPSobj(this.psObj);
        }
        if (!this.deleteSecondaryProjects(userName)) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setProjectFailed(true);
            fUserObj.setPSobj(this.psObj);
        }
        try {
            pwTable.deletePasswdRow(fUserObj);
        }
        catch (DirectoryTableRowNotFoundException e) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2536", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2530", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2532", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2534", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2531", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2047", "LM_2535", userName, ex.getLocalizedMessage(), null, null);
            throw new UserException(msg);
        }
        if (this.psObj != null) {
            msg = provUtil.writeLog(2, "LM_2027", "LM_2907", userName, null, null, null);
            throw new PartialSuccessException(msg);
        }
        msg = provUtil.writeLog(0, "LM_2044", "LM_2052", userName, null, null, null);
    }

    public synchronized void modifyUser(FlatUserObj fUserObj, ProviderUtility provUtil, CIMObjectPath objPath) throws Exception {
        String newName;
        String msg = "";
        String userName = fUserObj.getNewName();
        String oldName = fUserObj.getUserName();
        if (fUserObj.getNewName() == null) {
            fUserObj.setNewName(oldName);
        }
        if ((newName = fUserObj.getNewName()).trim().length() == 0) {
            fUserObj.setNewName(oldName);
        }
        SolarisPasswdTable pw = null;
        SolarisShadowTable sd = null;
        try {
            pw = new SolarisPasswdTable(this.scope);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2525", userName, null, null, null);
            throw new UserException(msg);
        }
        try {
            sd = new SolarisShadowTable(this.scope);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2745", userName, null, null, null);
            throw new UserException(msg);
        }
        try {
            pw.modifyPasswdRow(fUserObj);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2520", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2522", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2524", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2521", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2526", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (UserMgrNameAlreadyInUseException ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2518", userName, null, null, null);
            throw new UserException(msg);
        }
        catch (Exception ex) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2525", userName, ex.getLocalizedMessage(), null, null);
            throw new UserException(msg);
        }
        this.psObj = null;
        if (!oldName.equals(newName)) {
            try {
                sd.modifyShadowUsername(newName, oldName, provUtil);
            }
            catch (DirectoryTableInvalidParameterException ex) {
                msg = provUtil.writeLog(2, "LM_2005", "LM_2740", null, null, null, null);
                throw new UserException("LM_2090");
            }
            catch (DirectoryTableAccessException ex) {
                msg = provUtil.writeLog(2, "LM_2005", "LM_2742", userName, null, null, null);
                throw new UserException("LM_2092");
            }
            catch (DirectoryTableConnectionException ex) {
                msg = provUtil.writeLog(2, "LM_2005", "LM_2744", userName, null, null, null);
                throw new UserException("LM_2094");
            }
            catch (DirectoryTableDoesNotExistException ex) {
                msg = provUtil.writeLog(2, "LM_2005", "LM_2741", userName, null, null, null);
                throw new UserException("LM_2094");
            }
            catch (DirectoryTableRowNotFoundException ex) {
                msg = provUtil.writeLog(2, "LM_2005", "LM_2747", userName, null, null, null);
                throw new UserException("LM_2094");
            }
            catch (Exception ex) {
                msg = provUtil.writeLog(2, "LM_2005", "LM_2745", userName, ex.getLocalizedMessage(), null, null);
                throw new UserException("LM_2100");
            }
        }
        if (fUserObj.getUserType().equals("normal")) {
            String aliasExp;
            String mailServer;
            SolarisAliasesTable at = new SolarisAliasesTable(this.scope);
            EmailAliasObj em = new EmailAliasObj(newName);
            try {
                EmailAliasObj tmpEm = at.getEmailRow(oldName);
                if (!oldName.equals(newName) || fUserObj.getMailBoxForceModify()) {
                    mailServer = fUserObj.getMailServer();
                    aliasExp = new String(newName + "@" + mailServer);
                    em.setAliasExpansion(aliasExp);
                    try {
                        at.modifyEmailRow(em, oldName);
                    }
                    catch (DirectoryTableRowNotUniqueException ex) {
                        if (this.psObj == null) {
                            this.psObj = new PartialSuccessObject();
                        }
                        this.psObj.setAliasFailed(true);
                        msg = provUtil.writeLog(2, "LM_2005", "LM_2913", userName, ex.getLocalizedMessage(), null, null);
                    }
                    catch (DirectoryTableAccessException ex) {
                        if (this.psObj == null) {
                            this.psObj = new PartialSuccessObject();
                        }
                        this.psObj.setAliasFailed(true);
                        msg = provUtil.writeLog(2, "LM_2005", "LM_2092", userName, null, null, null);
                    }
                    catch (DirectoryTableConnectionException ex) {
                        if (this.psObj == null) {
                            this.psObj = new PartialSuccessObject();
                        }
                        this.psObj.setAliasFailed(true);
                        msg = provUtil.writeLog(2, "LM_2005", "LM_2094", userName, null, null, null);
                    }
                    catch (Exception ex) {
                        if (this.psObj == null) {
                            this.psObj = new PartialSuccessObject();
                        }
                        this.psObj.setAliasFailed(true);
                        msg = provUtil.writeLog(2, "LM_2005", "LM_2913", userName, ex.getLocalizedMessage(), null, null);
                    }
                }
            }
            catch (Exception ex) {
                try {
                    if (fUserObj.getMailServer() != null) {
                        mailServer = fUserObj.getMailServer();
                        aliasExp = new String(newName + "@" + mailServer);
                        em.setAliasExpansion(aliasExp);
                        at.addEmailRow(em);
                    }
                }
                catch (Exception e) {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setAliasFailed(true);
                    msg = provUtil.writeLog(2, "LM_2005", "LM_2913", userName, ex.getLocalizedMessage(), null, null);
                }
            }
        }
        fUserObj.setUserName(newName);
        try {
            if (fUserObj.getPwdForceModify()) {
                if (provUtil.testRights(USER_PSWD_RIGHT, (CIMObjectPath)null)) {
                    sd.addShadowRow(fUserObj, provUtil);
                } else {
                    if (this.psObj == null) {
                        this.psObj = new PartialSuccessObject();
                    }
                    this.psObj.setAliasFailed(true);
                    msg = provUtil.writeLog(2, "LM_2005", "LM_2923", userName, null, null, null);
                }
            } else if (provUtil.testRights(USER_PSWD_RIGHT, (CIMObjectPath)null)) {
                sd.modifyShadowRow(fUserObj, provUtil);
            } else {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAliasFailed(true);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2923", userName, null, null, null);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2740", null, null, null, null);
        }
        catch (DirectoryTableAccessException ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2742", userName, null, null, null);
        }
        catch (DirectoryTableConnectionException ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2744", userName, null, null, null);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2741", userName, null, null, null);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2747", userName, null, null, null);
        }
        catch (Exception ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setAliasFailed(true);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2745", userName, ex.getLocalizedMessage(), null, null);
        }
        fUserObj.setUserName(oldName);
        GroupObj mygrp = new GroupObj();
        mygrp.setGroupName(fUserObj.getPrimaryGroup());
        String[] members = new String[]{""};
        members[0] = oldName;
        String grpName = null;
        try {
            SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
            Vector vSecGroups = tbl.getAllSecondaryGroups(fUserObj);
            for (int i = 0; i < vSecGroups.size(); ++i) {
                mygrp.setGroupName((String)vSecGroups.elementAt(i));
                this.performDeleteUsersFromGroup(mygrp, members);
            }
            if (fUserObj.getSecondaryGroups() != null && fUserObj.getSecondaryGroups().size() != 0) {
                Vector vGrps = fUserObj.getSecondaryGroups();
                String[] newMembers = new String[]{""};
                newMembers[0] = newName;
                mygrp = new GroupObj();
                for (int i = 0; i < vGrps.size(); ++i) {
                    grpName = (String)vGrps.elementAt(i);
                    mygrp.setGroupName(grpName);
                    this.performAddUsersToGroup(mygrp, newMembers);
                }
            }
        }
        catch (GroupNotFoundException ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setGroupFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2922", userName, grpName, null, null);
        }
        catch (Exception ex) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setGroupFailed(true);
            fUserObj.setPSobj(this.psObj);
            msg = provUtil.writeLog(2, "LM_2005", "LM_2912", userName, mygrp.getGroupName(), ex.getLocalizedMessage(), null);
        }
        try {
            SolarisAutoHomeTable ah = new SolarisAutoHomeTable(this.scope);
            ah.deleteAutoHomeRow(fUserObj);
        }
        catch (Exception ex) {
            // empty catch block
        }
        fUserObj.setUserName(newName);
        if (fUserObj.getAutoMountHomeDir()) {
            SolarisAutoHomeTable ahTable = new SolarisAutoHomeTable(this.scope);
            try {
                ahTable.addAutoHomeRow(fUserObj);
            }
            catch (DirectoryTableInvalidParameterException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2840", userName, null, null, null);
            }
            catch (DirectoryTableAccessException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2842", userName, null, null, null);
            }
            catch (DirectoryTableConnectionException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2844", userName, null, null, null);
            }
            catch (DirectoryTableDoesNotExistException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2841", userName, null, null, null);
            }
            catch (DirectoryTableRowNotFoundException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2847", userName, null, null, null);
            }
            catch (Exception ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setAutohomeFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2845", userName, ex.getLocalizedMessage(), null, null);
            }
        }
        fUserObj.setUserName(oldName);
        String newAttributes = fUserObj.getAttrKey();
        String flatPrimaryProject = fUserObj.getPrimaryProject();
        if (!oldName.equals(newName) || newAttributes != null) {
            try {
                UserAttrUpdate attrUpdate = new UserAttrUpdate(provUtil, this.scope);
                UserAttrObj userAttr = null;
                if (newAttributes == null) {
                    userAttr = attrUpdate.userAttrRead(oldName);
                    if (userAttr != null) {
                        userAttr.setUserName(newName);
                    }
                } else {
                    userAttr = new UserAttrObj(newName, fUserObj.getUserType());
                    userAttr.putAttributeString(newAttributes);
                }
                Object attrPrimaryProject = null;
                if (userAttr != null) {
                    userAttr.getPrimaryProject();
                }
                if (fUserObj.getUserType().equals("normal")) {
                    if (userAttr != null) {
                        userAttr.clearAttribute("project");
                    }
                } else if (attrPrimaryProject == null) {
                    if (flatPrimaryProject != null) {
                        userAttr.setPrimaryProject(flatPrimaryProject);
                    }
                } else if (flatPrimaryProject != null) {
                    userAttr.setPrimaryProject(flatPrimaryProject);
                }
                attrUpdate.userAttrModify(oldName, userAttr, objPath);
            }
            catch (UserException ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setUserattrFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2914", userName, ex.getLocalizedMessage(), null, null);
            }
            catch (Exception ex) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setUserattrFailed(true);
                fUserObj.setPSobj(this.psObj);
                msg = provUtil.writeLog(2, "LM_2005", "LM_2914", userName, ex.getLocalizedMessage(), null, null);
            }
        }
        boolean result = true;
        if (fUserObj.getUserType().equals("normal")) {
            try {
                if (!oldName.equals(newName)) {
                    result = this.deletePrimaryProject(oldName);
                }
                if (flatPrimaryProject != null && !this.modifyPrimaryProject(newName, flatPrimaryProject)) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
            }
            if (!result) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setProjectFailed(true);
                fUserObj.setPSobj(this.psObj);
            }
        }
        result = true;
        try {
            if (!oldName.equals(newName)) {
                result = this.deleteSecondaryProjects(oldName);
            }
            if (!this.modifySecondaryProjects(newName, fUserObj.getSecondaryProjects())) {
                result = false;
            }
            if (!result) {
                if (this.psObj == null) {
                    this.psObj = new PartialSuccessObject();
                }
                this.psObj.setProjectFailed(true);
                fUserObj.setPSobj(this.psObj);
            }
        }
        catch (Exception e) {
            if (this.psObj == null) {
                this.psObj = new PartialSuccessObject();
            }
            this.psObj.setProjectFailed(true);
            fUserObj.setPSobj(this.psObj);
        }
        if (this.psObj != null) {
            msg = provUtil.writeLog(2, "LM_2005", "LM_2915", userName, null, null, null);
            throw new PartialSuccessException(msg);
        }
        msg = provUtil.writeLog(0, "LM_2004", "LM_2053", userName, null, null, null);
    }

    private String parseForMailServer(String exp, String userName) throws Exception {
        String tmp;
        StringTokenizer tk;
        if (exp == null) {
            // empty if block
        }
        if (exp.trim().length() == 0) {
            // empty if block
        }
        if ((tk = new StringTokenizer(exp, "@")).countTokens() < 2) {
            // empty if block
        }
        if (!(tmp = tk.nextToken()).equals(userName)) {
            // empty if block
        }
        if (!tk.hasMoreTokens()) {
            throw new Exception("Failed");
        }
        tmp = tk.nextToken();
        return tmp;
    }

    private GroupObj performAddUsersToGroup(GroupObj grp, String[] members) throws Exception {
        block8: {
            if (grp.getGroupName() == null) {
                return grp;
            }
            SolarisGroupTable grpTable = null;
            grpTable = new SolarisGroupTable(this.scope);
            GroupObj localGroup = new GroupObj();
            grp = grpTable.getGroupRow(grp);
            String users = SolarisGroupTable.formatMembersIntoString(grp.getGroupUsers());
            if (users != "") {
                users = users.concat(",");
            }
            String testUsers = new StringBuffer().append(",").append(users).append(",").toString();
            for (int i = 0; i < members.length; ++i) {
                String tryUser = new StringBuffer().append(",").append(members[i]).append(",").toString();
                if (testUsers.indexOf(tryUser) != -1) continue;
                users = users.concat(members[i]);
                users = users.concat(",");
            }
            users = users.substring(0, users.length() - 1);
            grp.setGroupUsers(SolarisGroupTable.parseMembersIntoArray(users));
            if (grp.getGroupID() == null) break block8;
            boolean bGrp = grpTable.doesGroupExist(grp);
            if (bGrp) {
                grpTable.modifyGroupRow(grp);
                break block8;
            }
            throw new GroupNotFoundException("");
        }
        return grp;
    }

    private GroupObj performDeleteUsersFromGroup(GroupObj grpObj, String[] members) throws Exception {
        SolarisGroupTable grpTable = new SolarisGroupTable(this.scope);
        GroupObj localGroup = new GroupObj();
        localGroup = grpTable.getGroupRow(grpObj);
        String[] usersArray = localGroup.getGroupUsers();
        String users = "";
        boolean delThisOne = false;
        for (int i = 0; i < usersArray.length; ++i) {
            for (int j = 0; j < members.length; ++j) {
                if (!usersArray[i].equals(members[j])) continue;
                delThisOne = true;
            }
            if (!delThisOne) {
                if (!users.equals("")) {
                    users = users.concat(",");
                }
                users = users.concat(usersArray[i]);
                continue;
            }
            delThisOne = false;
        }
        localGroup.setGroupUsers(SolarisGroupTable.parseMembersIntoArray(users));
        grpTable.modifyGroupRow(localGroup);
        return localGroup;
    }

    private boolean isVectorEmpty(Vector v1) {
        if (v1 == null) {
            return true;
        }
        if (v1.isEmpty()) {
            return true;
        }
        String dblCheck = (String)v1.elementAt(0);
        return dblCheck.trim().length() == 0;
    }

    private boolean modifyPrimaryProject(String userName, String primaryProject) throws Exception {
        try {
            ProjectObj actualProj;
            ProjectObj projObj;
            SolarisUserAttrTable uat;
            block18: {
                SolarisProjectTable pt;
                block17: {
                    if (this.isNISPlusScope) {
                        return true;
                    }
                    pt = new SolarisProjectTable(this.scope);
                    uat = new SolarisUserAttrTable(this.scope);
                    projObj = new ProjectObj(primaryProject);
                    actualProj = null;
                    try {
                        projObj = pt.getProjectRow(projObj);
                    }
                    catch (ProjectException pe) {
                    }
                    catch (DirectoryTableException de) {
                        return false;
                    }
                    if (primaryProject.equals(pt.DEFAULT_PROJECT_NAME) || primaryProject.equals(pt.STAFF_PROJECT_NAME)) {
                        ProjectObj userDot = new ProjectObj("user." + userName);
                        try {
                            pt.deleteProjectRow(userDot);
                        }
                        catch (ProjectException pe) {
                            // empty catch block
                        }
                        return true;
                    }
                    if (primaryProject.startsWith("user.")) break block17;
                    if (!primaryProject.startsWith("group.")) break block18;
                }
                if ((actualProj = this.getActualProject(pt, projObj.getProjectID())) == null) {
                    return false;
                }
            }
            String ID = null;
            ID = actualProj != null ? actualProj.getProjectID() : projObj.getProjectID();
            if (uat == null) {
                return false;
            }
            UserAttrObj uao = uat.readUserAttr(userName);
            if (uao == null) {
                uao = uat.newUserAttr(userName);
            }
            uao.setPrimaryProject(primaryProject);
            uat.writeUserAttr(uao);
            return true;
        }
        catch (DirectoryTableException ex) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean deletePrimaryProject(String userName) {
        block5: {
            try {
                if (this.isNISPlusScope) {
                    return true;
                }
                SolarisProjectTable pt = new SolarisProjectTable(this.scope);
                SolarisUserAttrTable uat = new SolarisUserAttrTable(this.scope);
                if (uat != null) {
                    UserAttrObj uao = uat.readUserAttr(userName);
                    if (uao != null) {
                        String[] primaryProjetArray = new String[]{uao.getPrimaryProject()};
                        uao.delPrimaryProject(primaryProjetArray);
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception ex) {
                this.provUtil.writeLog(2, "LM_2047", "LM_2950", userName, ex.getLocalizedMessage(), null, null);
                return false;
            }
        }
        return true;
    }

    private boolean deleteSecondaryProjects(String userName) throws Exception {
        try {
            if (this.isNISPlusScope) {
                return true;
            }
            SolarisProjectTable pt = new SolarisProjectTable(this.scope);
            Enumeration allProjects = pt.getAllProjectRows().elements();
            Object[] users = null;
            while (allProjects.hasMoreElements()) {
                ProjectObj tempProjObj = (ProjectObj)allProjects.nextElement();
                users = tempProjObj.getProjectUsers();
                int j = 0;
                String[] newUsers = null;
                if (users != null) {
                    Arrays.sort(users);
                    if (Arrays.binarySearch(users, userName) >= 0) {
                        if (users.length == 1) {
                            newUsers = null;
                            j = 1;
                        } else {
                            newUsers = new String[users.length - 1];
                            for (int i = 0; i < users.length; ++i) {
                                if (userName.equals(users[i])) continue;
                                newUsers[j] = users[i];
                                ++j;
                            }
                        }
                    }
                }
                if (j <= 0) continue;
                tempProjObj.setProjectUsers(newUsers);
                pt.modifyProjectRow(tempProjObj);
            }
        }
        catch (DirectoryTableException dte) {
            this.provUtil.writeLog(2, "LM_2047", "LM_2951", userName, dte.getLocalizedMessage(), null, null);
            return false;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_2047", "LM_2951", userName, e.getLocalizedMessage(), null, null);
        }
        return true;
    }

    private boolean modifySecondaryProjects(String userName, Vector addProjectNames) throws Exception {
        try {
            if (this.isNISPlusScope || addProjectNames == null) {
                return true;
            }
            SolarisProjectTable pt = new SolarisProjectTable(this.scope);
            Vector allProjects = pt.getAllProjectRows();
            Enumeration curSecProjects = this.getSecondaryProjects(userName, allProjects).elements();
            Vector<String> delProjectNames = new Vector<String>(20);
            ProjectObj tempProject = null;
            String tempProjectName = null;
            while (curSecProjects.hasMoreElements()) {
                tempProject = (ProjectObj)curSecProjects.nextElement();
                tempProjectName = tempProject.getProjectName();
                if (addProjectNames.contains(tempProjectName)) {
                    addProjectNames.remove(tempProjectName);
                    continue;
                }
                delProjectNames.add(tempProjectName);
            }
            Enumeration deletes = delProjectNames.elements();
            String[] users = null;
            Vector<String> vUsers = null;
            while (deletes.hasMoreElements()) {
                ProjectObj tempProjObj = new ProjectObj((String)deletes.nextElement());
                tempProjObj = pt.getProjectRow(tempProjObj);
                users = tempProjObj.getProjectUsers();
                vUsers = new Vector<String>(users.length);
                for (int q = 0; q < users.length; ++q) {
                    if (userName.equals(users[q])) continue;
                    vUsers.add(users[q]);
                }
                tempProjObj.setProjectUsers(this.toStringArray(vUsers));
                pt.modifyProjectRow(tempProjObj);
            }
            if (addProjectNames != null) {
                Enumeration adds = addProjectNames.elements();
                while (adds.hasMoreElements()) {
                    ProjectObj tempProjObj = new ProjectObj((String)adds.nextElement());
                    users = (tempProjObj = pt.getProjectRow(tempProjObj)).getProjectUsers();
                    if (users != null) {
                        vUsers = new Vector(users.length);
                        for (int i = 0; i < users.length; ++i) {
                            vUsers.add(users[i]);
                        }
                    }
                    vUsers.add(userName);
                    tempProjObj.setProjectUsers(this.toStringArray(vUsers));
                    pt.modifyProjectRow(tempProjObj);
                }
            }
        }
        catch (DirectoryTableException dte) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private ProjectObj getActualProject(SolarisProjectTable pt, String ID) {
        try {
            if (this.isNISPlusScope) {
                return null;
            }
            Vector allProjects = pt.getAllProjectRows();
            ProjectObj projEntry = null;
            Enumeration e = allProjects.elements();
            String projName = null;
            while (e.hasMoreElements()) {
                projEntry = (ProjectObj)e.nextElement();
                if (projEntry == null) continue;
                projName = projEntry.getProjectName();
                if (projName.startsWith("user.")) continue;
                if (projName.startsWith("group.") || !ID.equals(projEntry.getProjectID())) continue;
                return projEntry;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private Vector getSecondaryProjects(String user, Vector allProjects) {
        try {
            if (user == null || this.isNISPlusScope) {
                return null;
            }
            if (allProjects == null) {
                SolarisProjectTable pt = new SolarisProjectTable(this.scope);
                allProjects = pt.getAllProjectRows();
            }
            Vector<ProjectObj> secondaryProjects = new Vector<ProjectObj>(20);
            ProjectObj projEntry = null;
            String[] allUsers = null;
            Enumeration e = allProjects.elements();
            block2: while (e.hasMoreElements()) {
                projEntry = (ProjectObj)e.nextElement();
                allUsers = projEntry.getProjectUsers();
                for (int i = 0; i < allUsers.length; ++i) {
                    if (!allUsers[i].equals(user)) continue;
                    secondaryProjects.add(projEntry);
                    continue block2;
                }
            }
            return secondaryProjects;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Vector getSecondaryProjectNames(String user, Vector allProjects) {
        try {
            if (user == null || this.isNISPlusScope) {
                return null;
            }
            Vector<String> projectNames = new Vector<String>(20);
            ProjectObj projEntry = null;
            Enumeration e = this.getSecondaryProjects(user, allProjects).elements();
            while (e.hasMoreElements()) {
                projEntry = (ProjectObj)e.nextElement();
                projectNames.add(projEntry.getProjectName());
            }
            return projectNames;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] toStringArray(Vector v) {
        try {
            Enumeration e = v.elements();
            String[] s = new String[v.size()];
            int i = 0;
            while (e.hasMoreElements()) {
                s[i] = (String)e.nextElement();
                ++i;
            }
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isScopeNISPlus() {
        String myScopeType = this.provUtil.getScopeType(this.scope);
        this.isNISPlusScope = myScopeType.equals("nisplus");
        return this.isNISPlusScope;
    }
}

