/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.common.ProviderFilter;
import com.sun.wbem.solarisprovider.usermgr.common.PartialSuccessException;
import com.sun.wbem.solarisprovider.usermgr.common.SolAccountAttr;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.LightUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisPasswdTable;
import com.sun.wbem.solarisprovider.usermgr.users.UMgrWrapper;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrUpdate;
import com.sun.wbem.solarisprovider.usermgr.users.UserProviderDirectoryFilter;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;

public class Solaris_UserAccount
extends UMgrProvider
implements MethodProvider,
Authorizable {
    private static final String COMPLETE_CLASS = "Solaris_UserAccount";
    private static final String SUPER_CLASS = "CIM_Account";
    private static String CAPTION = "Caption";
    private static String DESCRIPTION = "Description";
    private static String INSTALL_DATE = "InstallDate";
    private static String STATUS = "Status";
    private static String DOMAIN_TYPE = "SystemCreationClassName";
    private static String DOMAIN_NAME = "SystemName";
    private static String CREATION_NAME = "CreationClassName";
    private static String NAME = "Name";
    private static String USER_ID = "UserID";
    private static String DESCRIPTONS = "Descriptions";
    private static String HOSTS = "Host";
    private static String LOCALITIES = "LocalityName";
    private static String ORGAN_NAMES = "OrganizationalName";
    private static String OUS = "OU";
    private static String SEE_ALSOS = "SeeAlso";
    private static String USER_CERT = "UserCertificate";
    private static String PASSWORDS = "UserPassword";
    private static String USER_UID = "userUID";
    private static String USER_PSWD = "loginPassword";
    private static String FULL_NAME = "fullName";
    private static String USER_DESCR = "userDescr";
    private static String USER_TYPE = "userType";
    private static String PRIM_GROUP = "primaryGroup";
    private static String SEC_GROUPS = "secondaryGroups";
    private static String ACCNT_EXPIRE = "accountExpireDate";
    private static String ACCNT_LOCKED = "isAccountLocked";
    private static String MUST_CHNG_PWD = "mustChangePasswdInDays";
    private static String DO_NOT_REUSE_PWD = "doNotReusePwdForDays";
    private static String WARN_PWD = "warnBeforePwdExpiresDays";
    private static String PWD_INACTIVE = "pwdInactiveDays";
    private static String CHANGE_PWD = "changePasswd";
    private static String HAS_PWD = "hasPasswd";
    private static String PWD_FRC_MOD = "pwdForceModify";
    private static String HOME_DIR_SERVER = "homeDirServer";
    private static String HOME_DIR_PATH = "homeDirPathName";
    private static String AUTOMOUNT = "autoMountHomeDir";
    private static String HOME_DIR_FRC_MOD = "homeDirForceModify";
    private static String HOME_DIR_ALLOW_MOD = "homeDirAllowModifyServer";
    private static String OWNER_PERMS = "ownerPerms";
    private static String GROUP_PERMS = "groupPerms";
    private static String WORLD_PERMS = "worldPerms";
    private static String INIT_FILE_PATH = "initFilePath";
    private static String MAIL_SERVER = "mailServer";
    private static String MBOX_ALLOW_MOD = "mailBoxAllowModifyServer";
    private static String MBOX_FRC_MOD = "mailBoxForceModify";
    private static String INIT_SHELL = "initialShell";
    private static String TEMPLATE_NAME = "templateName";
    private static String ATTR_KEY = "SolarisAttrKeyValue";
    private static String NEW_NAME = "newName";
    private static String PRIMARY_PROJECT = "primaryProject";
    private static String SECONDARY_PROJECTS = "secondaryProjects";
    private String GMT_TIMEZONE = "GMT";
    protected String providerName = "Solaris_UserAccount";

    public CIMObjectPath createInstance(CIMObjectPath objPath, CIMInstance cimInst) throws CIMException {
        String cn = objPath.getObjectName();
        if (!cn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String scope = null;
        scope = this.provUtil.getMgmtScope(objPath);
        String type = this.getStringValue(cimInst, USER_TYPE);
        if (type == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (!type.equals("normal") && !type.equals("role")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.checkUserUpdateRights(type, objPath);
        String userID = this.getStringValue(cimInst, NAME);
        if (userID == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String uid = this.getStringValue(cimInst, USER_UID);
        if (uid == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String ccn = this.getStringValue(cimInst, CREATION_NAME);
        if (ccn != null && !ccn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String sid = this.getStringValue(cimInst, USER_ID);
        if (sid != null && !userID.equals(sid)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String userPwd = this.getStringValue(cimInst, USER_PSWD);
        String fName = this.getStringValue(cimInst, FULL_NAME);
        String uDescr = this.getStringValue(cimInst, USER_DESCR);
        String priGrp = this.getStringValue(cimInst, PRIM_GROUP);
        Vector vSecGrps = this.getVectorValue(cimInst, SEC_GROUPS);
        CIMDateTime datetime = this.getDateValue(cimInst, ACCNT_EXPIRE);
        String expDat = null;
        if (datetime != null) {
            Calendar cal = datetime.getCalendar();
            Date tempDate = cal.getTime();
            expDat = this.convertDateToString(tempDate);
        }
        boolean isLock = this.getBooleanValue(cimInst, ACCNT_LOCKED);
        String mChgPwd = this.getStringValue(cimInst, MUST_CHNG_PWD);
        String noReUse = this.getStringValue(cimInst, DO_NOT_REUSE_PWD);
        String warn = this.getStringValue(cimInst, WARN_PWD);
        String inactive = this.getStringValue(cimInst, PWD_INACTIVE);
        boolean chgPwd = this.getBooleanValue(cimInst, CHANGE_PWD);
        boolean hasPwd = this.getBooleanValue(cimInst, HAS_PWD);
        boolean frcMod = this.getBooleanValue(cimInst, PWD_FRC_MOD);
        String homeSrv = this.getStringValue(cimInst, HOME_DIR_SERVER);
        String homePth = this.getStringValue(cimInst, HOME_DIR_PATH);
        boolean autoMnt = this.getBooleanValue(cimInst, AUTOMOUNT);
        boolean dirMod = this.getBooleanValue(cimInst, HOME_DIR_FRC_MOD);
        boolean modSrv = this.getBooleanValue(cimInst, HOME_DIR_ALLOW_MOD);
        String oPerms = this.getStringValue(cimInst, OWNER_PERMS);
        String gPerms = this.getStringValue(cimInst, GROUP_PERMS);
        String wPerms = this.getStringValue(cimInst, WORLD_PERMS);
        String filePath = this.getStringValue(cimInst, INIT_FILE_PATH);
        String mailSrv = this.getStringValue(cimInst, MAIL_SERVER);
        boolean mboxMod = this.getBooleanValue(cimInst, MBOX_ALLOW_MOD);
        boolean mboxFrc = this.getBooleanValue(cimInst, MBOX_FRC_MOD);
        String shell = this.getStringValue(cimInst, INIT_SHELL);
        String tName = this.getStringValue(cimInst, TEMPLATE_NAME);
        String attrKey = this.getStringValue(cimInst, ATTR_KEY);
        String primaryProject = this.getStringValue(cimInst, PRIMARY_PROJECT);
        Vector vSecondaryProjects = this.getVectorValue(cimInst, SECONDARY_PROJECTS);
        UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
        FlatUserObj flatUserObj = new FlatUserObj();
        flatUserObj.setUserName(userID);
        flatUserObj.setUserUID(uid);
        flatUserObj.setCurPassword(userPwd);
        flatUserObj.setFullName(fName);
        flatUserObj.setUserDescr(uDescr);
        flatUserObj.setUserType(type);
        flatUserObj.setPrimaryGroup(priGrp);
        flatUserObj.setSecondaryGroups(vSecGrps);
        flatUserObj.setAccountExpireDate(expDat);
        flatUserObj.setIsAccountLocked(isLock);
        flatUserObj.setMustChangePasswdInDays(mChgPwd);
        flatUserObj.setDoNotReUsePwdForDays(noReUse);
        flatUserObj.setWarnBeforePwdExpiresDays(warn);
        flatUserObj.setPwdInactiveDays(inactive);
        flatUserObj.setChangePasswd(chgPwd);
        flatUserObj.setHasPasswd(hasPwd);
        flatUserObj.setPwdForceModify(frcMod);
        flatUserObj.setHomeDirServer(homeSrv);
        flatUserObj.setHomeDirPathName(homePth);
        flatUserObj.setAutoMountHomeDir(autoMnt);
        flatUserObj.setHomeDirForceModify(dirMod);
        flatUserObj.setHomeDirAllowModifyServer(modSrv);
        flatUserObj.setOwnerPerms(oPerms);
        flatUserObj.setGroupPerms(gPerms);
        flatUserObj.setWorldPerms(wPerms);
        flatUserObj.setInitFilePath(filePath);
        flatUserObj.setMailServer(mailSrv);
        flatUserObj.setMailBoxAllowModifyServer(mboxMod);
        flatUserObj.setMailBoxForceModify(mboxFrc);
        flatUserObj.setInitialShell(shell);
        flatUserObj.setTemplateName(tName);
        flatUserObj.setAttrKey(attrKey);
        flatUserObj.setPrimaryProject(primaryProject);
        flatUserObj.setSecondaryProjects(vSecondaryProjects);
        boolean isPartialSuccess = false;
        String partialSuccessMessage = null;
        try {
            uMgrWrapper.addUser(flatUserObj, this.provUtil, objPath);
        }
        catch (UserMgrNameAlreadyInUseException ex) {
            throw new CIMException("CIM_ERR_ALREADY_EXISTS", (Object)ex.getMessage());
        }
        catch (PartialSuccessException pex) {
            isPartialSuccess = true;
            partialSuccessMessage = pex.getMessage();
        }
        catch (UserException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            InstanceProvider internalProv = this.cimomhandle.getInternalProvider();
            CIMObjectPath op = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
            CIMClass cc = this.cimomhandle.getClass(op, false, true, true, null);
            CIMInstance perCI = cc.newInstance();
            if (userID != null) {
                perCI.setProperty(NAME, new CIMValue((Object)userID));
            }
            if (fName == null || fName.trim().length() == 0) {
                fName = userID;
            }
            perCI.setProperty(FULL_NAME, new CIMValue((Object)fName));
            internalProv.createInstance(op, perCI);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_UserAccount createInstance() : null WbemAuditSession.");
                throw new UserException("");
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_UserAccount createInstance() : null platform AuditSession.");
                throw new UserException("");
            }
            AuditEvent_usermgr_add userAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (userAddEvent == null) {
                Debug.trace1((String)"Solaris_UserAccount createInstance() : null AuditEvent_usermgr_add.");
                throw new UserException("");
            }
            String auth = null;
            auth = type.equals("normal") ? "solaris.admin.usermgr.write" : "solaris.role.write";
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(cimInst);
            userAddEvent.object_name(cn);
            userAddEvent.domain(this.provUtil.getDomainToken(scope));
            userAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            userAddEvent.auth_used(auth);
            userAddEvent.initial_values(propertyToken);
            userAddEvent.putEvent(0, 0);
        }
        catch (UserException uex) {
            if (isPartialSuccess) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)partialSuccessMessage);
            }
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_UserAccount createInstance() : Auditing threw exception", (Throwable)ex);
        }
        if (isPartialSuccess) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)partialSuccessMessage);
        }
        return null;
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        String userName = null;
        String scope = null;
        String cn = null;
        cn = cp.getObjectName();
        if (!cn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        scope = this.provUtil.getMgmtScope(cp);
        Enumeration e = cp.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMValue cv;
            CIMProperty cprop = null;
            cprop = (CIMProperty)e.nextElement();
            if (cprop == null) continue;
            if (cprop.getName().equalsIgnoreCase(NAME) && (cv = cprop.getValue()) != null) {
                userName = (String)cv.getValue();
            }
            if (!cprop.getName().equalsIgnoreCase(CREATION_NAME) || (cv = cprop.getValue()) == null) continue;
            cn = (String)cv.getValue();
        }
        if (userName == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (cn != null && !cn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        FlatUserObj fUserObj = new FlatUserObj();
        boolean isPartialSuccess = false;
        String partialSuccessMessage = null;
        try {
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            fUserObj.setUserName(userName);
            fUserObj = uMgrWrapper.getUser(fUserObj, this.provUtil);
            if (fUserObj.getAttrKey() == null || fUserObj.getAttrKey().trim().equals("")) {
                fUserObj.setUserType("normal");
            }
            this.checkUserUpdateRights(fUserObj.getUserType(), cp);
            uMgrWrapper.deleteUser(fUserObj, this.provUtil);
        }
        catch (PartialSuccessException pex) {
            isPartialSuccess = true;
            partialSuccessMessage = pex.getMessage();
        }
        catch (UserException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            InstanceProvider internalProv = this.cimomhandle.getInternalProvider();
            CIMObjectPath cop = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
            cop.addKey(NAME, new CIMValue((Object)userName));
            internalProv.deleteInstance(cop);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_UserAccount deleteInstance() : null WbemAuditSession.");
                throw new UserException("");
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_UserAccount deleteInstance() : null platform AuditSession.");
                throw new UserException("");
            }
            AuditEvent_usermgr_delete userDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (userDelEvent == null) {
                Debug.trace1((String)"Solaris_UserAccount deleteInstance() : null AuditEvent_usermgr_delete.");
                throw new UserException("");
            }
            String auth = null;
            auth = fUserObj.getUserType().equals("normal") ? "solaris.admin.usermgr.write" : "solaris.role.write";
            userDelEvent.object_name(cn);
            userDelEvent.domain(this.provUtil.getDomainToken(scope));
            userDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            userDelEvent.auth_used(auth);
            userDelEvent.delete_values(userName);
            userDelEvent.putEvent(0, 0);
        }
        catch (UserException uex) {
            if (isPartialSuccess) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)partialSuccessMessage);
            }
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_UserAccount deleteInstance() : Auditing threw exception", (Throwable)ex);
        }
        if (isPartialSuccess) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)partialSuccessMessage);
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        String cn = cc.getName();
        if (cn.equals(SUPER_CLASS)) {
            return new CIMObjectPath[0];
        }
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        Vector<CIMObjectPath> vKeyPaths = new Vector<CIMObjectPath>();
        Vector vUsers = null;
        UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
        try {
            vUsers = uMgrWrapper.getAllFlatUsers();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        String domType = this.provUtil.getScopeClassType(scope);
        String domName = this.provUtil.getScopeDomainName(scope);
        String ns = op.getNameSpace();
        for (int i = 0; vUsers != null && i < vUsers.size(); ++i) {
            FlatUserObj flatUserObj = (FlatUserObj)vUsers.elementAt(i);
            CIMObjectPath cop = new CIMObjectPath(COMPLETE_CLASS, ns);
            cop.addKey("SystemCreationClassName", new CIMValue((Object)domType));
            cop.addKey("SystemName", new CIMValue((Object)domName));
            cop.addKey(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
            cop.addKey(NAME, new CIMValue((Object)flatUserObj.getUserName()));
            vKeyPaths.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[vKeyPaths.size()];
        vKeyPaths.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        String cn = cc.getName();
        if (cn.equals(SUPER_CLASS)) {
            return new CIMInstance[0];
        }
        String scope = this.provUtil.getMgmtScope(op);
        Vector<CIMInstance> vInstances = new Vector<CIMInstance>();
        Vector vUsers = null;
        UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
        try {
            vUsers = uMgrWrapper.getAllFlatUsers();
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        String domType = this.provUtil.getScopeClassType(scope);
        String domName = this.provUtil.getScopeDomainName(scope);
        InstanceProvider iProv = null;
        CIMClass pcc = null;
        try {
            iProv = this.cimomhandle.getInternalProvider();
            CIMObjectPath pcop = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
            pcc = this.cimomhandle.getClass(pcop, false, true, true, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; vUsers != null && i < vUsers.size(); ++i) {
            FlatUserObj fUserObj = (FlatUserObj)vUsers.elementAt(i);
            String userName = fUserObj.getUserName();
            FlatUserObj newFUserObj = null;
            try {
                newFUserObj = uMgrWrapper.getUser(fUserObj, this.provUtil);
            }
            catch (UserException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            catch (Exception ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            String fName = this.readFullName(iProv, pcc, userName);
            newFUserObj.setFullName(fName);
            CIMInstance ci = this.buildInstance(cc, domType, domName, newFUserObj);
            vInstances.addElement(ci);
        }
        CIMInstance[] ciArray = new CIMInstance[vInstances.size()];
        vInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        Vector<CIMInstance> vInstances = new Vector<CIMInstance>();
        this.checkRights("solaris.admin.usermgr.read", op);
        String cn = op.getObjectName();
        if (!cn.equals(COMPLETE_CLASS)) {
            return null;
        }
        Object ccn = null;
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        ProviderFilter pf = null;
        UserProviderDirectoryFilter pdf = null;
        try {
            pf = new ProviderFilter(cc, query);
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        try {
            pdf = new UserProviderDirectoryFilter(pf);
        }
        catch (Exception ex) {
            pdf = null;
        }
        UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
        String domType = this.provUtil.getScopeClassType(scope);
        String domName = this.provUtil.getScopeDomainName(scope);
        Vector vUsers = null;
        FlatUserObj fuo = new FlatUserObj();
        try {
            vUsers = pdf != null ? uMgrWrapper.getAllLightUsers(pdf) : uMgrWrapper.getAllLightUsers();
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        InstanceProvider iProv = null;
        CIMClass pcc = null;
        try {
            iProv = this.cimomhandle.getInternalProvider();
            CIMObjectPath pcop = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
            pcc = this.cimomhandle.getClass(pcop, false, true, true, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; vUsers != null && i < vUsers.size(); ++i) {
            LightUserObj lUserObj = (LightUserObj)vUsers.elementAt(i);
            String userName = lUserObj.getUserName();
            String userType = lUserObj.getUserType();
            fuo.setUserName(userName);
            fuo.setUserType(userType);
            FlatUserObj newFUserObj = null;
            try {
                newFUserObj = uMgrWrapper.getUser(fuo, this.provUtil);
            }
            catch (UserException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            catch (Exception ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            String fName = this.readFullName(iProv, pcc, userName);
            newFUserObj.setFullName(fName);
            CIMInstance ci = this.buildInstance(cc, domType, domName, newFUserObj);
            if (pdf == null && !pf.apply(ci)) continue;
            vInstances.addElement(pf.project(ci));
        }
        CIMInstance[] ciArray = new CIMInstance[vInstances.size()];
        vInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        String cn = op.getObjectName();
        if (!cn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        String userName = null;
        String scope = null;
        String ccn = null;
        scope = this.provUtil.getMgmtScope(op);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMValue cv;
            CIMProperty cp = null;
            cp = (CIMProperty)e.nextElement();
            if (cp == null) continue;
            if (cp.getName().equalsIgnoreCase(NAME) && (cv = cp.getValue()) != null) {
                userName = (String)cv.getValue();
            }
            if (!cp.getName().equalsIgnoreCase(CREATION_NAME) || (cv = cp.getValue()) == null) continue;
            ccn = (String)cv.getValue();
        }
        if (userName == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (ccn != null && !ccn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
        FlatUserObj fUserObj = new FlatUserObj();
        fUserObj.setUserName(userName);
        FlatUserObj newFUserObj = null;
        try {
            newFUserObj = uMgrWrapper.getUser(fUserObj, this.provUtil);
        }
        catch (UserException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        InstanceProvider iProv = null;
        CIMClass pcc = null;
        try {
            iProv = this.cimomhandle.getInternalProvider();
            CIMObjectPath pcop = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
            pcc = this.cimomhandle.getClass(pcop, false, true, true, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String fName = this.readFullName(iProv, pcc, userName);
        newFUserObj.setFullName(fName);
        String domType = this.provUtil.getScopeClassType(scope);
        String domName = this.provUtil.getScopeDomainName(scope);
        CIMInstance ci = this.buildInstance(cc, domType, domName, newFUserObj);
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public void setInstance(CIMObjectPath objP, CIMInstance cimInst) throws CIMException {
        String uid;
        String cn = objP.getObjectName();
        if (!cn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String scope = null;
        String userID = null;
        String ccn = null;
        scope = this.provUtil.getMgmtScope(objP);
        Enumeration e = objP.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMValue cv;
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp == null) continue;
            if (cp.getName().equalsIgnoreCase(NAME) && (cv = cp.getValue()) != null) {
                userID = (String)cv.getValue();
            }
            if (!cp.getName().equalsIgnoreCase(CREATION_NAME) || (cv = cp.getValue()) == null) continue;
            ccn = (String)cv.getValue();
        }
        if (userID == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (ccn != null && !ccn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String type = this.getStringValue(cimInst, USER_TYPE);
        if (type == null) {
            type = new String("normal");
        }
        if ((uid = this.getStringValue(cimInst, USER_UID)) == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        ccn = this.getStringValue(cimInst, CREATION_NAME);
        if (ccn != null && !ccn.equals(COMPLETE_CLASS)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String sid = this.getStringValue(cimInst, USER_ID);
        if (sid != null && !userID.equals(sid)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String userPwd = this.getStringValue(cimInst, USER_PSWD);
        String fName = this.getStringValue(cimInst, FULL_NAME);
        String uDescr = this.getStringValue(cimInst, USER_DESCR);
        String priGrp = this.getStringValue(cimInst, PRIM_GROUP);
        Vector vSecGrps = this.getVectorValue(cimInst, SEC_GROUPS);
        CIMDateTime datetime = this.getDateValue(cimInst, ACCNT_EXPIRE);
        String expDat = "";
        if (datetime != null) {
            Calendar cal = datetime.getCalendar();
            Date tempDate = cal.getTime();
            expDat = this.convertDateToString(tempDate);
        }
        boolean isLock = this.getBooleanValue(cimInst, ACCNT_LOCKED);
        String mChgPwd = this.getStringValue(cimInst, MUST_CHNG_PWD);
        String noReUse = this.getStringValue(cimInst, DO_NOT_REUSE_PWD);
        String warn = this.getStringValue(cimInst, WARN_PWD);
        String inactive = this.getStringValue(cimInst, PWD_INACTIVE);
        boolean chgPwd = this.getBooleanValue(cimInst, CHANGE_PWD);
        boolean hasPwd = this.getBooleanValue(cimInst, HAS_PWD);
        boolean frcMod = this.getBooleanValue(cimInst, PWD_FRC_MOD);
        String homeSrv = this.getStringValue(cimInst, HOME_DIR_SERVER);
        String homePth = this.getStringValue(cimInst, HOME_DIR_PATH);
        boolean autoMnt = this.getBooleanValue(cimInst, AUTOMOUNT);
        boolean dirMod = this.getBooleanValue(cimInst, HOME_DIR_FRC_MOD);
        boolean modSrv = this.getBooleanValue(cimInst, HOME_DIR_ALLOW_MOD);
        String oPerms = this.getStringValue(cimInst, OWNER_PERMS);
        String gPerms = this.getStringValue(cimInst, GROUP_PERMS);
        String wPerms = this.getStringValue(cimInst, WORLD_PERMS);
        String filePath = this.getStringValue(cimInst, INIT_FILE_PATH);
        String mailSrv = this.getStringValue(cimInst, MAIL_SERVER);
        boolean mboxMod = this.getBooleanValue(cimInst, MBOX_ALLOW_MOD);
        boolean mboxFrc = this.getBooleanValue(cimInst, MBOX_FRC_MOD);
        String shell = this.getStringValue(cimInst, INIT_SHELL);
        String tName = this.getStringValue(cimInst, TEMPLATE_NAME);
        String attrKey = this.getStringValue(cimInst, ATTR_KEY);
        String newName = this.getStringValue(cimInst, NEW_NAME);
        String primaryProject = this.getStringValue(cimInst, PRIMARY_PROJECT);
        Vector vSecondaryProjects = this.getVectorValue(cimInst, SECONDARY_PROJECTS);
        UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
        if (newName == null) {
            newName = userID;
        }
        if (newName.trim().length() == 0) {
            newName = userID;
        }
        FlatUserObj flatUserObj = new FlatUserObj();
        flatUserObj.setUserName(userID);
        flatUserObj.setUserUID(uid);
        flatUserObj.setCurPassword(userPwd);
        flatUserObj.setFullName(fName);
        flatUserObj.setUserDescr(uDescr);
        flatUserObj.setUserType(type);
        flatUserObj.setPrimaryGroup(priGrp);
        flatUserObj.setSecondaryGroups(vSecGrps);
        flatUserObj.setAccountExpireDate(expDat);
        flatUserObj.setIsAccountLocked(isLock);
        flatUserObj.setMustChangePasswdInDays(mChgPwd);
        flatUserObj.setDoNotReUsePwdForDays(noReUse);
        flatUserObj.setWarnBeforePwdExpiresDays(warn);
        flatUserObj.setPwdInactiveDays(inactive);
        flatUserObj.setChangePasswd(chgPwd);
        flatUserObj.setHasPasswd(hasPwd);
        flatUserObj.setPwdForceModify(frcMod);
        flatUserObj.setHomeDirServer(homeSrv);
        flatUserObj.setHomeDirPathName(homePth);
        flatUserObj.setAutoMountHomeDir(autoMnt);
        flatUserObj.setHomeDirForceModify(dirMod);
        flatUserObj.setHomeDirAllowModifyServer(modSrv);
        flatUserObj.setOwnerPerms(oPerms);
        flatUserObj.setGroupPerms(gPerms);
        flatUserObj.setWorldPerms(wPerms);
        flatUserObj.setInitFilePath(filePath);
        flatUserObj.setMailServer(mailSrv);
        flatUserObj.setMailBoxAllowModifyServer(mboxMod);
        flatUserObj.setMailBoxForceModify(mboxFrc);
        flatUserObj.setInitialShell(shell);
        flatUserObj.setTemplateName(tName);
        flatUserObj.setAttrKey(attrKey);
        flatUserObj.setNewName(newName);
        flatUserObj.setPrimaryProject(primaryProject);
        flatUserObj.setSecondaryProjects(vSecondaryProjects);
        FlatUserObj tmpUser = new FlatUserObj();
        tmpUser.setUserName(userID);
        FlatUserObj oldUser = null;
        try {
            oldUser = uMgrWrapper.getUser(tmpUser, this.provUtil);
        }
        catch (UserException ex) {
            String msg = this.provUtil.writeLog(2, "LM_2005", "LM_2920", userID, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            String msg = this.provUtil.writeLog(2, "LM_2005", "LM_2920", userID, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        InstanceProvider internalProv = this.cimomhandle.getInternalProvider();
        CIMObjectPath cop = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
        cop.addKey(NAME, new CIMValue((Object)userID));
        CIMClass cClass = this.cimomhandle.getClass(cop, false, true, true, null);
        String oldFName = null;
        try {
            CIMInstance perCI = internalProv.getInstance(cop, false, false, false, null, cClass);
            oldFName = this.getStringValue(perCI, FULL_NAME);
        }
        catch (Exception ex) {
            String msg = this.provUtil.writeLog(2, "LM_2042", "LM_2917", userID, null, null, null);
        }
        boolean isPartialSuccess = false;
        String partialSuccessMessage = null;
        oldUser.setFullName(fName);
        if (!userID.equals(newName) || !oldUser.equals(flatUserObj)) {
            this.checkUserUpdateRights(type, objP);
            try {
                uMgrWrapper.modifyUser(flatUserObj, this.provUtil, objP);
            }
            catch (PartialSuccessException pex) {
                isPartialSuccess = true;
                partialSuccessMessage = pex.getMessage();
            }
            catch (UserException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            catch (Exception ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
        } else {
            boolean updateAttr = false;
            if (attrKey != null) {
                if (oldUser.getAttrKey() == null) {
                    updateAttr = true;
                }
                if (!attrKey.equals(oldUser.getAttrKey())) {
                    updateAttr = true;
                }
            }
            if (updateAttr) {
                String msg;
                UserAttrObj userAttr = null;
                userAttr = new UserAttrObj(newName);
                userAttr.putAttributeString(flatUserObj.getAttrKey());
                userAttr.setUserType(flatUserObj.getUserType());
                try {
                    UserAttrUpdate attrUpdate = new UserAttrUpdate(this.provUtil, scope);
                    attrUpdate.userAttrModify(userID, userAttr, objP);
                    if (!userID.equals(newName)) {
                        UserAttrObj tmpAttr = null;
                        tmpAttr = new UserAttrObj(userID);
                        tmpAttr.putAttributeString(flatUserObj.getAttrKey());
                        tmpAttr.setUserType(flatUserObj.getUserType());
                        attrUpdate.userAttrDelete(userID, userAttr);
                    }
                }
                catch (UserException ex) {
                    msg = "";
                    msg = this.provUtil.writeLog(2, "LM_2005", "LM_2914", userID, ex.getLocalizedMessage(), null, null);
                }
                catch (Exception ex) {
                    msg = "";
                    msg = this.provUtil.writeLog(2, "LM_2005", "LM_2914", userID, ex.getLocalizedMessage(), null, null);
                }
            }
        }
        try {
            CIMObjectPath op = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
            CIMClass cc = this.cimomhandle.getClass(op, false, true, true, null);
            CIMInstance perCI = cc.newInstance();
            if (newName == null) {
                newName = userID;
            }
            if (newName.trim().length() == 0) {
                newName = userID;
            }
            if (userID.equals(newName)) {
                if (userID != null) {
                    perCI.setProperty(NAME, new CIMValue((Object)userID));
                }
                if (fName == null || fName.trim().length() == 0) {
                    fName = userID;
                }
                perCI.setProperty(FULL_NAME, new CIMValue((Object)fName));
                if (oldFName != null && oldFName.trim().length() != 0) {
                    internalProv.setInstance(op, perCI);
                } else {
                    internalProv.createInstance(op, perCI);
                }
            } else {
                op.addKey(NAME, new CIMValue((Object)userID));
                internalProv.deleteInstance(op);
                CIMObjectPath newOp = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
                CIMClass cc1 = this.cimomhandle.getClass(newOp, false, true, true, null);
                CIMInstance newCI = cc1.newInstance();
                newCI.setProperty(NAME, new CIMValue((Object)newName));
                newCI.setProperty(FULL_NAME, new CIMValue((Object)fName));
                internalProv.createInstance(newOp, newCI);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_UserAccount setInstance() : null WbemAuditSession.");
                throw new UserException("");
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_UserAccount setInstance() : null platform AuditSession.");
                throw new UserException("");
            }
            AuditEvent_usermgr_modify userModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (userModEvent == null) {
                Debug.trace1((String)"Solaris_UserAccount setInstance() : null AuditEvent_usermgr_modify.");
                throw new UserException("");
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(cimInst);
            String auth = null;
            auth = type.equals("normal") ? "solaris.admin.usermgr.write" : "solaris.role.write";
            userModEvent.object_name(cn);
            userModEvent.domain(this.provUtil.getDomainToken(scope));
            userModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            userModEvent.auth_used(auth);
            userModEvent.changed_values(propertyToken);
            userModEvent.putEvent(0, 0);
        }
        catch (UserException uex) {
            if (isPartialSuccess) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)partialSuccessMessage);
            }
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_UserAccount setInstance() : Auditing threw exception", (Throwable)ex);
        }
        if (isPartialSuccess) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)partialSuccessMessage);
        }
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        String scope = null;
        String name = null;
        CIMObjectPath cop = new CIMObjectPath(COMPLETE_CLASS, "root\\cimv2");
        CIMClass cc = this.cimomhandle.getClass(cop, false, true, true, null);
        scope = this.provUtil.getMgmtScope(op);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (methodName == null) {
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)"(null)", (Object)op.getObjectName());
        }
        if (methodName.equals("getNextUID")) {
            results = this.getNextUID(scope, inParams, outParams);
        } else if (methodName.equals("getUserRoles")) {
            results = this.getUserRoles(cc, scope, inParams, outParams);
        } else if (methodName.equals("bulkData")) {
            results = this.bulkData(cc, scope, inParams, outParams);
        } else {
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)methodName, (Object)op.getObjectName());
        }
        return results;
    }

    private CIMValue getNextUID(String scope, Vector inParams, Vector outParams) throws CIMException {
        SolarisPasswdTable spt = null;
        String suid = null;
        this.provUtil.checkRights("solaris.admin.usermgr.read", (CIMObjectPath)null);
        CIMValue rv = new CIMValue((Object)new Integer(0));
        try {
            spt = new SolarisPasswdTable(scope);
            suid = spt.getNextAvailableUID();
        }
        catch (Exception ex) {
            String msg = "";
            msg = this.provUtil.writeLog(2, "LM_2001", "LM_2100", ex.getLocalizedMessage(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        CIMValue ov = new CIMValue((Object)suid);
        outParams.addElement(ov);
        return rv;
    }

    private CIMValue getUserRoles(CIMClass cc, String scope, Vector inParams, Vector outParams) throws CIMException {
        CIMValue rv = new CIMValue((Object)new Integer(0));
        String user_name = null;
        CIMValue iv = null;
        if (inParams != null && inParams.size() > 0) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                user_name = (String)iv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (user_name == null || user_name.trim().length() == 0) {
            String msg = this.provUtil.writeLog(2, "LM_2312", "LM_2300", user_name, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        String[] list = null;
        try {
            list = AuthorizationUtility.getRoleNames((String)user_name);
        }
        catch (Exception ex) {
            list = null;
        }
        if (list == null) {
            list = new String[]{};
        }
        Vector<String> vlist = new Vector<String>(list.length);
        for (int i = 0; i < list.length; ++i) {
            vlist.addElement(list[i]);
        }
        CIMValue ov = new CIMValue(vlist);
        outParams.addElement(ov);
        return rv;
    }

    private CIMValue bulkData(CIMClass cc, String scope, Vector inParams, Vector outParams) throws CIMException {
        ProviderFilter pf = null;
        UserProviderDirectoryFilter pdf = null;
        Vector list = null;
        LightUserObj luo = null;
        this.provUtil.checkRights("solaris.admin.usermgr.read", (CIMObjectPath)null);
        CIMValue rv = new CIMValue((Object)new Integer(0));
        String type = null;
        CIMValue iv = null;
        if (inParams != null && inParams.size() > 0) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                type = (String)iv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (type == null || type.trim().length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (!type.equals("normal") && !type.equals("role")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String filter = null;
        iv = null;
        if (inParams != null && inParams.size() > 1) {
            try {
                iv = (CIMValue)inParams.elementAt(1);
                filter = (String)iv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        pdf = null;
        if (filter != null) {
            try {
                pf = new ProviderFilter(cc, filter);
                pdf = new UserProviderDirectoryFilter(pf);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_QUERY");
            }
        }
        try {
            UMgrWrapper umw = new UMgrWrapper(this.provUtil, scope);
            list = type.equals("normal") ? umw.getAllLightUsers(pdf) : umw.getAllLightRoles(pdf);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        if (list == null) {
            list = new Vector(0);
        }
        Vector<String> vOutParam = new Vector<String>();
        boolean i = false;
        Enumeration en = list.elements();
        while (en.hasMoreElements()) {
            luo = (LightUserObj)en.nextElement();
            vOutParam.addElement(luo.getUserName());
            vOutParam.addElement(luo.getUserUID());
            vOutParam.addElement(luo.getFullName());
            vOutParam.addElement(luo.getUserDescr());
        }
        CIMDataType dtype = new CIMDataType(22);
        CIMValue outVal = new CIMValue(vOutParam, dtype);
        outParams.addElement(outVal);
        return rv;
    }

    private String readFullName(InstanceProvider iProv, CIMClass cc, String userName) throws CIMException {
        String fName = null;
        if (iProv == null) {
            return fName;
        }
        CIMObjectPath cop = new CIMObjectPath(COMPLETE_CLASS, "/root/cimv2");
        cop.addKey(NAME, new CIMValue((Object)userName));
        try {
            CIMInstance ci = iProv.getInstance(cop, false, false, false, null, cc);
            fName = this.getStringValue(ci, FULL_NAME);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return fName;
    }

    private CIMInstance buildInstance(CIMClass cc, String domType, String domName, FlatUserObj fuo) {
        CIMInstance ci = cc.newInstance();
        ci.setProperty("SystemCreationClassName", new CIMValue((Object)domType));
        ci.setProperty("SystemName", new CIMValue((Object)domName));
        ci.setProperty(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
        ci.setProperty(NAME, new CIMValue((Object)fuo.getUserName()));
        ci.setProperty(USER_TYPE, new CIMValue((Object)fuo.getUserType()));
        ci.setProperty(USER_ID, new CIMValue((Object)fuo.getUserName()));
        ci.setProperty(USER_UID, new CIMValue((Object)fuo.getUserUID()));
        ci.setProperty(USER_DESCR, new CIMValue((Object)fuo.getUserDescr()));
        ci.setProperty(PRIM_GROUP, new CIMValue((Object)fuo.getPrimaryGroup()));
        ci.setProperty(HOME_DIR_PATH, new CIMValue((Object)fuo.getHomeDirPathName()));
        ci.setProperty(INIT_SHELL, new CIMValue((Object)fuo.getInitialShell()));
        ci.setProperty(FULL_NAME, new CIMValue((Object)fuo.getFullName()));
        ci.setProperty(SEC_GROUPS, new CIMValue((Object)fuo.getSecondaryGroups()));
        if (fuo.getAccountExpireDate() != null) {
            String sDate = fuo.getAccountExpireDate();
            if (sDate.trim().length() > 0) {
                Date expDate = this.setUpExpirationDate(sDate);
                ci.setProperty(ACCNT_EXPIRE, new CIMValue((Object)new CIMDateTime(expDate)));
            } else {
                ci.setProperty(ACCNT_EXPIRE, new CIMValue(null));
            }
        } else {
            ci.setProperty(ACCNT_EXPIRE, new CIMValue(null));
        }
        ci.setProperty(ACCNT_LOCKED, new CIMValue((Object)new Boolean(fuo.getIsAccountLocked())));
        ci.setProperty(MUST_CHNG_PWD, new CIMValue((Object)fuo.getMustChangePasswdInDays()));
        ci.setProperty(DO_NOT_REUSE_PWD, new CIMValue((Object)fuo.getDoNotReUsePwdForDays()));
        ci.setProperty(WARN_PWD, new CIMValue((Object)fuo.getWarnBeforePwdExpiresDays()));
        ci.setProperty(PWD_INACTIVE, new CIMValue((Object)fuo.getPwdInactiveDays()));
        ci.setProperty(CHANGE_PWD, new CIMValue((Object)new Boolean(fuo.getChangePasswd())));
        ci.setProperty(HAS_PWD, new CIMValue((Object)new Boolean(fuo.getHasPasswd())));
        ci.setProperty(PWD_FRC_MOD, new CIMValue((Object)new Boolean(fuo.getPwdForceModify())));
        ci.setProperty(HOME_DIR_SERVER, new CIMValue((Object)fuo.getHomeDirServer()));
        ci.setProperty(AUTOMOUNT, new CIMValue((Object)new Boolean(fuo.getAutoMountHomeDir())));
        ci.setProperty(HOME_DIR_FRC_MOD, new CIMValue((Object)new Boolean(fuo.getHomeDirForceModify())));
        ci.setProperty(HOME_DIR_ALLOW_MOD, new CIMValue((Object)new Boolean(fuo.getHomeDirAllowModifyServer())));
        ci.setProperty(OWNER_PERMS, new CIMValue((Object)fuo.getOwnerPerms()));
        ci.setProperty(GROUP_PERMS, new CIMValue((Object)fuo.getGroupPerms()));
        ci.setProperty(WORLD_PERMS, new CIMValue((Object)fuo.getWorldPerms()));
        ci.setProperty(INIT_FILE_PATH, new CIMValue((Object)fuo.getInitFilePath()));
        ci.setProperty(MAIL_SERVER, new CIMValue((Object)fuo.getMailServer()));
        ci.setProperty(MBOX_ALLOW_MOD, new CIMValue((Object)new Boolean(fuo.getMailBoxAllowModifyServer())));
        ci.setProperty(MBOX_FRC_MOD, new CIMValue((Object)new Boolean(fuo.getMailBoxForceModify())));
        ci.setProperty(ATTR_KEY, new CIMValue((Object)fuo.getAttrKey()));
        ci.setProperty(TEMPLATE_NAME, new CIMValue((Object)fuo.getTemplateName()));
        ci.setProperty(PRIMARY_PROJECT, new CIMValue((Object)fuo.getPrimaryProject()));
        ci.setProperty(SECONDARY_PROJECTS, new CIMValue((Object)fuo.getSecondaryProjects()));
        return ci;
    }

    private String getStringValue(CIMInstance ci, String propName) {
        String stringValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            stringValue = (String)cv.getValue();
        }
        return stringValue;
    }

    private Vector getVectorValue(CIMInstance ci, String propName) {
        Vector vValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            vValue = (Vector)cv.getValue();
        }
        return vValue;
    }

    private boolean getBooleanValue(CIMInstance ci, String propName) {
        boolean bVal = false;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            bVal = (Boolean)cv.getValue();
        }
        return bVal;
    }

    private CIMDateTime getDateValue(CIMInstance ci, String propName) {
        CIMDateTime dateValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            dateValue = (CIMDateTime)cv.getValue();
        }
        return dateValue;
    }

    private String convertDateToString(Date theDate) {
        String dateStr = null;
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        sdf.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        sdf.setLenient(false);
        try {
            dateStr = sdf.format(theDate);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return dateStr;
    }

    private Date setUpExpirationDate(String inputDate) {
        Date date = new Date();
        if (inputDate == null || inputDate.equals("")) {
            return date;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        sdf.setLenient(false);
        try {
            date = sdf.parse(inputDate);
        }
        catch (Exception e) {
            // empty catch block
        }
        return date;
    }
}

