/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrTable;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SolarisUserAttrTable
implements UserAttrTable {
    private static final String table = new String("user_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String qualCol = "qualifier";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String attrCol = "attr";
    private int nameColNum = 0;
    private int qualColNum = 0;
    private int res1ColNum = 0;
    private int res2ColNum = 0;
    private int attrColNum = 0;
    private String scope;

    public SolarisUserAttrTable(String scopeUrl) {
        this.scope = scopeUrl;
        Class[] noArgs = new Class[]{};
        Class[] stringArray = new Class[]{String[].class};
        UserAttrObj attrObj = new UserAttrObj();
    }

    public UserAttrObj readUserAttr(String userName) throws DirectoryTableException {
        String qualifier = null;
        return this.readUserAttr(userName, qualifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAttrObj readUserAttr(String userName, String qualifier) throws DirectoryTableException {
        UserAttrObj attrObj = null;
        DirectoryTable etcTable = this.openUserAttrTable();
        try {
            DirectoryRow userAttrRow = etcTable.getRowInstance();
            userAttrRow.putColumn(this.nameColNum, userName);
            if (qualifier != null) {
                userAttrRow.putColumn(this.qualColNum, qualifier);
            }
            if ((userAttrRow = etcTable.getFirstRow((SearchTemplate)userAttrRow)) != null) {
                attrObj = new UserAttrObj(userName);
                attrObj.setQualifier(userAttrRow.getColumn(this.qualColNum));
                String attrList = userAttrRow.getColumn(this.attrColNum);
                KeyValue.getAttributes(attrList, attrObj.attrSet);
            }
        }
        finally {
            this.closeUserAttrTable(etcTable);
        }
        return attrObj;
    }

    public UserAttrObj newUserAttr(String userName) throws DirectoryTableException {
        return new UserAttrObj(userName);
    }

    public UserAttrObj newUserAttr(String userName, String qualifier) throws DirectoryTableException {
        UserAttrObj attrObj = new UserAttrObj(userName);
        attrObj.setQualifier(qualifier);
        return attrObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUserAttr(UserAttrObj attrObj) throws DirectoryTableException {
        DirectoryTable etcTable = this.openUserAttrTable();
        try {
            boolean bDel;
            DirectoryRow newAttrRow = etcTable.getRowInstance();
            newAttrRow.putColumn(this.nameColNum, attrObj.getUserName());
            newAttrRow.putColumn(this.qualColNum, attrObj.getQualifier());
            DirectoryRow oldAttrRow = etcTable.getFirstRow((SearchTemplate)newAttrRow);
            String attrList = oldAttrRow != null ? oldAttrRow.getColumn(this.attrColNum) : null;
            String attrs = KeyValue.putAttributes(attrList, attrObj.attrSet, false);
            newAttrRow.putColumn(this.attrColNum, attrs);
            String type = attrObj.getUserType();
            boolean bl = bDel = type.equals("normal") && this.isEmpty(attrObj);
            if (oldAttrRow == null) {
                if (!bDel) {
                    etcTable.addRow(newAttrRow);
                }
            } else if (bDel) {
                etcTable.deleteRow(oldAttrRow);
            } else {
                etcTable.modifyRow(oldAttrRow, newAttrRow);
            }
        }
        finally {
            this.closeUserAttrTable(etcTable);
        }
    }

    public void removeUserAttr(String userName) throws DirectoryTableException {
        String qualifier = null;
        this.removeUserAttr(userName, qualifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserAttr(String userName, String qualifier) throws DirectoryTableException {
        DirectoryTable etcTable = this.openUserAttrTable();
        try {
            DirectoryRow userAttrRow = etcTable.getRowInstance();
            userAttrRow.putColumn(this.nameColNum, userName);
            if (qualifier != null) {
                userAttrRow.putColumn(this.qualColNum, qualifier);
            }
            if ((userAttrRow = etcTable.getFirstRow((SearchTemplate)userAttrRow)) != null) {
                etcTable.deleteRow(userAttrRow);
            }
        }
        finally {
            this.closeUserAttrTable(etcTable);
        }
    }

    public void removeUserAttr(UserAttrObj userAttr) throws DirectoryTableException {
        String userName = userAttr.getUserName();
        String qualifier = userAttr.getQualifier();
        this.removeUserAttr(userName, qualifier);
    }

    public void createUserAttrTable() throws DirectoryTableException {
        DirectoryTable userAttrTable = null;
        boolean exists = true;
        try {
            userAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            userAttrTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            exists = false;
        }
        catch (DirectoryTableException ex) {
            userAttrTable.close();
            throw ex;
        }
        TableDefinitions tbldef = null;
        try {
            if (!exists) {
                tbldef = userAttrTable.getTableDefinitionsInstance();
                tbldef.loadTableDefinitions(table);
                userAttrTable.create(table);
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            userAttrTable.close();
        }
    }

    private DirectoryTable openUserAttrTable() throws DirectoryTableException {
        DirectoryTableFactory factory = new DirectoryTableFactory();
        DirectoryTable userAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        userAttrTable.open(table);
        TableDefinitions tabledefs = userAttrTable.getCurrentTableDefinitions();
        this.nameColNum = tabledefs.getColumnNumber(nameCol);
        this.qualColNum = tabledefs.getColumnNumber(qualCol);
        this.res1ColNum = tabledefs.getColumnNumber(res1Col);
        this.res2ColNum = tabledefs.getColumnNumber(res2Col);
        this.attrColNum = tabledefs.getColumnNumber(attrCol);
        return userAttrTable;
    }

    private void closeUserAttrTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.qualColNum = 0;
        this.res1ColNum = 0;
        this.res2ColNum = 0;
        this.attrColNum = 0;
    }

    public String[] getRolesList() throws DirectoryTableException {
        Vector<String> roles = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openUserAttrTable();
        DirectoryMask mask = etcTable.getDirectoryMaskInstance();
        mask.setColumn(this.nameColNum);
        mask.setColumn(this.attrColNum);
        DirectoryRow userRow = etcTable.getAll(mask);
        if (userRow != null) {
            int index = 0;
            numRows = userRow.getNumberOfRows();
            roles = new Vector(numRows);
            roles.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                String roleName = userRow.getColumn(this.nameColNum, i);
                UserAttrObj userAttr = new UserAttrObj(roleName);
                String attrList = userRow.getColumn(this.attrColNum, i);
                KeyValue.getAttributes(attrList, userAttr.attrSet);
                String userType = userAttr.getUserType();
                if (!userType.equals("role")) continue;
                roles.setElementAt(roleName, index);
                ++index;
            }
            roles.setSize(index);
        } else {
            roles = new Vector<String>();
        }
        this.closeUserAttrTable(etcTable);
        Object[] roleArray = new String[roles.size()];
        roles.copyInto(roleArray);
        return roleArray;
    }

    public Vector getUsersInRole(String roleName) throws DirectoryTableException {
        Vector<String> users = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openUserAttrTable();
        DirectoryMask mask = etcTable.getDirectoryMaskInstance();
        mask.setColumn(this.nameColNum);
        mask.setColumn(this.attrColNum);
        DirectoryRow userRow = etcTable.getAll(mask);
        if (userRow != null) {
            int index = 0;
            numRows = userRow.getNumberOfRows();
            users = new Vector(numRows);
            users.setSize(numRows);
            block0: for (int i = 1; i <= numRows; ++i) {
                String[] roles;
                String userName = userRow.getColumn(this.nameColNum, i);
                UserAttrObj userAttr = new UserAttrObj(userName);
                String attrList = userRow.getColumn(this.attrColNum, i);
                KeyValue.getAttributes(attrList, userAttr.attrSet);
                String userType = userAttr.getUserType();
                if (!userType.equals("normal") || (roles = userAttr.getRoleNames()) == null) continue;
                for (int j = 0; j < roles.length; ++j) {
                    if (!roleName.equals(roles[j])) continue;
                    users.setElementAt(userName, index);
                    ++index;
                    continue block0;
                }
            }
            users.setSize(index);
        } else {
            users = new Vector<String>();
        }
        this.closeUserAttrTable(etcTable);
        return users;
    }

    public void addRoleToUsers(String roleName, Vector userNames) throws DirectoryTableException {
        UserAttrObj uao = null;
        if (userNames != null && userNames.size() > 0) {
            Enumeration e = userNames.elements();
            while (e.hasMoreElements()) {
                int j;
                String type;
                String user = (String)e.nextElement();
                uao = this.readUserAttr(user);
                if (uao == null) {
                    uao = new UserAttrObj(user, "normal");
                }
                if (!(type = uao.getUserType()).equals("normal")) continue;
                Vector<String> v = uao.getAttribute("roles");
                if (v == null) {
                    v = new Vector<String>(1);
                }
                if ((j = v.indexOf(roleName)) >= 0) continue;
                v.addElement(roleName);
                uao.setAttribute("roles", v);
                this.writeUserAttr(uao);
            }
        }
    }

    public void removeRoleFromUsers(String roleName, Vector userNames) throws DirectoryTableException {
        UserAttrObj uao = null;
        if (userNames != null && userNames.size() > 0) {
            Enumeration e = userNames.elements();
            while (e.hasMoreElements()) {
                int j;
                Vector v;
                String type;
                String user = (String)e.nextElement();
                uao = this.readUserAttr(user);
                if (uao == null || !(type = uao.getUserType()).equals("normal") || (v = uao.getAttribute("roles")) == null || (j = v.indexOf(roleName)) < 0) continue;
                v.removeElementAt(j);
                uao.setAttribute("roles", v);
                if (this.isEmpty(uao)) {
                    this.removeUserAttr(uao);
                    continue;
                }
                this.writeUserAttr(uao);
            }
        }
    }

    public int getRoleAssignCount(String roleName) throws DirectoryTableException {
        int assignCount = 0;
        DirectoryTable etcTable = this.openUserAttrTable();
        DirectoryMask mask = etcTable.getDirectoryMaskInstance();
        mask.setColumn(this.nameColNum);
        mask.setColumn(this.attrColNum);
        DirectoryRow userRow = etcTable.getAll(mask);
        if (userRow != null) {
            for (int i = 1; i <= userRow.getNumberOfRows(); ++i) {
                String userName = userRow.getColumn(this.nameColNum, i);
                UserAttrObj userAttr = new UserAttrObj(userName);
                String attrList = userRow.getColumn(this.attrColNum, i);
                KeyValue.getAttributes(attrList, userAttr.attrSet);
                String[] roleArray = userAttr.getRoleNames();
                for (int j = 0; j < roleArray.length; ++j) {
                    if (!roleArray[j].equals(roleName)) continue;
                    ++assignCount;
                }
            }
        }
        this.closeUserAttrTable(etcTable);
        return assignCount;
    }

    public boolean isEmpty(UserAttrObj uao) {
        Hashtable ht = (Hashtable)uao.attrSet.clone();
        ht.remove("type");
        String str = KeyValue.putAttributes(null, ht, false);
        return str == null || str.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAttrObj[] listUserAttrs() throws DirectoryTableException {
        UserAttrObj[] user_attrs = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openUserAttrTable();
        try {
            DirectoryRow userRow = null;
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.attrColNum);
            mask.setColumn(this.qualColNum);
            userRow = etcTable.getAll();
            if (userRow != null) {
                numRows = userRow.getNumberOfRows();
                user_attrs = new UserAttrObj[numRows];
                for (int i = 1; i <= numRows; ++i) {
                    UserAttrObj userAttr = new UserAttrObj();
                    userAttr.setUserName(userRow.getColumn(this.nameColNum, i));
                    userAttr.setQualifier(userRow.getColumn(this.qualColNum, i));
                    String attrList = userRow.getColumn(this.attrColNum, i);
                    KeyValue.getAttributes(attrList, userAttr.attrSet);
                    Array.set(user_attrs, i - 1, userAttr);
                }
            } else {
                user_attrs = new UserAttrObj[]{};
            }
        }
        finally {
            this.closeUserAttrTable(etcTable);
        }
        return user_attrs;
    }
}

