/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.FilterItem;
import com.sun.wbem.solarisprovider.usermgr.common.ListProperties;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerDirTableException;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.groups.SolGroupAttr;
import com.sun.wbem.solarisprovider.usermgr.groups.SolarisGroupTable;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.LightUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolHomedirAttr;
import com.sun.wbem.solarisprovider.usermgr.users.SolServicesAttr;
import com.sun.wbem.solarisprovider.usermgr.users.UserObj;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class SolarisPasswdTable {
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String tableName = "passwd";
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String uidCol = "uid";
    private String gidCol = "gid";
    private String gcosCol = "gcos";
    private String homeCol = "home";
    private String shellCol = "shell";
    private int nameColNum = 0;
    private int passwdColNum = 0;
    private int uidColNum = 0;
    private int gidColNum = 0;
    private int gcosColNum = 0;
    private int homeColNum = 0;
    private int shellColNum = 0;
    private String xPassword = "x";
    private String scope;
    private static final String DEFAULT_PRIMARY_GROUP_NAME = "staff";

    public SolarisPasswdTable(String scope) {
        this.scope = scope;
    }

    private DirectoryTable openPasswdTable() throws Exception {
        try {
            DirectoryTable dirTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            dirTable.open(this.tableName);
            TableDefinitions tabledefs = dirTable.getCurrentTableDefinitions();
            this.nameColNum = tabledefs.getColumnNumber(this.nameCol);
            this.passwdColNum = tabledefs.getColumnNumber(this.passwdCol);
            this.uidColNum = tabledefs.getColumnNumber(this.uidCol);
            this.gidColNum = tabledefs.getColumnNumber(this.gidCol);
            this.gcosColNum = tabledefs.getColumnNumber(this.gcosCol);
            this.homeColNum = tabledefs.getColumnNumber(this.homeCol);
            this.shellColNum = tabledefs.getColumnNumber(this.shellCol);
            return dirTable;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private void closePasswdTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.passwdColNum = 0;
        this.uidColNum = 0;
        this.gidColNum = 0;
        this.gcosColNum = 0;
        this.homeColNum = 0;
        this.shellColNum = 0;
    }

    public Vector getAllLightRows(ProviderDirectoryFilter pdf) throws Exception {
        Vector<LightUserObj> vUserObjs = null;
        int numRows = 0;
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        DirectoryFilter df = null;
        if (pdf != null) {
            try {
                df = pdf.getDirectoryFilter(etcTable);
            }
            catch (Exception ex) {
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            DirectoryRow pwdRow = null;
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.uidColNum);
            mask.setColumn(this.gcosColNum);
            pwdRow = df != null ? etcTable.getAll((SearchTemplate)df, mask) : etcTable.getAll(mask);
            if (pwdRow != null) {
                numRows = pwdRow.getNumberOfRows();
                vUserObjs = new Vector(numRows);
                vUserObjs.setSize(numRows);
                for (int i = 1; i <= numRows; ++i) {
                    LightUserObj lUserobj = new LightUserObj();
                    lUserobj.setUserName(pwdRow.getColumn(this.nameColNum, i));
                    lUserobj.setUserUID(pwdRow.getColumn(this.uidColNum, i));
                    lUserobj.setUserDescr(pwdRow.getColumn(this.gcosColNum, i));
                    vUserObjs.setElementAt(lUserobj, i - 1);
                }
            } else {
                vUserObjs = new Vector<LightUserObj>();
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return vUserObjs;
    }

    public Vector getAllLightRows() throws Exception {
        Vector<LightUserObj> vUserObjs = null;
        int numRows = 0;
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        try {
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.uidColNum);
            mask.setColumn(this.gcosColNum);
            DirectoryRow passwdEntry = etcTable.getAll();
            if (passwdEntry == null) {
                Vector<LightUserObj> vector = vUserObjs = new Vector<LightUserObj>();
                return vector;
            }
            numRows = passwdEntry.getNumberOfRows();
            vUserObjs = new Vector(numRows);
            vUserObjs.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                LightUserObj lUserobj = new LightUserObj();
                lUserobj.setUserName(passwdEntry.getColumn(this.nameColNum, i));
                lUserobj.setUserUID(passwdEntry.getColumn(this.uidColNum, i));
                lUserobj.setUserDescr(passwdEntry.getColumn(this.gcosColNum, i));
                vUserObjs.setElementAt(lUserobj, i - 1);
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return vUserObjs;
    }

    public Vector getAllFlatRows() throws Exception {
        Vector<FlatUserObj> vUserObjs = null;
        int numRows = 0;
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        try {
            DirectoryRow passwdEntry = etcTable.getAll();
            if (passwdEntry == null) {
                Vector<FlatUserObj> vector = vUserObjs = new Vector<FlatUserObj>();
                return vector;
            }
            numRows = passwdEntry.getNumberOfRows();
            vUserObjs = new Vector(numRows);
            vUserObjs.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                FlatUserObj fUserObj = new FlatUserObj();
                fUserObj.setUserName(passwdEntry.getColumn(this.nameColNum, i));
                fUserObj.setUserUID(passwdEntry.getColumn(this.uidColNum, i));
                fUserObj.setUserDescr(passwdEntry.getColumn(this.gcosColNum, i));
                vUserObjs.setElementAt(fUserObj, i - 1);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return vUserObjs;
    }

    public Vector getAllPasswdRows(ListProperties listProps) throws SolServerDirTableException, Exception {
        Vector<UserObj> users = null;
        int numRows = 0;
        DirectoryTable etcTable = null;
        try {
            etcTable = this.openPasswdTable();
        }
        catch (SolServerDirTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        try {
            Object tbl;
            Vector vFilterItem = listProps.getFilters();
            DirectoryFilter dirFilter = new DirectoryFilter(vFilterItem.size());
            String filterValue = "";
            for (int i = 0; i < vFilterItem.size(); ++i) {
                FilterItem clientFilter = (FilterItem)vFilterItem.elementAt(i);
                filterValue = clientFilter.getValue();
                String attr = clientFilter.getAttribute();
                int colNumber = 0;
                if (attr.equals("filter_user_name")) {
                    colNumber = this.nameColNum;
                } else if (attr.equals("filter_user_desc")) {
                    colNumber = this.gcosColNum;
                } else if (attr.equals("filter_user_id")) {
                    colNumber = this.uidColNum;
                } else if (attr.equals("filter_group_id")) {
                    colNumber = this.gidColNum;
                } else if (attr.equals("filter_user_group")) {
                    tbl = new SolarisGroupTable(this.scope);
                    filterValue = ((SolarisGroupTable)tbl).translateNametoGID(clientFilter.getValue());
                    colNumber = this.gidColNum;
                }
                dirFilter.add(colNumber, clientFilter.getBooleanOperator(), clientFilter.getOperator(), filterValue);
            }
            DirectoryRow passwdEntry = etcTable.getAll((SearchTemplate)dirFilter);
            if (passwdEntry == null) {
                users = new Vector<UserObj>();
                tbl = users;
                return tbl;
            }
            numRows = passwdEntry.getNumberOfRows();
            users = new Vector(numRows);
            users.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                UserObj solarisUser = new UserObj(passwdEntry.getColumn(this.nameColNum, i));
                solarisUser.setUserName(passwdEntry.getColumn(this.nameColNum, i));
                solarisUser.setUserID(passwdEntry.getColumn(this.uidColNum, i));
                solarisUser.setUserDescription(passwdEntry.getColumn(this.gcosColNum, i));
                solarisUser.setUserType("Solaris");
                users.setElementAt(solarisUser, i - 1);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw new SolServerDirTableException("LM_2090");
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw new SolServerDirTableException("LM_2094");
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return users;
    }

    public String getNextAvailableUID() throws Exception {
        long availUID = 100L;
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        try {
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.uidColNum);
            DirectoryRow passwdEntry = etcTable.getAll(mask);
            if (passwdEntry == null) {
                String string = String.valueOf(availUID);
                return string;
            }
            TableDefinitions tabledefs = etcTable.getCurrentTableDefinitions();
            passwdEntry.sortByColumn(this.uidColNum, tabledefs);
            long currentUID = 0L;
            boolean found = false;
            for (int i = 1; i <= passwdEntry.getNumberOfRows() && !found; ++i) {
                String stringUID = passwdEntry.getColumn(this.uidColNum, i);
                if (stringUID == null || stringUID.trim().length() <= 0 || (currentUID = Long.parseLong(stringUID)) == 60001L || currentUID == 60002L || currentUID == 65534L) continue;
                if (availUID == currentUID) {
                    ++availUID;
                    continue;
                }
                if (availUID >= currentUID) continue;
                found = true;
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return String.valueOf(availUID);
    }

    public void deletePasswdRow(FlatUserObj fUserobj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.nameColNum, fUserobj.getUserName());
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry == null) {
                throw new Exception("User does not exist");
            }
            etcTable.deleteRow(passwdEntry);
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
    }

    public void addPasswdRow(FlatUserObj fUserObj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            if (fUserObj.getUserUID() == null || fUserObj.getUserName() == null || fUserObj.getHomeDirPathName() == null) {
                throw new Exception();
            }
            passwdEntry.putColumn(this.uidColNum, fUserObj.getUserUID());
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry != null) {
                throw new UserMgrIDAlreadyInUseException(null);
            }
            passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.nameColNum, fUserObj.getUserName());
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry != null) {
                throw new UserMgrNameAlreadyInUseException(null);
            }
            passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.nameColNum, fUserObj.getUserName());
            if (fUserObj.getUserDescr() != null) {
                passwdEntry.putColumn(this.gcosColNum, fUserObj.getUserDescr());
            }
            passwdEntry.putColumn(this.uidColNum, fUserObj.getUserUID());
            if (fUserObj.getPrimaryGroup() != null) {
                SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
                passwdEntry.putColumn(this.gidColNum, tbl.translateNametoGID(fUserObj.getPrimaryGroup()));
            }
            String pathname = fUserObj.getHomeDirPathName();
            if (fUserObj.getAutoMountHomeDir()) {
                pathname = this.getAutomountPath("auto_home");
                pathname = pathname.concat(fUserObj.getUserName());
            }
            passwdEntry.putColumn(this.homeColNum, pathname);
            if (fUserObj.getInitialShell() != null) {
                passwdEntry.putColumn(this.shellColNum, fUserObj.getInitialShell());
            }
            passwdEntry.putColumn(this.passwdColNum, this.xPassword);
            etcTable.addRow(passwdEntry);
        }
        catch (DirectoryTableException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
    }

    public LightUserObj getPasswdRow(LightUserObj lfUserObj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        String usrName = lfUserObj.getUserName();
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.nameColNum, usrName);
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry == null) {
                // empty if block
            }
            lfUserObj.setUserUID(passwdEntry.getColumn(this.uidColNum));
            lfUserObj.setUserDescr(passwdEntry.getColumn(this.gcosColNum));
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return lfUserObj;
    }

    public UserObj getPasswdRow(UserObj usrObj) throws SolServerException, Exception {
        SolServicesAttr srvs;
        SolHomedirAttr home;
        AdminCommonTools.CMN_Trace3("In getPasswdRow()");
        DirectoryTable etcTable = null;
        try {
            etcTable = this.openPasswdTable();
        }
        catch (SolServerDirTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        SolGroupAttr grp = usrObj.getSolGroupAttr();
        if (grp == null) {
            grp = new SolGroupAttr();
            usrObj.setSolGroupAttr(grp);
        }
        if ((home = usrObj.getSolHomedirAttr()) == null) {
            home = new SolHomedirAttr();
            usrObj.setSolHomedirAttr(home);
        }
        if ((srvs = usrObj.getSolServicesAttr()) == null) {
            srvs = new SolServicesAttr();
            usrObj.setSolServicesAttr(srvs);
        }
        String usrName = usrObj.getUserName();
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.nameColNum, usrName);
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry == null) {
                throw new SolServerException("EXM_SUS2", usrName);
            }
            usrObj.setUserID(passwdEntry.getColumn(this.uidColNum));
            usrObj.setUserType("Solaris");
            usrObj.setUserDescription(passwdEntry.getColumn(this.gcosColNum));
            SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
            String gid = passwdEntry.getColumn(this.gidColNum);
            if (gid.length() > 0) {
                grp.setPrimaryGroup(tbl.translateGIDtoName(gid));
            } else {
                grp.setPrimaryGroup(DEFAULT_PRIMARY_GROUP_NAME);
            }
            home.setPathname(passwdEntry.getColumn(this.homeColNum));
            srvs.setInitialShell(passwdEntry.getColumn(this.shellColNum));
            srvs.setMailServer("");
        }
        catch (SolServerException ex) {
            throw ex;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw new SolServerDirTableException("LM_2090");
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw new SolServerDirTableException("LM_2094");
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return usrObj;
    }

    public FlatUserObj getPasswdRow(FlatUserObj fUserObj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        String usrName = fUserObj.getUserName();
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.nameColNum, usrName);
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry == null) {
                // empty if block
            }
            fUserObj.setUserUID(passwdEntry.getColumn(this.uidColNum));
            fUserObj.setUserDescr(passwdEntry.getColumn(this.gcosColNum));
            SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
            String gid = passwdEntry.getColumn(this.gidColNum);
            if (gid.length() > 0) {
                fUserObj.setPrimaryGroup(tbl.translateGIDtoName(gid));
            } else {
                fUserObj.setPrimaryGroup(DEFAULT_PRIMARY_GROUP_NAME);
            }
            fUserObj.setHomeDirPathName(passwdEntry.getColumn(this.homeColNum));
            fUserObj.setInitialShell(passwdEntry.getColumn(this.shellColNum));
            fUserObj.setMailServer("");
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
        return fUserObj;
    }

    public void modifyPasswdRow(UserObj usrObj, String oldName) throws SolServerException, Exception {
        DirectoryTable etcTable = null;
        try {
            etcTable = this.openPasswdTable();
        }
        catch (SolServerDirTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            passwdEntry.putColumn(this.uidColNum, usrObj.getUserID());
            passwdEntry.putColumn(this.nameColNum, oldName);
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry == null) {
                throw new SolServerException("EXM_SUS2", usrObj.getUserName());
            }
            DirectoryRow newEntry = passwdEntry.extractRows(1, 1);
            if (!oldName.equals(usrObj.getUserName())) {
                newEntry.putColumn(this.nameColNum, usrObj.getUserName());
                newEntry = etcTable.getFirstRow((SearchTemplate)newEntry);
                if (newEntry != null) {
                    throw new UserMgrNameAlreadyInUseException("EXM_SUS19", usrObj.getUserName());
                }
                newEntry = etcTable.getRowInstance();
            }
            SolGroupAttr grp = usrObj.getSolGroupAttr();
            SolHomedirAttr home = usrObj.getSolHomedirAttr();
            SolServicesAttr srvs = usrObj.getSolServicesAttr();
            newEntry.putColumn(this.nameColNum, usrObj.getUserName());
            newEntry.putColumn(this.uidColNum, usrObj.getUserID());
            SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
            newEntry.putColumn(this.gidColNum, tbl.translateNametoGID(grp.getPrimaryGroup()));
            newEntry.putColumn(this.gcosColNum, usrObj.getUserDescription());
            newEntry.putColumn(this.shellColNum, srvs.getInitialShell());
            newEntry.putColumn(this.passwdColNum, passwdEntry.getColumn(this.passwdColNum));
            String pathname = home.getPathname();
            if (home.getAutomount()) {
                pathname = new String("/home/");
                pathname = pathname.concat(usrObj.getUserName());
            } else {
                pathname = home.getPathname();
            }
            newEntry.putColumn(this.homeColNum, pathname);
            etcTable.modifyRow(passwdEntry, newEntry);
        }
        catch (SolServerException ex) {
            throw ex;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw new SolServerDirTableException("LM_2090");
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw new SolServerDirTableException("LM_2094");
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
    }

    public void modifyPasswdRow(FlatUserObj fUserObj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openPasswdTable();
        try {
            DirectoryRow passwdEntry = etcTable.getRowInstance();
            if (fUserObj.getUserUID() == null) {
                throw new Exception();
            }
            if (fUserObj.getUserName() == null) {
                throw new Exception();
            }
            passwdEntry.putColumn(this.uidColNum, fUserObj.getUserUID());
            passwdEntry.putColumn(this.nameColNum, fUserObj.getUserName());
            passwdEntry = etcTable.getFirstRow((SearchTemplate)passwdEntry);
            if (passwdEntry == null) {
                throw new Exception();
            }
            DirectoryRow newEntry = passwdEntry.extractRows(1, passwdEntry.getNumberOfRows());
            String newName = fUserObj.getNewName();
            String oldName = fUserObj.getUserName();
            if (!oldName.equals(newName)) {
                DirectoryRow searchEntry = etcTable.getRowInstance();
                searchEntry.putColumn(this.nameColNum, newName);
                if (etcTable.getFirstRow((SearchTemplate)searchEntry) != null) {
                    throw new UserMgrNameAlreadyInUseException(null);
                }
            }
            newEntry.putColumn(this.nameColNum, newName);
            if (fUserObj.getUserDescr() != null) {
                newEntry.putColumn(this.gcosColNum, fUserObj.getUserDescr());
            }
            newEntry.putColumn(this.uidColNum, fUserObj.getUserUID());
            if (fUserObj.getPrimaryGroup() != null) {
                SolarisGroupTable tbl = new SolarisGroupTable(this.scope);
                newEntry.putColumn(this.gidColNum, tbl.translateNametoGID(fUserObj.getPrimaryGroup()));
            }
            String pathname = fUserObj.getHomeDirPathName();
            if (fUserObj.getAutoMountHomeDir()) {
                pathname = this.getAutomountPath("auto_home");
                pathname = pathname.concat(newName);
            }
            if (pathname != null) {
                newEntry.putColumn(this.homeColNum, pathname);
            }
            if (fUserObj.getInitialShell() != null) {
                newEntry.putColumn(this.shellColNum, fUserObj.getInitialShell());
            }
            newEntry.putColumn(this.passwdColNum, passwdEntry.getColumn(this.passwdColNum));
            etcTable.modifyRow(passwdEntry, newEntry);
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closePasswdTable(etcTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAutomountPath(String mapName) {
        String defaultAutomountPath = "/home/";
        DirectoryTable directoryTable = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("auto_master");
            directoryTable.open(tableDefinitions);
            DirectoryFilter filter = new DirectoryFilter(1);
            filter.add(tableDefinitions.getColumnNumber("value"), 1, 3, mapName);
            DirectoryRow row = directoryTable.getFirstRow((SearchTemplate)filter);
            if (row == null) {
                String string = defaultAutomountPath;
                return string;
            }
            String automountPath = row.getColumn(tableDefinitions.getColumnNumber("key"));
            if (automountPath == null || automountPath.trim().length() == 0) {
                String string = defaultAutomountPath;
                return string;
            }
            String string = automountPath + "/";
            return string;
        }
        catch (Exception e) {
            String string = defaultAutomountPath;
            return string;
        }
        finally {
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
    }
}

