/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

public class CheckSyntax {
    private static String errorString;
    private static final int MAX_PASSWD_LEN = 16;

    public void CheckSyntax() {
        CheckSyntax.setErrorString(" ");
    }

    public static void setErrorString(String currentErrorString) {
        errorString = currentErrorString;
    }

    public static String getErrorString() {
        return errorString;
    }

    public static boolean isNameOK(String name) {
        String[] allowedChars = new String[]{"0", "_", "-", "."};
        if (name.length() < 2) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        if (name.length() > 32) {
            return false;
        }
        if (!CheckSyntax.isOneLowerCase(name)) {
            return false;
        }
        return CheckSyntax.isStringOK(name, allowedChars);
    }

    public static boolean isUIDOK(String uid) {
        long longUid = Long.parseLong(uid);
        if (longUid < 100L) {
            return false;
        }
        if (longUid > Integer.MAX_VALUE) {
            return false;
        }
        return longUid != 60001L && longUid != 60002L && longUid != 65534L;
    }

    public static boolean isDescLenOK(String desc) {
        return desc.length() <= 256;
    }

    public static boolean isPasswordConf(String passwd, String confPasswd) {
        if (!passwd.equals(confPasswd)) {
            return false;
        }
        return CheckSyntax.isPasswordLenOK(passwd);
    }

    public static boolean isPasswordLenOK(String passwd) {
        String[] specials = new String[]{"!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "~", "-", "=", "{", "}", "[", "]", ":", ";", "'", "`", "<", ">", "?", ",", ".", "/", "\\", "\""};
        boolean atLeastOneSpec = false;
        int countAlphas = 0;
        if (!passwd.equals("")) {
            if (passwd.length() < 6) {
                return false;
            }
            if (passwd.length() > 16) {
                return false;
            }
            String tmpPwd = passwd.substring(0, 6);
            for (int j = 0; j < 6; ++j) {
                char tmpChar = tmpPwd.charAt(j);
                if (Character.isLetter(tmpChar)) {
                    ++countAlphas;
                } else if (Character.isDigit(tmpChar)) {
                    atLeastOneSpec = true;
                } else {
                    for (int k = 0; k < specials.length; ++k) {
                        if (!String.valueOf(tmpChar).equals(specials[k])) continue;
                        atLeastOneSpec = true;
                        break;
                    }
                }
                if (countAlphas <= 1 || !atLeastOneSpec) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isHomeDirServerOK(String homeDirServerName) {
        String[] allowedChars = new String[]{"0", "-"};
        if (homeDirServerName.equals("")) {
            return false;
        }
        if (homeDirServerName.length() > 255) {
            return false;
        }
        if (!Character.isLetterOrDigit(homeDirServerName.charAt(0))) {
            return false;
        }
        return CheckSyntax.isStringOK(homeDirServerName, allowedChars);
    }

    public static boolean isHomeDirPathnameOK(String homeDirPathName) {
        String[] allowedChars = new String[]{"0", "-", "/", ".", "_"};
        if (homeDirPathName.equals("")) {
            return false;
        }
        if (!String.valueOf(homeDirPathName.charAt(0)).equals("/")) {
            return false;
        }
        if (!CheckSyntax.isPathLenOK(homeDirPathName)) {
            return false;
        }
        return CheckSyntax.isStringOK(homeDirPathName, allowedChars);
    }

    private static boolean isPathLenOK(String testName) {
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < testName.length(); ++i) {
            char tempChar = testName.charAt(i);
            if (!String.valueOf(tempChar).equals("/") || (pos2 = i) - pos1 <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isOneLowerCase(String testName) {
        for (int i = 0; i < testName.length(); ++i) {
            char tempChar = testName.charAt(i);
            if (!Character.isLowerCase(tempChar)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringOK(String testName, String[] allowableChars) {
        for (int i = 0; i < testName.length(); ++i) {
            char tempChar = testName.charAt(i);
            if (Character.isLetterOrDigit(tempChar)) continue;
            int len = allowableChars.length;
            boolean isAllowable = false;
            if (len == 1) {
                return false;
            }
            for (int j = 1; j < len; ++j) {
                if (!String.valueOf(tempChar).equals(allowableChars[j])) continue;
                isAllowable = true;
                break;
            }
            if (isAllowable) continue;
            return false;
        }
        return true;
    }
}

