/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.mbox;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.solarisprovider.usermgr.mbox.MBoxObj;
import com.sun.wbem.solarisprovider.usermgr.mbox.MboxWrapper;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;

public class Solaris_MailBox
extends UMgrProvider
implements Authorizable {
    private static String USER_NAME = "userName";
    private static String USER_UID = "userUID";
    private static String MAIL_SERVER = "mailServer";
    private static String MBOX_ALLOW_MOD = "mailBoxAllowModifyServer";
    private static String MBOX_FRC_MOD = "mailBoxForceModify";
    private static String NEW_USER_NAME = "newUserName";

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance cimInst) throws CIMException {
        this.checkRights("solaris.admin.usermgr.write", op);
        try {
            String name = this.getStringValue(cimInst, USER_NAME);
            if (name == null || name.equals("")) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String uid = this.getStringValue(cimInst, USER_UID);
            if (uid == null || uid.equals("")) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String mailSrv = this.getStringValue(cimInst, MAIL_SERVER);
            boolean mboxMod = this.getBooleanValue(cimInst, MBOX_ALLOW_MOD);
            boolean mboxFrc = this.getBooleanValue(cimInst, MBOX_FRC_MOD);
            MboxWrapper mBoxWrapper = new MboxWrapper(this.provUtil);
            MBoxObj mBoxObj = new MBoxObj();
            mBoxObj.setUserName(name);
            mBoxObj.setUserUID(uid);
            mBoxObj.setMailServer(mailSrv);
            mBoxObj.setMailBoxAllowModifyServer(mboxMod);
            mBoxObj.setMailBoxForceModify(mboxFrc);
            mBoxWrapper.createMailbox(mBoxObj);
        }
        catch (Exception e) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_MailBox createInstance() : null WbemAuditSession.");
                return null;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_MailBox createInstance() : null platform AuditSession.");
                return null;
            }
            AuditEvent_usermgr_add mailboxAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (mailboxAddEvent == null) {
                Debug.trace3((String)"Solaris_MailBox createInstance() : null AuditEvent_usermgr_add.");
                return null;
            }
            String propertyToken = this.provUtil.formatAuditToken(cimInst);
            String scope = this.provUtil.getMgmtScope(op);
            mailboxAddEvent.object_name(op.getObjectName());
            mailboxAddEvent.domain(this.provUtil.getDomainToken(scope));
            mailboxAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            mailboxAddEvent.auth_used("solaris.admin.usermgr.write");
            mailboxAddEvent.initial_values(propertyToken);
            mailboxAddEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_MailBox createInstance() : Auditing threw exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.checkRights("solaris.admin.usermgr.write", op);
        String userName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = null;
            cp = (CIMProperty)e.nextElement();
            if (cp == null || !cp.getName().equalsIgnoreCase(USER_NAME)) continue;
            CIMValue cv = null;
            cv = cp.getValue();
            if (cv == null) continue;
            userName = (String)cv.getValue();
        }
        if (userName == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String uid = this.getStringValue(ci, USER_UID);
        if (uid == null || uid.equals("")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String mailSrv = this.getStringValue(ci, MAIL_SERVER);
        boolean mboxMod = this.getBooleanValue(ci, MBOX_ALLOW_MOD);
        boolean mboxFrc = this.getBooleanValue(ci, MBOX_FRC_MOD);
        String newName = this.getStringValue(ci, NEW_USER_NAME);
        if (newName == null || newName.equals("") || userName.equals("")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        MboxWrapper mBoxWrapper = new MboxWrapper(this.provUtil);
        MBoxObj mBoxObj = new MBoxObj();
        mBoxObj.setUserName(userName);
        mBoxObj.setUserUID(uid);
        mBoxObj.setMailServer(mailSrv);
        mBoxObj.setMailBoxAllowModifyServer(mboxMod);
        mBoxObj.setMailBoxForceModify(mboxFrc);
        try {
            mBoxWrapper.modifyMailBox(mBoxObj, newName);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_MailBox setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_MailBox setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_modify mailboxModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (mailboxModEvent == null) {
                Debug.trace3((String)"Solaris_MailBox setInstance() : null AuditEvent_usermgr_modify.");
                return;
            }
            String propertyToken = this.provUtil.formatAuditToken(ci);
            String scope = this.provUtil.getMgmtScope(op);
            mailboxModEvent.object_name(op.getObjectName());
            mailboxModEvent.domain(this.provUtil.getDomainToken(scope));
            mailboxModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            mailboxModEvent.auth_used("solaris.admin.usermgr.write");
            mailboxModEvent.changed_values(propertyToken);
            mailboxModEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_MailBox setInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        this.checkRights("solaris.admin.usermgr.write", op);
        String userName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = null;
            cp = (CIMProperty)e.nextElement();
            if (cp == null || !cp.getName().equalsIgnoreCase(USER_NAME)) continue;
            CIMValue cv = null;
            cv = cp.getValue();
            if (cv == null) continue;
            userName = (String)cv.getValue();
        }
        if (userName == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        try {
            MboxWrapper mBoxWrapper = new MboxWrapper(this.provUtil);
            MBoxObj mBoxObj = new MBoxObj();
            mBoxWrapper.deleteMBox(userName);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_MailBox deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_MailBox deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_delete mailboxDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (mailboxDelEvent == null) {
                Debug.trace3((String)"Solaris_MailBox deleteInstance() : null AuditEvent_usermgr_delete.");
                return;
            }
            String scope = this.provUtil.getMgmtScope(op);
            mailboxDelEvent.object_name(op.getObjectName());
            mailboxDelEvent.domain(this.provUtil.getDomainToken(scope));
            mailboxDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            mailboxDelEvent.auth_used("solaris.admin.usermgr.write");
            mailboxDelEvent.delete_values(userName);
            mailboxDelEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_MailBox deleteInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean inlcudeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }

    private String getStringValue(CIMInstance ci, String propName) {
        String stringValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            stringValue = (String)cv.getValue();
        }
        return stringValue;
    }

    private Vector getVectorValue(CIMInstance ci, String propName) {
        Vector vValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            vValue = (Vector)cv.getValue();
        }
        return vValue;
    }

    private boolean getBooleanValue(CIMInstance ci, String propName) {
        boolean bVal = false;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            bVal = (Boolean)cv.getValue();
        }
        return bVal;
    }
}

