/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.homedir;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.solarisprovider.usermgr.homedir.HomeDirObj;
import com.sun.wbem.solarisprovider.usermgr.homedir.UMgrWrapper;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;

public class Solaris_UserHomeDirectory
extends UMgrProvider
implements Authorizable {
    private static String CAPTION = "Caption";
    private static String DESCRIPTION = "Description";
    private static String INSTALLDATE = "InstallDate";
    private static String STATUS = "Status";
    private static String CS_NAME = "CSCreationClassName";
    private static String SERVERNAME = "CSName";
    private static String FS_CLASSNAME = "FSCreationClassName";
    private static String FS_NAME = "FSName";
    private static String CREATION_NAME = "CreationClassName";
    private static String PATHNAME = "Name";
    private static String FILESIZE = "FileSize";
    private static String CREATION_DATE = "CreationDate";
    private static String LAST_MODIFIED = "LastModified";
    private static String LAST_ACCESSED = "LastAccessed";
    private static String READABLE = "Readable";
    private static String WRITEABLE = "Writeable";
    private static String ENCRYPTION = "EncryptionMethod";
    private static String IN_USE_COUNT = "InUseCount";
    private static String USERNAME = "userName";
    private static String USERID = "uid";
    private static String PRIMARYGROUP = "primaryGroup";
    private static String INITFILES = "initFiles";
    private static String AUTOMOUNTHDIR = "autoMountHomeDir";
    private static String FORCE_MODIFY = "homeDirForceModify";
    private static String ALLOW_MODIFY = "homeDirAllowModifyServer";
    private static String OWNER_PERMS = "ownerPerms";
    private static String GROUP_PERMS = "groupPerms";
    private static String WORLD_PERMS = "worldPerms";
    private static String NEW_PATHNAME = "newPathName";
    private static String SCRIPT_BEFORE = "scriptBefore";
    private static String SCRIPT_AFTER = "scriptAfter";
    private static String INIT_FILEPATH = "initFilePath";

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            this.checkRights("solaris.admin.usermgr.write", op);
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil);
            HomeDirObj homedir = new HomeDirObj();
            String serverName = this.getStringValue(ci, SERVERNAME);
            homedir.setServer(serverName);
            String userName = this.getStringValue(ci, USERNAME);
            homedir.setUserName(userName);
            String uid = this.getStringValue(ci, USERID);
            homedir.setUID(uid);
            String primaryGroup = this.getStringValue(ci, PRIMARYGROUP);
            homedir.setPrimaryGroup(primaryGroup);
            String pathName = this.getStringValue(ci, PATHNAME);
            homedir.setPathname(pathName);
            boolean initFiles = this.getBooleanValue(ci, INITFILES);
            homedir.setInitFiles(initFiles);
            boolean automount = this.getBooleanValue(ci, AUTOMOUNTHDIR);
            homedir.setAutomount(automount);
            boolean forceMod = this.getBooleanValue(ci, FORCE_MODIFY);
            homedir.setForceModify(forceMod);
            boolean allowMod = this.getBooleanValue(ci, ALLOW_MODIFY);
            homedir.setModifyServer(allowMod);
            String worldPerms = this.getStringValue(ci, WORLD_PERMS);
            homedir.setWorldPerms(worldPerms);
            String groupPerms = this.getStringValue(ci, GROUP_PERMS);
            homedir.setGroupPerms(groupPerms);
            String ownerPerms = this.getStringValue(ci, OWNER_PERMS);
            homedir.setOwnerPerms(ownerPerms);
            String initFilePath = this.getStringValue(ci, INIT_FILEPATH);
            homedir.setInitFilePath(initFilePath);
            uMgrWrapper.createHomeDir(homedir);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory createInstance() : null WbemAuditSession.");
                return null;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory createInstance() : null platform AuditSession.");
                return null;
            }
            AuditEvent_usermgr_add homedirAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (homedirAddEvent == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory createInstance() : null AuditEvent_usermgr_add.");
                return null;
            }
            String propertyToken = this.provUtil.formatAuditToken(ci);
            String scope = this.provUtil.getMgmtScope(op);
            homedirAddEvent.object_name(op.getObjectName());
            homedirAddEvent.domain(this.provUtil.getDomainToken(scope));
            homedirAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            homedirAddEvent.auth_used("solaris.admin.usermgr.write");
            homedirAddEvent.initial_values(propertyToken);
            homedirAddEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_UserHomeDirectory createInstance() : Auditing threw exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        this.checkRights("solaris.admin.usermgr.write", op);
        String pathName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = null;
            cp = (CIMProperty)e.nextElement();
            if (cp == null || !cp.getName().equalsIgnoreCase(PATHNAME)) continue;
            CIMValue cv = null;
            cv = cp.getValue();
            if (cv == null) continue;
            pathName = (String)cv.getValue();
        }
        if (pathName == null) {
            throw new CIMProviderException("GENERAL_EXCEPTION");
        }
        UMgrWrapper uMgrWrapper = null;
        try {
            uMgrWrapper = new UMgrWrapper(this.provUtil);
            if (uMgrWrapper == null) {
                throw new CIMProviderException("GENERAL_EXCEPTION");
            }
            uMgrWrapper.deleteHomeDir(pathName);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_delete homedirDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (homedirDelEvent == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory deleteInstance() : null AuditEvent_usermgr_delete.");
                return;
            }
            String scope = this.provUtil.getMgmtScope(op);
            homedirDelEvent.object_name(op.getObjectName());
            homedirDelEvent.domain(this.provUtil.getDomainToken(scope));
            homedirDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            homedirDelEvent.auth_used("solaris.admin.usermgr.write");
            homedirDelEvent.delete_values(pathName);
            homedirDelEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_UserHomeDirectory deleteInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        UMgrWrapper uMgrWrapper = null;
        String pathName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = null;
            cp = (CIMProperty)e.nextElement();
            if (cp == null || !cp.getName().equalsIgnoreCase(PATHNAME)) continue;
            CIMValue cv = null;
            cv = cp.getValue();
            if (cv == null) continue;
            pathName = (String)cv.getValue();
        }
        if (pathName == null) {
            return null;
        }
        HomeDirObj homeObj = new HomeDirObj();
        homeObj.setPathname(pathName);
        try {
            uMgrWrapper = new UMgrWrapper(this.provUtil);
            homeObj = uMgrWrapper.getPermissions(homeObj);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty(SERVERNAME, new CIMValue((Object)homeObj.getServer()));
        ci.setProperty(USERNAME, new CIMValue((Object)homeObj.getUserName()));
        ci.setProperty(USERID, new CIMValue((Object)homeObj.getUID()));
        ci.setProperty(PRIMARYGROUP, new CIMValue((Object)homeObj.getPrimaryGroup()));
        ci.setProperty(PATHNAME, new CIMValue((Object)homeObj.getPathname()));
        ci.setProperty(INITFILES, new CIMValue((Object)new Boolean(homeObj.getInitFiles())));
        ci.setProperty(AUTOMOUNTHDIR, new CIMValue((Object)new Boolean(homeObj.getAutomount())));
        ci.setProperty(FORCE_MODIFY, new CIMValue((Object)new Boolean(homeObj.requireModify())));
        ci.setProperty(ALLOW_MODIFY, new CIMValue((Object)new Boolean(homeObj.getModifyServer())));
        ci.setProperty(OWNER_PERMS, new CIMValue((Object)homeObj.getOwnerPerms()));
        ci.setProperty(GROUP_PERMS, new CIMValue((Object)homeObj.getGroupPerms()));
        ci.setProperty(WORLD_PERMS, new CIMValue((Object)homeObj.getWorldPerms()));
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            this.checkRights("solaris.admin.usermgr.write", op);
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil);
            HomeDirObj homedir = new HomeDirObj();
            String pathName = null;
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = null;
                cp = (CIMProperty)e.nextElement();
                if (cp == null || !cp.getName().equalsIgnoreCase(PATHNAME)) continue;
                CIMValue cv = null;
                cv = cp.getValue();
                if (cv == null) continue;
                pathName = (String)cv.getValue();
            }
            if (pathName == null) {
                throw new CIMProviderException("GENERAL_EXCEPTION");
            }
            homedir.setPathname(pathName);
            String serverName = this.getStringValue(ci, SERVERNAME);
            homedir.setServer(serverName);
            String userName = this.getStringValue(ci, USERNAME);
            homedir.setUserName(userName);
            String uid = this.getStringValue(ci, USERID);
            homedir.setUID(uid);
            String primaryGroup = this.getStringValue(ci, PRIMARYGROUP);
            homedir.setPrimaryGroup(primaryGroup);
            boolean initFiles = this.getBooleanValue(ci, INITFILES);
            homedir.setInitFiles(initFiles);
            boolean automount = this.getBooleanValue(ci, AUTOMOUNTHDIR);
            homedir.setAutomount(automount);
            boolean forceMod = this.getBooleanValue(ci, FORCE_MODIFY);
            homedir.setForceModify(forceMod);
            boolean allowMod = this.getBooleanValue(ci, ALLOW_MODIFY);
            homedir.setModifyServer(allowMod);
            String worldPerms = this.getStringValue(ci, WORLD_PERMS);
            homedir.setWorldPerms(worldPerms);
            String groupPerms = this.getStringValue(ci, GROUP_PERMS);
            homedir.setGroupPerms(groupPerms);
            String ownerPerms = this.getStringValue(ci, OWNER_PERMS);
            homedir.setOwnerPerms(ownerPerms);
            String newPath = this.getStringValue(ci, NEW_PATHNAME);
            uMgrWrapper.modifyHomeDir(homedir, newPath);
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_modify homedirModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (homedirModEvent == null) {
                Debug.trace3((String)"Solaris_UserHomeDirectory setInstance() : null AuditEvent_usermgr_modify.");
                return;
            }
            String propertyToken = this.provUtil.formatAuditToken(ci);
            String scope = this.provUtil.getMgmtScope(op);
            homedirModEvent.object_name(op.getObjectName());
            homedirModEvent.domain(this.provUtil.getDomainToken(scope));
            homedirModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            homedirModEvent.auth_used("solaris.admin.usermgr.write");
            homedirModEvent.changed_values(propertyToken);
            homedirModEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_UserHomeDirectory setInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    private String getStringValue(CIMInstance ci, String propName) {
        String stringValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            stringValue = (String)cv.getValue();
        }
        return stringValue;
    }

    private Vector getVectorValue(CIMInstance ci, String propName) {
        Vector vValue = null;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            vValue = (Vector)cv.getValue();
        }
        return vValue;
    }

    private boolean getBooleanValue(CIMInstance ci, String propName) {
        boolean bVal = false;
        CIMValue cv = null;
        CIMProperty cp = ci.getProperty(propName);
        if (cp != null) {
            cv = cp.getValue();
        }
        if (cv != null) {
            bVal = (Boolean)cv.getValue();
        }
        return bVal;
    }
}

