/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.groups;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.common.ProviderException;
import com.sun.wbem.solarisprovider.common.ProviderFilter;
import com.sun.wbem.solarisprovider.usermgr.common.FilterItem;
import com.sun.wbem.solarisprovider.usermgr.common.ListProperties;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.solarisprovider.usermgr.groups.GroupObj;
import com.sun.wbem.solarisprovider.usermgr.groups.GroupProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.groups.SolGroupAttr;
import com.sun.wbem.solarisprovider.usermgr.groups.SolarisGroupTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisPasswdTable;
import com.sun.wbem.solarisprovider.usermgr.users.UserObj;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_UserGroup
extends UMgrProvider
implements Authorizable,
MethodProvider {
    private static final String GROUP_NAME = "GroupName";
    private static final String GROUP_ID = "GroupID";
    private static final String MEMBER_NAMES = "GroupMembers";
    private static final String OS_TYPE = "OSType";
    private static final String GROUP_CLASS = "Solaris_UserGroup";

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.checkRights("solaris.admin.usermgr.write", op);
        SolarisGroupTable gat = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        GroupObj newObj = this.cimToGroup(ci);
        gat = new SolarisGroupTable(scope);
        if (newObj == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "the Group Object";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)msg);
        }
        String groupId = newObj.getGroupID();
        if (Long.parseLong(groupId) > Integer.MAX_VALUE) {
            String[] args = new String[]{groupId};
            String msg = this.logUtil.writeLog(this.providerName, "LM_2013", "LM_2198", args, null, false, 0, 2);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            gat.addGroupRow(newObj);
        }
        catch (SolServerException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
        cop.addKey("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        cop.addKey("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        cop.addKey(GROUP_NAME, new CIMValue((Object)newObj.getGroupName()));
        cop.addKey(GROUP_ID, new CIMValue((Object)newObj.getGroupID()));
        this.writeLog(0, "LM_2012", "LM_2084", newObj.getGroupName(), null, null, null);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_UserGroup createInstance() : null WbemAuditSession.");
                return cop;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_UserGroup createInstance() : null platform AuditSession.");
                return cop;
            }
            AuditEvent_usermgr_add groupAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (groupAddEvent == null) {
                Debug.trace1((String)"Solaris_UserGroup createInstance() : null AuditEvent_usermgr_add.");
                return cop;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            groupAddEvent.object_name(op.getObjectName());
            groupAddEvent.domain(this.provUtil.getDomainToken(scope));
            groupAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            groupAddEvent.auth_used("solaris.admin.usermgr.write");
            groupAddEvent.initial_values(propertyToken);
            groupAddEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_UserGroup createInstance() : Auditing threw exception", (Throwable)ex);
            return cop;
        }
        return cop;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.checkRights("solaris.admin.usermgr.write", op);
        SolarisGroupTable gat = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        String name = null;
        String id = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(GROUP_NAME)) {
                name = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(GROUP_ID)) continue;
            id = (String)cp.getValue().getValue();
        }
        if (name == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Group Name";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        GroupObj oldObj = null;
        GroupObj tempObj = new GroupObj(name);
        if (id != null && !id.equals("")) {
            tempObj.setGroupID(id);
        } else {
            GroupObj newObj = null;
            try {
                gat = new SolarisGroupTable(scope);
                newObj = gat.getGroupRow(tempObj);
            }
            catch (DirectoryTableException ex) {
                this.writeLog(2, (Exception)((Object)ex));
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            catch (SolServerException ex) {
                this.writeLog(2, (Exception)((Object)ex));
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            if (newObj != null && (id = newObj.getGroupID()) != null) {
                tempObj.setGroupID(id);
            }
        }
        try {
            gat = new SolarisGroupTable(scope);
            oldObj = gat.getGroupRow(tempObj);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (SolServerException ex) {
            this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        if (oldObj == null) {
            String msg = this.writeLog(1, "LM_2017", "LM_2189", name, id, null, null);
            throw new CIMProviderException("CIM_ERR_NOT_FOUND");
        }
        GroupObj changedObj = this.cimToGroup(ci);
        if (changedObj.getGroupID() == null || changedObj.getGroupID().equals("")) {
            changedObj.setGroupID(oldObj.getGroupID());
        }
        boolean changed = false;
        boolean in_users_null = false;
        boolean str_users_null = false;
        String[] inUsers = changedObj.getGroupUsers();
        String[] strUsers = oldObj.getGroupUsers();
        if (inUsers == null && strUsers != null) {
            in_users_null = true;
            str_users_null = false;
        } else if (inUsers != null && strUsers == null) {
            in_users_null = false;
            str_users_null = true;
        } else if (inUsers == null && strUsers == null) {
            changed = false;
        } else if (inUsers.length != strUsers.length) {
            changed = true;
        } else {
            for (int i = 0; i < strUsers.length; ++i) {
                if (strUsers[i].equals(inUsers[i])) continue;
                changed = true;
            }
        }
        try {
            gat.modifyGroupRow(changedObj);
        }
        catch (SolServerException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2016", "LM_2081", name, null, null, null);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_UserGroup setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_UserGroup setInstance() : null AuditEvent_usermgr_modify.");
                return;
            }
            AuditEvent_usermgr_modify groupModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (groupModEvent == null) {
                Debug.trace1((String)"Solaris_UserGroup setInstance() : null AuditEvent_usermgr_modify.");
                return;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            groupModEvent.object_name(op.getObjectName());
            groupModEvent.domain(this.provUtil.getDomainToken(scope));
            groupModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            groupModEvent.auth_used("solaris.admin.usermgr.write");
            groupModEvent.changed_values(propertyToken);
            groupModEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_UserGroup setInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        String msg;
        this.checkRights("solaris.admin.usermgr.write", op);
        SolarisGroupTable gat = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg2 = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg2);
        }
        String name = null;
        String id = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(GROUP_NAME)) {
                name = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(GROUP_ID)) continue;
            id = (String)cp.getValue().getValue();
        }
        if (name == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Group Name";
            String msg3 = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg3);
        }
        GroupObj tempObj = new GroupObj(name);
        if (id != null) {
            tempObj.setGroupID(id);
            this.checkID(id);
        } else {
            GroupObj newObj = null;
            try {
                gat = new SolarisGroupTable(scope);
                newObj = gat.getGroupRow(tempObj);
            }
            catch (DirectoryTableException ex) {
                this.writeLog(2, (Exception)((Object)ex));
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            catch (SolServerException ex) {
                this.writeLog(2, (Exception)((Object)ex));
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
            if (newObj != null && (id = newObj.getGroupID()) != null) {
                tempObj.setGroupID(id);
                this.checkID(id);
            }
        }
        try {
            ListProperties lp = new ListProperties();
            FilterItem fi = new FilterItem("filter_group_id", 5, tempObj.getGroupID(), 1);
            SolarisPasswdTable pw = null;
            Vector v = new Vector(1);
            v.addElement(fi);
            lp.setFilters(v);
            try {
                pw = new SolarisPasswdTable(scope);
            }
            catch (Exception ex) {
                String msg4 = "";
                msg4 = this.provUtil.writeLog(2, "LM_2001", "LM_2100", ex.getLocalizedMessage(), null, null, null);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg4);
            }
            v = pw.getAllPasswdRows(lp);
            for (int i = 0; i < v.size(); ++i) {
                UserObj uo = (UserObj)v.elementAt(i);
                try {
                    uo = pw.getPasswdRow(uo);
                    SolGroupAttr grp = uo.getSolGroupAttr();
                    if (grp == null) continue;
                    grp.setPrimaryGroup("staff");
                    uo.setSolGroupAttr(grp);
                    pw.modifyPasswdRow(uo, uo.getUserName());
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            gat = new SolarisGroupTable(scope);
            gat.deleteGroupRow(tempObj);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, ex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2014", "LM_2085", name, null, null, null);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_UserGroup deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_UserGroup deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_delete groupDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (groupDelEvent == null) {
                Debug.trace1((String)"Solaris_UserGroup deleteInstance() : null AuditEvent_usermgr_delete.");
                return;
            }
            groupDelEvent.object_name(op.getObjectName());
            groupDelEvent.domain(this.provUtil.getDomainToken(scope));
            groupDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            groupDelEvent.auth_used("solaris.admin.usermgr.write");
            groupDelEvent.delete_values(name);
            groupDelEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_UserGroup deleteInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
        SolarisGroupTable gat = null;
        Vector allGroups = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        try {
            gat = new SolarisGroupTable(scope);
            allGroups = gat.getAllGroupRows();
        }
        catch (DirectoryTableException ex) {
            this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        for (int i = 0; allGroups != null && i < allGroups.size(); ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            cop.addKey("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            cop.addKey(GROUP_NAME, new CIMValue((Object)((GroupObj)allGroups.elementAt(i)).getGroupName()));
            cop.addKey(GROUP_ID, new CIMValue((Object)((GroupObj)allGroups.elementAt(i)).getGroupID()));
            allRecs.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
        allRecs.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        Vector<CIMInstance> allRecs = new Vector<CIMInstance>();
        SolarisGroupTable gat = null;
        Vector allGroups = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        try {
            gat = new SolarisGroupTable(scope);
            allGroups = gat.getAllGroupRows();
        }
        catch (DirectoryTableException ex) {
            this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        for (int i = 0; allGroups != null && i < allGroups.size(); ++i) {
            CIMInstance ci = this.groupToCim((GroupObj)allGroups.elementAt(i), cc, scope);
            if (localOnly) {
                ci = ci.localElements();
            }
            allRecs.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[allRecs.size()];
        allRecs.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        SolarisGroupTable gat = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        String name = null;
        String id = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(GROUP_NAME) && cp.getValue() != null) {
                name = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(GROUP_ID) || cp.getValue() == null) continue;
            id = (String)cp.getValue().getValue();
        }
        if (name == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        GroupObj newObj = null;
        GroupObj tempObj = new GroupObj(name);
        if (id != null) {
            tempObj.setGroupID(id);
        }
        try {
            gat = new SolarisGroupTable(scope);
            newObj = gat.getGroupRow(tempObj);
        }
        catch (DirectoryTableException ex) {
            this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (SolServerException ex) {
            this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        if (newObj == null) {
            throw new CIMProviderException("CIM_ERR_NOT_FOUND");
        }
        CIMInstance ci = this.groupToCim(newObj, cc, scope);
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        String scope = null;
        CIMObjectPath cop = new CIMObjectPath(GROUP_CLASS, "root\\cimv2");
        CIMClass cc = this.cimomhandle.getClass(cop, false, true, true, null);
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            scope = this.getDefaultScope();
        }
        if (methodName.equalsIgnoreCase("bulkData")) {
            results = this.bulkData(cc, scope, inParams, outParams);
        } else if (methodName.equalsIgnoreCase("getNextAvailableGID")) {
            results = this.getNextAvailableGID(cc, scope, inParams, outParams);
        } else {
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)methodName, (Object)op.getObjectName());
        }
        return results;
    }

    public CIMInstance[] myExecQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        Vector<CIMInstance> results = new Vector<CIMInstance>(0);
        CIMInstance ci = null;
        SolarisGroupTable gat = null;
        ArrayList list = null;
        String scope = null;
        this.checkRights("solaris.admin.usermgr.read", op);
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_2187", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        ProviderFilter pf = null;
        GroupProviderDirectoryFilter pdf = null;
        try {
            pf = new ProviderFilter(cc, query);
            pdf = new GroupProviderDirectoryFilter(pf);
        }
        catch (ProviderException ex) {
            this.writeLog(1, "LM_2310", "LM_2188", query, null, null, null);
            return this.myExecQuery(op, query, ql, cc);
        }
        catch (CIMException cex) {
            this.writeLog(1, "LM_2310", "LM_2188", query, null, null, null);
            return this.myExecQuery(op, query, ql, cc);
        }
        catch (Exception ex) {
            String msg = this.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            gat = new SolarisGroupTable(scope);
            list = gat.getAllGroupRows(pdf);
        }
        catch (DirectoryTableDoesNotExistException dex) {
            String msg = this.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            String msg = this.writeLog(2, ex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                GroupObj aa = (GroupObj)list.get(i);
                ci = this.groupToCim(aa, cc, scope);
                results.addElement(ci);
            }
        }
        CIMInstance[] ciArray = new CIMInstance[results.size()];
        results.toArray(ciArray);
        return ciArray;
    }

    private CIMValue bulkData(CIMClass cc, String scope, Vector inParams, Vector outParams) throws CIMException {
        ProviderFilter pf = null;
        GroupProviderDirectoryFilter pdf = null;
        ArrayList list = null;
        this.provUtil.checkRights("solaris.admin.usermgr.read", (CIMObjectPath)null);
        CIMValue rv = new CIMValue((Object)new Integer(0));
        CIMValue iv = null;
        String filter = null;
        iv = null;
        if (inParams != null && inParams.size() > 0) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                filter = (String)iv.getValue();
            }
            catch (Exception ex) {
                this.writeLog(2, ex);
            }
        }
        pdf = null;
        if (filter != null) {
            try {
                pf = new ProviderFilter(cc, filter);
                pdf = new GroupProviderDirectoryFilter(pf);
            }
            catch (Exception ex) {
                String msg = this.writeLog(2, ex);
                throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)msg);
            }
        }
        SolarisGroupTable gat = null;
        try {
            gat = new SolarisGroupTable(scope);
            list = gat.getAllGroupRows(pdf);
        }
        catch (DirectoryTableDoesNotExistException dex) {
            String msg = this.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            String msg = this.writeLog(2, ex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (list == null || list.size() == 0) {
            outParams.addElement(new CIMValue((Vector)null, new CIMDataType(22)));
            return rv;
        }
        Vector<String> vOutParam = new Vector<String>();
        boolean j = false;
        for (int i = 0; i < list.size(); ++i) {
            GroupObj obj = (GroupObj)list.get(i);
            vOutParam.addElement(obj.getGroupName());
            vOutParam.addElement(obj.getGroupID());
        }
        CIMDataType dtype = new CIMDataType(22);
        CIMValue outVal = new CIMValue(vOutParam, dtype);
        outParams.addElement(outVal);
        return rv;
    }

    private CIMValue getNextAvailableGID(CIMClass cc, String scope, Vector inParams, Vector outParams) throws CIMException {
        CIMValue rv = null;
        CIMValue cv = new CIMValue((Object)new Integer(0));
        String groupId = null;
        SolarisGroupTable gat = null;
        try {
            gat = new SolarisGroupTable(scope);
            groupId = gat.getNextAvailableGID();
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (groupId == null) {
            String msg = this.writeLog(2, "LM_2311", "LM_2183", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        rv = new CIMValue((Object)groupId);
        outParams.addElement(rv);
        return cv;
    }

    private GroupObj cimToGroup(CIMInstance ci) throws CIMException {
        GroupObj newPa = null;
        String groupName = "";
        String groupType = "";
        String groupID = "";
        String[] members = new String[]{""};
        try {
            groupName = (String)ci.getProperty(GROUP_NAME).getValue().getValue();
            if (groupName == null) {
                throw new Exception("Group Name is null!!");
            }
            newPa = new GroupObj(groupName);
            groupType = (String)ci.getProperty(OS_TYPE).getValue().getValue();
            if (groupType != null) {
                newPa.setGroupType(groupType);
            }
            if ((groupID = (String)ci.getProperty(GROUP_ID).getValue().getValue()) != null) {
                newPa.setGroupID(groupID);
            }
            CIMValue cv = null;
            cv = ci.getProperty(MEMBER_NAMES).getValue();
            if (cv != null) {
                Vector users = (Vector)cv.getValue();
                if (users != null) {
                    String[] user_array = new String[users.size()];
                    for (int i = 0; users != null && i < users.size(); ++i) {
                        user_array[i] = (String)users.elementAt(i);
                    }
                    newPa.setGroupUsers(user_array);
                }
            } else {
                newPa.setGroupUsers(members);
            }
        }
        catch (Exception ex) {
            this.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED");
        }
        return newPa;
    }

    private CIMInstance groupToCim(GroupObj pa, CIMClass cc, String scope) throws CIMException {
        CIMInstance ci = null;
        ci = cc.newInstance();
        ci.setProperty("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        ci.setProperty("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        ci.setProperty(GROUP_NAME, new CIMValue((Object)pa.getGroupName()));
        ci.setProperty(OS_TYPE, new CIMValue((Object)pa.getGroupType()));
        ci.setProperty(GROUP_ID, new CIMValue((Object)pa.getGroupID()));
        Vector<String> members = new Vector<String>();
        String[] users = pa.getGroupUsers();
        for (int i = 0; users != null && i < users.length; ++i) {
            members.addElement(users[i]);
        }
        if (members.size() == 0) {
            members.addElement("");
        }
        ci.setProperty(MEMBER_NAMES, new CIMValue(members));
        return ci;
    }

    private String[] getKeys(CIMObjectPath op) {
        String[] keys = new String[op.getKeys().size() + 1];
        int i = 0;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            keys[i] = (String)cp.getValue().getValue();
            if (keys[i] == null) {
                keys[i] = " ";
            }
            ++i;
        }
        return keys;
    }

    private void checkID(String id) throws CIMException {
        int idNum = 0;
        try {
            idNum = Integer.parseInt(id);
        }
        catch (Exception ex) {
            String msg = this.writeLog(1, "LM_2015", "LM_2197", id, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (idNum < 100 || idNum == 60001 || idNum == 60002 || idNum == 65534) {
            String msg = this.writeLog(1, "LM_2015", "LM_2197", id, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
    }
}

