/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.groups;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.groups.GroupObj;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisGroupTable {
    private String table = new String("group");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String gidCol = "gid";
    private String memberCol = "members";
    private int nameColNum = 0;
    private int passwdColNum = 0;
    private int gidColNum = 0;
    private int memberColNum = 0;
    private String scope;

    public SolarisGroupTable(String scope) {
        this.scope = scope;
    }

    public static String[] parseMembersIntoArray(String members) {
        StringTokenizer tk = new StringTokenizer(members, ",");
        String[] myStr = new String[tk.countTokens()];
        int i = 0;
        while (tk.hasMoreTokens()) {
            myStr[i++] = tk.nextToken();
        }
        return myStr;
    }

    public static String formatMembersIntoString(String[] members) {
        if (members.length == 0) {
            return "";
        }
        StringBuffer myBuffer = new StringBuffer(members[0]);
        for (int i = 1; i < members.length; ++i) {
            myBuffer.append(",");
            myBuffer.append(members[i]);
        }
        return myBuffer.toString();
    }

    private boolean isGroupMember(String name, String members) {
        if (members == null) {
            return false;
        }
        if (members == "") {
            return false;
        }
        String[] myList = SolarisGroupTable.parseMembersIntoArray(members);
        for (int i = 0; i < myList.length; ++i) {
            if (name.compareTo(myList[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private DirectoryTable openGroupTable() throws DirectoryTableException {
        try {
            DirectoryTable groupTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            groupTable.open(this.table);
            TableDefinitions tabledefs = groupTable.getCurrentTableDefinitions();
            this.nameColNum = tabledefs.getColumnNumber(this.nameCol);
            this.passwdColNum = tabledefs.getColumnNumber(this.passwdCol);
            this.gidColNum = tabledefs.getColumnNumber(this.gidCol);
            this.memberColNum = tabledefs.getColumnNumber(this.memberCol);
            return groupTable;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
    }

    private void closeGroupTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.passwdColNum = 0;
        this.gidColNum = 0;
        this.memberColNum = 0;
    }

    public String translateNametoGID(String name) {
        try {
            DirectoryTable etcTable = this.openGroupTable();
            DirectoryRow myRow = etcTable.getRowInstance();
            myRow.putColumn(this.nameColNum, name);
            DirectoryRow foundRow = etcTable.getFirstRow((SearchTemplate)myRow);
            if (foundRow == null) {
                return name;
            }
            String gid = foundRow.getColumn(this.gidColNum);
            this.closeGroupTable(etcTable);
            return gid;
        }
        catch (Exception ex) {
            return name;
        }
    }

    public String translateGIDtoName(String gid) {
        try {
            DirectoryTable etcTable = this.openGroupTable();
            DirectoryRow myRow = etcTable.getRowInstance();
            myRow.putColumn(this.gidColNum, gid);
            DirectoryRow foundRow = etcTable.getFirstRow((SearchTemplate)myRow);
            if (foundRow == null) {
                return gid;
            }
            String name = foundRow.getColumn(this.nameColNum);
            this.closeGroupTable(etcTable);
            return name;
        }
        catch (Exception ex) {
            return gid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupObj getGroupRow(GroupObj grpObj) throws DirectoryTableException, SolServerException {
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        try {
            DirectoryRow grpEntry = etcTable.getRowInstance();
            grpEntry.putColumn(this.nameColNum, grpObj.getGroupName());
            grpEntry = etcTable.getFirstRow((SearchTemplate)grpEntry);
            if (grpEntry == null) {
                throw new SolServerException("EXM_SUS22", grpObj.getGroupName());
            }
            grpObj.setGroupUsers(SolarisGroupTable.parseMembersIntoArray(grpEntry.getColumn(this.memberColNum)));
            grpObj.setGroupID(grpEntry.getColumn(this.gidColNum));
            grpObj.setGroupPassword(grpEntry.getColumn(this.passwdColNum));
        }
        catch (DirectoryTableInvalidParameterException ex) {
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (SolServerException ex) {
            throw ex;
        }
        catch (Exception exception) {
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
        return grpObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupRow(GroupObj grpObj) throws DirectoryTableException, SolServerException {
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        try {
            DirectoryRow grpEntry = etcTable.getRowInstance();
            if (grpObj.getGroupID() != null) {
                grpEntry.putColumn(this.gidColNum, grpObj.getGroupID());
                grpEntry = etcTable.getFirstRow((SearchTemplate)grpEntry);
            }
            if (grpEntry != null) {
                throw new SolServerException("EXM_SUS16", grpObj.getGroupID());
            }
            grpEntry = etcTable.getRowInstance();
            if (grpObj.getGroupName() != null) {
                grpEntry.putColumn(this.nameColNum, grpObj.getGroupName());
                grpEntry = etcTable.getFirstRow((SearchTemplate)grpEntry);
            }
            if (grpEntry != null) {
                throw new SolServerException("EXM_SUS18", grpObj.getGroupName());
            }
            grpEntry = etcTable.getRowInstance();
            if (grpObj.getGroupName() != null) {
                grpEntry.putColumn(this.nameColNum, grpObj.getGroupName());
            }
            if (grpObj.getGroupID() != null) {
                grpEntry.putColumn(this.gidColNum, grpObj.getGroupID());
            }
            if (grpObj.getGroupPassword() != null) {
                grpEntry.putColumn(this.passwdColNum, grpObj.getGroupPassword());
            }
            if (grpObj.getGroupUsers() != null) {
                grpEntry.putColumn(this.memberColNum, SolarisGroupTable.formatMembersIntoString(grpObj.getGroupUsers()));
            }
            etcTable.addRow(grpEntry);
        }
        catch (SolServerException ex) {
            throw ex;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception exception) {
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        block24: {
            DirectoryRow newEntry;
            DirectoryRow grpEntry;
            DirectoryTable etcTable = null;
            etcTable = this.openGroupTable();
            try {
                grpEntry = etcTable.getRowInstance();
                if (groupObj.getGroupID() != null) {
                    grpEntry.putColumn(this.gidColNum, groupObj.getGroupID());
                    grpEntry = etcTable.getFirstRow((SearchTemplate)grpEntry);
                    if (grpEntry == null) {
                        this.addGroupRow(groupObj);
                        return;
                    }
                }
                newEntry = etcTable.getRowInstance();
            }
            catch (SolServerException ex) {
                throw ex;
            }
            catch (DirectoryTableInvalidParameterException ex) {
                throw ex;
            }
            catch (DirectoryTableAccessException ex) {
                throw ex;
            }
            catch (DirectoryTableConnectionException ex) {
                throw ex;
            }
            catch (DirectoryTableException ex) {
                throw ex;
            }
            catch (Exception exception) {
                break block24;
            }
            finally {
                if (etcTable != null) {
                    this.closeGroupTable(etcTable);
                }
            }
            String tmpName = grpEntry.getColumn(this.nameColNum);
            if (!tmpName.equals(groupObj.getGroupName()) && groupObj.getGroupName() != null) {
                newEntry.putColumn(this.nameColNum, groupObj.getGroupName());
                newEntry = etcTable.getFirstRow((SearchTemplate)newEntry);
                if (newEntry != null) {
                    throw new SolServerException("EXM_SUS18", groupObj.getGroupName());
                }
                newEntry = etcTable.getRowInstance();
            }
            if (groupObj.getGroupUsers() != null) {
                newEntry.putColumn(this.memberColNum, SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
            }
            if (groupObj.getGroupName() != null) {
                newEntry.putColumn(this.nameColNum, groupObj.getGroupName());
            }
            if (groupObj.getGroupPassword() != null) {
                newEntry.putColumn(this.passwdColNum, groupObj.getGroupPassword());
            }
            if (groupObj.getGroupID() != null) {
                newEntry.putColumn(this.gidColNum, groupObj.getGroupID());
            }
            etcTable.modifyRow(grpEntry, newEntry);
        }
    }

    public void deleteGroupRow(GroupObj grpObj) throws DirectoryTableException, Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        try {
            DirectoryRow grpEntry = etcTable.getRowInstance();
            grpEntry.putColumn(this.nameColNum, grpObj.getGroupName());
            grpEntry = etcTable.getFirstRow((SearchTemplate)grpEntry);
            if (grpEntry == null) {
                return;
            }
            etcTable.deleteRow(grpEntry);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllGroupRows(ProviderDirectoryFilter pdf) throws DirectoryTableException {
        ArrayList<GroupObj> groups = new ArrayList<GroupObj>();
        DirectoryTable etcTable = null;
        DirectoryFilter df = null;
        etcTable = this.openGroupTable();
        if (pdf != null) {
            try {
                df = pdf.getDirectoryFilter(etcTable);
            }
            catch (Exception ex) {
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            DirectoryRow grpEntry = null;
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.gidColNum);
            grpEntry = df != null ? etcTable.getAll((SearchTemplate)df, mask) : etcTable.getAll(mask);
            if (grpEntry == null) {
                ArrayList<GroupObj> arrayList = groups;
                return arrayList;
            }
            for (int i = 1; i <= grpEntry.getNumberOfRows(); ++i) {
                GroupObj solarisGroup = new GroupObj(grpEntry.getColumn(this.nameColNum, i));
                solarisGroup.setGroupType("Solaris");
                solarisGroup.setGroupID(grpEntry.getColumn(this.gidColNum, i));
                groups.add(solarisGroup);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
        return groups;
    }

    public Vector getAllGroupRows() throws DirectoryTableException {
        Vector<GroupObj> groups = null;
        int numRows = 0;
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        try {
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.gidColNum);
            DirectoryRow grpEntry = etcTable.getAll(mask);
            if (grpEntry == null) {
                Vector<GroupObj> vector = groups = new Vector<GroupObj>();
                return vector;
            }
            numRows = grpEntry.getNumberOfRows();
            groups = new Vector(numRows);
            groups.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                GroupObj solarisGroup = new GroupObj(grpEntry.getColumn(this.nameColNum, i));
                solarisGroup.setGroupType("Solaris");
                solarisGroup.setGroupID(grpEntry.getColumn(this.gidColNum, i));
                groups.setElementAt(solarisGroup, i - 1);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
        return groups;
    }

    public Vector getAllSecondaryGroups(FlatUserObj fUserObj) throws DirectoryTableException {
        Vector<String> vSecGroups = null;
        int numRows = 0;
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        try {
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.memberColNum);
            DirectoryRow groupEntry = etcTable.getAll(mask);
            boolean j = false;
            String priGroup = "";
            if (fUserObj.getPrimaryGroup() != null) {
                priGroup = fUserObj.getPrimaryGroup();
            }
            String tmpName = "";
            if (groupEntry == null) {
                vSecGroups = new Vector<String>();
            } else {
                numRows = groupEntry.getNumberOfRows();
                vSecGroups = new Vector(numRows);
                vSecGroups.setSize(numRows);
            }
            int index = 0;
            for (int i = 1; i <= numRows; ++i) {
                String membersList = groupEntry.getColumn(this.memberColNum, i);
                if (!this.isGroupMember(fUserObj.getUserName(), membersList) || (tmpName = groupEntry.getColumn(this.nameColNum, i)) == null || tmpName.equals(priGroup)) continue;
                vSecGroups.setElementAt(tmpName, index);
                ++index;
            }
            vSecGroups.setSize(index);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
        return vSecGroups;
    }

    public String getNextAvailableGID() throws DirectoryTableException {
        int availGID = 100;
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        int currentGID = 0;
        boolean found = false;
        try {
            TableDefinitions tabledefs = etcTable.getCurrentTableDefinitions();
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.gidColNum);
            DirectoryRow grpEntry = etcTable.getAll(mask);
            grpEntry.sortByColumn(this.gidColNum, tabledefs);
            for (int i = 1; i <= grpEntry.getNumberOfRows(); ++i) {
                String tmpGID = grpEntry.getColumn(this.gidColNum, i);
                if (tmpGID == null || tmpGID.trim().length() <= 0 || (currentGID = Integer.parseInt(tmpGID)) == 60001 || currentGID == 60002 || currentGID == 65534) continue;
                if (availGID == currentGID) {
                    ++availGID;
                    continue;
                }
                if (availGID >= currentGID) continue;
                found = true;
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
        return String.valueOf(availGID);
    }

    public boolean doesGroupExist(GroupObj grpObj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openGroupTable();
        try {
            DirectoryRow grpEntry = etcTable.getRowInstance();
            grpEntry.putColumn(this.nameColNum, grpObj.getGroupName());
            grpEntry = etcTable.getFirstRow((SearchTemplate)grpEntry);
            if (grpEntry == null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeGroupTable(etcTable);
            }
        }
        return true;
    }
}

