/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.common;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;

public class UserRightsUtil {
    private static final String ROLE_TYPE = "role";
    private static final String USER_TYPE = "normal";
    private static final String ROLE_LIST = "roles";
    private static final String USER_LIST = "members";
    private static final String PROF_LIST = "profiles";
    private static final String AUTH_LIST = "auths";
    private static final String ROLE_ASSIGN_RIGHT = "solaris.role.assign";
    private static final String ROLE_DELEGATE_RIGHT = "solaris.role.delegate";
    private static final String PROF_ASSIGN_RIGHT = "solaris.profmgr.assign";
    private static final String PROF_DELEGATE_RIGHT = "solaris.profmgr.delegate";
    private ProviderUtility provUtil;

    public UserRightsUtil(ProviderUtility provUtility) {
        this.provUtil = provUtility;
    }

    public void checkRoleAssignRights(String userName, String userType, ExtAttrObj oldAttrs, ExtAttrObj newAttrs, CIMObjectPath objPath) throws UserException {
        String name;
        Vector<String> v1;
        if (newAttrs == null) {
            return;
        }
        Vector v2 = null;
        Vector v3 = null;
        if (userType.equals(ROLE_TYPE)) {
            if (newAttrs != null) {
                v2 = newAttrs.getAttribute(USER_LIST);
            }
            if (oldAttrs != null) {
                v3 = oldAttrs.getAttribute(USER_LIST);
            }
        } else {
            if (newAttrs != null) {
                v2 = newAttrs.getAttribute(ROLE_LIST);
            }
            if (oldAttrs != null) {
                v3 = oldAttrs.getAttribute(ROLE_LIST);
            }
        }
        if (v2 == null) {
            v2 = new Vector(0);
        }
        if (v3 == null) {
            v3 = new Vector(0);
        }
        Vector<String> v4 = this.diffVector(v2, v3);
        Vector v5 = this.diffVector(v3, v2);
        if (v4.size() == 0 && v5.size() == 0) {
            return;
        }
        if (this.provUtil.testRights(ROLE_ASSIGN_RIGHT, (CIMObjectPath)null)) {
            return;
        }
        String authUser = this.provUtil.getClientUserName();
        if (!this.provUtil.testRights(ROLE_DELEGATE_RIGHT, (CIMObjectPath)null)) {
            this.provUtil.unAuthorizedAudit(objPath, ROLE_DELEGATE_RIGHT);
            throw new UserException("EXM_URU2", authUser);
        }
        if (userType.equals(ROLE_TYPE)) {
            v4 = new Vector<String>(1);
            v4.addElement(userName);
            v5 = new Vector(0);
        }
        if (this.provUtil.isClientRole()) {
            v1 = new Vector<String>(1);
            v1.addElement(authUser);
        } else {
            String[] star = AuthorizationUtility.getRoleNames((String)authUser);
            v1 = new Vector(star.length);
            for (int i = 0; i < star.length; ++i) {
                v1.addElement(star[i]);
            }
        }
        int bad = 0;
        String bad_names = "";
        Enumeration en = v4.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (v1.contains(name)) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        en = v5.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (v1.contains(name)) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        if (bad > 0) {
            throw new UserException("EXM_URU3", (Object)authUser, bad_names);
        }
    }

    public void checkProfAssignRights(ExtAttrObj oldAttrs, ExtAttrObj newAttrs, CIMObjectPath objPath) throws UserException {
        String name;
        if (newAttrs == null) {
            return;
        }
        Vector v2 = null;
        if (newAttrs != null) {
            v2 = newAttrs.getAttribute(PROF_LIST);
        }
        if (v2 == null) {
            v2 = new Vector(0);
        }
        Vector v3 = null;
        if (oldAttrs != null) {
            v3 = oldAttrs.getAttribute(PROF_LIST);
        }
        if (v3 == null) {
            v3 = new Vector(0);
        }
        Vector v4 = this.diffVector(v2, v3);
        Vector v5 = this.diffVector(v3, v2);
        if (v4.size() == 0 && v5.size() == 0) {
            return;
        }
        if (this.provUtil.testRights(PROF_ASSIGN_RIGHT, (CIMObjectPath)null)) {
            return;
        }
        String authUser = this.provUtil.getClientUserName();
        if (!this.provUtil.testRights(PROF_DELEGATE_RIGHT, (CIMObjectPath)null)) {
            this.provUtil.unAuthorizedAudit(objPath, PROF_DELEGATE_RIGHT);
            throw new UserException("EXM_URU4", authUser);
        }
        String[] star = AuthorizationUtility.getUserProfs((String)authUser);
        Vector<String> v1 = new Vector<String>(star.length);
        for (int i = 0; i < star.length; ++i) {
            v1.addElement(star[i]);
        }
        int bad = 0;
        String bad_names = "";
        Enumeration en = v4.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (v1.contains(name)) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        en = v5.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (v1.contains(name)) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        if (bad > 0) {
            throw new UserException("EXM_URU5", (Object)authUser, bad_names);
        }
    }

    public void checkAuthAssignRights(ExtAttrObj oldAttrs, ExtAttrObj newAttrs) throws UserException {
        String name;
        if (newAttrs == null) {
            return;
        }
        String authUser = this.provUtil.getClientUserName();
        String[] star = AuthorizationUtility.getUserAuths((String)authUser);
        UserAttrObj pua = new UserAttrObj(authUser);
        pua.setAuthNames(star);
        UserAttrObj nua = new UserAttrObj(authUser);
        Vector v1 = null;
        if (newAttrs != null && (v1 = newAttrs.getAttribute(AUTH_LIST)) != null) {
            nua.setAttribute(AUTH_LIST, v1);
        }
        if (v1 == null) {
            v1 = new Vector(0);
        }
        UserAttrObj oua = new UserAttrObj(authUser);
        Vector v2 = null;
        if (oldAttrs != null && (v2 = oldAttrs.getAttribute(AUTH_LIST)) != null) {
            oua.setAttribute(AUTH_LIST, v1);
        }
        if (v2 == null) {
            v2 = new Vector(0);
        }
        int bad = 0;
        String bad_names = "";
        Enumeration en = v1.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (oua.checkAuthName(name) || pua.checkAuthGrant(name)) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        en = v2.elements();
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            if (nua.checkAuthName(name) || pua.checkAuthGrant(name)) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        if (bad > 0) {
            throw new UserException("EXM_URU1", (Object)authUser, bad_names);
        }
    }

    public void checkAttrAssignRights(ExtAttrObj oldAttrs, ExtAttrObj newAttrs) throws UserException {
        if (newAttrs == null) {
            return;
        }
        String authUser = this.provUtil.getClientUserName();
        String[] star = AuthorizationUtility.getUserAuths((String)authUser);
        UserAttrObj pua = new UserAttrObj(authUser);
        pua.setAuthNames(star);
        Map authAttrMap = newAttrs.getAuthAttrMap();
        if (authAttrMap == null) {
            return;
        }
        for (Map.Entry entry : authAttrMap.entrySet()) {
            String auth = (String)entry.getKey();
            String[] attrs = (String[])entry.getValue();
            int numModifiedAttrs = 0;
            StringBuffer badNames = new StringBuffer();
            for (int index = 0; index < attrs.length; ++index) {
                AttrObj oao = null;
                AttrObj nao = null;
                if (oldAttrs != null) {
                    oao = (AttrObj)oldAttrs.attrSet.get(attrs[index]);
                }
                if ((nao = (AttrObj)newAttrs.attrSet.get(attrs[index])) == null && oao == null || nao != null && oao != null && nao.equals(oao)) continue;
                if (index > 0) {
                    badNames.append(", ");
                }
                badNames.append(attrs[index]);
                ++numModifiedAttrs;
            }
            if (numModifiedAttrs <= 0 || pua.checkAuthName(auth)) continue;
            throw new UserException("EXM_URU6", (Object)authUser, badNames.toString());
        }
    }

    private Vector diffVector(Vector v1, Vector v2) {
        Vector<String> v3 = new Vector<String>();
        Enumeration en = v1.elements();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (v2.contains(name)) continue;
            v3.addElement(name);
        }
        return v3;
    }
}

