/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.auths;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrObj;
import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrTable;
import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class SolarisAuthAttrTable
implements AuthAttrTable {
    private static final String table = new String("auth_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String shortDescCol = "short_descr";
    private static final String longDescCol = "long_descr";
    private static final String attrCol = "attr";
    private int nameColNum = 0;
    private int res1ColNum = 0;
    private int res2ColNum = 0;
    private int shortDescColNum = 0;
    private int longDescColNum = 0;
    private int attrColNum = 0;
    private String scope;

    public SolarisAuthAttrTable(String scopeUrl) {
        this.scope = scopeUrl;
        Class[] noArgs = new Class[]{};
        Class[] stringArray = new Class[]{String[].class};
        AuthAttrObj attrObj = new AuthAttrObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthAttrObj readAuthAttrObj(String authName) throws DirectoryTableException {
        AuthAttrObj attrObj = null;
        DirectoryTable etcTable = this.openAuthAttrTable();
        try {
            DirectoryRow authAttrRow = etcTable.getRowInstance();
            authAttrRow.putColumn(this.nameColNum, authName);
            authAttrRow = etcTable.getFirstRow((SearchTemplate)authAttrRow);
            if (authAttrRow != null) {
                attrObj = new AuthAttrObj(authName);
                attrObj.setShortDesc(authAttrRow.getColumn(this.shortDescColNum));
                attrObj.setLongDesc(authAttrRow.getColumn(this.longDescColNum));
                String attrList = authAttrRow.getColumn(this.attrColNum);
                KeyValue.getAttributes(attrList, attrObj.attrSet);
            } else {
                System.out.println("Attrs for " + authName + " do not exist");
            }
        }
        finally {
            this.closeAuthAttrTable(etcTable);
        }
        return attrObj;
    }

    public AuthAttrObj[] listAuthAttributes() throws DirectoryTableException {
        return this.listAuthAttributes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthAttrObj[] listAuthAttributes(ProviderDirectoryFilter pdf) throws DirectoryTableException {
        AuthAttrObj[] authArray;
        block8: {
            authArray = null;
            int numRows = 0;
            DirectoryTable etcTable = this.openAuthAttrTable();
            DirectoryFilter df = null;
            if (pdf != null) {
                try {
                    df = pdf.getDirectoryFilter(etcTable);
                }
                catch (Exception ex) {
                    System.out.println("AuthAttr: error getting filter: " + ex.getMessage());
                    throw new DirectoryTableInvalidParameterException("EXM_INVALID");
                }
            }
            try {
                DirectoryRow authRow = null;
                authRow = df != null ? etcTable.getAll((SearchTemplate)df) : etcTable.getAll();
                if (authRow != null) {
                    numRows = authRow.getNumberOfRows();
                    authArray = new AuthAttrObj[numRows];
                    for (int i = 1; i <= numRows; ++i) {
                        AuthAttrObj authAttr = new AuthAttrObj();
                        authAttr.setAuthName(authRow.getColumn(this.nameColNum, i));
                        authAttr.setShortDesc(authRow.getColumn(this.shortDescColNum, i));
                        authAttr.setLongDesc(authRow.getColumn(this.longDescColNum, i));
                        String attrList = authRow.getColumn(this.attrColNum, i);
                        KeyValue.getAttributes(attrList, authAttr.attrSet);
                        authArray[i - 1] = authAttr;
                    }
                    break block8;
                }
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            finally {
                this.closeAuthAttrTable(etcTable);
            }
        }
        return authArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthAttrObj[] readAuthAttrObjList(String matchname) throws DirectoryTableException {
        AuthAttrObj[] authArray = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openAuthAttrTable();
        try {
            DirectoryRow authRow = etcTable.getAll();
            if (authRow == null) {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            numRows = authRow.getNumberOfRows();
            authArray = new AuthAttrObj[numRows];
            for (int i = 1; i <= numRows; ++i) {
                String authName = authRow.getColumn(this.nameColNum, i);
                if (!authName.startsWith(matchname)) continue;
                AuthAttrObj authAttr = new AuthAttrObj(authName);
                authAttr.setShortDesc(authRow.getColumn(this.shortDescColNum, i));
                authAttr.setLongDesc(authRow.getColumn(this.longDescColNum, i));
                String attrList = authRow.getColumn(this.attrColNum);
                KeyValue.getAttributes(attrList, authAttr.attrSet);
                authArray[i - 1] = authAttr;
            }
        }
        finally {
            this.closeAuthAttrTable(etcTable);
        }
        return authArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAuthAttrObj(AuthAttrObj authAttr) throws DirectoryTableException {
        DirectoryTable etcTable = this.openAuthAttrTable();
        try {
            DirectoryRow newAttrRow = etcTable.getRowInstance();
            newAttrRow.putColumn(this.nameColNum, authAttr.getAuthName());
            DirectoryRow oldAttrRow = etcTable.getFirstRow((SearchTemplate)newAttrRow);
            String attrList = oldAttrRow != null ? oldAttrRow.getColumn(this.attrColNum) : null;
            String attrs = KeyValue.putAttributes(attrList, authAttr.attrSet, false);
            newAttrRow.putColumn(this.shortDescColNum, authAttr.getShortDesc());
            newAttrRow.putColumn(this.longDescColNum, authAttr.getLongDesc());
            newAttrRow.putColumn(this.attrColNum, attrs);
            if (oldAttrRow == null) {
                etcTable.addRow(newAttrRow);
            } else {
                etcTable.modifyRow(oldAttrRow, newAttrRow);
            }
        }
        finally {
            this.closeAuthAttrTable(etcTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthAttrObj(String authName) throws DirectoryTableException {
        DirectoryTable etcTable = this.openAuthAttrTable();
        try {
            DirectoryRow authAttrRow = etcTable.getRowInstance();
            authAttrRow.putColumn(this.nameColNum, authName);
            authAttrRow = etcTable.getFirstRow((SearchTemplate)authAttrRow);
            if (authAttrRow == null) {
                System.out.println("Auth " + authName + " does not exist");
            } else {
                etcTable.deleteRow(authAttrRow);
            }
        }
        finally {
            this.closeAuthAttrTable(etcTable);
        }
    }

    public void removeAuthAttrObj(AuthAttrObj authAttr) throws DirectoryTableException {
        String authName = authAttr.getAuthName();
        this.removeAuthAttrObj(authName);
    }

    public void createAuthAttrTable() throws DirectoryTableException {
        DirectoryTable authAttrTable = null;
        boolean exists = true;
        try {
            authAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            authAttrTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            exists = false;
        }
        catch (DirectoryTableException ex) {
            System.out.println("Error creating auth table: " + ex.getMessage());
            authAttrTable.close();
            throw ex;
        }
        TableDefinitions tbldef = null;
        try {
            if (!exists) {
                tbldef = authAttrTable.getTableDefinitionsInstance();
                tbldef.loadTableDefinitions(table);
                authAttrTable.create(table);
            }
        }
        catch (DirectoryTableException ex) {
            System.out.println("Error creating table: " + ex.getMessage());
            throw ex;
        }
        finally {
            authAttrTable.close();
        }
    }

    private DirectoryTable openAuthAttrTable() throws DirectoryTableException {
        DirectoryTableFactory factory = new DirectoryTableFactory();
        DirectoryTable authAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        try {
            authAttrTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        TableDefinitions tabledefs = authAttrTable.getCurrentTableDefinitions();
        this.nameColNum = tabledefs.getColumnNumber(nameCol);
        this.res1ColNum = tabledefs.getColumnNumber(res1Col);
        this.res2ColNum = tabledefs.getColumnNumber(res2Col);
        this.shortDescColNum = tabledefs.getColumnNumber(shortDescCol);
        this.longDescColNum = tabledefs.getColumnNumber(longDescCol);
        this.attrColNum = tabledefs.getColumnNumber(attrCol);
        return authAttrTable;
    }

    private void closeAuthAttrTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.res1ColNum = 0;
        this.res2ColNum = 0;
        this.shortDescColNum = 0;
        this.longDescColNum = 0;
        this.attrColNum = 0;
    }
}

