/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.aliases;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.aliases.EmailAliasObj;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisAliasesTable {
    private String table = "aliases";
    private String fileType = new String("File");
    private String scope;
    private String emptyString = new String("");
    private static String aliasCol = "alias";
    private static String expansionCol = "expansion";
    private static final String DEV_NULL = "/dev/null";
    private int aliasColNum = 0;
    private int expansionColNum = 0;

    public SolarisAliasesTable(String scope) {
        this.scope = scope;
    }

    private DirectoryTable createAliasesTable() throws DirectoryTableException {
        DirectoryTable aliasesTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        aliasesTable.create(this.table);
        return aliasesTable;
    }

    private DirectoryTable openAliasesTable() throws DirectoryTableException {
        try {
            DirectoryTable dirTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            dirTable.open(this.table);
            TableDefinitions tabledefs = dirTable.getCurrentTableDefinitions();
            this.aliasColNum = tabledefs.getColumnNumber(aliasCol);
            this.expansionColNum = tabledefs.getColumnNumber(expansionCol);
            return dirTable;
        }
        catch (DirectoryTableException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void closeAliasesTable(DirectoryTable dirTable) {
        dirTable.close();
        this.aliasColNum = 0;
        this.expansionColNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllAliasRows() throws DirectoryTableException {
        Vector<EmailAliasObj> aliases = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openAliasesTable();
        try {
            DirectoryRow aliasEntry = etcTable.getAll();
            if (aliasEntry == null) {
                Vector<EmailAliasObj> vector = aliases = new Vector<EmailAliasObj>();
                return vector;
            }
            numRows = aliasEntry.getNumberOfRows();
            aliases = new Vector(numRows);
            aliases.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                EmailAliasObj solarisAlias = new EmailAliasObj();
                solarisAlias.setAliasName(aliasEntry.getColumn(this.aliasColNum, i));
                solarisAlias.setAliasExpansion(aliasEntry.getColumn(this.expansionColNum, i));
                String tmpStr = solarisAlias.getAliasName();
                tmpStr = tmpStr.trim();
                if (tmpStr == null || tmpStr.equals("")) continue;
                aliases.setElementAt(solarisAlias, i - 1);
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
        }
        finally {
            if (etcTable != null) {
                this.closeAliasesTable(etcTable);
            }
        }
        return aliases;
    }

    public Vector getAllAliasRows(ProviderDirectoryFilter pdf) throws Exception {
        Vector<EmailAliasObj> aliases = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openAliasesTable();
        DirectoryFilter df = null;
        if (pdf != null) {
            try {
                df = pdf.getDirectoryFilter(etcTable);
            }
            catch (Exception ex) {
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            DirectoryRow aliasEntry = null;
            aliasEntry = df != null ? etcTable.getAll((SearchTemplate)df) : etcTable.getAll();
            if (aliasEntry == null) {
                Vector<EmailAliasObj> vector = aliases = new Vector<EmailAliasObj>();
                return vector;
            }
            numRows = aliasEntry.getNumberOfRows();
            aliases = new Vector(numRows);
            aliases.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                EmailAliasObj solarisAlias = new EmailAliasObj();
                solarisAlias.setAliasName(aliasEntry.getColumn(this.aliasColNum, i));
                solarisAlias.setAliasExpansion(aliasEntry.getColumn(this.expansionColNum, i));
                String tmpStr = solarisAlias.getAliasName();
                tmpStr = tmpStr.trim();
                if (tmpStr == null || tmpStr.equals("")) continue;
                aliases.setElementAt(solarisAlias, i - 1);
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeAliasesTable(etcTable);
            }
        }
        return aliases;
    }

    public EmailAliasObj getEmailRow(String strAliasName) throws Exception {
        DirectoryTable etcTable = null;
        EmailAliasObj solarisAlias = null;
        try {
            etcTable = this.openAliasesTable();
        }
        catch (DirectoryTableException e) {
            this.createAliasesTable();
            etcTable = this.openAliasesTable();
        }
        if (strAliasName == null || strAliasName.equals("")) {
            return solarisAlias;
        }
        solarisAlias = new EmailAliasObj();
        try {
            DirectoryRow aliasEntry = etcTable.getRowInstance();
            aliasEntry.putColumn(this.aliasColNum, strAliasName);
            aliasEntry = etcTable.getFirstRow((SearchTemplate)aliasEntry);
            if (aliasEntry == null) {
                throw new UserMgrNameNotFoundException(null);
            }
            solarisAlias.setAliasName(aliasEntry.getColumn(this.aliasColNum));
            solarisAlias.setAliasExpansion(aliasEntry.getColumn(this.expansionColNum));
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeAliasesTable(etcTable);
            }
        }
        return solarisAlias;
    }

    public void addEmailRow(EmailAliasObj Obj) throws Exception {
        DirectoryTable aliasesTable = null;
        try {
            aliasesTable = this.openAliasesTable();
        }
        catch (DirectoryTableException e) {
            this.createAliasesTable();
            aliasesTable = this.openAliasesTable();
        }
        try {
            DirectoryRow aliasEntry = aliasesTable.getRowInstance();
            aliasEntry.putColumn(this.aliasColNum, Obj.getAliasName());
            if (Obj.getAliasExpansion() != null && !Obj.getAliasExpansion().equals("")) {
                aliasEntry.putColumn(this.expansionColNum, Obj.getAliasExpansion());
            } else {
                aliasEntry.putColumn(this.expansionColNum, DEV_NULL);
            }
            aliasesTable.addRow(aliasEntry);
        }
        catch (DirectoryTableRowSizeException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (aliasesTable != null) {
                this.closeAliasesTable(aliasesTable);
            }
        }
    }

    public void modifyEmailRow(EmailAliasObj aliasObj, String strOldAliasName) throws Exception {
        DirectoryTable etcTable = null;
        boolean bDuplicateAliasExists = true;
        try {
            etcTable = this.openAliasesTable();
        }
        catch (DirectoryTableException e) {
            this.createAliasesTable();
            etcTable = this.openAliasesTable();
        }
        try {
            DirectoryRow aliasEntry = etcTable.getRowInstance();
            EmailAliasObj emailObj = new EmailAliasObj();
            if (strOldAliasName != null) {
                aliasEntry.putColumn(this.aliasColNum, strOldAliasName);
            } else {
                aliasEntry.putColumn(this.aliasColNum, aliasObj.getAliasName());
            }
            if (!strOldAliasName.equals(aliasObj.getAliasName())) {
                try {
                    EmailAliasObj eObj = this.getEmailRow(aliasObj.getAliasName());
                }
                catch (Exception e) {
                    bDuplicateAliasExists = false;
                }
                if (bDuplicateAliasExists) {
                    throw new DirectoryTableRowNotUniqueException();
                }
            }
            if ((aliasEntry = etcTable.getFirstRow((SearchTemplate)aliasEntry)) == null) {
                throw new UserMgrNameNotFoundException(null);
            }
            try {
                etcTable = this.openAliasesTable();
            }
            catch (DirectoryTableException e) {
                this.createAliasesTable();
                etcTable = this.openAliasesTable();
            }
            DirectoryRow newEntry = etcTable.getRowInstance();
            emailObj.debugPrint();
            newEntry.putColumn(this.aliasColNum, aliasObj.getAliasName());
            if (aliasObj.getAliasExpansion() != null && !aliasObj.getAliasExpansion().equals("")) {
                newEntry.putColumn(this.expansionColNum, aliasObj.getAliasExpansion());
            } else {
                newEntry.putColumn(this.expansionColNum, DEV_NULL);
            }
            etcTable.modifyRow(aliasEntry, newEntry);
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeAliasesTable(etcTable);
            }
        }
    }

    public void deleteEmailRow(EmailAliasObj aliasObj) throws Exception {
        DirectoryTable etcTable = null;
        try {
            etcTable = this.openAliasesTable();
        }
        catch (DirectoryTableException e) {
            this.createAliasesTable();
            return;
        }
        try {
            DirectoryRow aliasEntry = etcTable.getRowInstance();
            aliasEntry.putColumn(this.aliasColNum, aliasObj.getAliasName());
            aliasEntry = etcTable.getFirstRow((SearchTemplate)aliasEntry);
            if (aliasEntry == null) {
                throw new UserMgrNameNotFoundException(null);
            }
            etcTable.deleteRow(aliasEntry);
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeAliasesTable(etcTable);
            }
        }
    }

    public static String[] parseMembersIntoArray(String members) {
        StringTokenizer tk = new StringTokenizer(members, ",");
        String[] myStr = new String[tk.countTokens()];
        int ii = 0;
        while (tk.hasMoreTokens()) {
            myStr[ii++] = tk.nextToken();
        }
        return myStr;
    }

    public static String formatMembersIntoString(String[] members) {
        if (members.length == 0) {
            return "";
        }
        StringBuffer myBuffer = new StringBuffer(members[0]);
        for (int i = 1; i < members.length; ++i) {
            myBuffer.append(",");
            myBuffer.append(members[i]);
        }
        return myBuffer.toString();
    }

    private boolean isAliasesMember(String name, String strExpansionList) {
        if (strExpansionList == null) {
            return false;
        }
        if (strExpansionList == "") {
            return false;
        }
        String[] myList = SolarisAliasesTable.parseMembersIntoArray(strExpansionList);
        for (int i = 0; i < myList.length; ++i) {
            if (name.compareTo(myList[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

