/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.CronLog;
import com.sun.wbem.solarisprovider.scheduledjob.CronUtility;
import com.sun.wbem.solarisprovider.scheduledjob.CrontabEntries;
import com.sun.wbem.solarisprovider.scheduledjob.NameFilter;
import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.io.File;
import javax.wbem.cim.CIMException;

public class Crontab {
    private static String CRONTAB_DIRECTORY = "/var/spool/cron/crontabs";
    CronLog cronLog = null;
    DirectoryTable crontab = null;
    boolean crontabOpen = false;
    TableDefinitions crontabTableDefs = null;
    int minuteCol = 0;
    int hourCol = 0;
    int dayOfMonthCol = 0;
    int dayOfWeekCol = 0;
    int monthCol = 0;
    int commandCol = 0;
    int nameCol = 0;
    ScheduledJobProvider provHandle = null;

    public Crontab(ScheduledJobProvider handle) {
        this.provHandle = handle;
    }

    public void initialize() throws CIMException {
        try {
            this.crontab = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
            this.crontabTableDefs = this.crontab.getTableDefinitionsInstance();
            this.crontabTableDefs.loadTableDefinitions("crontab");
            this.minuteCol = this.crontabTableDefs.getColumnNumber("minute");
            this.hourCol = this.crontabTableDefs.getColumnNumber("hour");
            this.dayOfMonthCol = this.crontabTableDefs.getColumnNumber("dayofmonth");
            this.dayOfWeekCol = this.crontabTableDefs.getColumnNumber("dayofweek");
            this.monthCol = this.crontabTableDefs.getColumnNumber("month");
            this.commandCol = this.crontabTableDefs.getColumnNumber("command");
            this.nameCol = this.crontabTableDefs.getColumnNumber("comment");
        }
        catch (DirectoryTableException e) {
            this.crontab = null;
            this.provHandle.logErrorAndThrow("LM_7688", "LM_7689");
        }
    }

    private void openCrontab(String crontabFile, String owner) throws CIMException {
        if (this.crontab == null) {
            return;
        }
        if (!CronUtility.isUser(owner)) {
            this.provHandle.logErrorAndThrow("LM_7698", "LM_7699", owner);
        }
        int gid = CronUtility.getGid(owner);
        try {
            this.crontabTableDefs.setMappedTableName(crontabFile);
            this.crontabTableDefs.setGroup(gid);
            this.crontab.open(this.crontabTableDefs);
        }
        catch (DirectoryTableException e) {
            try {
                this.crontab.create(this.crontabTableDefs);
                this.provHandle.logWarning("LM_7900", "LM_7901", crontabFile);
            }
            catch (DirectoryTableException e2) {
                this.provHandle.logErrorAndThrow("LM_7690", "LM_7691", crontabFile);
            }
        }
        this.crontabOpen = true;
    }

    private void closeCrontab() {
        if (this.crontabOpen) {
            this.crontab.close();
            this.crontabOpen = false;
        }
    }

    public void addEntry(CrontabEntries addEntry) throws CIMException {
        String owner = addEntry.getOwner(1);
        String crontabFile = CRONTAB_DIRECTORY + File.separator + owner;
        this.openCrontab(crontabFile, owner);
        DirectoryRow rowToAdd = this.crontabEntryToDirectoryRow(addEntry);
        try {
            this.crontab.addRow(rowToAdd);
        }
        catch (DirectoryTableRowNotUniqueException e1) {
            this.provHandle.logErrorAndThrow("LM_7650", "LM_7692", crontabFile);
        }
        catch (DirectoryTableException e2) {
            this.provHandle.logErrorAndThrow("LM_7650", "LM_7693", crontabFile);
        }
        this.closeCrontab();
        CronUtility.notifyCron(this.provHandle, CronUtility.TYPE_CRON, CronUtility.ACTION_ADD, owner, owner);
    }

    public void deleteEntry(String owner, String name) throws CIMException {
        NameFilter nameFilter = null;
        String crontabFile = CRONTAB_DIRECTORY + File.separator + owner;
        this.openCrontab(crontabFile, owner);
        nameFilter = new NameFilter(name);
        try {
            DirectoryRow rowToDelete = this.crontab.getFirstRow((SearchTemplate)nameFilter);
            this.crontab.deleteRow(rowToDelete);
        }
        catch (DirectoryTableRowNotFoundException e1) {
            this.provHandle.logErrorAndThrow("LM_7656", "LM_7694", name, owner);
        }
        catch (DirectoryTableException e2) {
            this.provHandle.logErrorAndThrow("LM_7656", "LM_7695", name, owner, crontabFile);
        }
        this.closeCrontab();
        CronUtility.notifyCron(this.provHandle, CronUtility.TYPE_CRON, CronUtility.ACTION_DELETE, owner, owner);
    }

    public void modifyEntry(String owner, String name, CrontabEntries modEntry) throws CIMException {
        NameFilter nameFilter = null;
        String crontabFile = CRONTAB_DIRECTORY + File.separator + owner;
        this.openCrontab(crontabFile, owner);
        nameFilter = new NameFilter(name);
        try {
            DirectoryRow rowToModify = this.crontab.getFirstRow((SearchTemplate)nameFilter);
            DirectoryRow modRow = this.crontabEntryToDirectoryRow(modEntry);
            this.crontab.modifyRow(rowToModify, modRow);
        }
        catch (DirectoryTableRowNotFoundException e1) {
            this.provHandle.logErrorAndThrow("LM_7652", "LM_7696", name, owner);
        }
        catch (DirectoryTableException e2) {
            this.provHandle.logErrorAndThrow("LM_7652", "LM_7697", name, owner, crontabFile);
        }
        this.closeCrontab();
        CronUtility.notifyCron(this.provHandle, CronUtility.TYPE_CRON, CronUtility.ACTION_ADD, owner, owner);
    }

    public CrontabEntries getEntryByName(String owner, String name) throws CIMException {
        String crontabFile = CRONTAB_DIRECTORY + File.separator + owner;
        DirectoryRow crontabRows = null;
        CrontabEntries entry = null;
        NameFilter nameFilter = null;
        this.openCrontab(crontabFile, owner);
        try {
            nameFilter = new NameFilter(name);
            crontabRows = this.crontab.getFirstRow((SearchTemplate)nameFilter);
            if (crontabRows != null) {
                String jobStatus = "";
                CronLog log = new CronLog(this.provHandle);
                log.initialize();
                log.loadCronLog();
                jobStatus = log.getCronLogJobStatus(owner, crontabRows.getColumn(this.commandCol, 1));
                if (jobStatus == null) {
                    jobStatus = "";
                }
                log.unloadCronLog();
                entry = new CrontabEntries(1);
                entry.setEntry(1, owner, crontabRows.getColumn(this.nameCol, 1), crontabRows.getColumn(this.commandCol, 1), crontabRows.getColumn(this.hourCol, 1), crontabRows.getColumn(this.minuteCol, 1), crontabRows.getColumn(this.dayOfWeekCol, 1), crontabRows.getColumn(this.dayOfMonthCol, 1), crontabRows.getColumn(this.monthCol, 1), jobStatus);
            }
        }
        catch (DirectoryTableException e) {
            // empty catch block
        }
        this.closeCrontab();
        return entry;
    }

    public CrontabEntries getEntriesByOwner(String owner, boolean noLog, boolean saveLog) throws CIMException {
        String crontabFile = CRONTAB_DIRECTORY + File.separator + owner;
        DirectoryRow crontabRows = null;
        CrontabEntries ownerEntries = null;
        this.openCrontab(crontabFile, owner);
        try {
            crontabRows = this.crontab.getAll();
            if (crontabRows != null) {
                if (!(noLog || saveLog && this.cronLog != null)) {
                    this.cronLog = new CronLog(this.provHandle);
                    this.cronLog.initialize();
                    this.cronLog.loadCronLog();
                }
                int numRows = crontabRows.getNumberOfRows();
                ownerEntries = new CrontabEntries(numRows);
                for (int i = 1; i <= numRows; ++i) {
                    String jobStatus = "";
                    if (!noLog && (jobStatus = this.cronLog.getCronLogJobStatus(owner, crontabRows.getColumn(this.commandCol, i))) == null) {
                        jobStatus = "";
                    }
                    ownerEntries.setEntry(i, owner, crontabRows.getColumn(this.nameCol, i), crontabRows.getColumn(this.commandCol, i), crontabRows.getColumn(this.hourCol, i), crontabRows.getColumn(this.minuteCol, i), crontabRows.getColumn(this.dayOfWeekCol, i), crontabRows.getColumn(this.dayOfMonthCol, i), crontabRows.getColumn(this.monthCol, i), jobStatus);
                }
                if (!noLog && !saveLog) {
                    this.cronLog.unloadCronLog();
                    this.cronLog = null;
                }
            }
        }
        catch (DirectoryTableException e) {
            // empty catch block
        }
        this.closeCrontab();
        return ownerEntries;
    }

    public CrontabEntries getAllEntries(boolean noLog) throws CIMException {
        CrontabEntries allEntries = null;
        CrontabEntries ownerEntries = null;
        File crontabDirectory = new File(CRONTAB_DIRECTORY);
        String[] crontabFiles = crontabDirectory.list();
        for (int i = 0; i < crontabFiles.length; ++i) {
            if (!CronUtility.isUser(crontabFiles[i]) || (ownerEntries = this.getEntriesByOwner(crontabFiles[i], noLog, true)) == null) continue;
            if (allEntries == null) {
                allEntries = ownerEntries;
                continue;
            }
            allEntries.addEntries(ownerEntries);
        }
        if (!noLog) {
            this.cronLog.unloadCronLog();
            this.cronLog = null;
        }
        return allEntries;
    }

    public DirectoryRow crontabEntryToDirectoryRow(CrontabEntries entry) throws CIMException {
        DirectoryRow row = null;
        String name = null;
        try {
            row = this.crontab.getRowInstance();
            row.putColumn(this.minuteCol, entry.getMinutes(1));
            row.putColumn(this.hourCol, entry.getHours(1));
            row.putColumn(this.dayOfMonthCol, entry.getDaysOfTheMonth(1));
            row.putColumn(this.dayOfWeekCol, entry.getDaysOfTheWeek(1));
            row.putColumn(this.monthCol, entry.getMonths(1));
            name = entry.getName(1);
            if (NameFilter.isGeneratedName(name)) {
                name = "";
                row.putColumn(this.commandCol, entry.getCommand(1));
            } else {
                row.putColumn(this.commandCol, entry.getCommand(1) + " ");
            }
            row.putColumn(this.nameCol, name);
        }
        catch (DirectoryTableException e) {
            // empty catch block
        }
        return row;
    }
}

