/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.UnsignedInt16;

public class CronUtility {
    private static boolean library_loaded = false;
    protected static char ACTION_DELETE = (char)100;
    protected static char ACTION_ADD = (char)97;
    protected static char TYPE_CRON = (char)99;
    protected static char TYPE_AT = (char)97;
    protected static String ALLOW_FILENAME = "/etc/cron.d/cron.allow";
    protected static String DENY_FILENAME = "/etc/cron.d/cron.deny";
    protected static int USER_NOT_IN_FILE = 0;
    protected static int USER_IN_FILE = 1;
    protected static int FILE_DOES_NOT_EXIST = -1;
    protected static int UNKNOWN_ERROR = -2;

    protected static void notifyCron(ScheduledJobProvider handle, char etype, char action, String login, String fname) throws CIMException {
        int ret = 0;
        if (library_loaded) {
            ret = CronUtility.sendmsg(action, login, fname, etype);
            if (ret != 0) {
                handle.logWarning("LM_7910", "LM_7911", login);
            }
        } else {
            handle.logErrorAndThrow("LM_7683", "LM_7685", "solprov");
        }
    }

    private static native int sendmsg(char var0, String var1, String var2, char var3);

    protected static int withinFile(ScheduledJobProvider handle, String userName, String fileName) {
        int ret = UNKNOWN_ERROR;
        if (library_loaded) {
            ret = CronUtility.within(userName, fileName);
        } else {
            handle.logWarning("LM_7912", "LM_7913", fileName, "solprov");
            ret = UNKNOWN_ERROR;
        }
        return ret;
    }

    private static native int within(String var0, String var1);

    protected static String getStringFromVectorOfUnsignedInt16(Vector vec, int min, int max) {
        String str = null;
        if (vec.size() == max - min + 1) {
            return "*";
        }
        if (vec.size() == 0) {
            return "*";
        }
        str = ((UnsignedInt16)vec.elementAt(0)).toString();
        for (int i = 1; i < vec.size(); ++i) {
            str = str + "," + ((UnsignedInt16)vec.elementAt(i)).toString();
        }
        return str;
    }

    protected static native boolean isUser(String var0);

    protected static native int getGid(String var0);

    protected static Vector getVectorOfUnsignedInt16FromString(String str, int min, int max) {
        Vector<UnsignedInt16> vec = new Vector<UnsignedInt16>(max - min + 1);
        if (str.equals("*")) {
            for (int i = min; i <= max; ++i) {
                vec.addElement(new UnsignedInt16(i));
            }
            vec.setSize(max - min + 1);
            return vec;
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int index = s.indexOf("-");
            if (index >= 0) {
                for (int i = CronUtility.toInt(s.substring(0, index)); i <= CronUtility.toInt(s.substring(index + 1)); ++i) {
                    vec.addElement(new UnsignedInt16(i));
                }
                continue;
            }
            vec.addElement(new UnsignedInt16(CronUtility.toInt(s)));
        }
        return vec;
    }

    private static int toInt(String s) {
        return Integer.parseInt(s);
    }

    static {
        try {
            System.loadLibrary("solprov");
            library_loaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

