/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class ProjCommon {
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_NAME = "ProjectName";
    public static int denyNever = 0;
    public static int denyAlways = 0;
    public static int signalNever = 0;

    public static native String[] rctls();

    public static native int rctlflags(String var0);

    public static CIMObjectPath projectToCOP(ProjectObj projObj, CIMObjectPath op, String scopeType, String scopeDomain) throws CIMException {
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
        cop.addKey("SystemCreationClassName", new CIMValue((Object)scopeType));
        cop.addKey("SystemName", new CIMValue((Object)scopeDomain));
        cop.addKey(PROJECT_NAME, new CIMValue((Object)projObj.getProjectName()));
        return cop;
    }

    public static Vector buildVector(String[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        Vector<String> members = new Vector<String>();
        for (int i = 0; i < elements.length; ++i) {
            members.addElement(elements[i]);
        }
        if (members.size() == 0) {
            members = null;
        }
        members.trimToSize();
        return members;
    }

    public static String[] stringToArray(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        StringTokenizer st = new StringTokenizer(s, " ");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public static String[] removeElements(String s, String[] a) {
        if (s == null) {
            return a;
        }
        s = s.trim();
        String[] result = new String[a.length];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (s.indexOf(a[i]) != -1) continue;
            result[j] = a[i];
            ++j;
        }
        return result;
    }

    public static CIMInstance projectToCim(ProjectObj projObj, CIMClass cc, String scopeType, String scopeDomain) throws CIMException {
        CIMInstance ci = null;
        String name = projObj.getProjectName();
        String id = projObj.getProjectID();
        String descrip = projObj.getProjectDescription();
        Vector attribs = ProjCommon.buildVector(projObj.getProjectAttributes());
        try {
            ci = cc.newInstance();
            ci.setProperty(PROJECT_NAME, new CIMValue((Object)name));
            ci.setProperty(PROJECT_ID, new CIMValue((Object)new UnsignedInt32(id)));
            ci.setProperty(PROJECT_DESCRIPTION, new CIMValue((Object)descrip));
            ci.setProperty(PROJECT_ATTRIBUTES, new CIMValue((Object)attribs));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)scopeType));
            ci.setProperty("SystemName", new CIMValue((Object)scopeDomain));
        }
        catch (Exception e) {
            throw new CIMException("GENERAL_EXCEPTION");
        }
        return ci;
    }

    public static ProjectObj opToProject(CIMObjectPath cop, String scope) throws ProjectException {
        ProjectObj projObj = new ProjectObj();
        String projName = null;
        Enumeration e = cop.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROJECT_NAME) || cp.getValue() == null) continue;
            projName = (String)cp.getValue().getValue();
        }
        if (projName == null) {
            throw new ProjectException("EXM_PRJ24");
        }
        projObj.setProjectName(projName);
        return projObj;
    }

    public static ProjectObj cimToProject(CIMInstance ci, String scope) throws CIMException, ProjectException {
        Vector attribs;
        ProjectObj newProj = new ProjectObj();
        ProjectObj existProj = null;
        String projName = null;
        String projID = null;
        String projDescrip = null;
        CIMValue cv = null;
        cv = ci.getProperty(PROJECT_NAME).getValue();
        projName = cv != null ? (String)cv.getValue() : null;
        if (projName == null) {
            throw new ProjectException("EXM_PRJ24");
        }
        newProj.setProjectName(projName);
        try {
            SolarisProjectTable pt = new SolarisProjectTable(scope);
            existProj = pt.getProjectRow(newProj);
        }
        catch (DirectoryTableException dex) {
            throw new CIMException("GENERAL_EXCEPTION");
        }
        catch (ProjectException sse) {
            // empty catch block
        }
        if (existProj != null) {
            if (existProj.getProjectUsers() != null) {
                newProj.setProjectUsers(existProj.getProjectUsers());
            }
            if (existProj.getProjectGroups() != null) {
                newProj.setProjectGroups(existProj.getProjectGroups());
            }
            if (existProj.getProjectAttributes() != null) {
                newProj.setProjectAttributes(existProj.getProjectAttributes());
            }
            if (existProj.getProjectDescription() != null) {
                newProj.setProjectDescription(existProj.getProjectDescription());
            }
        }
        if ((projID = (cv = ci.getProperty(PROJECT_ID).getValue()) != null ? cv.getValue().toString() : null) == null) {
            throw new ProjectException("EXM_PRJ25");
        }
        newProj.setProjectID(projID);
        cv = ci.getProperty(PROJECT_DESCRIPTION).getValue();
        projDescrip = cv != null ? (String)cv.getValue() : null;
        if (projDescrip != null) {
            newProj.setProjectDescription(projDescrip);
        }
        if ((cv = ci.getProperty(PROJECT_ATTRIBUTES).getValue()) != null && (attribs = (Vector)cv.getValue()) != null) {
            String[] attribs_array = new String[attribs.size()];
            for (int i = 0; attribs != null && i < attribs.size(); ++i) {
                attribs_array[i] = (String)attribs.elementAt(i);
            }
            ProjCommon.validateAttributes(attribs_array);
            newProj.setProjectAttributes(attribs_array);
        }
        return newProj;
    }

    static void validateAttributes(String[] attribs) throws ProjectException {
        denyNever = 0;
        denyAlways = 0;
        signalNever = 0;
        for (int i = 0; i < attribs.length; ++i) {
            String[] RCs = attribs[i].split("=", 2);
            RCs[1] = RCs[1].substring(1, RCs[1].length() - 1);
            if (ProjCommon.rctlflags(RCs[0]) == 0) break;
            if (signalNever == 1 && (RCs[1].indexOf("sig=") > 0 || RCs[1].indexOf("signal=") > 0)) {
                throw new ProjectException("EXM_PRJ28", (Object)"signal action never allowed ", RCs[0]);
            }
            if (denyNever != 1 && denyAlways != 1) continue;
            String[] gflags = RCs[1].split(",");
            String gDeny = gflags[gflags.length - 1].trim();
            if (denyNever == 1 && gDeny.equalsIgnoreCase("deny")) {
                throw new ProjectException("EXM_PRJ28", (Object)"deny action never allowed ", RCs[0]);
            }
            if (denyAlways != 1 || gDeny.equalsIgnoreCase("deny")) continue;
            throw new ProjectException("EXM_PRJ28", (Object)"deny action always required", RCs[0]);
        }
    }

    static {
        System.loadLibrary("solprov");
    }
}

