/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.ParseException;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_PatchToPatchDependency
implements InstanceProvider {
    private static final String SOLARIS_PATCH = "Solaris_Patch";
    private static final String REQUIRED = "Antecedent";
    private static final String DEPENDENT = "Dependent";
    private static final String NAME = "Name";
    private static final String NAME_SPACE = "/root/cimv2";
    private static final String REQUIRES = "Requires";
    private static final String OBSOLETES = "Obsoletes";
    private static final String INCOMPATIBLES = "Incompatibles";
    private static final String PATCH_RELATION = "PatchDependencyRelation";
    private ProviderCIMOMHandle cimomhandle = null;
    private LogUtil logUtil = null;
    private ProviderUtility provUtil;
    private static final String providerName = "Solaris_PatchToPatchDependency";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        try {
            this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
            this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
            this.provUtil = new ProviderUtility(cimomhandle, providerName);
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.getLocalizedMessage());
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        try {
            Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
            Vector tmpVec = new Vector();
            CIMObjectPath dependentCOP = new CIMObjectPath(SOLARIS_PATCH);
            dependentCOP.setNameSpace(NAME_SPACE);
            Vector vRequires = null;
            Vector vObsoletes = null;
            Vector vIncompat = null;
            Enumeration e = this.cimomhandle.enumerateInstanceNames(dependentCOP);
            while (e.hasMoreElements()) {
                int i;
                dependentCOP = (CIMObjectPath)e.nextElement();
                CIMInstance patchCI = this.cimomhandle.getInstance(dependentCOP, false, true, true, null);
                tmpVec.clear();
                CIMProperty cp = patchCI.getProperty(REQUIRES);
                CIMValue cv = cp.getValue();
                Vector vector = vRequires = cv != null ? (Vector)cv.getValue() : null;
                if (vRequires != null && vRequires.size() > 0) {
                    tmpVec = this.formCOPPatchDataVec(dependentCOP, patchCI, vRequires);
                    for (i = 0; i < tmpVec.size(); ++i) {
                        allRecs.addElement((CIMObjectPath)tmpVec.elementAt(i));
                    }
                }
                tmpVec.clear();
                cp = patchCI.getProperty(OBSOLETES);
                cv = cp.getValue();
                Vector vector2 = vObsoletes = cv != null ? (Vector)cv.getValue() : null;
                if (vObsoletes != null && vObsoletes.size() > 0) {
                    tmpVec = this.formCOPPatchDataVec(dependentCOP, patchCI, vObsoletes);
                    for (i = 0; i < tmpVec.size(); ++i) {
                        allRecs.addElement((CIMObjectPath)tmpVec.elementAt(i));
                    }
                }
                tmpVec.clear();
                cp = patchCI.getProperty(INCOMPATIBLES);
                cv = cp.getValue();
                vIncompat = cv != null ? (Vector)cv.getValue() : null;
                if (vIncompat == null || vIncompat.size() <= 0) continue;
                tmpVec = this.formCOPPatchDataVec(dependentCOP, patchCI, vIncompat);
                for (i = 0; i < tmpVec.size(); ++i) {
                    allRecs.addElement((CIMObjectPath)tmpVec.elementAt(i));
                }
            }
            CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
            allRecs.toArray(copArray);
            return copArray;
        }
        catch (CIMException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMException("CIM_ERR_FAILED", (Object)ex.getLocalizedMessage());
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            Vector<CIMInstance> allRecs = new Vector<CIMInstance>();
            Vector tmpVec = new Vector();
            CIMObjectPath dependentCOP = new CIMObjectPath(SOLARIS_PATCH);
            dependentCOP.setNameSpace(NAME_SPACE);
            Vector vRequires = null;
            Vector vObsoletes = null;
            Vector vIncompat = null;
            Enumeration e = this.cimomhandle.enumerateInstances(dependentCOP, false, false, true, true, null);
            while (e.hasMoreElements()) {
                CIMInstance tmpCI;
                int i;
                CIMInstance patchCI = (CIMInstance)e.nextElement();
                CIMProperty cp = patchCI.getProperty(REQUIRES);
                CIMValue cv = cp.getValue();
                Vector vector = vRequires = cv != null ? (Vector)cv.getValue() : null;
                if (vRequires != null && vRequires.size() > 0) {
                    tmpVec = this.formCIPatchDataVec(dependentCOP, patchCI, cc, vRequires, REQUIRES);
                    for (i = 0; i < tmpVec.size(); ++i) {
                        tmpCI = (CIMInstance)tmpVec.elementAt(i);
                        if (localOnly) {
                            tmpCI = tmpCI.localElements();
                        }
                        allRecs.addElement(tmpCI.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                    }
                }
                tmpVec.clear();
                cp = patchCI.getProperty(OBSOLETES);
                cv = cp.getValue();
                Vector vector2 = vObsoletes = cv != null ? (Vector)cv.getValue() : null;
                if (vObsoletes != null && vObsoletes.size() > 0) {
                    tmpVec = this.formCIPatchDataVec(dependentCOP, patchCI, cc, vObsoletes, OBSOLETES);
                    for (i = 0; i < tmpVec.size(); ++i) {
                        tmpCI = (CIMInstance)tmpVec.elementAt(i);
                        if (localOnly) {
                            tmpCI = tmpCI.localElements();
                        }
                        allRecs.addElement(tmpCI.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                    }
                }
                tmpVec.clear();
                cp = patchCI.getProperty(INCOMPATIBLES);
                cv = cp.getValue();
                Vector vector3 = vIncompat = cv != null ? (Vector)cv.getValue() : null;
                if (vIncompat != null && vIncompat.size() > 0) {
                    tmpVec = this.formCIPatchDataVec(dependentCOP, patchCI, cc, vIncompat, INCOMPATIBLES);
                    for (i = 0; i < tmpVec.size(); ++i) {
                        tmpCI = (CIMInstance)tmpVec.elementAt(i);
                        if (localOnly) {
                            tmpCI = tmpCI.localElements();
                        }
                        allRecs.addElement(tmpCI.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                    }
                }
                tmpVec.clear();
            }
            CIMInstance[] ciArray = new CIMInstance[allRecs.size()];
            allRecs.toArray(ciArray);
            return ciArray;
        }
        catch (CIMException ex) {
            String msg = this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)msg);
        }
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            CIMObjectPath sPatchDependentCOP = null;
            CIMObjectPath sPatchAntecedentCOP = null;
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase(DEPENDENT)) {
                    sPatchDependentCOP = (CIMObjectPath)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase(REQUIRED)) continue;
                sPatchAntecedentCOP = (CIMObjectPath)cp.getValue().getValue();
            }
            if (sPatchDependentCOP == null && sPatchAntecedentCOP == null) {
                return null;
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty(REQUIRED, new CIMValue(sPatchAntecedentCOP));
            ci.setProperty(DEPENDENT, new CIMValue((Object)sPatchDependentCOP));
            UnsignedInt16 pri = this.getPatchRelationInfo(sPatchDependentCOP, sPatchAntecedentCOP);
            if (pri != null) {
                ci.setProperty(PATCH_RELATION, new CIMValue((Object)pri));
            }
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
        }
        catch (CIMException ex) {
            String msg = this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)msg);
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (ParseException e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.getLocalizedMessage());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    private Vector formCOPPatchDataVec(CIMObjectPath patchCOP, CIMInstance patchCI, Vector inVector) {
        Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
        int size = inVector != null ? inVector.size() : 0;
        for (int i = 0; i < size; ++i) {
            CIMObjectPath cop = new CIMObjectPath(providerName);
            CIMObjectPath sPatchRequiredCOP = new CIMObjectPath(SOLARIS_PATCH);
            sPatchRequiredCOP.setNameSpace(NAME_SPACE);
            sPatchRequiredCOP.addKey(NAME, new CIMValue((Object)((String)inVector.elementAt(i))));
            cop.addKey(REQUIRED, new CIMValue((Object)sPatchRequiredCOP));
            cop.addKey(DEPENDENT, new CIMValue((Object)patchCOP));
            allRecs.addElement(cop);
        }
        return allRecs;
    }

    private Vector formCIPatchDataVec(CIMObjectPath patchCOP, CIMInstance patchCI, CIMClass cc, Vector inVector, String dataType) {
        Vector<CIMInstance> allRecs = new Vector<CIMInstance>();
        Integer dt = this.getDataType(dataType);
        int size = 0;
        if (inVector != null) {
            size = inVector.size();
        }
        for (int i = 0; i < size; ++i) {
            CIMObjectPath sPatchRequiredCOP = new CIMObjectPath(SOLARIS_PATCH);
            sPatchRequiredCOP.setNameSpace(NAME_SPACE);
            sPatchRequiredCOP.addKey(NAME, new CIMValue((Object)((String)inVector.elementAt(i))));
            CIMInstance ci = cc.newInstance();
            ci.setProperty(REQUIRED, new CIMValue((Object)sPatchRequiredCOP));
            ci.setProperty(DEPENDENT, new CIMValue((Object)patchCOP));
            ci.setProperty(PATCH_RELATION, new CIMValue((Object)dt));
            allRecs.addElement(ci);
        }
        return allRecs;
    }

    private Integer getDataType(String dataType) {
        if (dataType.equals(REQUIRES)) {
            return new Integer(0);
        }
        if (dataType.equals(OBSOLETES)) {
            return new Integer(1);
        }
        if (dataType.equals(INCOMPATIBLES)) {
            return new Integer(2);
        }
        return null;
    }

    private UnsignedInt16 getPatchRelationInfo(CIMObjectPath dependentCOP, CIMObjectPath antecedentCOP) throws CIMException {
        Vector vIncompat;
        Vector vObsoletes;
        CIMValue cv;
        Vector vRequires;
        CIMProperty cp;
        CIMInstance patchCI = null;
        patchCI = this.cimomhandle.getInstance(dependentCOP, false, true, true, null);
        String antecPatchId = "";
        Enumeration e = antecedentCOP.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(NAME)) continue;
            antecPatchId = (String)cp.getValue().getValue();
            break;
        }
        Vector vector = vRequires = (cv = (cp = patchCI.getProperty(REQUIRES)).getValue()) != null ? (Vector)cv.getValue() : null;
        if (vRequires != null && vRequires.size() > 0) {
            for (int i = 0; i < vRequires.size(); ++i) {
                if (!((String)vRequires.elementAt(i)).equals(antecPatchId)) continue;
                return new UnsignedInt16(0);
            }
        }
        Vector vector2 = vObsoletes = (cv = (cp = patchCI.getProperty(OBSOLETES)).getValue()) != null ? (Vector)cv.getValue() : null;
        if (vObsoletes != null && vObsoletes.size() > 0) {
            for (int i = 0; i < vObsoletes.size(); ++i) {
                if (!((String)vObsoletes.elementAt(i)).equals(antecPatchId)) continue;
                return new UnsignedInt16(1);
            }
        }
        Vector vector3 = vIncompat = (cv = (cp = patchCI.getProperty(INCOMPATIBLES)).getValue()) != null ? (Vector)cv.getValue() : null;
        if (vIncompat != null && vIncompat.size() > 0) {
            for (int i = 0; i < vIncompat.size(); ++i) {
                if (!((String)vIncompat.elementAt(i)).equals(antecPatchId)) continue;
                return new UnsignedInt16(2);
            }
        }
        return null;
    }
}

